/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.impt.SheetHandler;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.restapi.service.impt.NoCodeImportContext;
import org.xml.sax.SAXException;

public class NoCodeSheetHandler
extends SheetHandler {
    private static final String BOS_IMPORT = "bos-import";
    private String url;
    private NoCodeImportContext ctx;
    private MainEntityType mainEntityType;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private ImportLogger logger;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private int dataIndex = 0;
    private int startRowNum = 0;
    private int startEntryRowNum = 0;
    private boolean errorData = false;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private JSONObject data;
    private SheetHandler.ParsedRow currentRow;
    private HeartBeat heartbeat;
    private Map<Integer, Integer> emptyRowsInBillData = new HashMap<Integer, Integer>(8);

    public NoCodeSheetHandler(NoCodeImportContext ctx, MainEntityType mainEntityType, String url) {
        this.url = url;
        this.ctx = ctx;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue(url);
        this.logger = ctx.getLogger(url);
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        this.logger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.logger.setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                return;
            }
            String entityName = row.get(Integer.valueOf(0));
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(Integer.valueOf(1));
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.mainEntityType.getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.ctx.setResolveComplete(this.url);
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u6570\u636e\uff1a", (String)"NoCodeSheetHandler_0", (String)BOS_IMPORT, (Object[])new Object[0]) + entityName);
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
        }
        this.buildBill(row);
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 10L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38", (String)"NoCodeSheetHandler_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38", (String)"NoCodeSheetHandler_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    private void buildBill(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow, (Map)row.getData());
            Collection colInfos = this.entityMapping.getCols().values();
            ArrayList<ImportEntityMapping.ColInfo> needDelBaseDataInfos = new ArrayList<ImportEntityMapping.ColInfo>();
            for (ImportEntityMapping.ColInfo colInfo : colInfos) {
                IDataEntityProperty property = colInfo.getProperty();
                if (!(property instanceof NoCodeRefBillProp) && !(property instanceof NoCodeMulRefBillProp) && !(property instanceof NoCodeMulRefBillField) && !(property instanceof NoCodeImageProp)) continue;
                needDelBaseDataInfos.add(colInfo);
            }
            colInfos.removeAll(needDelBaseDataInfos);
        } else if (currRowNum > 3) {
            if (!this.addNewBillData(row)) {
                return;
            }
            List errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
            if (!errMsg.isEmpty()) {
                this.errorData = true;
                this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
            }
            this.currentRow = row;
        }
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.entityMapping.isEntityEmpty(row.getData())) {
            return false;
        }
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
            ++this.dataIndex;
        }
        this.data = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            if (this.errorData) {
                this.logger.fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, this.entityMapping);
            }
            lastBillData.setDataIndex(this.dataIndex);
            lastBillData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
            lastBillData.setEmptyRowNum(this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0).intValue());
            this.addBillData(lastBillData);
        }
        this.ctx.setResolveComplete(this.url);
        this.ctx.feedbackProgress(0, this.logger, null);
    }
}

