/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.service.impt.NoCodeImportContext;
import kd.bos.nocode.restapi.service.impt.NoCodeImportHelper;
import kd.bos.nocode.restapi.service.impt.NoCodeSheetHandler;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ReloveAndImportData
implements Callable<Object> {
    private List<String> startArgs;
    private RequestContext rc;
    protected MainEntityType mainEntityType;
    protected NoCodeImportContext ctx;
    private HeartBeat heartbeat = new HeartBeat();
    private static Log log = LogFactory.getLog(ReloveAndImportData.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_IMPORT", new DistributeCacheHAPolicy(true, true));
    private Map<String, Set<String>> importRowMapping = new HashMap<String, Set<String>>(this.getBatchImportSize());

    public ReloveAndImportData setContext(RequestContext rc, NoCodeImportContext ctx, List<String> startArgs) {
        this.startArgs = startArgs == null ? new CopyOnWriteArrayList<String>() : new CopyOnWriteArrayList<String>(startArgs);
        this.rc = rc;
        this.ctx = ctx;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ExcelReader reader = new ExcelReader();
        String url = this.ctx.getUrl();
        try (InputStream in = tempFileCache.getInputStream(url);){
            MainEntityType mainEntityType = this.getMainEntityType();
            if (mainEntityType instanceof QueryEntityType) {
                mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
            }
            reader.read(in, (SheetHandler)new NoCodeSheetHandler(this.ctx, mainEntityType, url));
        }
        catch (Throwable e) {
            if (!SystemParamServiceHelper.isShowStackTrace()) {
                Throwable cause = e.getCause();
                String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ReloveAndImportData_0", (String)"bos-nocode-service", (Object[])new Object[0]);
                log.debug(importErrMsg);
            }
            this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
        }
        finally {
            this.ctx.setResolveComplete(url);
        }
    }

    private MainEntityType getMainEntityType() {
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBillFormId());
        return this.mainEntityType;
    }

    private String getBillFormId() {
        return this.ctx.getBillFormId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void importData() {
        String logId = this.ctx.getLogId().toString();
        String taskId = (String)cache.get("noCodeLogId:" + logId);
        try {
            ImportBillData billdata = null;
            boolean isShowStackTrace = SystemParamServiceHelper.isShowStackTrace();
            String url = this.ctx.getUrl();
            LinkedBlockingQueue<ImportBillData> dataQ = this.ctx.getDataQueue(url);
            ArrayList<int[]> delRows = new ArrayList<int[]>(this.getBatchImportSize());
            ImportLogger logger = this.ctx.getLogger(url);
            logger.setDelRows(delRows);
            ArrayList<ImportBillData> leftRowdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
            ArrayList<ImportBillData> billdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
            ArrayList tempBilldatas = new ArrayList(this.getBatchImportSize());
            boolean suspend = false;
            while (this.checkHasDataLeft(url, dataQ, leftRowdatas)) {
                if (StringUtils.equals((CharSequence)((CharSequence)cache.get("Cancel_Import_ByTaskId:" + taskId)), (CharSequence)"cancel")) {
                    cache.remove("Cancel_Import_ByTaskId:" + taskId);
                    suspend = true;
                    break;
                }
                int leftRowDatasCount = this.countBatchRows(leftRowdatas);
                int needCount = this.getBatchImportSize() - leftRowDatasCount;
                if (needCount > 0 && this.checkHasDataLeft(url, dataQ, null) || leftRowDatasCount <= 0) {
                    billdata = dataQ.poll(3L, TimeUnit.SECONDS);
                    if (billdata == null || billdata.isEmpty()) continue;
                    leftRowdatas.add(billdata);
                    if ((needCount -= Math.max(1, billdata.getEndIndex() - billdata.getStartIndex() + 1)) > 0) {
                        dataQ.drainTo(tempBilldatas, needCount);
                        for (ImportBillData tempBill : tempBilldatas) {
                            if (tempBill == null || tempBill.isEmpty()) continue;
                            leftRowdatas.add(tempBill);
                            needCount -= Math.max(1, tempBill.getEndIndex() - tempBill.getStartIndex() + 1);
                        }
                        tempBilldatas.clear();
                    }
                    if (this.isForceBatch() && needCount > 0 && this.checkHasDataLeft(url, dataQ, null)) continue;
                }
                this.filterFromLeftRowDatas(leftRowdatas, billdatas);
                int firstRow = ((ImportBillData)billdatas.get(0)).getStartIndex();
                OperationResult saveResult = null;
                try {
                    this.beforeSave(billdatas, logger);
                    if (!billdatas.isEmpty()) {
                        firstRow = ((ImportBillData)billdatas.get(0)).getStartIndex();
                        saveResult = this.save(billdatas);
                    }
                    this.buildResult(saveResult, delRows, billdatas, url);
                }
                catch (KDBizException kdexp) {
                    logger.log(Integer.valueOf(firstRow), kdexp.getMessage()).setFailed(logger.getFailed() + billdatas.size());
                    logger.signTotalRow(this.getBillDataRowsCount(billdatas));
                    this.buildResult(saveResult, delRows, billdatas, url);
                }
                catch (Throwable exp) {
                    log.warn(exp);
                    if (isShowStackTrace) {
                        logger.log(Integer.valueOf(firstRow), exp).setFailed(logger.getFailed() + billdatas.size());
                    } else {
                        String importErrMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ReloveAndImportData_1", (String)"bos-nocode-service", (Object[])new Object[0]);
                        logger.log(Integer.valueOf(firstRow), exp instanceof KDBizException ? exp.getMessage() : importErrMsg).setFailed(logger.getFailed() + billdatas.size());
                    }
                    logger.signTotalRow(this.getBillDataRowsCount(billdatas));
                    this.buildResult(saveResult, delRows, billdatas, url);
                    {
                        catch (Throwable throwable) {
                            this.buildResult(saveResult, delRows, billdatas, url);
                            throw throwable;
                        }
                    }
                }
                logger.setTotal(logger.getTotalRow());
                if (billdatas.isEmpty()) continue;
                int lastEndIndex = ((ImportBillData)billdatas.get(billdatas.size() - 1)).getEndIndex();
                billdatas.clear();
                this.ctx.feedbackProgress(Math.min(99, lastEndIndex * 100 / logger.getLastRowIndex()), logger, null);
            }
            if (!suspend && !this.ctx.isResolveComplete(url) && this.heartbeat.isTimeOut()) {
                this.ctx.feedbackProgress(99, logger, ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u8d85\u65f6,\u672a\u5b8c\u6210", (String)"ReloveAndImportData_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else {
                this.ctx.feedbackProgress(99, logger, null);
            }
            int total = 0;
            int failed = 0;
            ImportLogger curLogger = null;
            curLogger = this.ctx.getLogger(url);
            total += curLogger.getTotal();
            failed += curLogger.getRowIndex() < curLogger.getLastRowIndex() - 1 ? curLogger.getTotal() - this.ctx.getSucceed() : curLogger.getFailed();
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            ImportLogHelper.logAll((Object)logId, (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            boolean error = failed == 0 && logger != null && !MapUtils.isEmpty((Map)logger.getLogCache()) && !((List)logger.getLogCache().get(0)).isEmpty();
            this.ctx.feedbackProgress(100, null, error ? ((ImportLogger.ImportLog)((List)logger.getLogCache().get((Object)Integer.valueOf((int)0))).get((int)0)).msg : null);
        }
        catch (Throwable e) {
            log.warn(e);
        }
        finally {
            cache.remove("noCodeLogId:" + logId);
            cache.remove("Import_TaskParam_ByTaskId:" + taskId);
            cache.remove("Import_Jobforminfo_ByTaskId:" + taskId);
        }
    }

    private void buildResult(OperationResult saveResult, List<int[]> delRows, List<ImportBillData> billdatas, String url) {
        if (saveResult != null) {
            int succeed = saveResult.getSuccessPkIds().size();
            int failed = saveResult.getValidateResult().errorSize();
            this.ctx.setSucceed(succeed + this.ctx.getSucceed());
            this.ctx.getLogger(url).fail(failed);
            this.ctx.getLogger(url).signTotalRow(succeed + failed);
        }
    }

    private void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        NoCodeImportHelper.invalidBill(billdatas, logger);
    }

    private int getBillDataRowsCount(List<ImportBillData> billDatas) {
        int rows = 0;
        for (ImportBillData billData : billDatas) {
            int startIndex = billData.getStartIndex();
            int endIndex = billData.getEndIndex();
            rows += endIndex - startIndex + 1;
        }
        return rows;
    }

    protected OperationResult save(List<ImportBillData> rowdatas) throws ParseException {
        ArrayList<JSONObject> bills = new ArrayList<JSONObject>(rowdatas.size());
        for (ImportBillData temp : rowdatas) {
            bills.add(temp.getData());
        }
        Set<String> colIds = this.getColIds(rowdatas);
        if (rowdatas.isEmpty()) {
            return null;
        }
        JSONObject dataPack = new JSONObject();
        dataPack.put("datas", bills);
        dataPack.put("colIds", colIds);
        return this.convertDataToDynamicObject((Map<String, Object>)dataPack);
    }

    private OperationResult convertDataToDynamicObject(Map<String, Object> requestData) throws ParseException {
        LinkedList<DynamicObject> billObjs = new LinkedList<DynamicObject>();
        List datas = (List)requestData.get("datas");
        for (Object data : datas) {
            DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)this.ctx.getBillFormId());
            JSONObject dataMap = (JSONObject)data;
            DataEntityPropertyCollection dataEntityProperties = dyObj.getDataEntityType().getProperties();
            for (Map.Entry curdata : dataMap.entrySet()) {
                String propertyName = (String)curdata.getKey();
                Object value = curdata.getValue();
                IDataEntityProperty property = (IDataEntityProperty)dataEntityProperties.get((Object)propertyName);
                if (property == null) continue;
                if (property instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)property;
                    String entityName = basedataProp.getBaseEntityId();
                    String importProp = ((JSONObject)value).get((Object)"importprop").toString();
                    QFilter[] filter = new QFilter[]{new QFilter(importProp, "=", (Object)((JSONObject)value).get((Object)importProp).toString())};
                    DynamicObject propertyNameObj = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])filter);
                    dyObj.set(propertyName, (Object)propertyNameObj);
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    Date date = ((DateTimeProp)property).getDateFormat().parse(value.toString());
                    dyObj.set(propertyName, (Object)date);
                    continue;
                }
                dyObj.set(propertyName, value);
            }
            billObjs.add(dyObj);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtype", "new");
        option.setVariableValue("autogeneratebillno", String.valueOf(true));
        option.setVariableValue("currbizappid", this.ctx.getAppId());
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("batchImport", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("importtag_of_datasource", String.valueOf(true));
        return NoCodeOperationServiceHelper.executeOperate("save", this.ctx.getBillFormId(), billObjs.toArray(new DynamicObject[0]), option);
    }

    @SdkInternal
    private Set<String> getColIds(List<ImportBillData> rowdatas) {
        return CollectionUtils.isNotEmpty(rowdatas) ? rowdatas.get(0).getEntityMapping().getCols().keySet() : new HashSet<String>(0);
    }

    private void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        int billRowSpan;
        this.importRowMapping.clear();
        int batchSize = this.getBatchImportSize();
        int i = 0;
        for (int needRowsCount = batchSize - this.countBatchRows(rowdatas); i < leftRowdatas.size() && needRowsCount > 0; needRowsCount -= Math.max(1, billRowSpan)) {
            ImportBillData billdata = leftRowdatas.get(i);
            billRowSpan = billdata.getEndIndex() - billdata.getStartIndex() + 1;
            billdata = leftRowdatas.remove(i);
            rowdatas.add(billdata);
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    protected boolean isForceBatch() {
        return false;
    }

    private int countBatchRows(List<ImportBillData> billdatas) {
        int countRows = 0;
        for (ImportBillData billdata : billdatas) {
            if (billdata.getEndIndex() < billdata.getStartIndex()) continue;
            countRows += billdata.getEndIndex() - billdata.getStartIndex() + 1;
        }
        return countRows;
    }

    private boolean checkHasDataLeft(String url, LinkedBlockingQueue<ImportBillData> dataQ, List<ImportBillData> leftRowdatas) {
        return !this.ctx.isResolveComplete(url) && !this.heartbeat.isTimeOut() || !dataQ.isEmpty() || leftRowdatas != null && !leftRowdatas.isEmpty();
    }

    private int getBatchImportSize() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object call() {
        try {
            RequestContext.copyAndSet((RequestContext)this.rc);
            OperationContext oc = new OperationContext();
            oc.setAppId(this.ctx.getAppId());
            oc.setFormId(this.ctx.getBillFormId());
            oc.setFormName(this.ctx.getListName());
            oc.setOpKey("importdata");
            OperationContext.set((OperationContext)oc);
            String tag = this.getTag();
            if (tag == null) {
                tag = "";
            }
            switch (tag) {
                case "resolveExcel": {
                    this.resolveExcel();
                    return null;
                }
                case "importData": {
                    try {
                        this.importData();
                        return null;
                    }
                    finally {
                        this.ctx.getCountDownLatch().countDown();
                    }
                }
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
    }

    private synchronized String getTag() {
        return this.startArgs.isEmpty() ? null : this.startArgs.remove(0);
    }
}

