/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.restapi.service.print.dataprovider.NoCodePrintDataProvider;
import kd.bos.nocode.restapi.service.print.datasource.ImageFieldSetting;
import kd.bos.nocode.restapi.service.print.datasource.NCPrintDataSource;
import kd.bos.print.api.FileStorageType;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridColumn;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.execute.PFileStorageType;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.service.helper.ExportService;
import kd.bos.print.service.helper.PrintJob;
import kd.bos.print.service.transform.PrintMetadataReader;
import kd.bos.session.SystemPropertyUtils;

public class NoCodePrintService
extends ExportService {
    private static final Log log = LogFactory.getLog(NoCodePrintService.class);

    public NoCodePrintService(String taskId, String lang) {
        super(taskId, lang);
    }

    public void exportPdf(PrintWork work) {
        ExecuteContext.get().setRunFast(true);
        ExecuteContext.get().setHorEconomizePaper(work.isHorEconomizePaper());
        ExecuteContext.get().setVerEconomizePaper(work.isVerEconomizePaper());
        ExecuteContext.get().setPageNumType(work.getPageNumType());
        ExecuteContext.get().setPageSeparation(work.isPageSeparation());
        ExecuteContext.get().setExtParam(work.getExtParam());
        ExecuteContext.get().setExpType(work.getExpType());
        FileStorageType fileStorageType = work.getFileStorageType();
        if (fileStorageType == null) {
            String storageType = SystemPropertyUtils.getProptyByTenant((String)"PrintUseFileStorage", (String)RequestContext.get().getTenantId());
            fileStorageType = "true".equals(storageType) ? FileStorageType.ATTACHMENT_FILE : FileStorageType.TEMP_FILE;
        }
        ExecuteContext.get().setpFileStorageType(new PFileStorageType(fileStorageType.getCode(), fileStorageType.getTimeout()));
        ArrayList<PrintJob> printJobList = new ArrayList<PrintJob>(10);
        for (PrintTask printTask : work.getTaskList()) {
            PrintJob printJob = new PrintJob();
            printJob.setFormId(printTask.getFormId());
            printJob.setDataProvider((IPrintDataProvider)new NoCodePrintDataProvider());
            printJob.setPkIds(printTask.getPkIds());
            printJob.setMetadata(printTask.getMetadata());
            printJob.setPrintType(printTask.getPrintType());
            printJobList.add(printJob);
        }
        this.doExport(printJobList, work.getExpType());
    }

    protected RuntimeModel loadR1Model(PrintJob job) {
        PrintMetadata metadata = job.getMetadata();
        IPrintDataProvider dataProvider = job.getDataProvider();
        PrintMetadataReader reader = new PrintMetadataReader();
        ReportModel rm = reader.parseModel(metadata);
        RuntimeModel runtimeModel = new RuntimeModel(rm);
        runtimeModel.setFormId(job.getFormId());
        runtimeModel.setPkIds(job.getPkIds());
        runtimeModel.setPdfName((String)metadata.getName().getLocaleValue());
        runtimeModel.setSplicePrint(metadata.getPaper().isSplicePrint());
        PrintPluginProxy proxy = this.buildPrintPluginProxy(job);
        runtimeModel.setPluginProxy(proxy);
        dataProvider.setPluginProxy(proxy);
        ExecuteContext.get().getServiceProxy().register(dataProvider);
        ExecuteContext.get().setPluginProxy(proxy);
        Map<String, PrtDataSource> dataSources = this.loadDataSource(job);
        runtimeModel.hookDataProvider(dataProvider, dataSources);
        return runtimeModel;
    }

    private Map<String, PrtDataSource> loadDataSource(PrintJob job) {
        PrintMetadata metadata = job.getMetadata();
        String mainFormId = metadata.getFormId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainFormId);
        Map<String, PrtDataSource> dataSourceMap = this.scanMetaData(dataEntityType, metadata);
        HashMap<String, PrtDataSource> resultDsMap = new HashMap<String, PrtDataSource>(16);
        MainDataSource mainDataSource = (MainDataSource)dataSourceMap.remove(mainFormId);
        if (mainDataSource == null) {
            mainDataSource = new NCPrintDataSource(mainFormId, DsType.MAIN, mainFormId);
        }
        mainDataSource.setPageId(job.getPageId());
        mainDataSource.getQueryField().add("id");
        resultDsMap.put(mainFormId, (PrtDataSource)mainDataSource);
        for (Map.Entry<String, PrtDataSource> entry : dataSourceMap.entrySet()) {
            String key = entry.getKey();
            String[] arr = key.split("\\.");
            String dsFormId = arr[0];
            PrtDataSource dataSource = entry.getValue();
            DsType dsType = dataSource.getDsType();
            if (dsType == DsType.SYS) {
                resultDsMap.put(key, dataSource);
                continue;
            }
            FormDataSource headDataSource = (FormDataSource)resultDsMap.get(dsFormId);
            headDataSource.addChildDs(dataSource);
        }
        return resultDsMap;
    }

    private Map<String, PrtDataSource> scanMetaData(MainEntityType dataEntityType, PrintMetadata metadata) {
        DataGrid dataGrid;
        HashMap<String, PrtDataSource> dsMap = new HashMap<String, PrtDataSource>();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String entityName = dataEntityType.getName();
        HashMap<String, ImageFieldSetting> imageFieldSettingMap = new HashMap<String, ImageFieldSetting>(16);
        HashMap<String, DataGrid> imageDataGridMap = new HashMap<String, DataGrid>(16);
        for (List page : metadata.getPages()) {
            for (Control control : page) {
                IDataEntityProperty property;
                String[] split;
                String dataSource;
                if (!(control instanceof DataGrid) || StringUtils.isBlank((CharSequence)(dataSource = (dataGrid = (DataGrid)control).getDataSource())) || !StringUtils.equals((CharSequence)(split = dataSource.split("\\."))[0], (CharSequence)entityName) || split.length <= 1 || !properties.containsKey((Object)split[1]) || !((property = (IDataEntityProperty)properties.get((Object)split[1])) instanceof NoCodeImageProp)) continue;
                imageDataGridMap.put(dataGrid.getId(), dataGrid);
            }
        }
        for (List page : metadata.getPages()) {
            for (Control control : page) {
                PrtDataSource dataSource;
                Image image;
                ImageFieldSetting imageFieldSetting;
                if (control instanceof LayoutGridColumn && imageDataGridMap.containsKey(control.getParentId())) {
                    dataGrid = (DataGrid)imageDataGridMap.get(control.getParentId());
                    String imageFieldKey = dataGrid.getDataSource().split("\\.")[1];
                    imageFieldSetting = imageFieldSettingMap.getOrDefault(imageFieldKey, new ImageFieldSetting("headImage", 0));
                    imageFieldSetting.setColSize(imageFieldSetting.getColSize() + 1);
                    imageFieldSettingMap.put(imageFieldKey, imageFieldSetting);
                }
                if (!(control instanceof BaseDsControl)) continue;
                BaseDsControl ctrl = (BaseDsControl)control;
                if (control instanceof Image && "base64".equals((image = (Image)control).getBindType())) {
                    imageFieldSetting = imageFieldSettingMap.getOrDefault(image.getBindField(), new ImageFieldSetting("staticImage", 0));
                    imageFieldSettingMap.put(image.getBindField(), imageFieldSetting);
                    continue;
                }
                String ds = ctrl.getDataSource();
                String dsTypeStr = ctrl.getDsType();
                DsType dsType = DsType.from((String)dsTypeStr);
                if (StringUtils.isBlank((CharSequence)ds)) continue;
                if (!dsMap.containsKey(ds)) {
                    dataSource = this.getDataSource(ds, dsType, dataEntityType.getName());
                    dataSource.addField(ctrl.getBindField());
                    dsMap.put(ds, dataSource);
                    continue;
                }
                dataSource = (PrtDataSource)dsMap.get(ds);
                dataSource.addField(ctrl.getBindField());
            }
        }
        NCPrintDataSource mainDataSource = (NCPrintDataSource)((Object)dsMap.get(entityName));
        if (mainDataSource == null) {
            mainDataSource = new NCPrintDataSource(entityName, DsType.MAIN, entityName);
            dsMap.put(entityName, (PrtDataSource)mainDataSource);
        }
        mainDataSource.setImageFieldSettingMap(imageFieldSettingMap);
        mainDataSource.getQueryField().addAll(imageFieldSettingMap.keySet());
        return dsMap;
    }

    private PrtDataSource getDataSource(String ds, DsType dsType, String formId) {
        NCPrintDataSource dataSource = dsType == DsType.MAIN || dsType == DsType.MAIN_REPORT ? new NCPrintDataSource(ds, dsType, ds) : (dsType == DsType.SYS ? new NCPrintDataSource(ds, dsType, formId) : new NCPrintDataSource(ds, dsType, formId));
        return dataSource;
    }
}

