/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.PrintRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiPrintParam;
import kd.bos.nocode.restapi.api.result.RestApiPrintResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.service.print.NoCodePrintService;
import kd.bos.nocode.restapi.service.print.actionparam.ExportPdfRequestData;
import kd.bos.nocode.restapi.service.print.actionparam.ExportPdfReturn;
import kd.bos.nocode.restapi.service.print.bean.PrintMetaDataConvertUtil;
import kd.bos.print.api.FileStorageType;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;

public class PrintRestApiServiceImpl
implements PrintRestApiService {
    private static final Log log = LogFactory.getLog(NoCodePrintService.class);
    private static final String REGEX = "/print/?";
    private static final Pattern PATTERN = Pattern.compile("/print/?");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiPrintResult> execute(RestApiPrintParam param) {
        long start = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        String action = this.getAction((RestApiParam)param);
        if ("exportPdf".equals(action)) {
            return this.exportPdf(param, start, (RestApiResponse<RestApiPrintResult>)response);
        }
        RestApiPrintResult restApiPrintResult = new RestApiPrintResult();
        response.setHttpStatus(404);
        restApiPrintResult.setData((Object)"not find action");
        response.setData((Object)restApiPrintResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiPrintResult> exportPdf(RestApiPrintParam param, long start, RestApiResponse<RestApiPrintResult> response) {
        PrintMetaDataConvertUtil convertUtil = new PrintMetaDataConvertUtil();
        ExportPdfRequestData pdfRequestData = this.getRequestData(param, convertUtil);
        String taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        String lang = Lang.zh_CN.toString();
        NoCodePrintService printService = new NoCodePrintService(taskId, lang);
        PrintWork printWork = this.getDefaultPrintWork();
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        PrintTask printTask = new PrintTask();
        printTask.setFormId(pdfRequestData.getEntityId());
        printTask.setPrintType("pdf");
        printTask.setPkIds(pdfRequestData.getPkIds());
        PrintMetadata metadata = null;
        try {
            metadata = convertUtil.resolveMetaJson(pdfRequestData.getTplBeanJson());
        }
        catch (KDBizException e) {
            log.warn((Throwable)e);
            RestApiPrintResult restApiPrintResult = new RestApiPrintResult();
            restApiPrintResult.setData((Object)e.getMessage());
            response.setData((Object)restApiPrintResult);
            return RestApiServiceData.ofFalse((String)"10000", (String)e.getMessage(), response, (long)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            RestApiPrintResult restApiPrintResult = new RestApiPrintResult();
            restApiPrintResult.setData((Object)e);
            response.setData((Object)restApiPrintResult);
            return RestApiServiceData.ofFalse((String)"999", (String)e.getMessage(), response, (long)(System.currentTimeMillis() - start));
        }
        printTask.setMetadata(metadata);
        taskList.add(printTask);
        printWork.setTaskList(taskList);
        printService.exportPdf(printWork);
        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
        RestApiPrintResult restApiPrintResult = new RestApiPrintResult();
        List attach = taskResult.getAttach();
        ExportPdfReturn exportPdfReturn = new ExportPdfReturn();
        String urlFormat = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
        for (PrtTaskResult.Attach att : attach) {
            String url = String.format(urlFormat, taskResult.getTaskId(), att.getAttachId());
            exportPdfReturn.getUrlList().add(url);
        }
        restApiPrintResult.setData((Object)exportPdfReturn);
        response.setData((Object)restApiPrintResult);
        response.setHttpStatus(200);
        return RestApiServiceData.ofTrue(response, (long)start, (long)System.currentTimeMillis());
    }

    private ExportPdfRequestData getRequestData(RestApiPrintParam param, PrintMetaDataConvertUtil convertUtil) {
        Map requestData = (Map)param.getRequest().getData();
        ExportPdfRequestData pdfRequestData = new ExportPdfRequestData();
        try {
            pdfRequestData = convertUtil.mapToBean(requestData, ExportPdfRequestData.class);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return pdfRequestData;
    }

    private String getAction(RestApiParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        String action = "";
        if (split.length > 1) {
            action = split[1];
        }
        return action;
    }

    private PrintWork getDefaultPrintWork() {
        PrintWork printWork = new PrintWork();
        printWork.setPageNumType("1");
        printWork.setExtParam(new HashMap(0));
        printWork.setExpType("pdf");
        printWork.setPrintLang(Lang.zh_CN.toString());
        printWork.setFileStorageType(FileStorageType.TEMP_FILE);
        return printWork;
    }
}

