/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print.bean;

import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.DatatypeConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.restapi.service.print.bean.NBasePropertyBlock;
import kd.bos.nocode.restapi.service.print.bean.TplBean;
import kd.bos.nocode.restapi.service.print.bean.annotation.FieldType;
import kd.bos.nocode.restapi.service.print.bean.control.NBaseControl;
import kd.bos.nocode.restapi.service.print.bean.control.NControl;
import kd.bos.nocode.restapi.service.print.bean.control.NControlBlock;
import kd.bos.nocode.restapi.service.print.bean.control.NDataCell;
import kd.bos.nocode.restapi.service.print.bean.control.NDataColumn;
import kd.bos.nocode.restapi.service.print.bean.control.NDataGrid;
import kd.bos.nocode.restapi.service.print.bean.control.NDataRow;
import kd.bos.nocode.restapi.service.print.bean.control.NFooter;
import kd.bos.nocode.restapi.service.print.bean.control.NGroupControl;
import kd.bos.nocode.restapi.service.print.bean.control.NImage;
import kd.bos.nocode.restapi.service.print.bean.control.NPaper;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseControl;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.HeaderFooter;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.QRCode;
import kd.bos.print.api.metedata.control.RichText;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridCell;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridColumn;
import kd.bos.print.api.metedata.control.prop.Border;
import kd.bos.print.api.metedata.control.prop.BorderProp;
import kd.bos.print.api.metedata.control.prop.Padding;
import kd.bos.print.api.metedata.control.support.IBorderSupport;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;

public class PrintMetaDataConvertUtil {
    private static final Log logger = LogFactory.getLog(PrintMetaDataConvertUtil.class);
    private static final String BOS_NOCODE_SERVICE = "bos-nocode-service";
    private TplBean tplBean;
    private NBasePropertyBlock basePropertyBlock;
    private Map<String, NDataSource> dataSourceMap;
    private String language;
    private double oneSizeWith;
    private static final Map<String, Method> writeMethodCache = new WeakHashMap<String, Method>(32);
    private static final Map<String, Map<String, Field>> fieldCache = new WeakHashMap<String, Map<String, Field>>(16);
    private static final Map<String, byte[]> imageByteMap = new HashMap<String, byte[]>(16);

    public static byte[] getImage(String key) {
        return imageByteMap.get(key);
    }

    public PrintMetadata resolveMetaJson(String tplJson) throws Exception {
        PrintMetadata metadata = new PrintMetadata();
        metadata.setType(NControlType.PRINT_METADATA);
        Map dataMap = (Map)JSONObject.parseObject((String)tplJson, Map.class);
        this.tplBean = this.mapToBean((Map)dataMap.get("printdesigner"), TplBean.class);
        this.basePropertyBlock = this.tplBean.getBaseProperty();
        String formId = this.tplBean.getFormId();
        this.dataSourceMap = this.getDataSourceMap(formId);
        metadata.setEntityId(formId);
        metadata.setFormId(formId);
        metadata.setName(this.getLocaleValue(formId, this.language));
        metadata.setVersion("2");
        metadata.setId(this.tplBean.getId());
        LocaleValue localeValue = new LocaleValue();
        localeValue.put(this.language, (Object)formId);
        metadata.setName(localeValue);
        metadata.setBizappId(this.tplBean.getBizappId());
        NPaper nPaper = this.tplBean.getPaper();
        Paper paper = this.convertToPaper(nPaper);
        metadata.setPaper(this.convertToPaper(nPaper));
        this.language = nPaper.getLanguage();
        Number containerWith = this.getPageContainerWith(paper);
        Number containerHeight = this.getPageContainerHeight(paper);
        this.oneSizeWith = containerWith.doubleValue() / 24.0;
        ArrayList pages = new ArrayList(1);
        metadata.setPages(pages);
        NFooter nHeader = this.tplBean.getHeader();
        NFooter nFooter = this.tplBean.getFooter();
        double endY = this.getEndY(containerHeight, nFooter);
        double startY = this.getStartY(nHeader);
        List<List<NControlBlock>> blocksList = this.getBlocksList(this.tplBean, endY, startY);
        for (List<NControlBlock> blocks : blocksList) {
            ArrayList<Control> page = new ArrayList<Control>(10);
            page.addAll(this.convertFooter(containerWith, nHeader, 0.0));
            page.addAll(this.convertChildrenControls(blocks, 0, 24, 0.0, startY, "body"));
            page.addAll(this.convertFooter(containerWith, nFooter, endY));
            pages.add(page);
        }
        if (pages.isEmpty() || pages.size() == 1 && ((List)pages.get(0)).isEmpty()) {
            metadata.getPaper().setVerticalEconomize(false);
        }
        return metadata;
    }

    private double getStartY(NFooter nHeader) {
        if (nHeader == null) {
            return 0.0;
        }
        return nHeader.getHeight().doubleValue();
    }

    private double getEndY(Number containerHeight, NFooter nFooter) {
        if (nFooter == null) {
            return containerHeight.doubleValue();
        }
        double footerY = containerHeight.doubleValue() - nFooter.getHeight().doubleValue();
        return footerY;
    }

    private List<Control> convertFooter(Number containerWith, NFooter nFooter, double footerY) {
        if (nFooter == null) {
            return new ArrayList<Control>(0);
        }
        ArrayList<Control> footerControlList = new ArrayList<Control>(10);
        HeaderFooter header = new HeaderFooter();
        footerControlList.add((Control)header);
        this.setControlProp(nFooter, (Control)header);
        header.setType(nFooter.getType());
        header.setHeight(this.getLocaleValue(this.language, nFooter.getHeight()));
        header.setWidth(this.getLocaleValue(this.language, containerWith));
        header.setX(this.getLocaleValue(this.language, 0));
        header.setY(this.getLocaleValue(this.language, footerY));
        List<NControlBlock> children = nFooter.getChildren();
        footerControlList.addAll(this.convertChildrenControls(children, 0, 24, 0.0, 0.0, "footer"));
        return footerControlList;
    }

    private Paper convertToPaper(NPaper nPaper) {
        Paper paper = new Paper();
        this.setControlProp(nPaper, (Control)paper);
        paper.setType(NControlType.PAPER);
        paper.setPaperType(nPaper.getPaperType());
        paper.setWidth(nPaper.getWidth());
        paper.setHeight(nPaper.getHeight());
        paper.setMarginTop(nPaper.getMarginTop());
        paper.setMarginBottom(nPaper.getMarginBottom());
        paper.setMarginLeft(nPaper.getMarginLeft());
        paper.setMarginRight(nPaper.getMarginRight());
        paper.setShowWaterMark(nPaper.getShowWaterMark());
        paper.setPaperDirection(nPaper.getPaperDirection());
        paper.setVerticalEconomize(true);
        return paper;
    }

    private List<List<NControlBlock>> getBlocksList(TplBean tplBean, double footerY, double startY) {
        List<List<NControlBlock>> pages = tplBean.getPages();
        return pages;
    }

    private List<List<NControlBlock>> getPageList(double footerY, double startY, List<NControlBlock> blocks) {
        if (CollectionUtils.isEmpty(blocks)) {
            return new ArrayList<List<NControlBlock>>(0);
        }
        ArrayList blocksList = new ArrayList(10);
        blocksList.add(new ArrayList(10));
        int subSize = 0;
        double maxHeight = 0.0;
        ArrayList<Double> maxHeightList = new ArrayList<Double>(10);
        for (NControlBlock block : blocks) {
            int size = block.getSize().intValue();
            if (size > 24) {
                String errMsg = this.getErrMsg(block);
                throw new KDBizException(ResManager.loadKDString((String)"%s\u7684\u5bbd\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u4e00\u9875\u3002", (String)"PrintMetaDataConvertUtil_0", (String)BOS_NOCODE_SERVICE, (Object[])new Object[]{errMsg}));
            }
            if ((subSize += size) > 24) {
                subSize = 0;
                blocksList.add(new ArrayList(10));
                maxHeightList.add(maxHeight);
            }
            if (maxHeight < block.getHeight().doubleValue()) {
                maxHeight = block.getHeight().doubleValue();
            }
            if (maxHeight > footerY - startY) {
                String errMsg = this.getErrMsg(block);
                throw new KDBizException(ResManager.loadKDString((String)"%s\u7684\u9ad8\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u4e00\u9875\u3002", (String)"PrintMetaDataConvertUtil_1", (String)BOS_NOCODE_SERVICE, (Object[])new Object[]{errMsg}));
            }
            ((List)blocksList.get(blocksList.size() - 1)).add(block);
        }
        if (maxHeightList.size() == blocksList.size() - 1) {
            maxHeightList.add(maxHeight);
        }
        ArrayList<List<NControlBlock>> res = new ArrayList<List<NControlBlock>>(10);
        res.add(new ArrayList(10));
        double subHeight = startY;
        for (int index = 0; index < maxHeightList.size(); ++index) {
            Double height = (Double)maxHeightList.get(index);
            if ((subHeight += height.doubleValue()) > footerY) {
                res.add(new ArrayList(10));
                subHeight = startY;
            }
            ((List)res.get(res.size() - 1)).addAll((Collection)blocksList.get(index));
        }
        return res;
    }

    private String getErrMsg(NControlBlock block) {
        NBaseControl headText = block.getHeadText();
        if (headText != null) {
            return headText.getViewText();
        }
        NControl bindControl = block.getBindControl();
        if (bindControl != null) {
            return bindControl.getId();
        }
        return SerializationUtils.toJsonString((Object)block);
    }

    private List<Control> convertChildrenControls(List<NControlBlock> blocks, int xPress, int endXPress, double startX, double startY, String containerType) {
        ArrayList<Control> controlList = new ArrayList<Control>(10);
        if (CollectionUtils.isEmpty(blocks)) {
            return controlList;
        }
        int startXPress = xPress;
        double maxHeight = 0.0;
        for (int index = 0; index < blocks.size(); ++index) {
            NControlBlock block = blocks.get(index);
            int size = block.getSize().intValue();
            double x = (double)xPress * this.oneSizeWith;
            if ((xPress += size) > endXPress) {
                xPress = startXPress + size;
                x = startX;
                startY = startY + maxHeight + this.basePropertyBlock.getRowMargin().doubleValue();
                maxHeight = 0.0;
            }
            ControlBlock controlBlock = this.createControl(xPress, x, startY, block, containerType);
            if (maxHeight < block.getHeight().doubleValue()) {
                maxHeight = block.getHeight().doubleValue();
            }
            if (controlBlock.getHeadText() != null) {
                controlList.add((Control)controlBlock.getHeadText());
            }
            if (CollectionUtils.isEmpty(controlBlock.getBody())) continue;
            controlList.addAll(controlBlock.getBody());
        }
        return controlList;
    }

    private Map<String, NDataSource> getDataSourceMap(String formId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        Map fieldMap = dataEntityType.getFields();
        HashMap<String, NDataSource> dataSourceMap = new HashMap<String, NDataSource>(fieldMap.size());
        for (Map.Entry entry : fieldMap.entrySet()) {
            String fieldKey = (String)entry.getKey();
            String dataSource = formId;
            String dsType = NDataSource.DS_TYPE[0];
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (property != null) {
                IDataEntityType parent = property.getParent();
                if (parent instanceof EntryType) {
                    String name = parent.getName();
                    dataSource = dataSource + "." + name;
                    dsType = NDataSource.DS_TYPE[1];
                } else if (property instanceof NoCodeImageProp) {
                    dataSource = dataSource + "." + property.getName();
                    dsType = NDataSource.DS_TYPE[1];
                }
            }
            dataSourceMap.put(fieldKey, new NDataSource(dataSource, dsType));
        }
        Map allEntities = dataEntityType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (!(entityType instanceof EntryType)) continue;
            dataSourceMap.put((String)entry.getKey(), new NDataSource(formId + "." + (String)entry.getKey(), NDataSource.DS_TYPE[1]));
        }
        return dataSourceMap;
    }

    private ControlBlock createControl(int endXPress, Number startX, Number startY, NControlBlock block, String containerType) {
        ControlBlock controlBlock = new ControlBlock();
        ArrayList<Control> body = new ArrayList<Control>(10);
        controlBlock.setBody(body);
        controlBlock.setEndX(startX);
        controlBlock.setEndY(startY);
        if (NControlType.IMAGE.equals(block.getBlockType())) {
            if ("footer".equals(containerType)) {
                Image image = new Image();
                body.add((Control)image);
                controlBlock.setEndX(startX.doubleValue() + 2.0);
                return this.createControlBlock(block, controlBlock);
            }
            if ("body".equals(containerType) || NControlType.GROUP_CONTAINER.equals(containerType)) {
                return this.createImageBlock(block, controlBlock);
            }
        }
        if (NControlType.TEXT.equals(block.getBlockType())) {
            if (block.getBindControl() != null) {
                Text bindFieldControl = new Text();
                body.add((Control)bindFieldControl);
            }
            return this.createControlBlock(block, controlBlock);
        }
        if (NControlType.QRCODE.equals(block.getBlockType())) {
            if (block.getBindControl() != null) {
                QRCode bindFieldControl = new QRCode();
                body.add((Control)bindFieldControl);
            }
            if ("footer".equals(containerType)) {
                controlBlock.setEndX(this.oneSizeWith * 24.0 - 33.0);
            }
            return this.createControlBlock(block, controlBlock);
        }
        if (NControlType.RICH_TEXT.equals(block.getBlockType())) {
            if (block.getBindControl() != null) {
                RichText bindFieldControl = new RichText();
                body.add((Control)bindFieldControl);
            }
            return this.createControlBlock(block, controlBlock);
        }
        if (NControlType.DATA_GRID.equals(block.getBlockType())) {
            return this.createDataGridBlock(block, controlBlock);
        }
        if (NControlType.GROUP_CONTAINER.equals(block.getBlockType())) {
            this.createGroupBlock(endXPress, block, controlBlock);
        }
        return controlBlock;
    }

    private void createGroupBlock(int endXPress, NControlBlock block, ControlBlock controlBlock) {
        List<Control> body = controlBlock.getBody();
        Number startX = controlBlock.getEndX();
        Number startY = controlBlock.getEndY();
        double offset = this.createHeadText(block, controlBlock);
        startY = startY.doubleValue() + offset;
        NGroupControl groupControl = (NGroupControl)block.getBindControl();
        if (groupControl == null) {
            return;
        }
        List<NControlBlock> childrenBlock = groupControl.getChildren();
        List<Control> controlList = this.convertChildrenControls(childrenBlock, endXPress - block.getSize().intValue(), endXPress, startX.doubleValue(), startY.doubleValue(), NControlType.GROUP_CONTAINER);
        body.addAll(controlList);
        Number height = groupControl.getHeight() == null ? (Number)0 : (Number)groupControl.getHeight();
        controlBlock.setEndY(startY.doubleValue() + height.doubleValue());
        controlBlock.setEndX(startX.doubleValue() + (double)block.getSize().intValue() * this.oneSizeWith);
    }

    private ControlBlock createDataGridBlock(NControlBlock block, ControlBlock controlBlock) {
        NDataGrid nGrid = (NDataGrid)block.getBindControl();
        List<Control> body = controlBlock.getBody();
        List<NDataRow> rows = nGrid.getRows();
        Number startX = controlBlock.getEndX();
        Number startY = controlBlock.getEndY();
        double offset = this.createHeadText(block, controlBlock);
        startY = startY.doubleValue() + offset;
        DataGrid dataGrid = new DataGrid();
        body.add((Control)dataGrid);
        dataGrid.setAutoAdjustHeight(true);
        dataGrid.setWholeRowPage(true);
        this.setControlProp(nGrid, (Control)dataGrid, startX, startY);
        String bindField = nGrid.getBindField();
        if (this.dataSourceMap.containsKey(bindField)) {
            NDataSource nDataSource = this.dataSourceMap.get(bindField);
            String ds = nDataSource.getDataSource();
            dataGrid.setDataSource(ds);
        }
        dataGrid.setType(NControlType.DATA_GRID);
        dataGrid.setHeight(this.getLocaleValue(this.language, nGrid.getHeight()));
        dataGrid.setWidth(this.getLocaleValue(this.language, nGrid.getSize().doubleValue() * this.oneSizeWith));
        for (NDataRow nRow : rows) {
            DataGridRow gridRow = new DataGridRow();
            this.setControlProp(nRow, (Control)gridRow);
            gridRow.setHeight(this.getLocaleValue(this.language, nRow.getHeight()));
            gridRow.setType(NControlType.DATA_ROW);
            gridRow.setRowType(nRow.getRowType());
            gridRow.setRowHeight(this.getLocaleValue(this.language, nRow.getHeight()));
            gridRow.setHeight(new LocaleValue(this.language, (Object)0, this.language));
            body.add((Control)gridRow);
        }
        dataGrid.setFixedRowCount(rows.size());
        List<NDataColumn> nColumns = nGrid.getColumns();
        ArrayList<LayoutGridColumn> columnList = new ArrayList<LayoutGridColumn>(nColumns.size());
        for (NDataColumn nColumn : nColumns) {
            LayoutGridColumn column = new LayoutGridColumn();
            body.add((Control)column);
            this.setControlProp(nColumn, (Control)column);
            column.setColumnWidth(this.getLocaleValue(this.language, nColumn.getColumnWidth()));
            columnList.add(column);
        }
        for (NDataRow row : rows) {
            List<NDataCell> cells = row.getCells();
            for (int index = 0; index < cells.size(); ++index) {
                NDataCell nCell = cells.get(index);
                nCell.setWidth(nColumns.get(index).getColumnWidth());
                DataGridCell gridCell = new DataGridCell();
                this.setControlProp(nCell, (Control)gridCell, startX, startY);
                List<NBaseControl> nCellChildren = nCell.getChildren();
                ArrayList<Image> children = new ArrayList<Image>(10);
                if (!CollectionUtils.isEmpty(nCellChildren)) {
                    double subWidth = 0.0;
                    String paddingString = this.getPaddingString(nCell);
                    if (StringUtils.isNotBlank((CharSequence)paddingString)) {
                        subWidth = KPrintUtil.printPointToLom((double)new BigDecimal(paddingString.split(" ")[3]).doubleValue()) / 10.0;
                    }
                    for (NBaseControl child : nCellChildren) {
                        Object control = child instanceof NImage ? new Image() : new Text();
                        this.setControlProp(child, (Control)control, startX, startY);
                        if (StringUtils.isNotBlank((CharSequence)control.getBindField())) {
                            control.setDataSource(dataGrid.getDataSource());
                            control.setDsType("Entry");
                        }
                        control.setX(this.getLocaleValue(this.language, 0.0 + subWidth));
                        Number cellHeight = this.getHeight(nCell);
                        Number childHeight = this.getHeight(child);
                        control.setY(this.getLocaleValue(this.language, (cellHeight.doubleValue() - childHeight.doubleValue()) / 2.0));
                        subWidth += this.getWith(child).doubleValue();
                        children.add((Image)control);
                    }
                }
                startX = startX.doubleValue() + nCell.getWidth().doubleValue();
                gridCell.setColumnId(((LayoutGridColumn)columnList.get(index)).getId());
                gridCell.setRowId(row.getId());
                gridCell.setParentId(dataGrid.getId());
                gridCell.setId(nCell.getId());
                gridCell.setCellType(row.getRowType());
                if (StringUtils.isNotBlank((CharSequence)gridCell.getBindField())) {
                    gridCell.setDataSource(dataGrid.getDataSource());
                    gridCell.setDsType("Entry");
                }
                gridCell.setBorder(dataGrid.getBorder());
                gridCell.setX(new LocaleValue(this.language, (Object)0, this.language));
                gridCell.setY(new LocaleValue(this.language, (Object)0, this.language));
                body.add((Control)gridCell);
                body.addAll(children);
            }
            startY = startY.doubleValue() + this.getHeight(row).doubleValue();
        }
        controlBlock.setEndX(startX);
        controlBlock.setEndY(startY);
        return controlBlock;
    }

    private double createHeadText(NControlBlock block, ControlBlock controlBlock) {
        NBaseControl nHeadText = block.getHeadText();
        Number startX = controlBlock.getEndX();
        Number startY = controlBlock.getEndY();
        double offset = 0.0;
        if (nHeadText != null) {
            Text headText = new Text();
            controlBlock.setHeadText(headText);
            this.setControlProp(nHeadText, (Control)headText, startX, startY);
            Number height = this.getHeight(nHeadText);
            String titleMargin = this.getTitleMargin(block);
            String[] split = titleMargin.split(" ");
            BigDecimal bomWith = new BigDecimal(split[2]);
            offset = height.doubleValue() + ((Number)bomWith).doubleValue();
        }
        return offset;
    }

    private String getTitleMargin(NControlBlock nBaseControl) {
        String titleMargin = nBaseControl.getTitleMargin();
        if (StringUtils.isBlank((CharSequence)titleMargin)) {
            titleMargin = this.basePropertyBlock.getTitleMargin();
        }
        return titleMargin;
    }

    private Number getHeight(NBaseControl nBaseControl) {
        Number height = nBaseControl.getHeight();
        if (height == null || height.doubleValue() == 0.0) {
            height = this.basePropertyBlock.getHeight();
        }
        return height;
    }

    private ControlBlock createControlBlock(NControlBlock block, ControlBlock controlBlock) {
        NControl nBindControl = block.getBindControl();
        double offset = this.createHeadText(block, controlBlock);
        if (nBindControl instanceof NBaseControl) {
            NBaseControl baseControl = (NBaseControl)nBindControl;
            List<Control> body = controlBlock.getBody();
            Number startX = controlBlock.getEndX();
            Number startY = controlBlock.getEndY();
            for (Control control : body) {
                startY = startY.doubleValue() + offset;
                this.setControlProp(baseControl, control, startX, startY);
                startY = startY.doubleValue() + this.getHeight(baseControl).doubleValue();
                if (!(control instanceof Image) || !(nBindControl instanceof NImage)) continue;
                NImage nImage = (NImage)nBindControl;
                Image image = (Image)control;
                String base64 = nImage.getBase64();
                if (!StringUtils.isNotBlank((CharSequence)base64)) continue;
                if (base64.contains("data:")) {
                    int start = base64.indexOf(",");
                    base64 = base64.substring(start + 1);
                }
                base64 = base64.replaceAll("\r|\n", "");
                String imageMd5str = PrintMetaDataConvertUtil.getMD5str(base64 = base64.trim());
                if (!imageByteMap.containsKey(imageMd5str)) {
                    byte[] decode = DatatypeConverter.parseBase64Binary((String)base64);
                    imageByteMap.put(imageMd5str, decode);
                }
                image.setBindType("base64");
                image.setDataSource(this.tplBean.getFormId());
                image.setDsType("Main");
                image.setBindField(imageMd5str);
            }
            controlBlock.setEndX(startX);
            controlBlock.setEndY(startY);
            return controlBlock;
        }
        return controlBlock;
    }

    private static String getMD5str(String str) {
        try {
            MessageDigest cmd = MessageDigest.getInstance("MD5");
            cmd.update(str.getBytes());
            byte[] resultBytes = cmd.digest();
            StringBuilder buf = new StringBuilder();
            for (byte b : resultBytes) {
                buf.append(String.format("%02X", b));
            }
            return buf.toString().toUpperCase();
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
            return "";
        }
    }

    private ControlBlock createImageBlock(NControlBlock nControlBlock, ControlBlock controlBlock) {
        NImage nImage = (NImage)nControlBlock.getBindControl();
        NDataGrid nGrid = new NDataGrid();
        nGrid.setRows(new ArrayList<NDataRow>(1));
        nGrid.setId(nImage.getId());
        nGrid.setParentId(nImage.getParentId());
        nGrid.setBindField(nImage.getBindField());
        nGrid.setViewText(nImage.getViewText());
        nGrid.setSize(nImage.getSize());
        nGrid.setType(NControlType.DATA_GRID);
        nGrid.setHeight(nImage.getHeight());
        int cellCount = nImage.getSize().intValue() / 6;
        NDataRow dataRow = new NDataRow();
        dataRow.setId(Uuid8.generateShortUuid());
        dataRow.setParentId(nGrid.getId());
        dataRow.setCells(new ArrayList<NDataCell>(10));
        dataRow.setRowType("Detail");
        dataRow.setHeight(nImage.getHeight());
        dataRow.setType(NControlType.DATA_ROW);
        nGrid.getRows().add(dataRow);
        for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
            NDataCell cell = new NDataCell();
            cell.setType(NControlType.DATA_CELL);
            if (StringUtils.isNotBlank((CharSequence)nImage.getBindField())) {
                cell.setBindField(nImage.getBindField() + "_index_" + cellIndex);
            }
            cell.setWidth(nImage.getWidth());
            cell.setRowId(dataRow.getId());
            cell.setId(Uuid8.generateShortUuid());
            cell.setHorAlignment(this.getHorAlignment(nImage));
            if (cellIndex == 0) {
                cell.setHorAlignment("left");
            }
            cell.setPadding(this.getPaddingString(nImage));
            dataRow.getCells().add(cell);
        }
        nGrid.setColumns(new ArrayList<NDataColumn>(dataRow.getCells().size()));
        List<NDataColumn> columns = nGrid.getColumns();
        for (NDataCell cell : dataRow.getCells()) {
            NDataColumn column = new NDataColumn();
            column.setId(Uuid8.generateShortUuid());
            column.setParentId(nGrid.getId());
            column.setType(NControlType.DATA_COLUMN);
            column.setColumnWidth(nImage.getWidth());
            cell.setColumnId(column.getId());
            columns.add(column);
        }
        nControlBlock.setBindControl(nGrid);
        return this.createDataGridBlock(nControlBlock, controlBlock);
    }

    private void setControlProp(NBaseControl nBaseControl, Control control, Number x, Number y) {
        this.setControlProp(nBaseControl, control);
        if (control instanceof BaseControl) {
            BaseControl baseControl = (BaseControl)control;
            baseControl.setX(this.getLocaleValue(this.language, x));
            baseControl.setY(this.getLocaleValue(this.language, y));
            Number height = this.getHeight(nBaseControl);
            baseControl.setHeight(this.getLocaleValue(this.language, height));
            Number with = this.getWith(nBaseControl);
            baseControl.setWidth(this.getLocaleValue(this.language, with));
            this.setDataSource(nBaseControl, control, this.dataSourceMap);
            this.setText(nBaseControl, control, this.language);
            this.setBorder(nBaseControl, control, this.language);
        }
    }

    private Number getWith(NBaseControl nBaseControl) {
        Number size = nBaseControl.getSize();
        if (size == null) {
            return nBaseControl.getWidth();
        }
        return this.oneSizeWith * size.doubleValue();
    }

    private void setDataSource(NBaseControl nBaseControl, Control control, Map<String, NDataSource> dataSourceMap) {
        if (control instanceof BaseDsControl) {
            BaseDsControl dsControl = (BaseDsControl)control;
            if (this.isNotBindField(nBaseControl)) {
                dsControl.setBindText(this.getLocaleValue(this.language, nBaseControl.getViewText()));
                return;
            }
            String bindField = nBaseControl.getBindField();
            dsControl.setBindField(bindField);
            dsControl.setBindText(this.getLocaleValue(this.language, bindField));
            if (StringUtils.isNotBlank((CharSequence)nBaseControl.getDataSource())) {
                dsControl.setDataSource(nBaseControl.getDataSource());
                dsControl.setDsType(nBaseControl.getDsType());
                return;
            }
            if (dataSourceMap.containsKey(bindField)) {
                NDataSource nDataSource = dataSourceMap.get(bindField);
                dsControl.setDataSource(nDataSource.getDataSource());
                dsControl.setDsType(nDataSource.getDsType());
            }
        }
    }

    private boolean isNotBindField(NBaseControl nBaseControl) {
        if (nBaseControl.isIsTitle()) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)nBaseControl.getBindField());
    }

    private void setBorder(NBaseControl nBaseControl, Control control, String language) {
        if (control instanceof IBorderSupport) {
            IBorderSupport borderSupport = (IBorderSupport)control;
            String borderString = nBaseControl.getBorder();
            if (StringUtils.isNotBlank((CharSequence)borderString)) {
                String[] split = borderString.split(" ");
                Border border = Border.newDefault();
                BorderProp width = border.getWidth();
                String with = split[0];
                String style = split[1];
                String color = split[2];
                width.setTop((Object)new BigDecimal(with));
                width.setRight((Object)new BigDecimal(with));
                width.setBottom((Object)new BigDecimal(with));
                width.setLeft((Object)new BigDecimal(with));
                BorderProp borderStyle = border.getStyle();
                borderStyle.setTop((Object)style);
                borderStyle.setRight((Object)style);
                borderStyle.setBottom((Object)style);
                borderStyle.setLeft((Object)style);
                BorderProp borderColor = border.getColor();
                borderColor.setTop((Object)color);
                borderColor.setRight((Object)color);
                borderColor.setBottom((Object)color);
                borderColor.setLeft((Object)color);
                borderSupport.setBorder(this.getLocaleValue(language, border));
            }
        }
    }

    private void setText(NBaseControl nBaseControl, Control control, String language) {
        if (control instanceof Text) {
            String backColor;
            String foreColor;
            Text text = (Text)control;
            if (this.isNotBindField(nBaseControl)) {
                text.setViewText(nBaseControl.getViewText());
            }
            Number fontSize = this.getFontSize(nBaseControl);
            String fontName = this.getFontName(nBaseControl);
            text.setFontSize(this.getLocaleValue(language, fontSize.intValue()));
            text.setFontName(this.getLocaleValue(language, fontName));
            text.setBold(this.getLocaleValue(language, nBaseControl.isBold()));
            text.setUnderLine(this.getLocaleValue(language, nBaseControl.isUnderLine()));
            text.setItalic(this.getLocaleValue(language, nBaseControl.isItalic()));
            text.setStrike(this.getLocaleValue(language, nBaseControl.isStrike()));
            text.setHorAlignment(this.getLocaleValue(language, this.getHorAlignment(nBaseControl)));
            text.setVerAlignment(this.getLocaleValue(language, this.getVerAlignment(nBaseControl)));
            text.setTextOverFlow("WrapLine");
            String paddingString = this.getPaddingString(nBaseControl);
            if (StringUtils.isNotBlank((CharSequence)paddingString)) {
                String[] split = paddingString.split(" ");
                Padding padding = new Padding();
                padding.setTop((Number)new BigDecimal(split[0]));
                padding.setRight((Number)new BigDecimal(split[1]));
                padding.setBottom((Number)new BigDecimal(split[2]));
                padding.setLeft((Number)new BigDecimal(split[3]));
                text.setPadding(this.getLocaleValue(language, padding));
            }
            if (StringUtils.isNotBlank((CharSequence)(foreColor = this.getForeColor(nBaseControl)))) {
                text.setForeColor(this.getLocaleValue(language, foreColor));
            }
            if (StringUtils.isNotBlank((CharSequence)(backColor = this.getBackColor(nBaseControl)))) {
                text.setBackColor(this.getLocaleValue(language, backColor));
            }
        }
        if (control instanceof RichText) {
            String fontName = this.getFontName(nBaseControl);
            RichText richText = (RichText)control;
            richText.setFontName(this.getLocaleValue(language, fontName));
            String paddingString = this.getPaddingString(nBaseControl);
            if (StringUtils.isNotBlank((CharSequence)paddingString)) {
                String[] split = paddingString.split(" ");
                BigDecimal left = new BigDecimal(split[3]);
                richText.setX(this.getLocaleValue(language, ((Number)richText.getX().getLocaleValue()).doubleValue() + KPrintUtil.printPointToLom((double)left.doubleValue()) / 10.0 - 2.0));
            }
        }
    }

    private String getHorAlignment(NBaseControl nBaseControl) {
        String horAlignment = nBaseControl.getHorAlignment();
        if (StringUtils.isBlank((CharSequence)horAlignment)) {
            horAlignment = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getHorAlignment() : this.basePropertyBlock.getBindControlProp().getHorAlignment();
        }
        return horAlignment;
    }

    private String getVerAlignment(NBaseControl nBaseControl) {
        String verAlignment = nBaseControl.getVerAlignment();
        if (StringUtils.isBlank((CharSequence)verAlignment)) {
            verAlignment = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getVerAlignment() : this.basePropertyBlock.getBindControlProp().getVerAlignment();
        }
        return verAlignment;
    }

    private String getBackColor(NBaseControl nBaseControl) {
        String backColor = nBaseControl.getBackColor();
        if (StringUtils.isBlank((CharSequence)backColor)) {
            backColor = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getBackColor() : this.basePropertyBlock.getBindControlProp().getBackColor();
        }
        return backColor;
    }

    private String getForeColor(NBaseControl nBaseControl) {
        String foreColor = nBaseControl.getForeColor();
        if (StringUtils.isBlank((CharSequence)foreColor)) {
            foreColor = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getForeColor() : this.basePropertyBlock.getBindControlProp().getForeColor();
        }
        return foreColor;
    }

    private String getPaddingString(NBaseControl nBaseControl) {
        String paddingString = nBaseControl.getPadding();
        if (StringUtils.isBlank((CharSequence)paddingString)) {
            paddingString = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getPadding() : this.basePropertyBlock.getBindControlProp().getPadding();
        }
        return paddingString;
    }

    private String getFontName(NBaseControl nBaseControl) {
        String fontName = nBaseControl.getFontName();
        if (StringUtils.isBlank((CharSequence)fontName)) {
            fontName = this.isNotBindField(nBaseControl) ? this.basePropertyBlock.getHeadTextProp().getFontName() : this.basePropertyBlock.getBindControlProp().getFontName();
        }
        return fontName;
    }

    private Number getFontSize(NBaseControl nBaseControl) {
        Number fontSize = nBaseControl.getFontSize();
        if (fontSize == null || fontSize.intValue() == 0) {
            fontSize = this.isNotBindField(nBaseControl) ? Integer.valueOf(this.basePropertyBlock.getHeadTextProp().getFontSize().intValue()) : Integer.valueOf(this.basePropertyBlock.getBindControlProp().getFontSize().intValue());
        }
        return fontSize;
    }

    private void setControlProp(NControl nControl, Control control) {
        control.setId(nControl.getId());
        control.setParentId(nControl.getParentId());
        control.setKey(nControl.getKey());
        control.setType(nControl.getType());
    }

    private Number getPageContainerHeight(Paper paper) {
        Number marginTop = paper.getMarginTop();
        Number marginBottom = paper.getMarginBottom();
        Number height = paper.getHeight();
        double i = height.doubleValue() - marginTop.doubleValue() - marginBottom.doubleValue();
        return i;
    }

    private Number getPageContainerWith(Paper paper) {
        Number marginLeft = paper.getMarginLeft();
        Number marginRight = paper.getMarginRight();
        Number width = paper.getWidth();
        double containerWith = width.doubleValue() - marginLeft.doubleValue() - marginRight.doubleValue();
        return containerWith;
    }

    private <T> LocaleValue<T> getLocaleValue(String language, T number) {
        LocaleValue localeValue = new LocaleValue(language, number, language);
        return localeValue;
    }

    private Class getControlClass(Map<String, Object> controlMap) {
        if (controlMap.containsKey("blockType")) {
            return NControlBlock.class;
        }
        String type = (String)controlMap.get("type");
        if (NControlType.IMAGE.equals(type)) {
            return NImage.class;
        }
        if (NControlType.DATA_GRID.equals(type)) {
            return NDataGrid.class;
        }
        if (NControlType.DATA_ROW.equals(type)) {
            return NDataRow.class;
        }
        if (NControlType.DATA_COLUMN.equals(type)) {
            return NDataColumn.class;
        }
        if (NControlType.DATA_CELL.equals(type)) {
            return NDataCell.class;
        }
        if (NControlType.GROUP_CONTAINER.equals(type)) {
            return NGroupControl.class;
        }
        return NBaseControl.class;
    }

    public <T> T mapToBean(Map<String, Object> dataMap, Class<T> claz) throws Exception {
        if (CollectionUtils.isEmpty(dataMap)) {
            return null;
        }
        Constructor<T> constructor = claz.getConstructor(new Class[0]);
        T instance = constructor.newInstance(new Object[0]);
        Map<String, Field> fieldMap = this.getAllFields(instance);
        for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
            String fieldName = entry.getKey();
            if (!fieldMap.containsKey(fieldName)) continue;
            Object value = dataMap.get(fieldName);
            Field field = entry.getValue();
            FieldType annotation = field.getAnnotation(FieldType.class);
            if (annotation == null) {
                if (ObjectUtils.isEmpty((Object)value)) continue;
                this.setFieldValue(instance, field, value);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)value)) {
                if (annotation.type() != FieldType.Type.NOTNULL) continue;
                throw new KDBizException(field.getName() + " is not null " + SerializationUtils.toJsonString(dataMap));
            }
            Class<?> target = annotation.target();
            FieldType.Type type = annotation.type();
            if (FieldType.Type.IGNORE == type) continue;
            if (FieldType.Type.SPECIAL == type) {
                Class<?> controlClass = this.getControlClass((Map)value);
                if (!target.isAssignableFrom(controlClass)) {
                    controlClass = target;
                }
                Object v = this.mapToBean((Map)value, controlClass);
                this.setFieldValue(instance, field, v);
                continue;
            }
            if (FieldType.Type.LIST == type) {
                List valueList;
                ArrayList<ArrayList<Object>> vList;
                if (target == List.class) {
                    vList = new ArrayList<ArrayList<Object>>(10);
                    valueList = (List)value;
                    for (List page : valueList) {
                        ArrayList<T> pageList = new ArrayList<T>(page.size());
                        for (Map map : page) {
                            if (map == null) continue;
                            Class controlClass = this.getControlClass(map);
                            T item = this.mapToBean(map, controlClass);
                            pageList.add(item);
                        }
                        vList.add(pageList);
                    }
                    this.setFieldValue(instance, field, vList);
                    continue;
                }
                vList = new ArrayList(10);
                valueList = (List)value;
                for (Map map : valueList) {
                    if (map == null) continue;
                    Class controlClass = this.getControlClass(map);
                    T item = this.mapToBean(map, controlClass);
                    vList.add((ArrayList<Object>)item);
                }
                this.setFieldValue(instance, field, vList);
                continue;
            }
            this.setFieldValue(instance, field, value);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFieldValue(Object bean, Field field, Object value) throws Exception {
        String methodKey = bean.getClass().toString() + field.getName();
        Method writeMethod = writeMethodCache.get(methodKey);
        if (writeMethod != null) {
            try {
                writeMethod.invoke(bean, value);
            }
            catch (Exception e) {
                System.out.println(1);
            }
            return;
        }
        Class<PrintMetaDataConvertUtil> e = PrintMetaDataConvertUtil.class;
        synchronized (PrintMetaDataConvertUtil.class) {
            writeMethod = writeMethodCache.get(methodKey);
            if (writeMethod == null) {
                PropertyDescriptor propDesc = new PropertyDescriptor(field.getName(), bean.getClass());
                writeMethod = propDesc.getWriteMethod();
                writeMethodCache.put(methodKey, writeMethod);
            }
            // ** MonitorExit[e] (shouldn't be in output)
            try {
                writeMethod.invoke(bean, value);
            }
            catch (Exception e2) {
                System.out.println(1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Field> getAllFields(Object bean) {
        String key = bean.getClass().getName();
        Map<String, Field> fieldMap = fieldCache.get(key);
        if (fieldMap != null) {
            return fieldMap;
        }
        Class<PrintMetaDataConvertUtil> clazz = PrintMetaDataConvertUtil.class;
        synchronized (PrintMetaDataConvertUtil.class) {
            fieldMap = fieldCache.get(key);
            if (fieldMap != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return fieldMap;
            }
            fieldMap = new HashMap<String, Field>(16);
            for (Class<?> tempClass = bean.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = tempClass.getDeclaredFields()) {
                    if (field.isSynthetic() || fieldMap.containsKey(field.getName())) continue;
                    fieldMap.put(field.getName(), field);
                }
            }
            fieldCache.put(key, fieldMap);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return fieldMap;
        }
    }

    static class NDataSource {
        static String[] DS_TYPE = new String[]{"Main", "Entry", "Sys"};
        private String dataSource;
        private String dsType;

        public NDataSource(String dataSource, String dsType) {
            this.dataSource = dataSource;
            this.dsType = dsType;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public String getDsType() {
            return this.dsType;
        }

        public void setDsType(String dsType) {
            this.dsType = dsType;
        }
    }

    static class NControlType {
        static String PRINT_METADATA = "PrintMetadata";
        static String PAPER = "Paper";
        static String GROUP_CONTAINER = "GroupContainer";
        static String TEXT = "Text";
        static String IMAGE = "Image";
        static String QRCODE = "QRCode";
        static String RICH_TEXT = "RichText";
        static String HEADER = "Header";
        static String FOOTER = "Footer";
        static String DATA_GRID = "DataGrid";
        static String DATA_ROW = "DataRow";
        static String DATA_COLUMN = "DataColumn";
        static String DATA_CELL = "DataCell";

        NControlType() {
        }
    }

    static class ControlBlock {
        private String type;
        private Number endX;
        private Number endY;
        private Text headText;
        private List<Control> body;

        ControlBlock() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Text getHeadText() {
            return this.headText;
        }

        public void setHeadText(Text headText) {
            this.headText = headText;
        }

        public List<Control> getBody() {
            return this.body;
        }

        public void setBody(List<Control> body) {
            this.body = body;
        }

        public Number getEndX() {
            return this.endX;
        }

        public void setEndX(Number endX) {
            this.endX = endX;
        }

        public Number getEndY() {
            return this.endY;
        }

        public void setEndY(Number endY) {
            this.endY = endY;
        }
    }
}

