/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print.dataprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.restapi.service.print.bean.PrintMetaDataConvertUtil;
import kd.bos.nocode.restapi.service.print.dataprovider.DefaultField;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ConvertParam;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ConvertProxy;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ExtParam;
import kd.bos.nocode.restapi.service.print.datasource.ImageFieldSetting;
import kd.bos.nocode.restapi.service.print.datasource.NCPrintDataSource;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrintDataQueryUtil {
    private MainEntityType mainEntityType;

    public void init(MainEntityType mainEntityType) {
        this.mainEntityType = mainEntityType;
    }

    public List<DataRowSet> queryDataRowSets(PrtDataSource dataSource) {
        NCPrintDataSource ncPrintDataSource = (NCPrintDataSource)dataSource;
        this.init(ncPrintDataSource.getMainEntityType());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ncPrintDataSource.getSortPKIds().toArray(), (DynamicObjectType)this.mainEntityType);
        DataEntityPropertyCollection properties = this.mainEntityType.getProperties();
        ArrayList<DataRowSet> dataRowSetList = new ArrayList<DataRowSet>(load.length);
        for (DynamicObject dynamicObject : load) {
            DataRowSet dataRowSet = this.getDataRowSet((PrtDataSource)ncPrintDataSource, properties, dynamicObject);
            this.fillEntryData((FormDataSource)ncPrintDataSource, dynamicObject, dataRowSet);
            dataRowSetList.add(dataRowSet);
        }
        return dataRowSetList;
    }

    private void fillEntryData(FormDataSource mainDs, DynamicObject rowData, DataRowSet dataRowSet) {
        List childrenDs = mainDs.getChildrenDs();
        for (PrtDataSource childDs : childrenDs) {
            String dsName = childDs.getDsName();
            EntityType entityType = this.getEntityType(dsName);
            if (entityType == null || DsType.ENTRY != childDs.getDsType()) continue;
            DynamicObjectCollection entryCollection = rowData.getDynamicObjectCollection(entityType.getName());
            CollectionField collectionField = new CollectionField();
            for (int i = 0; i < entryCollection.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCollection.get(i);
                DataRowSet entryRow = this.getDataRowSet(childDs, entityType.getProperties(), entryObj);
                entryRow.put("seq", (Field)new IntegerField(Integer.valueOf(i + 1)));
                collectionField.add(entryRow);
            }
            dataRowSet.put(entityType.getName(), (Field)collectionField);
        }
    }

    private EntityType getEntityType(String dsName) {
        Map allEntities = this.mainEntityType.getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    private DataRowSet getDataRowSet(PrtDataSource dataSource, DataEntityPropertyCollection properties, DynamicObject dynamicObject) {
        DataRowSet dataRowSet = new DataRowSet();
        HashMap<String, ImageFieldSetting> imageFieldSettingMap = new HashMap(0);
        if (dataSource instanceof NCPrintDataSource) {
            NCPrintDataSource ncPrintDataSource = (NCPrintDataSource)dataSource;
            imageFieldSettingMap = ncPrintDataSource.getImageFieldSettingMap();
        }
        List queryField = dataSource.getQueryField();
        for (String fieldKey : queryField) {
            Field field = this.getField(properties, dynamicObject, fieldKey, imageFieldSettingMap);
            dataRowSet.put(fieldKey, field);
        }
        return dataRowSet;
    }

    private Field getField(DataEntityPropertyCollection properties, DynamicObject dynamicObject, String fieldKey, Map<String, ImageFieldSetting> imageFieldSettingMap) {
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            return new TextField("");
        }
        String[] propKeys = fieldKey.split("\\.");
        if (propKeys.length == 1) {
            String propKey = propKeys[0];
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            ImageFieldSetting setting = imageFieldSettingMap.get(fieldKey);
            if (setting != null && "staticImage".equals(setting.getType())) {
                byte[] image = PrintMetaDataConvertUtil.getImage(fieldKey);
                ImageField imageField = new ImageField(fieldKey, image);
                return imageField;
            }
            if (property == null) {
                return DefaultField.getDefaultField();
            }
            Object value = property.getValue((Object)dynamicObject);
            ConvertParam convertParam = new ConvertParam();
            convertParam.setValue(value);
            convertParam.setProperty(property);
            convertParam.setCurrDynObj(dynamicObject);
            this.setImageCustomParam(imageFieldSettingMap, property, convertParam, propKeys);
            Field field = ConvertProxy.convertField(convertParam);
            return field;
        }
        IDataEntityProperty property = null;
        Object value = null;
        DynamicObject parent = dynamicObject;
        for (int index = 0; index < propKeys.length; ++index) {
            String propKey = propKeys[index];
            DataEntityPropertyCollection propertyCollection = parent.getDataEntityType().getProperties();
            property = (IDataEntityProperty)propertyCollection.get((Object)propKey);
            if (property == null) {
                return DefaultField.getDefaultField();
            }
            value = property.getValue((Object)parent);
            if (value instanceof DynamicObject) {
                parent = (DynamicObject)value;
            }
            if (property instanceof NoCodeImageProp) break;
        }
        ConvertParam convertParam = new ConvertParam();
        convertParam.setValue(value);
        convertParam.setProperty(property);
        convertParam.setCurrDynObj(parent);
        this.setImageCustomParam(imageFieldSettingMap, property, convertParam, propKeys);
        return ConvertProxy.convertField(convertParam);
    }

    private void setImageCustomParam(Map<String, ImageFieldSetting> imageFieldSettingMap, IDataEntityProperty property, ConvertParam convertParam, String[] propKeys) {
        if (property instanceof NoCodeImageProp) {
            HashMap<String, Object> extParam = new HashMap<String, Object>(2);
            ImageFieldSetting imageFieldSetting = imageFieldSettingMap.get(property.getName());
            if (imageFieldSetting != null) {
                extParam.put(ExtParam.IMAGE_TYPE_HEAD.getKey(), ExtParam.IMAGE_TYPE_HEAD.getValue());
                extParam.put(ExtParam.IMAGE_COL_DEFAULT_SIZE.getKey(), imageFieldSetting.getColSize());
            } else if ("count".equals(propKeys[propKeys.length - 1])) {
                extParam.put(ExtParam.IMAGE_TYPE_ENTRY_COUNT.getKey(), ExtParam.IMAGE_TYPE_ENTRY_COUNT.getValue());
            } else {
                extParam.put(ExtParam.IMAGE_TYPE_ENTRY.getKey(), ExtParam.IMAGE_TYPE_ENTRY.getValue());
            }
            convertParam.setExtParam(extParam);
        }
    }
}

