/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print.dataprovider.convert;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.service.print.dataprovider.DefaultField;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ConvertParam;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;

public class BaseConvert {
    protected static final Log logger = LogFactory.getLog(BaseConvert.class);

    Field convertToField(ConvertParam param) {
        Object value = param.getValue();
        IDataEntityProperty property = param.getProperty();
        return this.deDesensitive(property, value);
    }

    protected List<String> getValues(Object value) {
        ArrayList<String> values = new ArrayList<String>(1);
        if (value instanceof String) {
            values.add((String)value);
        } else {
            values.add(DefaultField.getDefaultField().toString());
        }
        return values;
    }

    protected Field deDesensitive(IDataEntityProperty property, Object value) {
        if (this.isPassword(property)) {
            return new TextField("\u2022\u2022\u2022\u2022\u2022\u2022");
        }
        if (StringUtils.isBlank((Object)value)) {
            return DefaultField.getDefaultField();
        }
        return new TextField(String.valueOf(value));
    }

    protected Field deDesensitiveList(IDataEntityProperty property, List<String> values) {
        if (this.isPassword(property)) {
            ArrayList<String> passwordList = new ArrayList<String>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                passwordList.add("\u2022\u2022\u2022\u2022\u2022\u2022");
            }
            String showValue = String.join((CharSequence)",", passwordList);
            return new TextField(showValue);
        }
        String showValue = String.join((CharSequence)",", values);
        return new TextField(showValue);
    }

    private boolean isPassword(IDataEntityProperty property) {
        TextProp textProp;
        return property instanceof TextProp && (textProp = (TextProp)property).isPassword();
    }
}

