/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print.dataprovider.convert;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.inte.api.IInteService;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.restapi.service.print.dataprovider.DefaultField;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.BaseConvert;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ConvertParam;
import kd.bos.print.core.data.field.DateField;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;

public class DateTimePropConvert
extends BaseConvert {
    @Override
    Field convertToField(ConvertParam param) {
        DateTimeField field;
        DateTimeProp property = (DateTimeProp)param.getProperty();
        boolean startDateTimeRange = property.isStartDateTimeRange();
        if (startDateTimeRange) {
            return this.getDateRangeField(param, property);
        }
        Object value = param.getValue();
        if (ObjectUtils.isEmpty((Object)value)) {
            return DefaultField.getDefaultField();
        }
        String format = this.formatDate(param);
        if (value instanceof Timestamp) {
            field = new DateTimeField((Timestamp)value);
            field.setDisplayVal(format);
        } else if (value instanceof Date) {
            field = new DateField((Date)value);
            field.setDisplayVal(format);
        } else {
            field = new TextField(format);
        }
        return field;
    }

    private Field getDateRangeField(ConvertParam param, DateTimeProp property) {
        String startTimeFormat = this.formatDate(param);
        DynamicObject currDynObj = param.getCurrDynObj();
        IDataEntityType parent = property.getParent();
        String relateDateTimeRange = property.getRelateDateTimeRange();
        if (StringUtils.isNotBlank((CharSequence)relateDateTimeRange)) {
            ConvertParam copy = param.copy();
            IDataEntityProperty endProperty = (IDataEntityProperty)parent.getProperties().get((Object)relateDateTimeRange);
            Object endValue = endProperty.getValue((Object)currDynObj);
            copy.setValue(endValue);
            copy.setProperty(endProperty);
            String endTimeFormat = this.formatDate(param);
            String emptyValue = DefaultField.getDefaultField().getValue().toString();
            if (emptyValue.equals(startTimeFormat) && emptyValue.equals(endTimeFormat)) {
                return DefaultField.getDefaultField();
            }
            return new TextField(startTimeFormat + "~" + endTimeFormat);
        }
        return new TextField(startTimeFormat);
    }

    private String formatDate(ConvertParam param) {
        NoCodeDateTimeProp noCodeDateTimeProp;
        DateFormat dateFormat;
        String tf = "timeFormat";
        String result = "";
        Object oldDate = param.getValue();
        Object value = param.getValue();
        if (ObjectUtils.isEmpty((Object)value)) {
            return DefaultField.getDefaultField().getValue().toString();
        }
        IDataEntityProperty prop = param.getProperty();
        if (prop instanceof NoCodeDateTimeProp && (dateFormat = (noCodeDateTimeProp = (NoCodeDateTimeProp)prop).getDateFormat()) != null) {
            return dateFormat.format(oldDate);
        }
        if (oldDate != null) {
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            Long userId = RequestContext.get().getCurrUserId();
            String dateFormat2 = inteService.getDateFormat(userId);
            Map timeFormat = inteService.getTimeFormat(userId);
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat2);
            sdf.setTimeZone(KDDateUtils.getSysTimeZone());
            if (prop instanceof DateProp) {
                result = sdf.format((Date)oldDate);
                sdf.setTimeZone(KDDateUtils.getSysTimeZone());
            } else if (prop instanceof CreateDateProp || prop instanceof ModifyDateProp) {
                sdf = new SimpleDateFormat(dateFormat2 + " " + (String)timeFormat.get(tf));
                sdf.setTimeZone(KDDateUtils.getSysTimeZone());
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                result = sysTz.format((Date)oldDate, (DateFormat)sdf);
            } else {
                DateTimeProp dProp = (DateTimeProp)prop;
                if (dProp.getRegionType() == 2) {
                    sdf = new SimpleDateFormat(dateFormat2 + " " + (String)timeFormat.get(tf));
                }
                sdf.setTimeZone(KDDateUtils.getSysTimeZone());
                result = sdf.format((Date)oldDate);
            }
        }
        return result;
    }
}

