/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.print.dataprovider.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.restapi.service.print.dataprovider.DefaultField;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.BaseConvert;
import kd.bos.nocode.restapi.service.print.dataprovider.convert.ConvertParam;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;

public class DecimalPropConvert
extends BaseConvert {
    @Override
    Field convertToField(ConvertParam param) {
        IDataEntityProperty property = param.getProperty();
        Object value = param.getValue();
        if (ObjectUtils.isEmpty((Object)value)) {
            return DefaultField.getDefaultField();
        }
        BigDecimal decimal = (BigDecimal)value;
        DecimalField field = new DecimalField(decimal);
        NoCodeDecimalProp decimalProp = (NoCodeDecimalProp)property;
        DecimalField decimalField = field;
        decimalField.setShowZero(decimalProp.isZeroShow());
        int defaultScale = this.getDefaultScale((DecimalProp)decimalProp);
        decimalField.setScale(defaultScale);
        boolean thousandsSeparator = decimalProp.getThousandsSeparator();
        if (thousandsSeparator) {
            char decimalPoint = '.';
            char numSeparator = ',';
            String numGroupFormat = "###,###";
            NumberFormatObject numberformatObj = new NumberFormatObject(decimalPoint, numSeparator, "", numGroupFormat, "-");
            numberformatObj.setGroupingUsed(thousandsSeparator);
            String display = this.formatNumber(decimal, numberformatObj, false, defaultScale);
            decimalField.setDisplayVal(display);
        }
        return field;
    }

    protected String formatNumber(BigDecimal value, NumberFormatObject numberformatObj, boolean ignoreTailZero, int scale) {
        FormatObject formatObject = new FormatObject();
        if (scale == -1) {
            scale = value.scale();
        }
        numberformatObj.setMinimumFractionDigits(scale);
        formatObject.setNumberFormat(numberformatObj);
        String num = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(value);
        if (ignoreTailZero && num.contains(".")) {
            String suffix = "";
            if (num.endsWith(")")) {
                suffix = ")";
                num = num.substring(0, num.length() - 1);
            }
            num = num.replaceAll("0+?$", "");
            num = num.replaceAll("[.]$", "");
            num = num + suffix;
        }
        return num;
    }

    private int getDefaultScale(DecimalProp property) {
        int scale = 2;
        if (property instanceof PriceProp) {
            scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("pp");
        } else if (property instanceof AmountProp) {
            scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("ap");
        } else if (property instanceof DecimalProp) {
            scale = property.getScale();
        }
        return scale;
    }
}

