/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.qing.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.qing.QingProxyService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class QingProxyServiceImpl
implements QingProxyService {
    private static final Log log = LogFactory.getLog(QingProxyServiceImpl.class);
    private static final String APP_ID = "qing";
    private static final String SERVICE_NAME = "QingService";
    public static final String FILTERS = "filters";
    public static final String QING_CARD_PARAMS = "qingCardParams";

    @Override
    public Map<String, Object> getQingCardParams(String cardId) {
        log.debug("\u67e5\u8be2\u8f7b\u5206\u6790\u5361\u7247\u53c2\u6570\uff0ccardId={}", (Object)cardId);
        String cardParamsStr = (String)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"getNocodeCardInfo", (Object[])new Object[]{cardId});
        Map cardParamsMap = (Map)SerializationUtils.fromJsonString((String)cardParamsStr, Map.class);
        String filtersStr = (String)cardParamsMap.get(FILTERS);
        String qingCardParamsStr = (String)cardParamsMap.get(QING_CARD_PARAMS);
        List filters = new ArrayList(0);
        Map qingCardParams = new HashMap(0);
        if (StringUtils.isNotEmpty((CharSequence)filtersStr)) {
            filters = SerializationUtils.fromJsonStringToList((String)filtersStr, Map.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)qingCardParamsStr)) {
            qingCardParams = (Map)SerializationUtils.fromJsonString((String)qingCardParamsStr, Map.class);
        }
        cardParamsMap.put(FILTERS, filters);
        cardParamsMap.put(QING_CARD_PARAMS, qingCardParams);
        return cardParamsMap;
    }

    @Override
    public Map<String, Object> getQingCardFilterParams(String cardId) {
        String filterParams = (String)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"getQingCardFilterParams", (Object[])new Object[]{cardId});
        return (Map)SerializationUtils.fromJsonString((String)filterParams, Map.class);
    }

    @Override
    public String saveOrUpdateQingCard(Map<String, Object> allParams) {
        try (TXHandle h = TX.notSupported();){
            String userId = (String)allParams.get("userId");
            String cardId = (String)allParams.get("cardId");
            if (StringUtils.isEmpty((CharSequence)cardId)) {
                cardId = null;
            }
            String cardPath = (String)allParams.get("cardPath");
            String formId = (String)allParams.get("formId");
            String filters = SerializationUtils.toJsonString((Object)allParams.get(FILTERS));
            String qingCardParams = SerializationUtils.toJsonString((Object)allParams.get(QING_CARD_PARAMS));
            log.debug("\u4fdd\u5b58\u8f7b\u5206\u6790\u5361\u7247\uff0cuserId={}, cardId={}, cardPath={}, filters={}, qingCardParams={}", new Object[]{userId, cardId, cardPath, filters, qingCardParams});
            cardId = (String)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"saveOrUpdateNocodeCardInfo", (Object[])new Object[]{userId, cardId, cardPath, formId, filters, qingCardParams});
            log.debug("\u4fdd\u5b58\u8f7b\u5206\u6790\u5361\u7247\u7ed3\u679c\uff1a{}", (Object)cardId);
            String string = cardId;
            return string;
        }
    }

    @Override
    public List<String> deleteQingCard(List<String> cardIds) {
        log.debug("\u5220\u9664\u8f7b\u5206\u6790\u5361\u7247\uff0ccardIds={}", (Object)SerializationUtils.toJsonString(cardIds));
        List deletedCardIds = (List)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"deleteNocodeCards", (Object[])new Object[]{cardIds});
        log.debug("\u5220\u9664\u8f7b\u5206\u6790\u5361\u7247\u7ed3\u679c\uff0cdeletedCardIds={}", (Object)deletedCardIds);
        return deletedCardIds;
    }

    @Override
    public List<String> exportNoCodeCards(Set<String> cardIds) {
        log.debug("\u5bfc\u51fa\u8f7b\u5206\u6790\u5361\u7247\uff0ccardIds={}", (Object)SerializationUtils.toJsonString(cardIds));
        List jsonStrings = (List)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"exportNocodeCards", (Object[])new Object[]{cardIds});
        log.debug("\u5bfc\u51fa\u8f7b\u5206\u6790\u5361\u7247\u7ed3\u679c\uff0cjsonStrings={}", (Object)jsonStrings);
        return jsonStrings;
    }

    @Override
    public void importNoCodeCards(List<String> jsonStrings) {
        log.debug("\u5bfc\u5165\u8f7b\u5206\u6790\u5361\u7247\uff0cjsonStrings={}", jsonStrings);
        DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"importNocodeCards", (Object[])new Object[]{jsonStrings});
    }

    @Override
    public Map<String, String> createFromExistQingCard(Map<String, Map<String, String>> cardInfos) {
        log.debug("\u4ece\u5df2\u6709\u5361\u7247\u521b\u5efa\u65b0\u7684\u8f7b\u5206\u6790\u7edf\u8ba1\u5361\uff0ccardInfos={}", (Object)SerializationUtils.toJsonString(cardInfos));
        List responseList = (List)DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)SERVICE_NAME, (String)"createCardsBasedOnExistingOnes", (Object[])new Object[]{cardInfos});
        log.debug("\u4ece\u5df2\u6709\u5361\u7247\u521b\u5efa\u65b0\u7684\u8f7b\u5206\u6790\u7edf\u8ba1\u5361\uff0cresponseList={}", (Object)responseList);
        return responseList.stream().map(e -> {
            Map cardInfo = (Map)SerializationUtils.fromJsonString((String)e, Map.class);
            String newCardId = (String)cardInfo.get("cardId");
            String oldCardId = (String)cardInfo.get("refCardId");
            if (StringUtils.isBlank((CharSequence)oldCardId) || StringUtils.isBlank((CharSequence)newCardId)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u5361\u7247\u521b\u5efa\u5931\u8d25", (String)"QingProxyServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            return new Tuple((Object)oldCardId, (Object)newCardId);
        }).collect(Collectors.toMap(e -> (String)e.item1, e -> (String)e.item2));
    }
}

