/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.qing.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.qing.StatCardRepository;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class StatCardRepositoryImpl
implements StatCardRepository {
    public static final String BOS_NOCODE_STAT_CARD = "bos_nocode_stat_card";
    public static final String ENV = "env";
    public static final String CARD_ID = "cardId";
    public static final String APP_ID = "appId";
    public static final String FORM_ID = "formId";
    public static final String USER_ID = "userId";
    public static final String CONFIG = "config";
    public static final String CARD_PATH = "cardPath";
    public static final String TITLE = "title";
    public static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();
    public static final String BOS_NC_STATSCHEMA = "bos_nc_statschema";
    public static final String DISPLAY = "display";
    public static final String SCHEMA_ID = "schemaId";
    public static final String INDEX = "index";

    @Override
    public void saveOrUpdateCard(Map<String, Object> dataMap) {
        try (TXHandle h = TX.requiresNew();){
            try {
                String cardId = (String)dataMap.get(CARD_ID);
                if (this.exist(cardId)) {
                    this.doUpdate(dataMap);
                } else {
                    this.doAdd(dataMap);
                }
                this.saveCardSchema(dataMap, cardId);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void update(long schemaId, List<Map<String, Object>> dataList) {
        DynamicObject[] statSchemaMiddles;
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        Map cardId2DataItem = dataList.stream().collect(Collectors.toMap(e -> (String)e.get(CARD_ID), Function.identity()));
        for (DynamicObject statSchemaMiddle : statSchemaMiddles = this.getStatSchemaMiddles(schemaId)) {
            String cardId = statSchemaMiddle.getString(CARD_ID);
            Map dataItem = (Map)cardId2DataItem.get(cardId);
            if (!MapUtils.isNotEmpty((Map)dataItem)) continue;
            statSchemaMiddle.set(DISPLAY, dataItem.get(DISPLAY));
        }
        SaveServiceHelper.update((DynamicObject[])statSchemaMiddles);
    }

    private void saveCardSchema(Map<String, Object> dataMap, String cardId) {
        List lastSchemaIdList = (List)dataMap.get("schemaIds");
        if (CollectionUtils.isEmpty((Collection)lastSchemaIdList)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (String)"StatCardRepositoryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        List<Long> oldSchemaIdList = this.getSchemaIdsByCardId(cardId);
        List deleteSchemaIdList = oldSchemaIdList.stream().filter(e -> !lastSchemaIdList.contains(e + "")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteSchemaIdList)) {
            QFilter cardSchemaFilter = new QFilter(CARD_ID, "=", (Object)cardId).and(SCHEMA_ID, "in", deleteSchemaIdList);
            DeleteServiceHelper.delete((String)BOS_NC_STATSCHEMA, (QFilter[])cardSchemaFilter.toArray());
        }
        List newSchemaIdLists = lastSchemaIdList.stream().map(Long::parseLong).filter(e -> !oldSchemaIdList.contains(e)).collect(Collectors.toList());
        ArrayList<DynamicObject> statSchemaMiddles = new ArrayList<DynamicObject>(newSchemaIdLists.size());
        for (Long schemaId : newSchemaIdLists) {
            DynamicObject statSchemaMiddle = BusinessDataServiceHelper.newDynamicObject((String)BOS_NC_STATSCHEMA);
            statSchemaMiddle.set(SCHEMA_ID, (Object)schemaId);
            statSchemaMiddle.set(CARD_ID, (Object)cardId);
            statSchemaMiddle.set(INDEX, (Object)(this.getMaxIndex(schemaId) + 1));
            statSchemaMiddle.set(DISPLAY, (Object)Boolean.TRUE);
            statSchemaMiddles.add(statSchemaMiddle);
        }
        if (CollectionUtils.isNotEmpty(statSchemaMiddles)) {
            SaveServiceHelper.save((DynamicObject[])statSchemaMiddles.toArray(new DynamicObject[0]));
        }
    }

    private int getMaxIndex(long schemaId) {
        QFilter schemaIdFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaIdFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)BOS_NC_STATSCHEMA, (String)INDEX, (QFilter[])filters, (String)"index desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return -1;
        }
        return ((DynamicObject)query.get(0)).getInt(INDEX);
    }

    private void doUpdate(Map<String, Object> dataMap) {
        String cardId = (String)dataMap.get(CARD_ID);
        String title = (String)dataMap.get(TITLE);
        DynamicObject statCard = this.getByCardId(cardId);
        if (Objects.isNull(statCard)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"StatCardRepositoryImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        statCard.set(TITLE, (Object)title);
        SaveServiceHelper.update((DynamicObject)statCard);
    }

    private void doAdd(Map<String, Object> dataMap) {
        String cardId = (String)dataMap.get(CARD_ID);
        String appId = (String)dataMap.get(CARD_PATH);
        String formId = (String)dataMap.get(FORM_ID);
        String title = (String)dataMap.get(TITLE);
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject statCard = BusinessDataServiceHelper.newDynamicObject((String)BOS_NOCODE_STAT_CARD);
        statCard.set(CARD_ID, (Object)cardId);
        statCard.set(TITLE, (Object)title);
        statCard.set(APP_ID, (Object)appId);
        statCard.set(FORM_ID, (Object)formId);
        statCard.set(USER_ID, (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statCard});
    }

    @Override
    public DynamicObject saveStatCard(DynamicObject saveDynObj) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDynObj});
        return saveDynObj;
    }

    @Override
    public DynamicObject getStatCard(String appId, String formId, long userId) {
        QFilter appIdFilter = new QFilter(APP_ID, "=", (Object)appId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{appIdFilter, formIdFilter, userIdFilter};
        return BusinessDataServiceHelper.loadSingle((String)BOS_NOCODE_STAT_CARD, (QFilter[])qFilters);
    }

    @Override
    public void deleteCards(List<String> cardIds) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                QFilter qFilter = new QFilter(CARD_ID, "in", cardIds);
                DeleteServiceHelper.delete((String)BOS_NOCODE_STAT_CARD, (QFilter[])qFilter.toArray());
                DeleteServiceHelper.delete((String)BOS_NC_STATSCHEMA, (QFilter[])qFilter.toArray());
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public boolean exist(String cardId) {
        QFilter qFilter = new QFilter(CARD_ID, "=", (Object)cardId);
        return ORM.create().exists(BOS_NOCODE_STAT_CARD, qFilter.toArray());
    }

    @Override
    public DynamicObject getByCardId(String cardId) {
        QFilter qFilter = new QFilter(CARD_ID, "=", (Object)cardId);
        return BusinessDataServiceHelper.loadSingle((String)BOS_NOCODE_STAT_CARD, (QFilter[])qFilter.toArray());
    }

    @Override
    public List<Long> getSchemaIdsByCardId(String cardId) {
        QFilter cardIdFilter = new QFilter(CARD_ID, "=", (Object)cardId);
        DynamicObject[] oldSchemaList = BusinessDataServiceHelper.load((String)BOS_NC_STATSCHEMA, (String)SCHEMA_ID, (QFilter[])cardIdFilter.toArray());
        return Arrays.stream(oldSchemaList).map(e -> e.getLong(SCHEMA_ID)).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, Object>> getStatCards(long schemaId) {
        DynamicObject[] statSchemaMiddles = this.getStatSchemaMiddles(schemaId);
        List cardIds = Arrays.stream(statSchemaMiddles).map(e -> e.getString(CARD_ID)).collect(Collectors.toList());
        QFilter cardIdsFilter = new QFilter(CARD_ID, "in", cardIds);
        DynamicObject[] cards = BusinessDataServiceHelper.load((String)BOS_NOCODE_STAT_CARD, (String)"cardId,title", (QFilter[])cardIdsFilter.toArray());
        Map<String, String> cardId2TitleMap = Arrays.stream(cards).collect(Collectors.toMap(e -> e.getString(CARD_ID), e -> e.getString(TITLE)));
        Set<String> existCardIds = cardId2TitleMap.keySet();
        List rows = PropertyHandleUtil.toMapListRoot((String)BOS_NC_STATSCHEMA, (String)"$", (DynamicObject[])statSchemaMiddles, (Set)Sets.newHashSet((Object[])new String[]{CARD_ID, INDEX, DISPLAY}));
        Iterator rowIterator = rows.iterator();
        while (rowIterator.hasNext()) {
            Map row = (Map)rowIterator.next();
            String cardId = (String)row.get("cardid");
            if (existCardIds.contains(cardId)) {
                row.put(CARD_ID, cardId);
                row.put(TITLE, cardId2TitleMap.get(cardId));
                row.remove("cardid");
                row.put("schemaIds", this.getSchemaIdsByCardId(cardId));
                continue;
            }
            rowIterator.remove();
        }
        return rows;
    }

    private DynamicObject[] getStatSchemaMiddles(long schemaId) {
        QFilter schemaIdFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaIdFilter};
        return BusinessDataServiceHelper.load((String)BOS_NC_STATSCHEMA, (String)"cardId,index,display", (QFilter[])filters);
    }
}

