/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.metadata.form.IHasStatusControl;
import kd.bos.nocode.ext.metadata.form.control.NoCodeDateRangeFieldAp;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EntryQueryService {
    private static final String ENTRY = "entry";

    public Pair<Boolean, RestApiServiceData<RestApiQueryResult>> handle(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String entryField = (String)param.getRequest().getHttpQueryString().get(ENTRY);
        if (StringUtils.isEmpty((CharSequence)entryField)) {
            return new Pair((Object)false, null);
        }
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        QFilter[] filters = (QFilter[])qFilterPair.getValue();
        String formId = param.getFormId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        EntityType entityType = (EntityType)dt.getAllEntities().get(entryField);
        Set<String> selectSet = entityType.getFields().keySet();
        Map allFields = ListConfigUtils.getAllFields((String)formId);
        selectSet.retainAll(allFields.keySet());
        Object[] mainTableRows = BusinessDataServiceHelper.load((String)param.getFormId(), (String)String.join((CharSequence)",", selectSet), (QFilter[])filters);
        List rows = new ArrayList(0);
        int totalCount = 0;
        boolean isLastPage = false;
        if (ArrayUtils.isNotEmpty((Object[])mainTableRows)) {
            DynamicObjectCollection entryEntityRows = mainTableRows[0].getDynamicObjectCollection(entryField);
            totalCount = entryEntityRows.size();
            List pages = Lists.partition((List)entryEntityRows, (int)param.getPage_size());
            int index = param.getPage_no() - 1;
            if (index < pages.size()) {
                List pageEntryEntityRows = (List)pages.get(index);
                Set foramtSet = selectSet.stream().map(e -> entryField + "." + e).collect(Collectors.toSet());
                rows = PropertyHandleUtil.toMapListRootByColumn((String)formId, (String)entryField, (DynamicObject[])pageEntryEntityRows.toArray(new DynamicObject[0]), foramtSet);
            }
            if (index == pages.size() - 1) {
                isLastPage = true;
            }
        }
        RestApiQueryResult restApiQueryResult = new RestApiQueryResult();
        restApiQueryResult.getExtra().put("fieldInfo", this.getFieldInfoList(formId, selectSet, allFields));
        restApiQueryResult.setRows(rows);
        restApiQueryResult.setTotalCount(totalCount);
        restApiQueryResult.setLastPage(Boolean.valueOf(isLastPage));
        restApiQueryResult.setPageNo(param.getPage_no());
        restApiQueryResult.setPageSize(param.getPage_size());
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)restApiQueryResult);
        return new Pair((Object)true, (Object)RestApiServiceData.ofTrue((RestApiResponse)response, (long)this.getCostTime(startTime)));
    }

    private long getCostTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    private List<Map<String, String>> getFieldInfoList(String formId, Set<String> fields, Map<String, IDataEntityProperty> allFields) {
        ArrayList<Map<String, String>> fieldInfoList = new ArrayList<Map<String, String>>(fields.size());
        formId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        HashMap key2Item = new HashMap(entityMetadata.getItems().size());
        HashMap dateRangeKeys = new HashMap(10);
        entityMetadata.getItems().forEach(item -> {
            if (item instanceof NoCodeDateRangeField) {
                NoCodeDateRangeField dateRangeField = (NoCodeDateRangeField)item;
                key2Item.put(dateRangeField.getStartDateFieldKey(), item);
                key2Item.put(dateRangeField.getEndDateFieldKey(), item);
                HashSet<String> keys = new HashSet<String>();
                keys.add(dateRangeField.getStartDateFieldKey());
                keys.add(dateRangeField.getEndDateFieldKey());
                dateRangeKeys.put(dateRangeField.getKey(), keys);
            } else {
                key2Item.put(item.getKey(), item);
            }
        });
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        HashSet keys2Hide = new HashSet(10);
        formMetadata.getItems().forEach(ap -> {
            if (ap instanceof IHasStatusControl && ((IHasStatusControl)ap).isHide()) {
                if (ap instanceof NoCodeDateRangeFieldAp) {
                    Set keys = (Set)dateRangeKeys.get(ap.getKey());
                    if (keys != null && !keys.isEmpty()) {
                        keys2Hide.addAll(keys);
                    }
                } else {
                    keys2Hide.add(ap.getKey());
                }
            }
        });
        fields.forEach(f -> {
            if (!keys2Hide.contains(f)) {
                HashMap<String, String> fieldInfo = new HashMap<String, String>(3);
                fieldInfo.put("number", (String)f);
                EntityItem item = (EntityItem)key2Item.get(f);
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(f);
                fieldInfo.put("name", property.getDisplayName().toString());
                fieldInfo.put("type", item.getClass().getSimpleName().toLowerCase());
                fieldInfoList.add(fieldInfo);
            }
        });
        return fieldInfoList;
    }
}

