/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.ComparatorUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.handle.QueryApiFormatUtil;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryApiUtil {
    private QueryApiUtil() {
    }

    public static List<DynamicObject> query(RestApiQueryParam param) {
        QFilter[] qFilterArray;
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        Object[] filters = (QFilter[])qFilterPair.getValue();
        Object filter = null;
        if (!CollectionUtil.isEmpty((Object[])filters)) {
            filter = filters[0];
        }
        String string = param.getFormId();
        if (filter == null) {
            qFilterArray = null;
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = filter;
        }
        Object[] objects = BusinessDataServiceHelper.load((String)string, (String)"id", (QFilter[])qFilterArray, (String)param.getOrder_by(), (int)(param.getPage_no() - 1), (int)param.getPage_size());
        if (CollectionUtil.isEmpty((Object[])objects)) {
            return Collections.emptyList();
        }
        Set ids = Arrays.stream(objects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        if (filter != null) {
            qFilter.and((QFilter)filter);
        }
        Set newSelectSet = ComparatorUtil.getSelect((Set)param.getSelect());
        newSelectSet.add("id");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)param.getFormId(), (String)String.join((CharSequence)",", newSelectSet), (QFilter[])new QFilter[]{qFilter}, (String)param.getOrder_by());
        if (CollectionUtil.isEmpty((Collection)collection)) {
            return Collections.emptyList();
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)param.getFormId()));
        Map idMap = collection.stream().collect(Collectors.groupingBy(it -> it.get("id"), LinkedHashMap::new, Collectors.toList()));
        return QueryApiUtil.queryObjListToLoadObjList(idMap.values(), (DynamicObjectType)type, newSelectSet, null);
    }

    public static List<DynamicObject> queryObjListToLoadObjList(Collection<List<DynamicObject>> sourceList, DynamicObjectType targetType, Set<String> select, String fullParentPropName) {
        if (sourceList == null) {
            return Collections.emptyList();
        }
        if (sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> targetList = new ArrayList<DynamicObject>(sourceList.size());
        for (List<DynamicObject> srcList : sourceList) {
            DynamicObject result = QueryApiFormatUtil.queryObjToLoadObj(srcList, (DynamicObjectType)targetType, select, (String)fullParentPropName);
            if (result == null) continue;
            targetList.add(result);
        }
        return targetList;
    }
}

