/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.mservice.NoCodeFilterService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.ComparatorUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.core.util.DynamicObjectUtil;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.query.EntryQueryService;
import kd.bos.nocode.restapi.service.query.QueryApiUtil;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsService;
import kd.bos.nocode.restapi.service.sys.SysServiceHelpHandle;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListSchemaUtils;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.util.OpenApiAliasHelper;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class QueryRestApiServiceImpl
implements QueryRestApiService {
    private static final Log LOG = LogFactory.getLog(QueryRestApiServiceImpl.class);

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        DynamicObject[] dynamicObjects;
        Pair<Boolean, RestApiServiceData<RestApiQueryResult>> statHandle;
        LOG.debug("lang={}", (Object)Lang.get().toString());
        Pair sysHandle = SysServiceHelpHandle.sysCustomHandle(param);
        if (Boolean.TRUE.equals(sysHandle.getKey())) {
            return (RestApiServiceData)sysHandle.getValue();
        }
        if (this.isReplaceAlias(param)) {
            this.replaceFilterAndOrderByAndSelectAlias(param);
        }
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)param.getFormId());
        String appId = param.getAppNumber();
        boolean share = NoCodePermHelper.isShare(null, null, (String)param.getShareId());
        if (!share) {
            try {
                NoCodePermHelper.verifyFuncPermPassTemp((FuncPermItemEnum)FuncPermItemEnum.view, (String)appId, (String)formNumber);
            }
            catch (Exception e) {
                return new RestApiServiceData(false, new RestApiResponse(), 0L, RestApiErrorCode.ERROR.getStatusCode(), ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"QueryRestApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (Boolean.TRUE.equals((statHandle = new FieldStatisticsService().handle(param)).getKey())) {
            return (RestApiServiceData)statHandle.getValue();
        }
        Pair<Boolean, RestApiServiceData<RestApiQueryResult>> entryHandle = new EntryQueryService().handle(param);
        if (Boolean.TRUE.equals(entryHandle.getKey())) {
            return (RestApiServiceData)entryHandle.getValue();
        }
        LOG.debug("nocode QueryRestApiServiceImpl execute begin");
        if (StringUtils.isBlank((Object)param.getSelect())) {
            ArrayList<String> fieldKeys = new ArrayList<String>();
            String displayProperty = (String)param.getRequest().getHttpQueryString().get("displayProperty");
            if (StringUtils.isNotBlank((CharSequence)displayProperty)) {
                String[] fields;
                for (String field2 : fields = displayProperty.split(",")) {
                    fieldKeys.add(field2);
                }
            }
            Set selectSet = ListConfigUtils.sureSelectSet((String)formNumber, fieldKeys);
            param.setSelect(selectSet);
        }
        if (!share) {
            Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formNumber);
            param.getSelect().removeIf(field -> {
                if (field.endsWith("_startdate")) {
                    return hides.contains(field.replace("_startdate", ""));
                }
                if (field.endsWith("_enddate")) {
                    return hides.contains(field.replace("_enddate", ""));
                }
                return hides.contains(field);
            });
        }
        Set newSelectSet = ComparatorUtil.getSelect((Set)param.getSelect());
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param, newSelectSet);
        QFilter[] filters1 = (QFilter[])qFilterPair.getValue();
        String schemaId = (String)param.getRequest().getHttpQueryString().get("schemaId");
        Object[] listDataFilters = ListSchemaUtils.getListDataFilter(appId, formNumber, schemaId, filters1, share);
        QFilter[] filters = (QFilter[])Arrays.stream(listDataFilters).filter(Objects::nonNull).toArray(QFilter[]::new);
        List<QFilter> qFilters = Arrays.stream(filters).collect(Collectors.toList());
        String defaultFilter = (String)param.getRequest().getHttpQueryString().get("defaultFilterRows");
        if (StringUtils.isNotBlank((CharSequence)defaultFilter)) {
            List defaultFilterRows = (List)SerializationUtils.fromJsonString((String)defaultFilter, List.class);
            NoCodeFilterService noCodeFilterService = (NoCodeFilterService)ServiceFactory.getService((String)"NoCodeFilterService");
            QFilter[] defaultQFilters = noCodeFilterService.getQFilters(formNumber, defaultFilterRows);
            qFilters.addAll(Arrays.stream(defaultQFilters).collect(Collectors.toList()));
        }
        RestApiQueryResult result = new RestApiQueryResult();
        long startTime = System.currentTimeMillis();
        boolean filterHasEntry = (Boolean)qFilterPair.getKey();
        String orderBy = param.getOrder_by();
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            orderBy = "id desc";
        }
        orderBy = this.handleParentOrg(formNumber, orderBy);
        if (filterHasEntry) {
            dynamicObjects = QueryApiUtil.query(param).toArray(new DynamicObject[0]);
        } else {
            LOG.info("\u8fc7\u6ee4\u5668filter={}", (Object)Arrays.toString(listDataFilters));
            String selectFields = String.join((CharSequence)",", newSelectSet);
            dynamicObjects = BusinessDataServiceHelper.load((String)formNumber, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBy, (int)(param.getPage_no() - 1), (int)param.getPage_size());
        }
        if (!param.getSelectedIds().isEmpty()) {
            dynamicObjects = this.appendSelectedObjs(dynamicObjects, formNumber, newSelectSet, param);
        }
        long endTime = System.currentTimeMillis();
        LOG.debug("nocode QueryRestApiServiceImpl execute query data:" + (endTime - startTime));
        List rows = param.isDyObjResult() ? DynamicObjectUtil.serializeToMap((DynamicObject[])dynamicObjects, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)formNumber, (Collection)newSelectSet)) : PropertyHandleUtil.toMapListRootByColumn((String)formNumber, (String)"$", (DynamicObject[])dynamicObjects, (Set)newSelectSet);
        long endTime2 = System.currentTimeMillis();
        LOG.debug("nocode QueryRestApiServiceImpl execute serializeToMap:" + (endTime2 - endTime));
        if (rows == null) {
            rows = Collections.emptyList();
        } else if (this.isReplaceAlias(param)) {
            rows = OpenApiAliasHelper.replaceField2Alias((String)formNumber, rows);
        }
        result.setRows(rows);
        try {
            int totalCount;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)formNumber, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
                totalCount = dataSet.count("id", true);
            }
            result.setTotalCount(totalCount);
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
        }
        catch (Exception e) {
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
            LOG.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e));
        }
        result.setPageNo(param.getPage_no());
        result.setPageSize(param.getPage_size());
        long endTime3 = System.currentTimeMillis();
        LOG.debug("nocode QueryRestApiServiceImpl execute setTotalCount:" + (endTime3 - endTime2));
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        LOG.debug("nocode QueryRestApiServiceImpl execute end");
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }

    private void replaceFilterAndOrderByAndSelectAlias(RestApiQueryParam param) {
        String filter = param.getRequest().getFilter();
        String orderBy = param.getOrder_by();
        Set select = param.getSelect();
        Map alias2FieldSource = OpenApiAliasHelper.getAlias2FieldSource((String)param.getFormNumber());
        for (Map.Entry entry : alias2FieldSource.entrySet()) {
            String alias = (String)entry.getKey();
            String source = (String)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                filter = filter.replace(alias, source);
            }
            if (!StringUtils.isNotBlank((CharSequence)orderBy)) continue;
            orderBy = orderBy.replace(alias, source);
        }
        param.getRequest().setFilter(filter);
        param.setOrder_by(orderBy);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            select = select.stream().map(k -> alias2FieldSource.getOrDefault(k, k)).collect(Collectors.toSet());
            param.setSelect(select);
        }
    }

    private boolean isReplaceAlias(RestApiQueryParam param) {
        return "true".equals(param.getRequest().getHttpQueryString().get("alias"));
    }

    private String handleParentOrg(String formNumber, String orderBy) {
        if (formNumber.equals("bos_adminorg") || formNumber.equals("PKJP6FA0=V1")) {
            return orderBy.replace("parent", "structure.viewparent.name");
        }
        return orderBy;
    }

    private DynamicObject[] appendSelectedObjs(DynamicObject[] dynamicObjects, String formNumber, Set<String> newSelectSet, RestApiQueryParam param) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formNumber);
        String pkName = "id";
        if (dt.getPrimaryKey() != null) {
            pkName = dt.getPrimaryKey().getName();
        }
        Object[] selectedPks = new Object[param.getSelectedIds().size()];
        for (int i = 0; i < param.getSelectedIds().size(); ++i) {
            selectedPks[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, param.getSelectedIds().get(i));
        }
        QFilter idsQFilter = new QFilter(pkName, "in", (Object)selectedPks);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)formNumber, (String)String.join((CharSequence)",", newSelectSet), (QFilter[])new QFilter[]{idsQFilter});
        ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>(dynamicObjects.length + objs.length);
        listDyn.addAll(Arrays.asList(objs));
        listDyn.addAll(Arrays.asList(dynamicObjects));
        return listDyn.toArray(new DynamicObject[listDyn.size()]);
    }

    private void addParentField(List<Map<String, Object>> rows) {
        rows.forEach(this::addParentField);
    }

    private void addParentField(Map<String, Object> row) {
        Long id = Long.parseLong(String.valueOf(row.get("id")));
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", Collections.singletonList(id));
        Long parentId = (Long)directSuperiorOrg.get(id);
        HashMap<String, Object> parent = new HashMap<String, Object>(2);
        if (Objects.isNull(parentId) || parentId == 0L) {
            parent.put("id", parentId);
            parent.put("name", "");
        } else {
            Map parentProperties = OrgUnitServiceHelper.getOrgProperty((long)parentId, (List)Lists.newArrayList((Object[])new String[]{"name"}));
            String name = "";
            name = MapUtils.isEmpty((Map)parentProperties) ? "" : ((ILocaleString)parentProperties.get("name")).getLocaleValue();
            parent.put("id", parentId);
            parent.put("name", name);
        }
        row.put("parent", parent.get("name"));
    }
}

