/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query.g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.restapi.service.query.g.GBaseVisitor;
import kd.bos.nocode.restapi.service.query.g.GLexer;
import kd.bos.nocode.restapi.service.query.g.GParser;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.PropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.PropParserStrategyFactory;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class FilterVisitor
extends GBaseVisitor<QFilter> {
    public static final ThreadLocal<MainEntityType> mainEntityType = new ThreadLocal();
    private static Log log = LogFactory.getLog(FilterVisitor.class);
    public static final HashMap<String, String> operators = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("EQ", "=");
            this.put("NQ", "!=");
            this.put("BT", ">");
            this.put("LT", "<");
            this.put("BQ", ">=");
            this.put("LQ", "<=");
            this.put("IN", "in");
            this.put("NI", "not in");
            this.put("CS", "like");
            this.put("BG", "like");
            this.put("NC", "not like");
        }
    };
    public static final Map<String, String> operatorsDesc = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("EQ", "\u7b49\u4e8e");
            this.put("NQ", "\u4e0d\u7b49\u4e8e");
            this.put("BT", "\u5927\u4e8e");
            this.put("LT", "\u5c0f\u4e8e");
            this.put("BQ", "\u5927\u4e8e\u7b49\u4e8e");
            this.put("LQ", "\u5c0f\u4e8e\u7b49\u4e8e");
            this.put("IN", "\u5728...\u4e4b\u4e2d");
            this.put("NI", "\u4e0d\u5728...\u4e4b\u4e2d");
            this.put("CS", "\u6a21\u7cca\u5339\u914d-\u5305\u542b");
            this.put("BG", "\u524d\u7f00\u6a21\u7cca\u5339\u914d-\u5305\u542b");
            this.put("NC", "\u6a21\u7cca\u5339\u914d-\u4e0d\u5305\u542b");
        }
    };
    List<QFilter> filters = new ArrayList<QFilter>();
    List<QFilter> compare_filters = new ArrayList<QFilter>();
    static String[] stringpack = new String[]{"'", "\""};

    public QFilter[] getFilters() {
        QFilter[] items = new QFilter[this.filters.size()];
        return this.filters.toArray(items);
    }

    public static QFilter Parse(String exp) {
        ANTLRInputStream stream = new ANTLRInputStream(exp);
        GLexer lexer = new GLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GParser parser = new GParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        GParser.ParseContext ctx = parser.parse();
        return (QFilter)new FilterVisitor().visitFilterExp(ctx.filterExp());
    }

    @Override
    public QFilter visitExp(GParser.ExpContext ctx) {
        GParser.Compare_expContext cctx = ctx.compare_exp();
        GParser.Logic_operatorContext lctx = ctx.logic_operator();
        if (cctx != null) {
            return this.visitCompare(cctx);
        }
        if (lctx != null) {
            QFilter left = this.visitExp(ctx.exp(0));
            QFilter right = this.visitExp(ctx.exp(1));
            if (lctx.AND() != null) {
                return left.and(right);
            }
            return left.or(right);
        }
        if ("(".equals(ctx.getChild(0).getText())) {
            return this.visitExp(ctx.exp(0));
        }
        throw new RuntimeException("not supported");
    }

    private QFilter visitCompare(GParser.Compare_expContext ctx) {
        String fn = ctx.fieldName().getText();
        String compare = ctx.compare_operator().getText();
        String value = ctx.value_exp().getText();
        return this.newFilter(fn, compare, value);
    }

    private QFilter newFilter(String field, String op, String value) {
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)((DynamicObjectType)mainEntityType.get()), (String)field);
        if (property instanceof NoCodeAttachmentProp && !field.contains(".fbasedataid.name")) {
            field = field + ".fbasedataid.name";
            property = NcEntityTypeUtil.findProperty((DynamicObjectType)((DynamicObjectType)mainEntityType.get()), (String)field);
        }
        if (property == null) {
            return null;
        }
        PropParserStrategy filterParserStrategy = PropParserStrategyFactory.getByProp(property);
        return filterParserStrategy.parse(property, field, op, value);
    }

    public static QFilter buildExists(String property) {
        QFilter filter = QFilter.exists((String)property);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.and(QFilter.exists((String)property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    public static QFilter buildNull(String property) {
        QFilter filter = QFilter.isNull((String)property);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.or(QFilter.isNull((String)property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    public static QFilter buildNotNull(String property) {
        QFilter filter = QFilter.isNotNull((String)property);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.and(QFilter.isNotNull((String)property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    @Override
    public QFilter visitCompare_exp(GParser.Compare_expContext ctx) {
        this.compare_filters.add(this.visitCompare(ctx));
        return (QFilter)super.visitCompare_exp(ctx);
    }

    public static String replaceQuotes(String value) {
        for (String sp : stringpack) {
            if (!value.startsWith(sp) || !value.endsWith(sp)) continue;
            value = value.substring(1, value.lastIndexOf(sp));
        }
        return value;
    }
}

