/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query.g.convert;

import java.util.Date;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nocode.restapi.service.query.g.convert.BaseConvert;
import kd.bos.nocode.utils.DateTimeUtils;

class DateTimeConvert
extends BaseConvert {
    DateTimeConvert(IDataEntityProperty dynamicProperty, Object value) {
        super(dynamicProperty, value);
    }

    @Override
    public Object getConvertValue() {
        String value = (String)this.getValue();
        DataConvertResult convertResult = new DataConvertResult();
        if (value.contains("'")) {
            DateTimeConvert.dataParse(value.substring(1, value.length() - 1), convertResult);
        }
        DateTimeConvert.dataParse(value, convertResult);
        if (!convertResult.success) {
            throw new KDException(new ErrorCode("DateTimeConvertException", String.format("field:%s value:%s convert fail", this.getName(), this.getValue())), new Object[]{convertResult.ex});
        }
        return convertResult.date;
    }

    public static void dataParse(String strDate, DataConvertResult convertResult) {
        try {
            convertResult.date = DateTimeUtils.loopParse((String)strDate);
            convertResult.success = Boolean.TRUE;
        }
        catch (Exception e) {
            convertResult.ex = e;
        }
    }

    static class DataConvertResult {
        boolean success = false;
        Date date = null;
        Exception ex;

        DataConvertResult() {
        }
    }
}

