/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query.g.parserstrategy;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import kd.bos.nocode.restapi.service.query.g.convert.FilterValueConvertHelper;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.PropParserStrategy;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPropParserStrategy
implements PropParserStrategy {
    static final String EQ = "EQ";
    static final String NQ = "NQ";
    static final String NC = "NC";
    static final String CS = "CS";
    static final String IN = "IN";
    static final String NI = "NI";
    static final String LQ = "LQ";
    static final String BQ = "BQ";
    static final String LT = "LT";
    static final String BT = "BT";
    static final String ID = "id";

    @Override
    public QFilter parse(IDataEntityProperty property, String field, String op, String value) {
        String qcp = FilterVisitor.operators.get(op.toUpperCase());
        if (StringUtils.isBlank((CharSequence)(value = FilterVisitor.replaceQuotes(value))) && (EQ.equalsIgnoreCase(op) || CS.equalsIgnoreCase(op) || IN.equalsIgnoreCase(op))) {
            return this.buildNull(field, property);
        }
        if (StringUtils.isBlank((CharSequence)value) && (NQ.equalsIgnoreCase(op) || NC.equalsIgnoreCase(op) || NI.equalsIgnoreCase(op))) {
            return this.buildNotNull(field, property);
        }
        QFilter filter = this.preParse(property, field, qcp, op, value);
        if (Objects.nonNull(filter)) {
            return filter;
        }
        return this.defaultParse(property, field, qcp, op, value);
    }

    private QFilter defaultParse(IDataEntityProperty property, String field, String qcp, String op, String value) {
        List convertResult;
        if (this.isContainOp(op)) {
            String[] itemValues = this.getItemValues(value);
            convertResult = Arrays.stream(itemValues).map(e -> FilterValueConvertHelper.getConvertResult(property, e)).collect(Collectors.toList());
        } else {
            convertResult = FilterValueConvertHelper.getConvertResult(property, value);
        }
        QFilter filter = new QFilter(field, qcp, (Object)convertResult);
        if (this.isNegativeOp(op)) {
            return filter.or(FilterVisitor.buildNull(field));
        }
        return filter;
    }

    protected boolean isNegativeOp(String op) {
        return NQ.equalsIgnoreCase(op) || NI.equalsIgnoreCase(op) || NC.equalsIgnoreCase(op) || LT.equalsIgnoreCase(op) || LQ.equalsIgnoreCase(op);
    }

    protected boolean isContainOp(String op) {
        return IN.equalsIgnoreCase(op) || NI.equalsIgnoreCase(op);
    }

    protected String[] getItemValues(String value) {
        while (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
        }
        return value.split(",");
    }

    protected QFilter preParse(IDataEntityProperty property, String field, String qcp, String op, String value) {
        return null;
    }

    protected QFilter buildNull(String field, IDataEntityProperty property) {
        if ("bd_attachment".equalsIgnoreCase(property.getParent().getName())) {
            return FilterVisitor.buildNull(field);
        }
        if (this.isNumberPropertyType(property)) {
            return FilterVisitor.buildNull(field);
        }
        return QFilter.emptyOrNotExists((String)field);
    }

    protected QFilter buildNotNull(String field, IDataEntityProperty property) {
        if ("bd_attachment".equalsIgnoreCase(property.getParent().getName())) {
            return FilterVisitor.buildNotNull(field);
        }
        if (this.isNumberPropertyType(property)) {
            return FilterVisitor.buildNotNull(field);
        }
        return FilterVisitor.buildExists(field);
    }

    private boolean isNumberPropertyType(IDataEntityProperty type) {
        Class cls = type.getPropertyType();
        return cls == Integer.TYPE || cls == Integer.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Long.TYPE || cls == Long.class || cls == BigDecimal.class || cls == Number.class || cls == Double.TYPE || cls == Double.class || Number.class.isAssignableFrom(cls);
    }
}

