/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query.g.parserstrategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.nocode.restapi.service.query.g.convert.FilterValueConvertHelper;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.AbstractPropParserStrategy;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.DateUtil;

public class DateTimePropParserStrategy
extends AbstractPropParserStrategy {
    @Override
    public QFilter preParse(IDataEntityProperty property, String field, String qcp, String op, String value) {
        Date date = (Date)FilterValueConvertHelper.getConvertResult(property, value);
        if (DateTimeUtils.isLongDate((String)value)) {
            QFilter filter = new QFilter(field, qcp, (Object)date);
            if ("NQ".equalsIgnoreCase(op)) {
                filter.or(QFilter.isNull((String)field));
            }
            return filter;
        }
        LocalDate localDate = DateUtil.toLocalDate((Date)date);
        LocalDateTime endDateTime = DateTimeUtils.getMaxLocalDateTime((Date)date, (String)value);
        LocalDateTime startDateTime = localDate.atStartOfDay();
        Date startDate = DateUtil.toDate((LocalDateTime)startDateTime);
        Date endDate = DateUtil.toDate((LocalDateTime)endDateTime);
        if ("EQ".equalsIgnoreCase(op)) {
            return new QFilter(field, ">=", (Object)startDate).and(new QFilter(field, "<=", (Object)endDate));
        }
        if ("NQ".equalsIgnoreCase(op)) {
            return new QFilter(field, "<", (Object)startDate).or(new QFilter(field, ">", (Object)endDate)).or(QFilter.isNull((String)field));
        }
        if ("LQ".equalsIgnoreCase(op)) {
            return new QFilter(field, "<=", (Object)endDate);
        }
        if ("BQ".equalsIgnoreCase(op)) {
            return new QFilter(field, ">=", (Object)startDate);
        }
        if ("LT".equalsIgnoreCase(op)) {
            return new QFilter(field, "<", (Object)startDate);
        }
        if ("BT".equalsIgnoreCase(op)) {
            return new QFilter(field, ">", (Object)endDate);
        }
        return null;
    }
}

