/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.query.g.parserstrategy;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.ComboPropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.DateTimePropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.DefaultPropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.MulRefBillPropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.PicturePropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.PropParserStrategy;
import kd.bos.nocode.restapi.service.query.g.parserstrategy.TextPropParserStrategy;
import org.jetbrains.annotations.NotNull;

public class PropParserStrategyFactory {
    private static final PropParserStrategy DEFAULT_PARSER_STRATEGY = new DefaultPropParserStrategy();
    private static final Map<Class<? extends IDataEntityProperty>, PropParserStrategy> STRATEGY_MAP = new ConcurrentHashMap<Class<? extends IDataEntityProperty>, PropParserStrategy>(16);
    private static final Map<Class<? extends IDataEntityProperty>, PropParserStrategy> STRATEGY_MAP_CACHE = new ConcurrentHashMap<Class<? extends IDataEntityProperty>, PropParserStrategy>(32);

    @NotNull
    public static PropParserStrategy getByProp(IDataEntityProperty type) {
        Class<?> clazz = type.getClass();
        PropParserStrategy propParserStrategy = STRATEGY_MAP_CACHE.get(clazz);
        if (Objects.nonNull(propParserStrategy)) {
            return propParserStrategy;
        }
        for (Class<? extends IDataEntityProperty> keyClass : STRATEGY_MAP.keySet()) {
            if (!keyClass.isAssignableFrom(clazz)) continue;
            propParserStrategy = STRATEGY_MAP.get(keyClass);
            STRATEGY_MAP_CACHE.put(clazz, propParserStrategy);
            return propParserStrategy;
        }
        return DEFAULT_PARSER_STRATEGY;
    }

    static {
        STRATEGY_MAP.put(TextProp.class, new TextPropParserStrategy());
        STRATEGY_MAP.put(ComboProp.class, new ComboPropParserStrategy());
        STRATEGY_MAP.put(NoCodeMulRefBillProp.class, new MulRefBillPropParserStrategy());
        STRATEGY_MAP.put(DateTimeProp.class, new DateTimePropParserStrategy());
        STRATEGY_MAP.put(PictureProp.class, new PicturePropParserStrategy());
        STRATEGY_MAP_CACHE.putAll(STRATEGY_MAP);
    }
}

