/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.rowstatusconvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.nocode.restapi.api.BaseFilterRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestBaseFilterParam;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterResult;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RowStatusConvertApiServiceImpl<P extends RestBaseFilterParam, R extends RestBaseFilterResult>
implements BaseFilterRestApiService<P, R> {
    private String operationNumber;

    public RestApiServiceData execute(RestBaseFilterParam param) {
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        Object[] filters = (QFilter[])qFilterPair.getValue();
        if (CollectionUtil.isEmpty((Object[])filters)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"RowStatusConvertApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        FormConfig config = FormMetadataCache.getFormConfig((String)param.getFormId());
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)config.getEntityTypeId()));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
        if (pkIds.size() == 0) {
            throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"RowStatusConvertApiServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        long start = System.currentTimeMillis();
        OperationResult operationResult = NoCodeOperationServiceHelper.executeOperate(this.getOperationNumber(), dt.getName(), pkIds.toArray(), this.createOption());
        long end = System.currentTimeMillis();
        String selectFields = "id".concat(",").concat(dt.getBillNo());
        DynamicObjectCollection returnFields = QueryServiceHelper.query((String)param.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        RestBaseFilterResult result = new RestBaseFilterResult();
        result.setSuccessCount((long)operationResult.getSuccessPkIds().size());
        result.setFailCount((long)pkIds.size() - (long)operationResult.getSuccessPkIds().size());
        result.setFilter(Arrays.toString(filters));
        result.setTotalCount((long)pkIds.size());
        ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
        result.setResult(resultsData);
        for (Object pkId : pkIds) {
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            data.setId(pkId.toString());
            returnFields.stream().filter(obj -> obj.get("id").equals(pkId)).findFirst().ifPresent(dynamicObject -> data.setNumber(dynamicObject.getString(dt.getBillNo())));
            Optional<Object> first = operationResult.getSuccessPkIds().stream().filter(i -> i.equals(pkId)).findFirst();
            if (first == Optional.empty()) {
                for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo().stream().filter(ev -> ev.getPkValue().equals(pkId)).collect(Collectors.toList())) {
                    data.getErrors().add(iOperateInfo.getMessage());
                }
            }
            data.setBillStatus(first != Optional.empty());
            resultsData.add(data);
        }
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        if (pkIds.size() == operationResult.getSuccessPkIds().size()) {
            return RestApiServiceData.of((boolean)operationResult.isSuccess(), (RestApiResponse)response, (long)(end - start));
        }
        return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.toString(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(end - start));
    }

    public void setOperationNumber(String operationNumber) {
        this.operationNumber = operationNumber;
    }

    public String getOperationNumber() {
        return this.operationNumber;
    }

    protected OperateOption createOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }
}

