/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.save.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.save.service.upper.AbstractSaveService;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DeleteEntryRowService
extends AbstractSaveService {
    static final String formatStr = "{0}:{1},";
    static final char keyTagSplit = '$';

    @Override
    public RestApiSaveResult execute() {
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        this.classifyByKey(this.param, insertList, updateList);
        if (updateList.size() == 0) {
            throw new RestApiException(RestApiErrorCode.DATA_NOTFOUND, ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u9700\u8981\u5220\u9664\u5206\u5f55\u7684\u5355\u636e\u6570\u636e", (String)"DeleteEntryRowService_0", (String)"bos-nocode-service", (Object[])new Object[0]), new Object[0]);
        }
        List<RestApiSaveItemData> opResult = this.executeDelete(updateList);
        return RestApiSaveResult.of(new ArrayList(), opResult);
    }

    private List<RestApiSaveItemData> executeDelete(List<Map<String, Object>> sourceDatas) {
        HashMap<String, RestApiSaveItemData> results;
        block6: {
            IDataModel model = this.getView().getModel();
            ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(sourceDatas.size());
            results = new HashMap<String, RestApiSaveItemData>(sourceDatas.size());
            for (Map<String, Object> objectMap : sourceDatas) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                String pkValue = objectMap.getOrDefault("id", "").toString();
                apiSaveData.setId(pkValue);
                this.resolve(model, objectMap);
                int index = Integer.parseInt(objectMap.get("_index_").toString());
                if (!pkValue.equals("")) {
                    apiSaveData.setBillIndex(index);
                    results.put(pkValue, apiSaveData);
                }
                billObjs.add(model.getDataEntity(true));
            }
            if (billObjs.isEmpty()) break block6;
            OperationResult result = NoCodeOperationServiceHelper.executeOperate(this.getOperationNumber(), model.getDataEntityType().getName(), billObjs.toArray(new DynamicObject[0]), this.getOperateOption());
            String billNo = ((BillEntityType)model.getDataEntityType()).getBillNo();
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                String selectFields = "id".concat(",").concat(billNo);
                DynamicObjectCollection returnFields = QueryServiceHelper.query((String)this.param.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)result.getSuccessPkIds())});
                for (Object successPkId : result.getSuccessPkIds()) {
                    String sPkId = successPkId.toString();
                    RestApiSaveItemData apiSaveData = (RestApiSaveItemData)results.get(sPkId);
                    if (apiSaveData == null) continue;
                    apiSaveData.setBillStatus(true);
                    returnFields.stream().filter(i -> i.get("id").equals(successPkId)).findFirst().ifPresent(id -> {
                        apiSaveData.setNumber(id.getString(billNo));
                        apiSaveData.setId(sPkId);
                    });
                }
            } else {
                for (Object successPkId : result.getSuccessPkIds()) {
                    String sPkId = successPkId.toString();
                    RestApiSaveItemData apiSaveData = (RestApiSaveItemData)results.get(sPkId);
                    if (apiSaveData == null) continue;
                    apiSaveData.setBillStatus(true);
                    apiSaveData.setId(sPkId);
                }
            }
        }
        return new ArrayList<RestApiSaveItemData>(results.values());
    }

    @Override
    protected void prepareDataEntity(IDataModel model, Map<String, Object> sourceData, boolean insert, Supplier<OperationResult> initializer) {
        model.beginInit();
        Object pkId = sourceData.get("id");
        ((IBillModel)model).load(pkId, () -> {
            OperationResult result = new OperationResult();
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"DeleteEntryRowService_1", (String)"bos-nocode-service", (Object[])new Object[]{this.getStatusCaption(dt, billStatusKey, BillStatus.B)}));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = true;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"DeleteEntryRowService_1", (String)"bos-nocode-service", (Object[])new Object[]{this.getStatusCaption(dt, billStatusKey, BillStatus.C)}));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
        model.endInit();
    }

    @Override
    protected OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }

    private void resolve(IDataModel model, Map<String, Object> sourceData) {
        OperationResult initResult = new OperationResult();
        this.prepareDataEntity(model, sourceData, false, () -> initResult);
    }
}

