/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.save.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.service.save.service.upper.AbstractSaveService;
import kd.bos.orm.util.CollectionUtils;

public class SaveService
extends AbstractSaveService {
    private static final Log log = LogFactory.getLog(SaveService.class);

    @Override
    public RestApiSaveResult execute() {
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        this.classifyByKey(this.param, insertList, updateList);
        List<RestApiSaveItemData> insertIds = this.batchInsert(insertList);
        List<RestApiSaveItemData> updateIds = this.batchUpdate(updateList);
        return RestApiSaveResult.of(insertIds, updateIds);
    }

    private List<RestApiSaveItemData> batchInsert(List<Map<String, Object>> insertList) {
        if (CollectionUtils.isEmpty(insertList)) {
            return Collections.emptyList();
        }
        return this.executeSave(insertList, true);
    }

    private List<RestApiSaveItemData> batchUpdate(List<Map<String, Object>> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return Collections.emptyList();
        }
        return this.executeSave(updateList, false);
    }

    @Override
    protected void prepareDataEntity(IDataModel model, Map<String, Object> sourceData, boolean insert, Supplier<OperationResult> initializer) {
        if (insert) {
            this.initInsertModel(model, sourceData, initializer);
        } else {
            if (!this.isFirePropChanged()) {
                model.beginInit();
            }
            this.initUpdateModel(model, sourceData.get("id"), sourceData, initializer);
            if (!this.isFirePropChanged()) {
                model.endInit();
            }
        }
    }

    @Override
    protected OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        Map<String, Object> optionVariables = this.getUserOptions();
        if (optionVariables != null) {
            for (Map.Entry<String, Object> entry : optionVariables.entrySet()) {
                option.setVariableValue(entry.getKey(), entry.getValue().toString());
            }
        }
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("webapitag_of_datasource", String.valueOf(true));
        return option;
    }

    private void initInsertModel(IDataModel model, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        model.beginInit();
        model.createNewData(this.getBlankDataEntity(model), initializer);
        model.endInit();
    }

    private void initUpdateModel(IDataModel model, Object pkId, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        ((IBillModel)model).load(pkId, () -> {
            OperationResult result = new OperationResult();
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaveService_0", (String)"bos-nocode-service", (Object[])new Object[]{this.getStatusCaption(dt, billStatusKey, BillStatus.B)}));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = true;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaveService_0", (String)"bos-nocode-service", (Object[])new Object[]{this.getStatusCaption(dt, billStatusKey, BillStatus.C)}));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
    }
}

