/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.save.service.convert;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.service.save.service.convert.BaseConvert;
import kd.bos.nocode.restapi.service.save.service.convert.FormatConverterContext;
import kd.bos.nocode.restapi.service.save.service.convert.FormatConverterFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class FormatConverter {
    private static final Log log = LogFactory.getLog(FormatConverter.class);
    FormatConverterContext contxt;

    Object getConvertResult(IDataEntityProperty type, Object value) {
        return this.getConvertResult(type, value, "");
    }

    Object getConvertResult(IDataEntityProperty type, Object value, String formId) {
        BaseConvert resultConvert = FormatConverterFactory.getFormatConverter(type, value);
        if (this.contxt == null) {
            this.contxt = new FormatConverterContext(formId);
        }
        resultConvert.setContext(this.contxt);
        Object result = value;
        try {
            result = resultConvert.Convert();
        }
        catch (Exception e) {
            log.debug(MessageFormat.format("webapi_log format fail,value:{0}", value));
        }
        return result;
    }

    public List<String> geterrorInfos() {
        return this.contxt != null ? this.contxt.getErrorInfos() : null;
    }

    public void replaceParamData(Map<String, Object> bill, String formId) {
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)formId);
        for (Map.Entry<String, Object> entry : bill.entrySet()) {
            IDataEntityProperty property = met.findProperty(entry.getKey());
            if (property instanceof EntryProp) {
                for (Object item : (List)entry.getValue()) {
                    this.replaceParamData((Map)item, formId);
                }
            }
            Object convertResult = this.getConvertResult(property, entry.getValue(), formId);
            entry.setValue(convertResult);
        }
    }

    public void replaceParamDatas(RestApiSaveParam source) {
        List dataList = source.getDataList();
        for (Map objectMap : dataList) {
            this.replaceParamData(objectMap, source.getFormId());
        }
    }
}

