/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.save.service.upper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.restapi.service.save.service.convert.FormatConverter;
import kd.bos.nocode.restapi.service.save.service.upper.SaveDataConvertResult;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.nocode.util.OpenApiAliasHelper;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractSaveService {
    private static final Log log = LogFactory.getLog(AbstractSaveService.class);
    private final String INDEX = "_index_";
    private final String MODEL_INIT_BY_WEBAPI = "MODEL_INIT_BY_WEBAPI";
    protected RestApiSaveParam param;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, Object> userOptions = new HashMap<String, Object>();
    private IFormView view;
    private String formId;
    private DynamicObject blankDataEntity;
    private OperateDataConverter dataConverter;
    private HasPermDimObjResult hasPermOrgResult;
    private List<String> dataConvertOrder = new ArrayList<String>();

    public Map<String, Object> getUserOptions() {
        return this.userOptions;
    }

    public void initialize(RestApiSaveParam param) {
        this.formId = param.getFormId();
        this.param = param;
        this.getView();
    }

    public void preExecute() {
        int i = 0;
        for (Map objectMap : this.param.getDataList()) {
            objectMap.put("_index_", i++);
        }
    }

    public abstract RestApiSaveResult execute();

    protected IFormView getView() {
        if (this.view == null) {
            this.createView();
        }
        return this.view;
    }

    private void createView() {
        FormShowParameter parameter = this.createShowParameter();
        this.view = parameter.createViewForWebApi();
        this.view.initialize(parameter);
    }

    private FormShowParameter createShowParameter() {
        HashMap<String, String> mapParam = new HashMap<String, String>(10);
        mapParam.put("formId", this.formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        return parameter;
    }

    protected Object getBlankDataEntity(IDataModel model) {
        if (this.blankDataEntity == null) {
            this.blankDataEntity = RestApiServiceLocalCache.getBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId());
        }
        if (this.blankDataEntity != null && !StringUtils.equals((CharSequence)this.blankDataEntity.getDataEntityType().getVersion(), (CharSequence)model.getDataEntityType().getVersion())) {
            this.blankDataEntity = null;
        }
        if (this.blankDataEntity == null) {
            model.removeContextVariable("MODEL_INIT_BY_WEBAPI");
            model.beginInit();
            model.createNewData();
            model.endInit();
            this.blankDataEntity = model.getDataEntity();
            model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
            RestApiServiceLocalCache.putBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId(), this.blankDataEntity);
        } else {
            IDataEntityType dt = this.blankDataEntity.getDataEntityType();
            for (IDataEntityProperty property : dt.getProperties()) {
                if (!(property instanceof CreateDateProp)) continue;
                property.setValue((Object)this.blankDataEntity, (Object)new Date());
                break;
            }
        }
        return OrmUtils.clone((IDataEntityBase)this.blankDataEntity, (boolean)false, (boolean)true);
    }

    protected OperateDataConverter getDataConverter(IDataModel model) {
        if (this.dataConverter == null) {
            String entityNumber = model.getDataEntityType().getName();
            Map<BasedataItem, Object> cacheBasePKs = RestApiServiceLocalCache.getBasePKs(entityNumber);
            Map<String, Map<Object, DynamicObject>> cacheBaseObjs = RestApiServiceLocalCache.getBaseOBJs(entityNumber);
            this.dataConverter = new OperateDataConverter(model, cacheBasePKs, cacheBaseObjs);
            this.dataConverter.setHasPermResult(this.getHasPermOrgResult());
        } else {
            this.dataConverter.beginNewBill(3);
        }
        return this.dataConverter;
    }

    public HasPermDimObjResult getHasPermOrgResult() {
        if (this.hasPermOrgResult == null) {
            PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            this.hasPermOrgResult = permService.getHasPermDimObjs(Long.parseLong(RequestContext.get().getUserId()), "", this.formId, "47150e89000000ac");
        }
        return this.hasPermOrgResult;
    }

    protected abstract void prepareDataEntity(IDataModel var1, Map<String, Object> var2, boolean var3, Supplier<OperationResult> var4);

    protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert) {
        boolean canInput;
        IDataModel model = this.getView().getModel();
        String entityNumber = model.getDataEntityType().getName();
        if (isInsert && !(canInput = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)entityNumber))) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6ca1\u6709\u65b0\u589e\u8868\u5355\u8bb0\u5f55\u6743\u9650", (String)"AbstractSaveService_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        sourceDatas = OpenApiAliasHelper.replaceAlias2Field((String)entityNumber, sourceDatas);
        HashSet<String> triggerRows = new HashSet<String>(sourceDatas.size());
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        ModelEventProxy eventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        if (eventProxy != null) {
            eventProxy.fireInitImportData(new InitImportDataEventArgs((Object)model, sourceDatas, this.options, this.dataConvertOrder));
        }
        HashMap<String, RestApiSaveItemData> results = new HashMap<String, RestApiSaveItemData>(sourceDatas.size());
        SaveDataConvertResult convertResult = SaveDataConvertResult.of(System.currentTimeMillis());
        int len = sourceDatas.size();
        for (int i = 0; i < len; ++i) {
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            String pkValue = ((Map)sourceDatas.get(i)).getOrDefault("id", "").toString();
            if (model.getDataEntityType() instanceof BillEntityType) {
                apiSaveData.setId(pkValue);
            }
            this.resolve(model, (Map)sourceDatas.get(i), isInsert, convertResult);
            pkValue = ((Map)sourceDatas.get(i)).getOrDefault("id", new Object()).toString();
            int index = Integer.parseInt(((Map)sourceDatas.get(i)).get("_index_").toString());
            if (!pkValue.equals("")) {
                apiSaveData.setBillIndex(index);
                results.put(pkValue, apiSaveData);
            }
            if (!isInsert && StringUtils.isNotBlank((CharSequence)pkValue) && !NoCodePermHelper.checkDataEditPermInNoCode((String)entityNumber, (Object)pkValue)) {
                apiSaveData.setBillStatus(false);
                HashSet errorMessage = Sets.newHashSet((Object[])new String[]{ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u8be5\u8868\u5355\u8bb0\u5f55[", (String)"AbstractSaveService_1", (String)"bos-nocode-service", (Object[])new Object[0]) + pkValue + ResManager.loadKDString((String)"]\u7684\u6743\u9650", (String)"AbstractSaveService_2", (String)"bos-nocode-service", (Object[])new Object[0])});
                apiSaveData.getErrors().add(new RestApiSaveRowErrorData(entityNumber, new HashMap(), (Set)errorMessage));
                continue;
            }
            if (convertResult.isSuccess()) {
                apiSaveData.setBillStatus(true);
                billObjs.add(model.getDataEntity(true));
                Boolean triggerWf = (Boolean)((Map)sourceDatas.get(i)).get("triggerWf");
                if (triggerWf != null && !triggerWf.booleanValue()) continue;
                triggerRows.add(pkValue);
                continue;
            }
            apiSaveData.setBillStatus(false);
            apiSaveData.getErrors().add(convertResult.getErrorInfos().get(index));
        }
        convertResult.setEndTime(System.currentTimeMillis());
        if (!billObjs.isEmpty()) {
            OperationResult result = NoCodeOperationServiceHelper.executeOperate(this.getOperationNumber(), entityNumber, billObjs.toArray(new DynamicObject[billObjs.size()]), this.getOperateOption());
            for (Map.Entry stringApiSaveDataEntry : results.entrySet()) {
                ((RestApiSaveItemData)stringApiSaveDataEntry.getValue()).setBillStatus(false);
            }
            this.setBillNo(model, results, result);
            for (IOperateInfo operateErrorInfoitem : result.getAllErrorOrValidateInfo()) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operateErrorInfoitem;
                RestApiSaveRowErrorData saveErrorData = new RestApiSaveRowErrorData();
                saveErrorData.setEntityKey(operateErrorInfo.getEntityKey());
                saveErrorData.getRowMsg().add(operateErrorInfo.getMessage());
                ((RestApiSaveItemData)results.get(operateErrorInfo.getPkValue().toString())).getErrors().add(saveErrorData);
            }
        }
        results.values().stream().filter(RestApiSaveItemData::isBillStatus).map(RestApiSaveItemData::getId).filter(triggerRows::contains).forEach(e -> this.triggerProcess(entityNumber, e, isInsert));
        return results.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void triggerProcess(String entityNumber, Object billPk, boolean isInsert) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billPk == null) {
            return;
        }
        String triggerMode = this.getTriggerMode(isInsert);
        ThreadPools.executeOnce((String)"nocode_triggerProcess", () -> {
            try {
                NoCodeWorkflowServiceHelper.tryTriggerProcessByTriggerMode((String)entityNumber, (String)billPk.toString(), (String)triggerMode);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        });
    }

    private String getTriggerMode(boolean isInsert) {
        return isInsert ? WfConsts.FireTypeEnum.NEWSUBMIT.getCode() : WfConsts.FireTypeEnum.EDITSUBMIT.getCode();
    }

    private Object getSourceBaseDataValue(Map value, String key) {
        String basefieldKey = key.substring(0, key.indexOf(46));
        String basefieldRefKey = key.substring(key.indexOf(46) + 1);
        if (value.get(basefieldKey) instanceof Map) {
            Object baseRefValue = ((Map)value.get(basefieldKey)).get(basefieldRefKey);
            if (baseRefValue instanceof Map) {
                return this.getSourceBaseDataValue((Map)baseRefValue, basefieldRefKey);
            }
            return baseRefValue;
        }
        return "";
    }

    protected abstract OperateOption getOperateOption();

    private void setBillNo(IDataModel model, Map<String, RestApiSaveItemData> results, OperationResult result) {
        String billNo = ((BillEntityType)model.getDataEntityType()).getBillNo();
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            String selectFields = "id".concat(",").concat(billNo);
            DynamicObjectCollection returnFields = QueryServiceHelper.query((String)this.formId, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)result.getSuccessPkIds())});
            for (Object successPkId2 : result.getSuccessPkIds()) {
                String sPkId = successPkId2.toString();
                RestApiSaveItemData apiSaveData = results.get(sPkId);
                if (apiSaveData == null) continue;
                apiSaveData.setBillStatus(true);
                Optional<DynamicObject> first = returnFields.stream().filter(i -> i.get("id").equals(successPkId2)).findFirst();
                first.ifPresent(e -> {
                    apiSaveData.setNumber(e.getString(billNo));
                    apiSaveData.setId(sPkId);
                });
            }
        } else {
            result.getSuccessPkIds().forEach(successPkId -> {
                String sPkId = successPkId.toString();
                Optional.ofNullable(results.get(sPkId)).ifPresent(apiSaveData -> {
                    apiSaveData.setBillStatus(true);
                    apiSaveData.setId(sPkId);
                });
            });
        }
    }

    private void resolve(IDataModel model, Map<String, Object> sourceData, boolean insert, SaveDataConvertResult result) {
        try {
            this.prepareDataEntity(model, sourceData, insert, () -> {
                boolean errorOccurred;
                FormatConverter formatConverter = new FormatConverter();
                formatConverter.replaceParamData(sourceData, model.getDataEntityType().getName());
                List<String> errorInfos = formatConverter.geterrorInfos();
                if (CollectionUtils.isNotEmpty(errorInfos)) {
                    // empty if block
                }
                OperateDataConverter convert = this.getDataConverter(model);
                PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
                Object pkValue = model.getDataEntity().getPkValue();
                if (!pkProp.getValueComparator().compareValue(pkValue)) {
                    convert.setModify(true);
                } else {
                    convert.setModify(false);
                    this.handleSourceData(model, sourceData, pkProp);
                }
                convert.setDataConvertOrder(this.dataConvertOrder);
                model.putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
                Map contextErrorMap = convert.getContextErrorInfo();
                boolean fireAfterImportData = this.isFireAfterImportData();
                ModelEventProxy eventProxy = convert.getModelEventProxy();
                if (eventProxy != null) {
                    BeforeImportDataEventArgs eventArgs = new BeforeImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), this.options);
                    eventArgs.setCheckImportable(false);
                    eventProxy.fireBeforeImportData(eventArgs);
                    convert.setCheckImportable(eventArgs.isCheckImportable());
                    boolean bl = fireAfterImportData = fireAfterImportData && eventArgs.isFireAfterImportData();
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                convert.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
                convert.filterBasedatas(sourceData, model.getDataEntity(), 0);
                convert.cacheBasedataPKIds();
                convert.convertComplexProperty(sourceData, model.getDataEntity(), 0);
                boolean bl = errorOccurred = sourceData.get("_ERROR_DATA_") != null;
                if (!errorOccurred && eventProxy != null && fireAfterImportData) {
                    ImportDataEventArgs eventArgs = new ImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), this.options);
                    eventProxy.fireAfterImportData(eventArgs);
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                model.clearNoDataRow();
                model.removeContextVariable("IGNORE_RELOADDATAMODEL");
                OperationResult initResult = this.buildInitResult(contextErrorMap);
                if (errorOccurred) {
                    initResult.setSuccess(false);
                }
                return initResult;
            });
        }
        catch (KDBizException e) {
            this.handleException(model, sourceData, result, e);
        }
    }

    private void handleException(IDataModel model, Map<String, Object> sourceData, SaveDataConvertResult result, KDBizException e) {
        result.setSuccess(false);
        RestApiSaveRowErrorData ed = new RestApiSaveRowErrorData();
        ed.setEntityKey(model.getDataEntityType().getName());
        String eMessage = e.getMessage();
        if (JSON.isValid((String)e.getMessage())) {
            Map hashMap = (Map)JSON.parseObject((String)eMessage, Map.class);
            for (Map.Entry listEntry : hashMap.entrySet()) {
                for (String s : (List)listEntry.getValue()) {
                    ed.getRowMsg().add(s);
                }
            }
        } else {
            ed.getRowMsg().add(eMessage);
        }
        int index = Integer.parseInt(sourceData.get("_index_").toString());
        result.getErrorInfos().put(index, ed);
    }

    private void handleSourceData(IDataModel model, Map<String, Object> sourceData, PKFieldProp pkProp) {
        if (sourceData.get("id") == null) {
            if (pkProp instanceof LongProp) {
                model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genGlobalLongId());
                sourceData.put(pkProp.getName(), model.getValue(pkProp.getName()));
            } else if (pkProp instanceof VarcharProp) {
                model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genStringId());
                sourceData.put(pkProp.getName(), model.getValue(pkProp.getName()));
            }
        }
    }

    protected boolean isFirePropChanged() {
        Object paramValue;
        boolean firePropChanged = false;
        if (this.options != null && (paramValue = this.options.get("firePropChanged")) != null) {
            firePropChanged = StringUtils.isBlank((Object)paramValue) ? false : Boolean.parseBoolean(paramValue.toString());
        }
        return firePropChanged;
    }

    protected boolean isFireAfterImportData() {
        boolean fireAfterImportData = true;
        if (this.options != null) {
            Object paramValue = this.options.get("fireAfterImportData");
            fireAfterImportData = StringUtils.isBlank((Object)paramValue) || Boolean.parseBoolean(paramValue.toString());
        }
        return fireAfterImportData;
    }

    private void mergeCancelMessages(Map<Integer, List<String>> cancelMessages, Map<Integer, List<String>> contextErrorMap) {
        if (!cancelMessages.isEmpty()) {
            for (Map.Entry<Integer, List<String>> entry : cancelMessages.entrySet()) {
                List<String> errlist = contextErrorMap.get(entry.getKey());
                if (errlist == null) {
                    errlist = new ArrayList<String>();
                    contextErrorMap.put(entry.getKey(), errlist);
                }
                errlist.addAll((Collection<String>)entry.getValue());
            }
        } else {
            contextErrorMap.put(0, Collections.singletonList(ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6d88\u5bfc\u5165\u672c\u5355", (String)"AbstractSaveService_3", (String)"bos-nocode-service", (Object[])new Object[0])));
        }
    }

    public String getOperationNumber() {
        if (this.options == null || this.options.get("forcedSubmit") == null) {
            return "save";
        }
        String submit = this.options.get("forcedSubmit").toString();
        if (StringUtils.isEmpty((CharSequence)submit)) {
            return "save";
        }
        return submit;
    }

    private OperationResult buildInitResult(Map<Integer, List<String>> contextErrorMap) {
        OperationResult initResult = new OperationResult();
        if (!contextErrorMap.isEmpty()) {
            initResult.setSuccess(false);
            initResult.setMessage(JSON.toJSONString(contextErrorMap));
        }
        return initResult;
    }

    protected boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty("createorg") != null && dt.getProperty("ctrlstrategy") != null;
    }

    protected Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    protected void classifyByKey(RestApiSaveParam param, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)param.getFormId()));
        for (Map dataMap : param.getDataList()) {
            Object id = this.queryId(entityType, dataMap);
            if (id == null) {
                insertList.add(dataMap);
                continue;
            }
            dataMap.put("id", id);
            updateList.add(dataMap);
        }
    }

    private Object queryId(MainEntityType entityType, Map<String, Object> dataMap) {
        DynamicProperty pkProperty = AbstractSaveService.getProperty((EntityType)entityType, "id");
        Object pkValue = null;
        Object pkId = null;
        try {
            Object sourceId = dataMap.get("id");
            log.debug("webapi_log_new sourceId:".concat(sourceId.toString()));
            pkValue = AbstractSaveService.castSingleValue(pkProperty, "id", sourceId);
            log.debug("webapi_log_new castSingleValue:".concat(pkValue.toString()));
        }
        catch (Exception e) {
            log.debug("id:" + dataMap.remove("id") + "\uff0c\u7c7b\u578b\u975e\u6cd5\uff0c\u5c06\u901a\u8fc7\u5019\u9009\u952e\u627e\u76ee\u6807\u5355ID");
        }
        if (pkValue != null) {
            QFilter filter = new QFilter("id", "=", pkValue);
            Object id = AbstractSaveService.innerGetPk(entityType.getName(), new QFilter[]{filter}, Collections.singletonList("id"), dataMap);
            if (id != null) {
                dataMap.put("_pkid_", id);
                log.debug("webapi_log_new pkValue innerGetPk:".concat(id.toString()));
                pkId = id;
            }
        }
        return pkId;
    }

    public static DynamicProperty getProperty(EntityType entityType, String field) {
        int index = field.indexOf(46);
        if (index < 0) {
            return entityType.getProperty(field);
        }
        DynamicProperty property = entityType.getProperty(field.substring(0, index));
        if (property instanceof BasedataProp) {
            String name = ((BasedataProp)property).getComplexType().getName();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)name);
            return AbstractSaveService.getProperty((EntityType)type, field.substring(index + 1));
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5f15\u7528\u7c7b\u578b\u5c5e\u6027\u8fc7\u6ee4, \u4e0d\u652f\u6301", (String)"AbstractSaveService_4", (String)"bos-nocode-service", (Object[])new Object[0]) + entityType.getName() + ResManager.loadKDString((String)"\u7684\u5c5e\u6027", (String)"AbstractSaveService_5", (String)"bos-nocode-service", (Object[])new Object[0]) + property.getName() + ResManager.loadKDString((String)"\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6", (String)"AbstractSaveService_6", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private static Object castSingleValue(DynamicProperty property, String field, Object oldValue) {
        String s = null;
        try {
            if (oldValue == null) {
                return null;
            }
            if (property instanceof MuliLangTextProp && oldValue instanceof Map) {
                return ((Map)oldValue).get(Lang.get().name());
            }
            if (property instanceof DateTimeProp) {
                return DataUtil.t((Object)oldValue);
            }
            if (property instanceof LongProp) {
                return DataUtil.l((Object)oldValue);
            }
            if (property instanceof IntegerProp) {
                return DataUtil.i((Object)oldValue);
            }
            if (property instanceof BooleanProp) {
                return DataUtil.x((Object)oldValue);
            }
            if (property instanceof VarcharProp && (s = DataUtil.s((Object)oldValue)) != null) {
                return s;
            }
            if (property instanceof BasedataProp) {
                return ((BasedataProp)property).getRefIdProp() instanceof LongProp ? Long.valueOf(DataUtil.l((Object)oldValue)) : DataUtil.s((Object)oldValue);
            }
            if (property instanceof TextProp) {
                return oldValue.toString();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new RestApiException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u5c5e\u6027", (String)"AbstractSaveService_7", (String)"bos-nocode-service", (Object[])new Object[0]) + field + ResManager.loadKDString((String)"\u7684\u503c", (String)"AbstractSaveService_8", (String)"bos-nocode-service", (Object[])new Object[0]) + s + ResManager.loadKDString((String)"\u8f6c\u6362\u4e3a", (String)"AbstractSaveService_9", (String)"bos-nocode-service", (Object[])new Object[0]) + property.getClass() + ResManager.loadKDString((String)"\u7c7b\u578b", (String)"AbstractSaveService_10", (String)"bos-nocode-service", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static Object innerGetPk(String entity, QFilter[] filters, List<String> fields, Map<String, Object> data) {
        String number;
        HashSet<String> requires = new HashSet<String>();
        requires.add("id");
        requires.addAll(fields);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entity, (String)String.join((CharSequence)",", requires), (QFilter[])filters);
        if (fields.size() == 1 && fields.contains("number") && (number = DataUtil.s((Object)data.get("number"))) != null) {
            return AbstractSaveService.findIdByNumber(entity, (List<DynamicObject>)ids, number);
        }
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ((DynamicObject)ids.get(0)).get("id");
        }
        return AbstractSaveService.handleMultiIds(entity, fields, (List<DynamicObject>)ids);
    }

    private static Object handleMultiIds(String entity, List<String> fields, List<DynamicObject> ids) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(ids);
        if (set.size() > 1) {
            throw new RestApiException(RestApiErrorCode.DATA_DUPLICATE, ResManager.loadKDString((String)"\u5b9e\u4f53 ", (String)"AbstractSaveService_11", (String)"bos-nocode-service", (Object[])new Object[0]) + entity + ResManager.loadKDString((String)"\u6839\u636e\u5019\u9009\u952e", (String)"AbstractSaveService_12", (String)"bos-nocode-service", (Object[])new Object[0]) + String.join((CharSequence)",", fields) + ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55", (String)"AbstractSaveService_13", (String)"bos-nocode-service", (Object[])new Object[0]), new Object[0]);
        }
        return ids.get(0).get("id");
    }

    private static Object findIdByNumber(String entity, List<DynamicObject> ids, String number) {
        Object id = null;
        for (DynamicObject obj : ids) {
            if (!number.equals(DataUtil.s((Object)obj.get("number")))) continue;
            if (id == null) {
                id = obj.get("id");
                continue;
            }
            if (id.equals(obj.get("id"))) continue;
            throw new RestApiException(RestApiErrorCode.DATA_DUPLICATE, ResManager.loadKDString((String)"\u5b9e\u4f53 ", (String)"AbstractSaveService_11", (String)"bos-nocode-service", (Object[])new Object[0]) + entity + ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u7684\u7f16\u7801\u662f\uff08", (String)"AbstractSaveService_14", (String)"bos-nocode-service", (Object[])new Object[0]) + number + "\uff09", new Object[0]);
        }
        return id;
    }
}

