/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandler;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.constant.StatPanelTypeEnum;
import kd.bos.nocode.restapi.service.statistics.handler.AggregationStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.AvgStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.GroupStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.IsFilledStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.MaxStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.MinStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.SpecialFieldValueGroupStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.SumStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.SummaryStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.TotalStatHandler;

public class FieldStatisticsHandlerRegistry {
    private static final Map<ReportTypeEnum, FieldStatisticsHandler> HANDLER_MAP = new EnumMap<ReportTypeEnum, FieldStatisticsHandler>(ReportTypeEnum.class);

    private FieldStatisticsHandlerRegistry() {
    }

    public static List<FieldStatisticsHandler> getHandler(StatPanelTypeEnum statPanelType) {
        ArrayList<FieldStatisticsHandler> handlers = new ArrayList<FieldStatisticsHandler>(3);
        switch (statPanelType) {
            case TOTAL: {
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.SUMMARY));
                break;
            }
            case DECIMAL: {
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.GROUP));
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.AGG));
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.SUMMARY));
                break;
            }
            case FILLED: {
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.IS_FILLED));
                break;
            }
            default: {
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.GROUP));
                handlers.add(HANDLER_MAP.get((Object)ReportTypeEnum.SUMMARY));
            }
        }
        return handlers;
    }

    public static FieldStatisticsHandler getHandler(ReportTypeEnum type) {
        return HANDLER_MAP.get((Object)type);
    }

    static {
        HANDLER_MAP.put(ReportTypeEnum.GROUP, new GroupStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.SPECIAL_GROUP_VALUE, new SpecialFieldValueGroupStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.SUMMARY, new SummaryStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.AGG, new AggregationStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.AVG, new AvgStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.SUM, new SumStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.MAX, new MaxStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.MIN, new MinStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.TOTAL, new TotalStatHandler());
        HANDLER_MAP.put(ReportTypeEnum.IS_FILLED, new IsFilledStatHandler());
    }
}

