/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandler;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandlerRegistry;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.StatPanelTypeEnum;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FieldStatisticsService {
    public Pair<Boolean, RestApiServiceData<RestApiQueryResult>> handle(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String fieldNameStr = (String)param.getRequest().getHttpQueryString().get("stat");
        if (StringUtils.isEmpty((CharSequence)fieldNameStr)) {
            return new Pair((Object)Boolean.FALSE, null);
        }
        String[] fieldNames = fieldNameStr.split(",");
        if (fieldNames.length > 1) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u540c\u65f6\u7edf\u8ba1\u591a\u4e2a\u5b57\u6bb5", (String)"FieldStatisticsService_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        String formId = param.getFormId();
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        Object[] filters = (QFilter[])qFilterPair.getValue();
        filters = NoCodePermHelper.combinePermFilter((String)param.getAppNumber(), (String)formId, (QFilter[])filters);
        String schemaId = (String)param.getRequest().getHttpQueryString().get("schemaId");
        if (StringUtils.isNotEmpty((CharSequence)schemaId)) {
            Object[] schemaFilters = ListSchemaService.create().getSchemaFilters(Long.parseLong(schemaId));
            filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])schemaFilters);
        }
        ArrayList<Map<String, Object>> fieldStatInfos = new ArrayList<Map<String, Object>>(10);
        for (String fieldName : fieldNames) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldName);
            Map<String, Object> fieldStatInfo = this.getFieldStatInfo(property, (QFilter[])filters);
            if (!MapUtils.isNotEmpty(fieldStatInfo)) continue;
            fieldStatInfos.add(fieldStatInfo);
        }
        RestApiQueryResult restApiQueryResult = new RestApiQueryResult();
        restApiQueryResult.setRows(fieldStatInfos);
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)restApiQueryResult);
        return new Pair((Object)Boolean.TRUE, (Object)RestApiServiceData.ofTrue((RestApiResponse)response, (long)this.getCostTime(startTime)));
    }

    public Map<String, Object> getFieldStatInfo(IDataEntityProperty property, QFilter[] filters) {
        StatPanelTypeEnum panelTypeEnum = FieldStatisticsService.getStatPanelType(property);
        List<FieldStatisticsHandler> handlers = FieldStatisticsHandlerRegistry.getHandler(panelTypeEnum);
        HashMap<String, Object> fieldStatInfo = new HashMap<String, Object>(10);
        if (CollectionUtils.isEmpty(handlers)) {
            return fieldStatInfo;
        }
        fieldStatInfo.put("fieldName", property.getName());
        fieldStatInfo.put("panelType", (Object)panelTypeEnum);
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(10);
        for (FieldStatisticsHandler handler : handlers) {
            String fieldName;
            String formNumber;
            Map<String, Object> infos = handler.handle(formNumber = property.getParent().getName(), fieldName = property.getName(), filters);
            if (!MapUtils.isNotEmpty(infos)) continue;
            details.putAll(infos);
        }
        fieldStatInfo.put("details", details);
        return fieldStatInfo;
    }

    public static StatPanelTypeEnum getStatPanelType(IDataEntityProperty property) {
        if (Objects.isNull(property)) {
            return StatPanelTypeEnum.TOTAL;
        }
        if (StatMapUtils.isText(property)) {
            return StatPanelTypeEnum.TEXT;
        }
        if (property instanceof DecimalProp) {
            return StatPanelTypeEnum.DECIMAL;
        }
        if (StatMapUtils.isFilled(property)) {
            return StatPanelTypeEnum.FILLED;
        }
        return StatPanelTypeEnum.TOTAL;
    }

    private long getCostTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }
}

