/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.nocode.ext.constant.DateFormatEnum;
import kd.bos.nocode.ext.metadata.entity.NoCodeEntryEntity;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRichTextProp;
import kd.bos.nocode.ext.property.NoCodeTextAreaProp;
import kd.bos.nocode.ext.property.NoCodeTextProp;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.dto.GroupInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class StatMapUtils {
    public static final String COUNT = "count";
    public static final String RPT_TYPE = "rptType";
    public static final String LABEL = "label";
    public static final String PERCENTAGE = "percentage";
    public static final String AVG = "avg";
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String FIELD_VALUE = "fieldValue";
    public static final String VALUE = "value";
    public static final String FILLED = "FILLED";
    public static final DecimalFormat DF = new DecimalFormat("0.00");

    private StatMapUtils() {
    }

    public static Map<String, Map<String, Object>> getAggregationMap(ReportTypeEnum rptType, String value) {
        HashMap<String, String> valueMap = new HashMap<String, String>(2);
        valueMap.put(VALUE, value);
        valueMap.put(LABEL, rptType.getTitle());
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(2);
        map.put(rptType.getCode(), valueMap);
        return map;
    }

    public static Map<String, Object> getGroupMap(String label, String groupValue, String percentage, int count) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
        valueMap.put(COUNT, count);
        valueMap.put(PERCENTAGE, percentage);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (StringUtils.isEmpty((CharSequence)label)) {
            label = ResManager.loadKDString((String)"\uff08\u7a7a\u767d\uff09", (String)"StatMapUtils_0", (String)"bos-nocode-service", (Object[])new Object[0]);
        }
        map.put(LABEL, label);
        map.put(FIELD_VALUE, groupValue);
        map.put(VALUE, valueMap);
        return map;
    }

    public static Map<String, Map<String, Object>> getSummaryMap(int groupNumber, int total) {
        HashMap<String, String> valueMap = new HashMap<String, String>(2);
        valueMap.put(VALUE, ResManager.loadKDString((String)"%1$s \u9879 %2$s \u6761", (String)"StatMapUtils_1", (String)"bos-nocode-service", (Object[])new Object[]{groupNumber, total}));
        valueMap.put(LABEL, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StatMapUtils_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(2);
        map.put(ReportTypeEnum.SUMMARY.getCode(), valueMap);
        return map;
    }

    public static Map<String, Map<String, Object>> getTotalMap(int total) {
        HashMap<String, String> valueMap = new HashMap<String, String>(2);
        valueMap.put(VALUE, ResManager.loadKDString((String)"%s \u6761", (String)"StatMapUtils_3", (String)"bos-nocode-service", (Object[])new Object[]{total}));
        valueMap.put(LABEL, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StatMapUtils_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(2);
        map.put(ReportTypeEnum.SUMMARY.getCode(), valueMap);
        return map;
    }

    public static String getPercentage(int count, int total) {
        if (total == 0) {
            return "0";
        }
        return DF.format((double)count * 1.0 / (double)total * 100.0);
    }

    public static GroupInfo getGroupInfo(IDataEntityProperty property, Object value) {
        if (Objects.isNull(value)) {
            return new GroupInfo(ResManager.loadKDString((String)"\uff08\u7a7a\u767d\uff09", (String)"StatMapUtils_0", (String)"bos-nocode-service", (Object[])new Object[0]), "");
        }
        if (value instanceof String) {
            return StatMapUtils.getGroupInfoByString(property, value);
        }
        if (property instanceof BigIntProp) {
            String valueStr = String.valueOf(value);
            return new GroupInfo(valueStr, valueStr);
        }
        if (property instanceof DecimalProp) {
            String valueStr = ((BigDecimal)value).toPlainString();
            return new GroupInfo(valueStr, valueStr);
        }
        if (property instanceof DateTimeProp) {
            String valueStr = ((DateTimeProp)property).getDateFormat().format(value);
            return new GroupInfo(valueStr, valueStr);
        }
        if (property instanceof NoCodeCreatorProp || property instanceof NoCodeModifierProp) {
            return StatMapUtils.getUserGroupInfo(value);
        }
        String valueStr = String.valueOf(value);
        return new GroupInfo(valueStr, valueStr);
    }

    @NotNull
    private static GroupInfo getGroupInfoByString(IDataEntityProperty property, Object value) {
        String valueStr = (String)value;
        String label = valueStr;
        if (StringUtils.isEmpty((CharSequence)label)) {
            label = ResManager.loadKDString((String)"\uff08\u7a7a\u767d\uff09", (String)"StatMapUtils_0", (String)"bos-nocode-service", (Object[])new Object[0]);
        } else if (property instanceof ComboProp) {
            label = ((ComboProp)property).getItemByName(valueStr);
            if (StringUtils.isEmpty((CharSequence)label)) {
                label = valueStr;
            }
        } else if (StatMapUtils.isFilled(property) && Objects.equals(value, FILLED)) {
            label = ResManager.loadKDString((String)"\uff08\u5df2\u586b\u5199\uff09", (String)"StatMapUtils_4", (String)"bos-nocode-service", (Object[])new Object[0]);
        } else if (property instanceof NoCodeCreatorProp || property instanceof NoCodeModifierProp) {
            return StatMapUtils.getUserGroupInfo(Long.parseLong(valueStr));
        }
        return new GroupInfo(label, valueStr);
    }

    @NotNull
    private static GroupInfo getUserGroupInfo(Object value) {
        Map userInfo = UserServiceHelper.getUserInfoByID((long)((Long)value));
        if (MapUtils.isEmpty((Map)userInfo)) {
            return new GroupInfo(ResManager.loadKDString((String)"\uff08\u7a7a\u767d\uff09", (String)"StatMapUtils_0", (String)"bos-nocode-service", (Object[])new Object[0]), String.valueOf(value));
        }
        String name = (String)userInfo.get("name");
        return new GroupInfo(name, String.valueOf(value));
    }

    public static boolean isShortDate(IDataEntityProperty property) {
        return property instanceof NoCodeDateTimeProp && ((NoCodeDateTimeProp)property).getFormatType().equalsIgnoreCase(DateFormatEnum.DATE.getCode());
    }

    public static boolean isFilled(IDataEntityProperty property) {
        return property instanceof NoCodeRefBillProp || property instanceof NoCodeMulRefBillProp || property instanceof NoCodeRichTextProp || property instanceof NoCodeEntryEntity || StatMapUtils.isPassword(property);
    }

    public static boolean isText(IDataEntityProperty property) {
        return property instanceof NoCodeTextProp && !StatMapUtils.isPassword(property) || property instanceof NoCodeTextAreaProp || property instanceof ComboProp || property instanceof NoCodeCreatorProp || property instanceof NoCodeModifierProp || property instanceof DateTimeProp || property instanceof PictureProp || property instanceof AttachmentProp;
    }

    private static boolean isPassword(IDataEntityProperty property) {
        return property instanceof NoCodeTextProp && ((NoCodeTextProp)property).isPassword();
    }

    static {
        DF.setRoundingMode(RoundingMode.HALF_UP);
    }
}

