/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.dto.GroupInfo;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AttachmentStatHelper {
    private AttachmentStatHelper() {
    }

    public static void handle(List<Map<String, Object>> details, String formNumber, String fieldName, QFilter[] filters) {
        AttachmentStatHelper.handleSubField(details, formNumber, fieldName, filters, "fbasedataid.name");
    }

    public static void handleSubField(List<Map<String, Object>> details, String formNumber, String fieldName, QFilter[] filters, String subField) {
        LongAdder totalCount = new LongAdder();
        LongAdder blankCount = new LongAdder();
        Map<String, Long> countMap = AttachmentStatHelper.getAttrCount(formNumber, fieldName, filters, totalCount, blankCount, subField);
        String selectField = fieldName + "." + subField;
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formNumber), (String)selectField);
        countMap.forEach((k, v) -> {
            String percentage = StatMapUtils.getPercentage(Math.toIntExact(v), totalCount.intValue());
            GroupInfo groupInfo = StatMapUtils.getGroupInfo(property, k);
            String label = groupInfo.getLabel();
            String groupValue = groupInfo.getValue();
            details.add(StatMapUtils.getGroupMap(label, groupValue, percentage, Math.toIntExact(v)));
        });
    }

    public static void handle(Map<String, Object> statMap, String formNumber, String fieldName, QFilter[] filters, String fieldValue) {
        LongAdder totalCount = new LongAdder();
        LongAdder blankCount = new LongAdder();
        Map<String, Long> nameCount = AttachmentStatHelper.getAttrNameCount(formNumber, fieldName, filters, totalCount, blankCount);
        int count = Math.toIntExact(nameCount.getOrDefault(fieldValue, 0L));
        String percentage = StatMapUtils.getPercentage(count, totalCount.intValue());
        statMap.put(ReportTypeEnum.GROUP.getCode(), StatMapUtils.getGroupMap(fieldValue, fieldValue, percentage, count));
    }

    public static void handleSummary(Map<String, Object> statMap, String formNumber, String fieldName, QFilter[] filters) {
        LongAdder totalCount = new LongAdder();
        LongAdder blankCount = new LongAdder();
        Map<String, Long> nameCount = AttachmentStatHelper.getAttrNameCount(formNumber, fieldName, filters, totalCount, blankCount);
        Map<String, Map<String, Object>> summaryMap = StatMapUtils.getSummaryMap(nameCount.size(), totalCount.intValue());
        statMap.putAll(summaryMap);
    }

    private static Map<String, Long> getAttrNameCount(String formNumber, String fieldName, QFilter[] filters, LongAdder totalCount, LongAdder emptyCount) {
        return AttachmentStatHelper.getAttrCount(formNumber, fieldName, filters, totalCount, emptyCount, "fbasedataid.name");
    }

    private static Map<String, Long> getAttrCount(String formNumber, String fieldName, QFilter[] filters, LongAdder totalCount, LongAdder emptyCount, String subField) {
        String selectField = fieldName + "." + subField;
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)formNumber, (String)selectField, (QFilter[])filters, (String)"", (int)100000);
        List attrObjs = Arrays.stream(dynObjs).flatMap(dynamicObject -> {
            DynamicObjectCollection attrs = dynamicObject.getDynamicObjectCollection(fieldName);
            totalCount.add(attrs.size() == 0 ? 1L : (long)attrs.size());
            if (CollectionUtils.isEmpty((Collection)attrs)) {
                emptyCount.increment();
            }
            return attrs.stream();
        }).collect(Collectors.toList());
        Map<String, Long> nameCount = attrObjs.stream().collect(Collectors.groupingBy(e -> StringUtils.isBlank((CharSequence)e.getString(subField)) ? "" : e.getString(subField), Collectors.counting()));
        long blankCountValue = emptyCount.longValue();
        if (blankCountValue > 0L) {
            nameCount.put("", blankCountValue);
        }
        return nameCount;
    }
}

