/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PictureStatHelper {
    private PictureStatHelper() {
    }

    public static void handle(List<Map<String, Object>> details, String formNumber, String fieldName, QFilter[] filters) {
        List<String> imageNames = PictureStatHelper.getImageNames(formNumber, fieldName, filters);
        int total = imageNames.size();
        Map<String, Long> name2CountMap = imageNames.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        Set<Map.Entry<String, Long>> entries = name2CountMap.entrySet();
        for (Map.Entry<String, Long> entry : entries) {
            String name = entry.getKey();
            int count = Math.toIntExact(name2CountMap.get(name));
            String percentage = StatMapUtils.getPercentage(count, total);
            details.add(StatMapUtils.getGroupMap(name, name, percentage, count));
        }
    }

    public static void handle(Map<String, Object> statMap, String formNumber, String fieldName, QFilter[] filters, String fieldValue) {
        List<String> imageNames = PictureStatHelper.getImageNames(formNumber, fieldName, filters);
        int total = imageNames.size();
        long count = imageNames.stream().filter(name -> Objects.equals(name, fieldValue)).count();
        String percentage = StatMapUtils.getPercentage((int)count, total);
        statMap.put(ReportTypeEnum.GROUP.getCode(), StatMapUtils.getGroupMap(fieldValue, fieldValue, percentage, (int)count));
    }

    private static List<String> getImageNames(String formNumber, String fieldName, QFilter[] filters) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)formNumber, (String)fieldName, (QFilter[])filters, (String)"", (int)100000);
        ArrayList<String> imageNames = new ArrayList<String>(dataList.size());
        for (DynamicObject data : dataList) {
            String imgStr = data.getString(fieldName);
            if (StringUtils.isBlank((CharSequence)imgStr)) {
                imageNames.add("");
                continue;
            }
            List images = SerializationUtils.fromJsonStringToList((String)imgStr, Map.class);
            if (CollectionUtils.isEmpty((Collection)images)) {
                imageNames.add("");
                continue;
            }
            for (Map image : images) {
                String name = (String)image.get("name");
                imageNames.add(name);
            }
        }
        return imageNames;
    }

    public static void handleSummary(Map<String, Object> statMap, String formNumber, String fieldName, QFilter[] filters) {
        List<String> imageNames = PictureStatHelper.getImageNames(formNumber, fieldName, filters);
        int total = imageNames.size();
        Map<String, Long> name2CountMap = imageNames.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        int keySize = name2CountMap.size();
        Map<String, Map<String, Object>> summaryMap = StatMapUtils.getSummaryMap(keySize, total);
        statMap.putAll(summaryMap);
    }
}

