/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics.handler;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RefBillPropStatHelper {
    private static final String DELIMITER = "$delimiter$";
    private static final String FIELD_VALUE_AND_NAME_DELIMITER = "$field_value_and_name_delimiter$";

    private RefBillPropStatHelper() {
    }

    public static void handle(List<Map<String, Object>> details, String formNumber, String fieldName, QFilter[] filters, String originName) {
        DynamicObjectCollection sourceObjs = QueryServiceHelper.query((String)formNumber, (String)fieldName, (QFilter[])filters, (String)"", (int)100000);
        INoCodeRefBillProp fieldProp = (INoCodeRefBillProp)NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formNumber), (String)fieldName);
        ArrayList<Object> refPkIdAndNameList = new ArrayList<Object>(50);
        HashMap<String, String> dictId2RefInfo = new HashMap<String, String>(10);
        for (DynamicObject srcObj : sourceObjs) {
            String refBillIds = srcObj.getString(fieldName);
            if (dictId2RefInfo.containsKey(refBillIds)) {
                refPkIdAndNameList.add(dictId2RefInfo.get(refBillIds));
                continue;
            }
            String refPkIdAndName = RefBillPropStatHelper.getRefPkIdAndName(refBillIds, fieldProp, originName);
            dictId2RefInfo.put(refBillIds, refPkIdAndName);
            refPkIdAndNameList.add(refPkIdAndName);
        }
        int total = refPkIdAndNameList.size();
        Map<String, Long> refPkIdAndName2CountMap = refPkIdAndNameList.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        Set<Map.Entry<String, Long>> entries = refPkIdAndName2CountMap.entrySet();
        for (Map.Entry<String, Long> entry : entries) {
            String refPkIdAndName = entry.getKey();
            int count = Math.toIntExact(refPkIdAndName2CountMap.get(refPkIdAndName));
            String percentage = StatMapUtils.getPercentage(count, total);
            if (StringUtils.isBlank((CharSequence)refPkIdAndName)) {
                details.add(StatMapUtils.getGroupMap(refPkIdAndName, refPkIdAndName, percentage, count));
                continue;
            }
            details.add(StatMapUtils.getGroupMap(RefBillPropStatHelper.getName(refPkIdAndName), RefBillPropStatHelper.getRefPkId(refPkIdAndName), percentage, count));
        }
    }

    private static String getRefPkIdAndName(String refBillIds, INoCodeRefBillProp prop, String originName) {
        if (StringUtils.isBlank((CharSequence)refBillIds) || "0".equalsIgnoreCase(refBillIds)) {
            return "";
        }
        String refBillId = prop.getBillEntityId();
        String mainPropKey = prop.getMainDisplayProperty();
        if (StringUtils.isEmpty((CharSequence)mainPropKey)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (String)"RefBillPropStatHelper_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        MainEntityType refBillType = null;
        try {
            refBillType = EntityMetadataCache.getDataEntityTypeById((String)refBillId);
        }
        catch (Exception e2) {
            refBillType = EntityMetadataCache.getDataEntityType((String)refBillId);
        }
        IDataEntityProperty mainProp = NcEntityTypeUtil.findProperty((DynamicObjectType)refBillType, (String)mainPropKey);
        String selectField = "id," + mainPropKey;
        if (StringUtils.isNotBlank((CharSequence)originName)) {
            selectField = "id," + originName;
            mainProp = NcEntityTypeUtil.findProperty((DynamicObjectType)refBillType, (String)originName);
        }
        IDataEntityProperty displayProp = mainProp;
        DynamicObject[] refObjs = prop.loadRefBillObjects(refBillIds, selectField);
        return Arrays.stream(refObjs).map(e -> {
            PropertyHandle propertyHandle = PropertyHandleFactory.getPropertyHandle((String)"$", (IDataEntityProperty)displayProp);
            String name = propertyHandle.formatStringValue(e);
            return e.getLong("id") + FIELD_VALUE_AND_NAME_DELIMITER + name;
        }).collect(Collectors.joining(DELIMITER));
    }

    private static String getName(String refPkIdAndName) {
        return Splitter.on((String)DELIMITER).splitToStream((CharSequence)refPkIdAndName).map(e -> {
            int i = e.indexOf(FIELD_VALUE_AND_NAME_DELIMITER);
            return e.substring(i + FIELD_VALUE_AND_NAME_DELIMITER.length());
        }).collect(Collectors.joining(","));
    }

    private static String getRefPkId(String refPkIdAndName) {
        return Splitter.on((String)DELIMITER).splitToStream((CharSequence)refPkIdAndName).map(e -> {
            int i = e.indexOf(FIELD_VALUE_AND_NAME_DELIMITER);
            return e.substring(0, i);
        }).collect(Collectors.joining(","));
    }
}

