/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics.handler;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.nocode.restapi.service.statistics.AbstractFieldStatisticHandler;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.dto.GroupInfo;
import kd.bos.nocode.restapi.service.statistics.handler.AttachmentStatHelper;
import kd.bos.nocode.restapi.service.statistics.handler.PictureStatHelper;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.ArrayUtils;

public class SpecialFieldValueGroupStatHandler
extends AbstractFieldStatisticHandler {
    public static final String SPECIAL_FIELD_VALUE_STAT_HANDLER = "SpecialFieldValueStatHandler";

    @Override
    public Map<String, Object> handle(String formId, String fieldName, QFilter[] filters, String fieldValue) {
        HashMap<String, Object> statMap = new HashMap<String, Object>(1);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dataEntityType, (String)fieldName);
        GroupInfo groupInfo = StatMapUtils.getGroupInfo(property, fieldValue);
        String label = groupInfo.getLabel();
        String groupValue = groupInfo.getValue();
        if (property instanceof AttachmentProp) {
            AttachmentStatHelper.handle(statMap, formId, fieldName, filters, fieldValue);
            return statMap;
        }
        if (property instanceof PictureProp) {
            PictureStatHelper.handle(statMap, formId, fieldName, filters, fieldValue);
            return statMap;
        }
        int total = ORM.create().count(SPECIAL_FIELD_VALUE_STAT_HANDLER, formId, "id", filters, null, 100000);
        if (total == 0) {
            statMap.put(ReportTypeEnum.GROUP.getCode(), StatMapUtils.getGroupMap(label, groupValue, "0", 0));
            return statMap;
        }
        ArrayList<QFilter> filterList = ArrayUtils.isEmpty((Object[])filters) ? new ArrayList<QFilter>(1) : Lists.newArrayList((Object[])filters);
        this.addFieldValueFilter(fieldName, fieldValue, property, filterList);
        int fieldCount = ORM.create().count(SPECIAL_FIELD_VALUE_STAT_HANDLER, formId, "id", filterList.toArray(new QFilter[0]), null, 100000);
        String percentage = StatMapUtils.getPercentage(fieldCount, total);
        statMap.put(ReportTypeEnum.GROUP.getCode(), StatMapUtils.getGroupMap(label, groupValue, percentage, fieldCount));
        return statMap;
    }

    private void addFieldValueFilter(String fieldName, String fieldValue, IDataEntityProperty property, List<QFilter> filterList) {
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            filterList.add(QFilter.emptyOrNotExists((String)fieldName));
        } else if (property instanceof DecimalProp) {
            filterList.add(new QFilter(fieldName, "=", (Object)new BigDecimal(fieldValue)));
        } else if (property instanceof DateTimeProp) {
            Date date = DateTimeUtils.parseDate((String)fieldValue);
            if (DateTimeUtils.isShortDate((String)fieldValue)) {
                filterList.addAll(DateTimeUtils.getDateRangeQFilter((String)fieldName, (Date)date));
            } else {
                filterList.add(new QFilter(fieldName, "=", (Object)date));
            }
        } else if (StatMapUtils.isFilled(property) && Objects.equals(fieldValue, "FILLED")) {
            filterList.add(QFilter.exists((String)fieldName));
        } else if (property instanceof RefBillProp) {
            filterList.add(new QFilter(fieldName, "=", (Object)Long.parseLong(fieldValue)));
        } else {
            filterList.add(new QFilter(fieldName, "=", (Object)fieldValue));
        }
    }
}

