/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.statistics.handler;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.nocode.restapi.service.statistics.AbstractFieldStatisticHandler;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandlerRegistry;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsService;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.constant.StatPanelTypeEnum;
import kd.bos.nocode.restapi.service.statistics.handler.AttachmentStatHelper;
import kd.bos.nocode.restapi.service.statistics.handler.GroupStatHandler;
import kd.bos.nocode.restapi.service.statistics.handler.PictureStatHelper;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SummaryStatHandler
extends AbstractFieldStatisticHandler {
    public static final String SUMMARY_STAT_HANDLER = "SummaryStatHandler";
    public static final String GROUP_FIELD = "groupfield";

    @Override
    public Map<String, Object> handle(String formId, String fieldName, QFilter[] filters, String fieldValue) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dataEntityType, (String)fieldName);
        HashMap<String, Object> statMap = new HashMap<String, Object>(1);
        if (property instanceof PictureProp) {
            PictureStatHelper.handleSummary(statMap, formId, fieldName, filters);
            return statMap;
        }
        if (property instanceof AttachmentProp) {
            AttachmentStatHelper.handleSummary(statMap, formId, fieldName, filters);
            return statMap;
        }
        StatPanelTypeEnum panelType = FieldStatisticsService.getStatPanelType(property);
        if (panelType == StatPanelTypeEnum.TOTAL) {
            return FieldStatisticsHandlerRegistry.getHandler(ReportTypeEnum.TOTAL).handle(formId, fieldName, filters, fieldValue);
        }
        if (panelType == StatPanelTypeEnum.FILLED) {
            return FieldStatisticsHandlerRegistry.getHandler(ReportTypeEnum.IS_FILLED).handle(formId, fieldName, filters, fieldValue);
        }
        int total = ORM.create().count(SUMMARY_STAT_HANDLER, formId, fieldName, filters, null, 100000);
        int distinct = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)SUMMARY_STAT_HANDLER, (String)formId, (String)fieldName, (QFilter[])filters, (String)fieldName, (int)100000);
             DataSet finishDataSet = dataSet.select(GroupStatHandler.formatDateField(property, fieldName)).groupBy(new String[]{GROUP_FIELD}).finish();){
            if (finishDataSet.hasNext()) {
                for (Row row : finishDataSet) {
                    ++distinct;
                }
            }
        }
        Map<String, Map<String, Object>> summaryMap = StatMapUtils.getSummaryMap(distinct, total);
        statMap.putAll(summaryMap);
        return statMap;
    }
}

