/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DirectRestApiService;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.NoCodePermHelper;

public class AppExportServiceImpl
implements DirectRestApiService {
    private static final String REGEX = "/app_export";
    private static final Log log = LogFactory.getLog(AppExportServiceImpl.class);
    private static final Pattern PATTERN = Pattern.compile("/app_export");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public void execute(RestApiParam<?> param) {
        this.exportApp(param);
    }

    private void exportApp(RestApiParam<?> param) {
        String id = param.getRequest().getHttpQueryString().getOrDefault("appId", "");
        String withData = param.getRequest().getHttpQueryString().getOrDefault("withData", "true");
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new RestApiException(ResManager.loadKDString((String)"appId \u4e0d\u80fd\u4e3a\u7a7a", (String)"AppExportServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        if (!NoCodeTemplateUtil.queryTemplateAppIds().contains(id)) {
            NoCodePermHelper.verifyManage((String)id);
        }
        try {
            AppServiceHelper.exportAppToZip(id, Boolean.parseBoolean(withData));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), new Object[]{e});
        }
    }
}

