/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.nocode.restapi.api.AttachmentRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiAttachmentParam;
import kd.bos.nocode.restapi.api.result.RestApiAttachmentResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.AttachmentAction;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.util.AttachExceptionHandler;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.servicehelper.FileRecord;
import kd.bos.servicehelper.util.FileRecordUtil;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.bos.web.actions.utils.FileTypeUtil;
import kd.bos.web.actions.utils.FileUploadUrlUtil;

public class AttachmentRestApiServiceImpl
implements AttachmentRestApiService {
    private static final Log log = LogFactory.getLog(AttachmentRestApiServiceImpl.class);
    public static final String DEFAULT_ROOT_PATH = "/";
    public static final int UPLOAD_FILE_TIMEOUT = 7200;
    public static final int FILENAME_SPLIT_LENGTH = 2;
    public static final int FORBIDDEN_FILE_TYPE_LIST_SIZE = 10;
    public static final int FILE_FACTOR = 0x100000;
    public static final String FMT_IMAGE = "/%s/%s/%s/nocode/%s/%s";

    public RestApiServiceData<RestApiAttachmentResult> execute(RestApiAttachmentParam param) {
        if (AttachmentAction.UPLOAD.getCode().equalsIgnoreCase(param.getAction())) {
            FileItem fileItem = new FileItem(param.getFilename(), param.getFilename(), (InputStream)new ByteArrayInputStream(param.getFileData()));
            if (!param.isTempStorage() && !FileUploadUrlUtil.isFileUploadWithUrl()) {
                fileItem.setPath(FileUploadUrlUtil.getAttachmentRandomUrl((String)fileItem.getFileName()));
            }
            return this.upload(fileItem, param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u9644\u4ef6\u64cd\u4f5c", (String)"AttachmentRestApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    /*
     * Exception decompiling
     */
    private RestApiServiceData<RestApiAttachmentResult> upload(FileItem fileItem, RestApiAttachmentParam param) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doSave(FileItem fileItem, RestApiAttachmentParam param, RestApiResponse<RestApiAttachmentResult> response, String fileName, BufferedInputStream bis) {
        try {
            String url = param.isTempStorage() ? this.saveTempFile(fileItem, bis) : this.saveFile(fileItem, bis);
            ((RestApiAttachmentResult)response.getData()).setFilename(fileName);
            ((RestApiAttachmentResult)response.getData()).setUrl(url);
            FileRecord fileRecord = new FileRecord();
            fileRecord.setUrl(url);
            fileRecord.setType("1");
            fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
            fileRecord.setCreateTime(DateTimeUtils.getNow());
            FileRecordUtil.doLog(Collections.singletonList(fileRecord));
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                AttachExceptionHandler.dealException((KDException)((Object)e));
            }
            log.debug(e.getMessage(), (Object)e);
            throw new RestApiException(e.getMessage());
        }
        finally {
            fileItem.close();
        }
    }

    private String saveFile(FileItem fileItem, BufferedInputStream bis) throws IOException {
        int size = bis.available();
        String path = this.getNewFilePath(fileItem.getPath(), fileItem.getFileName());
        try {
            path = FilePathUtil.dealPath((String)path, (String)"attach");
        }
        catch (KDException e) {
            AttachExceptionHandler.dealException(e);
        }
        fileItem = new FileItem(fileItem.getFileName(), path, (InputStream)bis);
        if (path.contains("+")) {
            path = path.replace('+', '_');
            fileItem = new FileItem(fileItem.getFileName(), path, (InputStream)bis);
        }
        log.debug("before FileService.upload InputStream.available() " + size);
        log.debug("fileservice.ext.impl.classname is " + System.getProperty("fileservice.ext.impl.classname"));
        log.debug("check.file.security is " + System.getProperty("check.file.security", "false"));
        return AttachmentRestApiServiceImpl.getFileService().upload(fileItem);
    }

    private String saveTempFile(FileItem fileItem, BufferedInputStream bis) throws IOException {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        log.debug("before cache.saveAsUrl InputStream.available() " + bis.available());
        log.debug("TempFileExtension.impl.classname is " + System.getProperty("TempFileExtension.impl.classname", ""));
        log.debug("check.file.security is " + System.getProperty("check.file.security", "false"));
        int timeout = 7200;
        String tempUrl = cache.saveAsUrl(fileItem.getFileName(), (InputStream)bis, timeout);
        String address = RequestContext.get().getClientFullContextPath();
        if (!address.endsWith(DEFAULT_ROOT_PATH)) {
            address = address + DEFAULT_ROOT_PATH;
        }
        tempUrl = address + tempUrl;
        return tempUrl;
    }

    private void assertNotForbidden(String fileName, BufferedInputStream bis) throws IOException {
        this.assertFileTypeValid(fileName);
        String[] splits = fileName.trim().split("\\.");
        if (splits.length < 2) {
            return;
        }
        if ("errorfile.errorfile".equals(fileName = FileTypeUtil.getFileRealName((String)fileName, (BufferedInputStream)bis))) {
            throw new RestApiException(ResManager.loadKDString((String)"\u7981\u6b62\u4e0a\u4f20\u975e\u6cd5\u6587\u4ef6", (String)"AttachmentRestApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        this.assertFileTypeValid(fileName);
    }

    private void assertFileTypeValid(String fileName) {
        String[] splits;
        List forbiddenFileTypeList = new ArrayList(10);
        ArrayList whiteTypeList = new ArrayList();
        Object setting = DispatchServiceHelper.invokeBOSService((String)"IAttachmentService", (String)"getAttSetting", (Object[])new Object[0]);
        if (setting instanceof Map) {
            forbiddenFileTypeList = (List)((Map)setting).get("forbidfiletype");
            List list = whiteTypeList = ((Map)setting).get("whitelist") != null ? (List)((Map)setting).get("whitelist") : new ArrayList();
        }
        if ((splits = fileName.trim().split("\\.")).length < 2) {
            return;
        }
        String fileType = splits[splits.length - 1];
        long occurCounts = forbiddenFileTypeList.stream().filter(s -> s.equalsIgnoreCase(fileType)).count();
        boolean enableUpload = false;
        if (occurCounts == 0L) {
            enableUpload = whiteTypeList.isEmpty() ? true : whiteTypeList.stream().anyMatch(s -> s.equalsIgnoreCase(fileType));
        }
        if (enableUpload) {
            return;
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u6587\u4ef6\u7c7b\u578b\uff1a", (String)"AttachmentRestApiServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]) + fileType + "");
    }

    public static long getMaxSize() {
        Object sizeMb = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"maxuploadsize"});
        if (sizeMb != null && !"0".equals(sizeMb.toString())) {
            long size = Long.parseLong(String.valueOf(sizeMb));
            return Math.min(size * 0x100000L, AttachmentRestApiServiceImpl.getFileService().maxUploadSize());
        }
        return AttachmentRestApiServiceImpl.getFileService().maxUploadSize();
    }

    protected static FileService getFileService() {
        return FileServiceFactory.getAttachmentFileService();
    }

    private String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        String isEncrptyPathMethodName = "isEncrptyPath";
        String attachServiceName = IAttachmentService.class.getSimpleName();
        Object isEncrptyPath = DispatchServiceHelper.invokeBOSService((String)attachServiceName, (String)isEncrptyPathMethodName, (Object[])new Object[0]);
        boolean encrptyPath = Boolean.parseBoolean(String.valueOf(isEncrptyPath));
        if (oldPath == null || !oldPath.contains(DEFAULT_ROOT_PATH)) {
            selfPath = this.generateAttPath(fileName);
        }
        if (!encrptyPath) {
            return selfPath;
        }
        return this.generateAttPath(fileName);
    }

    private String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", DEFAULT_ROOT_PATH);
        if (!rootPath.startsWith(DEFAULT_ROOT_PATH)) {
            rootPath = DEFAULT_ROOT_PATH + rootPath;
        }
        if (rootPath.endsWith(DEFAULT_ROOT_PATH)) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + String.format(FMT_IMAGE, rc.getTenantCode(), rc.getAccountId(), AttachmentRestApiServiceImpl.getMonthStr(), uuid, fileName);
    }

    static String getMonthStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        String monthStr = sf.format(cale.getTime());
        return monthStr;
    }

    private long getModelTimeCost(long startTime) {
        return System.currentTimeMillis() - startTime;
    }
}

