/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaService;
import kd.bos.nocode.restapi.service.sys.CardServiceImpl;
import kd.bos.nocode.restapi.service.util.CardRefHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CardContainerServiceImpl {
    public static final long SYSTEM_USER_ID = 0L;
    public static final String ACTIVE = "active";
    public static final String USER_ID = "userid";
    public static final String SCHEMA_ID = "schemaid";
    public static final String ID = "id";
    public static final String CARD_ID = "cardid";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String W = "w";
    public static final String H = "h";
    public static final String I = "i";
    public static final String NAME = "name";
    public static final String SELECT_PROPERTIES = "cardid,x,y,w,h";
    public static final String LAYOUT = "layout";
    public static final String CARD_INFO = "cardInfo";
    protected static final ExecutorService ES = ThreadPools.newCachedExecutorService((String)"NoCode-CardSchemaService-Thread", (int)3, (int)6);
    private static final CardSchemaService CARD_SCHEMA_SERVICE = CardSchemaService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            CardContainerSaveService saveService = new CardContainerSaveService();
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            CardContainerQueryService queryService = new CardContainerQueryService();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            CardContainerDeleteService deleteService = new CardContainerDeleteService();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"CardContainerServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class CardContainerDeleteService
    implements DeleteRestApiService {
        static final String ID = "id";

        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            QFilter schemaIdFilter;
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CardContainerServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            long userId = RequestContext.get().getCurrUserId();
            boolean page = ((Map)param.getRequest().getData()).containsKey("pageId");
            long schemaId = 0L;
            if (page) {
                String pageId = (String)((Map)param.getRequest().getData()).get("pageId");
                String appid = FormMetaUtil.getAppIdByFormId((String)pageId);
                NoCodePermHelper.verifyManage((String)appid);
                schemaIdFilter = new QFilter("pageid", "=", (Object)Long.parseLong(pageId));
            } else {
                schemaId = CARD_SCHEMA_SERVICE.getActiveSchemaId(userId);
                if (schemaId < 0L) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u9009\u4e2d\u7684\u89c6\u56fe", (String)"CardContainerServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                if (!CARD_SCHEMA_SERVICE.canEdit(userId, schemaId)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u7f16\u8f91\u6b64\u89c6\u56fe\u4e2d\u7684\u5361\u7247", (String)"CardContainerServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                schemaIdFilter = new QFilter(CardContainerServiceImpl.SCHEMA_ID, "=", (Object)schemaId);
            }
            ArrayList filterList = Lists.newArrayList((Object[])filters);
            filterList.add(schemaIdFilter);
            filters = filterList.toArray(new QFilter[0]);
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"CardContainerServiceImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"CardContainerServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[]{Integer.MAX_VALUE}));
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            for (Object pkId : pkIds) {
                QFilter qFilter = new QFilter("id", "=", pkId);
                DynamicObject delObj = BusinessDataServiceHelper.loadSingle(pkId, (String)"bos_nocode_cardcontainer");
                long cardId = delObj.getLong(CardContainerServiceImpl.CARD_ID);
                int type = delObj.getInt("type");
                if (type == 1 && !page) {
                    throw new RestApiException(ResManager.loadKDString((String)"pageId\u4e0d\u80fd\u4e3a\u7a7a", (String)"CardContainerServiceImpl_9", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DeleteServiceHelper.delete((String)"bos_nocode_cardcontainer", (QFilter[])new QFilter[]{qFilter});
                        if (page) {
                            DeleteServiceHelper.delete((String)"bos_nocode_card", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cardId)});
                        } else {
                            CardRefHelper.deleteStartPageRef(userId, schemaId, cardId);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw new RestApiException(ResManager.loadKDString((String)"\u79fb\u9664\u5361\u7247\u5931\u8d25", (String)"CardContainerServiceImpl_10", (String)"bos-nocode-service", (Object[])new Object[0]), (Throwable)e);
                    }
                }
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                data.setId(String.valueOf(cardId));
                data.setBillStatus(true);
                resultsData.add(data);
            }
            long endTime = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(endTime - start));
        }
    }

    public static class CardContainerQueryService
    implements QueryRestApiService {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            QFilter filter;
            long startTime = System.currentTimeMillis();
            boolean page = param.getRequest().getHttpQueryString().containsKey("pageId");
            if (page) {
                String pageId = (String)param.getRequest().getHttpQueryString().get("pageId");
                if (!StringUtils.isNotEmpty((String)pageId)) throw new RestApiException(ResManager.loadKDString((String)"page id \u4e0d\u80fd\u4e3a\u7a7a", (String)"CardContainerServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
                if (!NcEntityTypeUtil.queryTemplateAppIds().contains(FormMetaUtil.getAppIdByFormId((String)pageId))) {
                    NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)pageId);
                }
                filter = new QFilter("pageId", "=", (Object)Long.parseLong(pageId));
            } else {
                String schemaIdStr = (String)param.getRequest().getHttpQueryString().get("schemaId");
                long schemaId = Long.parseLong(schemaIdStr);
                this.activateSchema(schemaId);
                filter = new QFilter(CardContainerServiceImpl.SCHEMA_ID, "=", (Object)schemaId);
            }
            HashSet selectSet = Sets.newHashSet((Object[])new String[]{CardContainerServiceImpl.CARD_ID, CardContainerServiceImpl.X, CardContainerServiceImpl.Y, CardContainerServiceImpl.W, CardContainerServiceImpl.H});
            String selectProperties = String.join((CharSequence)",", selectSet);
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)selectProperties, (QFilter[])filter.toArray());
            List layout = PropertyHandleUtil.toMapListRoot((String)"bos_nocode_cardcontainer", (String)"$", (DynamicObject[])rows, (Set)selectSet);
            CardContainerQueryService.formatFields(layout);
            Object[] cardIds = layout.stream().map(e -> e.get(CardContainerServiceImpl.I)).toArray();
            List<Map<String, Object>> cardInfos = new CardServiceImpl.CardServiceQueryImpl().getCardInfo(cardIds, param, page);
            if (cardInfos.size() != layout.size()) {
                List existIds = cardInfos.stream().map(e -> e.get(CardContainerServiceImpl.ID)).collect(Collectors.toList());
                layout.removeIf(e -> !existIds.contains(e.get(CardContainerServiceImpl.I)));
            }
            Map id2CardInfo = cardInfos.stream().collect(Collectors.toMap(e -> e.get(CardContainerServiceImpl.ID), Function.identity()));
            layout.forEach(e -> this.populateSizeInfo(id2CardInfo, (Map<String, Object>)e));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put(CardContainerServiceImpl.LAYOUT, layout);
            resultMap.put(CardContainerServiceImpl.CARD_INFO, cardInfos);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }

        private void populateSizeInfo(Map<Object, Map<String, Object>> id2CardInfo, Map<String, Object> e) {
            Map<String, Object> cardInfo = id2CardInfo.get(e.get(CardContainerServiceImpl.I));
            if (Objects.nonNull(cardInfo)) {
                String type = (String)cardInfo.get("type");
                CardTypeEnum cardTypeEnum = CardTypeEnum.valueOf(type);
                e.put("minW", cardTypeEnum.getMinW());
                e.put("maxW", cardTypeEnum.getMaxW());
                e.put("minH", cardTypeEnum.getMinH());
            }
        }

        @NotNull
        private RestApiServiceData<RestApiQueryResult> getEmptyCardList(long startTime) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put(CardContainerServiceImpl.LAYOUT, new ArrayList(0));
            resultMap.put(CardContainerServiceImpl.CARD_INFO, new ArrayList(0));
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }

        private void activateSchema(long schemaId) {
            CompletableFuture.runAsync(() -> CARD_SCHEMA_SERVICE.activate(RequestContext.get().getCurrUserId(), schemaId), ES);
        }

        private static void formatFields(List<Map<String, Object>> layout) {
            layout.forEach(CardContainerQueryService::formatField);
        }

        private static Map<String, Object> formatField(Map<String, Object> e) {
            e.put(CardContainerServiceImpl.I, e.remove(CardContainerServiceImpl.CARD_ID));
            e.remove(CardContainerServiceImpl.ID);
            return e;
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(Map<String, Object> resultMap) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows((List)Lists.newArrayList((Object[])new Map[]{resultMap}));
            return response;
        }
    }

    public static class CardContainerSaveService
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            List dataList = param.getDataList();
            List<RestApiSaveItemData> saveItemDataList = dataList.stream().flatMap(data -> this.doSave((Map<String, Object>)data).stream()).collect(Collectors.toList());
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private List<RestApiSaveItemData> doSave(Map<String, Object> data) {
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                if (data.containsKey("pageId")) {
                    List<RestApiSaveItemData> list = this.savePageContainer(data);
                    return list;
                }
                List<RestApiSaveItemData> list = this.saveSchemaContainer(data);
                return list;
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    throw new RestApiException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5361\u7247\u5bb9\u5668\u5931\u8d25", (String)"CardContainerServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]), (Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        private List<RestApiSaveItemData> savePageContainer(Map<String, Object> data) {
            List layout = (List)data.get(CardContainerServiceImpl.LAYOUT);
            String pageId = (String)data.get("pageId");
            String appId = FormMetaUtil.getAppIdByFormId((String)pageId);
            NoCodePermHelper.verifyManage((String)appId);
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(layout.size());
            for (Map item : layout) {
                QFilter cardIdFilter;
                String cardId = (String)item.get(CardContainerServiceImpl.I);
                QFilter filter = new QFilter("pageid", "=", (Object)Long.parseLong(pageId));
                QFilter[] qFilters = new QFilter[]{filter, cardIdFilter = new QFilter(CardContainerServiceImpl.CARD_ID, "=", (Object)Long.parseLong(cardId))};
                DynamicObject saveObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_cardcontainer", (String)CardContainerServiceImpl.SELECT_PROPERTIES, (QFilter[])qFilters);
                boolean isAdd = Objects.isNull(saveObj);
                if (isAdd) {
                    if (!CardServiceImpl.CardServiceQueryImpl.existCard(cardId)) {
                        saveItemDataList.add(this.invalidCardId(cardId));
                        continue;
                    }
                    saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcontainer");
                    saveObj.set(CardContainerServiceImpl.CARD_ID, (Object)cardId);
                    saveObj.set("pageId", (Object)pageId);
                }
                saveObj.set(CardContainerServiceImpl.X, item.get(CardContainerServiceImpl.X));
                saveObj.set(CardContainerServiceImpl.Y, item.get(CardContainerServiceImpl.Y));
                saveObj.set(CardContainerServiceImpl.W, item.get(CardContainerServiceImpl.W));
                saveObj.set(CardContainerServiceImpl.H, item.get(CardContainerServiceImpl.H));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveObj});
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(cardId);
                apiSaveData.setBillStatus(true);
                apiSaveData.setType(isAdd ? "Add" : "Update");
                saveItemDataList.add(apiSaveData);
            }
            return saveItemDataList;
        }

        private List<RestApiSaveItemData> saveSchemaContainer(Map<String, Object> data) {
            List layout = (List)data.get(CardContainerServiceImpl.LAYOUT);
            long currUserId = RequestContext.get().getCurrUserId();
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(layout.size());
            long schemaId = CARD_SCHEMA_SERVICE.getActiveSchemaId(currUserId);
            for (Map item : layout) {
                QFilter cardIdFilter;
                String cardId = (String)item.get(CardContainerServiceImpl.I);
                QFilter schemaIdFilter = new QFilter(CardContainerServiceImpl.SCHEMA_ID, "=", (Object)schemaId);
                QFilter[] qFilters = new QFilter[]{schemaIdFilter, cardIdFilter = new QFilter(CardContainerServiceImpl.CARD_ID, "=", (Object)Long.parseLong(cardId))};
                DynamicObject saveObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_cardcontainer", (String)CardContainerServiceImpl.SELECT_PROPERTIES, (QFilter[])qFilters);
                boolean isAdd = Objects.isNull(saveObj);
                if (isAdd) {
                    if (!CardServiceImpl.CardServiceQueryImpl.existCard(cardId)) {
                        saveItemDataList.add(this.invalidCardId(cardId));
                        continue;
                    }
                    saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcontainer");
                    saveObj.set(CardContainerServiceImpl.CARD_ID, (Object)cardId);
                    saveObj.set(CardContainerServiceImpl.SCHEMA_ID, (Object)schemaId);
                }
                saveObj.set(CardContainerServiceImpl.X, item.get(CardContainerServiceImpl.X));
                saveObj.set(CardContainerServiceImpl.Y, item.get(CardContainerServiceImpl.Y));
                saveObj.set(CardContainerServiceImpl.W, item.get(CardContainerServiceImpl.W));
                saveObj.set(CardContainerServiceImpl.H, item.get(CardContainerServiceImpl.H));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveObj});
                if (isAdd) {
                    CardRefHelper.saveStartPageRef(currUserId, schemaId, Long.parseLong(cardId));
                }
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(cardId);
                apiSaveData.setBillStatus(true);
                apiSaveData.setType(isAdd ? "Add" : "Update");
                saveItemDataList.add(apiSaveData);
            }
            return saveItemDataList;
        }

        private void closeOtherSchema(long currUserId) {
            QFilter userIdFilter = new QFilter(CardContainerServiceImpl.USER_ID, "=", (Object)currUserId);
            DynamicObject[] activeObjs = BusinessDataServiceHelper.load((String)"bos_nocode_cardschema", (String)CardContainerServiceImpl.ACTIVE, (QFilter[])userIdFilter.toArray());
            Arrays.stream(activeObjs).forEach(e -> e.set(CardContainerServiceImpl.ACTIVE, (Object)false));
            SaveServiceHelper.update((DynamicObject[])activeObjs);
        }

        private RestApiSaveItemData invalidCardId(String cardId) {
            RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
            HashSet<String> msg = new HashSet<String>(1);
            msg.add(ResManager.loadKDString((String)"\u5361\u7247ID\u65e0\u6548", (String)"CardContainerServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            errorData.setRowMsg(msg);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setId(cardId);
            apiSaveData.setBillStatus(false);
            apiSaveData.setType("Add");
            apiSaveData.getErrors().add(errorData);
            return apiSaveData;
        }

        private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
            RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
        }
    }
}

