/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.jetbrains.annotations.NotNull;

public class CardSchemaApiServiceImpl {
    private static final Log log = LogFactory.getLog(CardSchemaApiServiceImpl.class);
    public static final String ID = "id";
    private final CardSchemaService cardSchemaService = CardSchemaService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            CardSchemaSaveApiServiceImpl saveService = new CardSchemaSaveApiServiceImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            CardSchemaQueryApiServiceImpl queryService = new CardSchemaQueryApiServiceImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            CardSchemaDeleteApiServiceImpl deleteService = new CardSchemaDeleteApiServiceImpl();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"CardSchemaApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public class CardSchemaDeleteApiServiceImpl
    implements DeleteRestApiService {
        public static final String CREATER = "creater";

        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CardSchemaApiServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"CardSchemaApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s\uff0c\u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"CardSchemaApiServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[]{Integer.MAX_VALUE}));
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            for (Object pkId : pkIds) {
                long creatorId;
                DynamicObject deleteObj = BusinessDataServiceHelper.loadSingle(pkId, (String)"bos_nocode_cardschema");
                long currUserId = RequestContext.get().getCurrUserId();
                if (currUserId != (creatorId = deleteObj.getDynamicObject(CREATER).getLong(CardSchemaApiServiceImpl.ID))) {
                    this.addNotCreatorError(resultsData, pkId);
                    continue;
                }
                CardSchemaApiServiceImpl.this.cardSchemaService.deleteCardSchema((Long)pkId);
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                data.setId(String.valueOf(pkId));
                data.setBillStatus(true);
                resultsData.add(data);
            }
            long endTime = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(endTime - start));
        }

        private void addNotCreatorError(List<RestBaseFilterItemData> resultsData, Object cardId) {
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            data.setId(String.valueOf(cardId));
            data.setBillStatus(false);
            data.getErrors().add(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u521b\u5efa\u4eba\u5220\u9664\u8be5\u89c6\u56fe", (String)"CardSchemaApiServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]));
            resultsData.add(data);
        }
    }

    public class CardSchemaQueryApiServiceImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            long userId = RequestContext.get().getCurrUserId();
            List<Map<String, Object>> rows = CardSchemaApiServiceImpl.this.cardSchemaService.getCardSchemas(userId);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(rows), (long)startTime, (long)endTime);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            return response;
        }
    }

    public class CardSchemaSaveApiServiceImpl
    implements SaveRestApiService {
        public static final String OP_UPDATE = "update";
        public static final String OP_COPY = "copy";
        public static final String OP_ADD = "add";
        public static final String COPY_SCHEMA_ID = "copySchemaId";

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map dataItem : dataList) {
                DynamicObject schemaObj;
                String saveType = this.getSaveType(dataItem);
                try {
                    switch (saveType) {
                        case "add": {
                            schemaObj = CardSchemaApiServiceImpl.this.cardSchemaService.addCardSchema(dataItem);
                            break;
                        }
                        case "update": {
                            schemaObj = CardSchemaApiServiceImpl.this.cardSchemaService.updateCardSchema(dataItem);
                            break;
                        }
                        case "copy": {
                            schemaObj = CardSchemaApiServiceImpl.this.cardSchemaService.copyCardSchema(dataItem);
                            break;
                        }
                        default: {
                            throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff1a%s", (String)"CardSchemaApiServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[]{SerializationUtils.toJsonString((Object)dataItem)}));
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("\u4fdd\u5b58\u5361\u7247\u89c6\u56fe\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                    RestApiSaveItemData apiSaveData = this.getErrorSaveItemData(dataItem, e);
                    saveItemDataList.add(apiSaveData);
                    continue;
                }
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(String.valueOf(schemaObj.getPkValue()));
                apiSaveData.setBillStatus(true);
                saveItemDataList.add(apiSaveData);
            }
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private String getSaveType(Map<String, Object> dataItem) {
            String id = (String)dataItem.get(CardSchemaApiServiceImpl.ID);
            String copySchemaId = (String)dataItem.get(COPY_SCHEMA_ID);
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                return OP_UPDATE;
            }
            if (StringUtils.isNotEmpty((CharSequence)copySchemaId)) {
                return OP_COPY;
            }
            return OP_ADD;
        }

        @NotNull
        private RestApiSaveItemData getErrorSaveItemData(Map<String, Object> dataItem, Exception e) {
            RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
            HashSet<String> msg = new HashSet<String>(1);
            msg.add(e.getMessage());
            errorData.setRowMsg(msg);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setId((String)dataItem.get(CardSchemaApiServiceImpl.ID));
            apiSaveData.setBillStatus(false);
            apiSaveData.getErrors().add(errorData);
            return apiSaveData;
        }

        private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
            RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            boolean allMatch = saveItemDataList.stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(endTime - startTime));
        }
    }
}

