/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.bo.CardQueryDTO;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.card.CardAuthService;
import kd.bos.nocode.restapi.service.card.CardDataManager;
import kd.bos.nocode.restapi.service.card.CardDataQuery;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaService;
import kd.bos.nocode.restapi.service.qing.QingProxyService;
import kd.bos.nocode.restapi.service.sys.repository.CardRepository;
import kd.bos.nocode.restapi.service.sys.repository.impl.CardRepositoryImpl;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class CardServiceImpl {
    public static final String ID = "id";
    public static final String TITLE = "title";
    public static final String TYPE = "type";
    public static final String APP = "app";
    public static final String FORM = "form";
    public static final String CONFIG = "config";
    public static final String CREATOR = "creater";
    public static final String CREATE_DATE = "createdate";
    public static final String USER_ID = "userid";
    public static final String CARD_ID = "cardid";
    public static final String COLLECTED = "collected";
    public static final String ADD_CONTAINER_TIME = "addContainerTime";
    public static final String REF_COUNT = "refCount";
    public static final String USER = "user";
    public static final String DELETED = "deleted";
    public static final String DATA = "data";
    public static final String WITH_DATA = "withdata";
    public static final String ONLY_DATA = "onlydata";
    public static final String COLLECT = "collect";
    public static final String COPY = "copy";
    public static final String IMAGE = "image";
    public static final String NUMBER = "number";
    private static final CardRepository cardRepository = new CardRepositoryImpl();
    private static final CardAuthService cardAuthService = CardAuthService.create();
    private static final Log log = LogFactory.getLog(CardServiceImpl.class);
    public static final String UPDATE = "Update";
    private static final QingProxyService QING_PROXY_SERVICE = QingProxyService.create();
    private static final CardSchemaService CARD_SCHEMA_SERVICE = CardSchemaService.create();
    public static final String QING_CARD_ID = "qingCardId";
    public static final String SCHEMA_ID = "schemaId";
    public static final String FORM_ID = "formId";
    public static final String CARD_PATH = "cardPath";
    private static final String APP_ID = "appId";

    private static String getFormDeleted() {
        return "\u8868\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e";
    }

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            CardServiceSaveImpl saveService = new CardServiceSaveImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            CardServiceQueryImpl queryService = new CardServiceQueryImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            CardServiceDeleteImpl deleteService = new CardServiceDeleteImpl();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException("\u8bf7\u6c42\u4e0d\u652f\u6301");
    }

    public static Map<String, Object> getFrequentlyUsedAppDefaultConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>(2);
        configMap.put("iconStyle", "large");
        configMap.put("size", 10);
        return configMap;
    }

    public static void populateData(Map<String, Object> row) {
        String type = (String)row.get(TYPE);
        Map configInfo = (Map)row.get(CONFIG);
        CardTypeEnum.of(type).ifPresent(typeEnum -> {
            CardDataQuery query = CardDataManager.getQuery(typeEnum);
            Map<String, Object> data = null;
            try {
                data = query.execute(configInfo);
                row.put(DATA, data);
                CardServiceImpl.afterPopulateData(typeEnum, row, data);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                row.put(DATA, new HashMap(0));
            }
        });
    }

    private static void rebuildConfigInfo(Map<String, Object> cardInfo) {
        try {
            Map config;
            Object type = cardInfo.get(TYPE);
            if (Objects.equals(CardTypeEnum.FORM_LIST.toString(), type)) {
                Map config2 = (Map)cardInfo.get(CONFIG);
                String formId = (String)config2.get(FORM_ID);
                if (!FormMetadataUtils.existByFormId((String)formId)) {
                    return;
                }
                List configuredFilterItems = (List)config2.get("configuredFilterItems");
                List listItems = (List)config2.get("listItems");
                List orderInfo = (List)config2.get("orderInfo");
                CardServiceImpl.removeInvalidField(formId, configuredFilterItems, listItems, orderInfo);
                String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
                Set noViewFieldPermSet = NoCodePermHelper.getNoViewFieldPermSet((String)entityNumber);
                List listItemConfigForAll = ListConfigUtils.getListItemConfig((String)formId);
                List numbers = listItems.stream().map(e -> (String)e.get(NUMBER)).collect(Collectors.toList());
                listItemConfigForAll.forEach(e -> {
                    String number = (String)e.get(NUMBER);
                    if (!numbers.contains(number) && !noViewFieldPermSet.contains(number)) {
                        listItems.add(e);
                    }
                });
                config2.put("filter", ListFilterConfigUtils.buildFilter(configuredFilterItems, formId));
                config2.put("orderBy", ListConfigUtils.buildOrderInfo((List)orderInfo));
            } else if (Objects.equals(CardTypeEnum.FREQUENTLY_USED_APP.toString(), type) && MapUtils.isEmpty((Map)(config = (Map)cardInfo.get(CONFIG)))) {
                cardInfo.put(CONFIG, CardServiceImpl.getFrequentlyUsedAppDefaultConfig());
            }
        }
        catch (Exception e2) {
            log.debug("\u91cd\u5efa\u914d\u7f6e\u5931\u8d25", (Object)e2);
        }
    }

    private static void removeInvalidField(String formId, List<Map<String, Object>> configuredFilterItems, List<Map<String, Object>> listItems, List<Map<String, Object>> orderInfo) {
        ListFilterConfigUtils.clearInvalidFilterRows(formId, configuredFilterItems);
        ListConfigUtils.clearNoExistField((String)formId, listItems, (String)NUMBER);
        ListConfigUtils.clearNoExistField((String)formId, orderInfo, (String)NUMBER);
    }

    private static void afterPopulateData(CardTypeEnum typeEnum, Map<String, Object> row, Map<String, Object> data) {
        if (Objects.equals((Object)typeEnum, (Object)CardTypeEnum.FREQUENTLY_USED_APP)) {
            List appInfos = (List)data.get("appInfos");
            List appIds = appInfos.stream().map(e -> e.get(ID)).collect(Collectors.toList());
            Map configMap = (Map)row.get(CONFIG);
            configMap.put("appList", appIds);
        }
    }

    public static class CardServiceDeleteImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException("\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee");
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"DeleteApiServiceImpl_1"), new Object[]{Integer.MAX_VALUE});
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            long uid = RequestContext.get().getCurrUserId();
            for (Object pkId : pkIds) {
                DynamicObject updateObj = BusinessDataServiceHelper.loadSingle(pkId, (String)"bos_nocode_card");
                int type = updateObj.getInt(CardServiceImpl.TYPE);
                if (type == 0) {
                    DynamicObject creater = updateObj.getDynamicObject(CardServiceImpl.CREATOR);
                    long createrId = creater.getLong(CardServiceImpl.ID);
                    if (uid != createrId) {
                        CardServiceDeleteImpl.addNotCreatorError(resultsData, pkId);
                        continue;
                    }
                } else if (type == 1) {
                    String pageId = (String)param.getRequest().getHttpQueryString().get("pageId");
                    if (pageId == null) {
                        RestBaseFilterItemData data = new RestBaseFilterItemData();
                        data.setId(String.valueOf(pkId));
                        data.setBillStatus(false);
                        data.getErrors().add("pageId\u4e0d\u80fd\u4e3a\u7a7a");
                        resultsData.add(data);
                        continue;
                    }
                    String appid = FormMetaUtil.getAppIdByFormId((String)pageId);
                    boolean check = NoCodePermHelper.checkUserAppManageInNoCode((Long)uid, (String)appid);
                    if (!check) {
                        RestBaseFilterItemData data = new RestBaseFilterItemData();
                        data.setId(String.valueOf(pkId));
                        data.setBillStatus(false);
                        data.getErrors().add("\u6743\u9650\u4e0d\u8db3");
                        resultsData.add(data);
                        continue;
                    }
                }
                updateObj.set(CardServiceImpl.DELETED, (Object)Boolean.TRUE);
                SaveServiceHelper.update((DynamicObject)updateObj);
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                data.setId(String.valueOf(pkId));
                data.setBillStatus(true);
                resultsData.add(data);
            }
            long endTime = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(endTime - start));
        }

        private static void addNotCreatorError(List<RestBaseFilterItemData> resultsData, Object cardId) {
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            data.setId(String.valueOf(cardId));
            data.setBillStatus(false);
            data.getErrors().add("\u4ec5\u5141\u8bb8\u521b\u5efa\u4eba\u5220\u9664\u8be5\u5361\u7247");
            resultsData.add(data);
        }
    }

    public static class CardServiceQueryImpl
    implements QueryRestApiService {
        private String getFormNotPermmit() {
            return "\u8868\u5355\u65e0\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e";
        }

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            CardQueryDTO queryDto = CardQueryDTO.of(param);
            List<QFilter> filterList = this.getQFilter(queryDto);
            HashSet selectSet = Sets.newHashSet((Object[])new String[]{CardServiceImpl.ID, CardServiceImpl.TITLE, CardServiceImpl.TYPE, CardServiceImpl.APP, CardServiceImpl.FORM, CardServiceImpl.CONFIG, CardServiceImpl.IMAGE, CardServiceImpl.CREATOR, CardServiceImpl.CREATE_DATE});
            String selectProperties = String.join((CharSequence)",", selectSet);
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_nocode_card", (String)selectProperties, (QFilter[])filterList.toArray(new QFilter[0]));
            List rows = PropertyHandleUtil.toMapListRoot((String)"bos_nocode_card", (String)"$", (DynamicObject[])objs, (Set)selectSet);
            CardServiceQueryImpl.addExtendedField(rows);
            this.handleInvalidCard(rows);
            CardServiceQueryImpl.rebuildConfigInfo(rows);
            this.sort(rows);
            if (CardServiceQueryImpl.withData(param)) {
                this.populateData(rows);
            }
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(rows, param), (long)startTime, (long)endTime);
        }

        private static void rebuildConfigInfo(List<Map<String, Object>> cardInfos) {
            cardInfos.forEach(x$0 -> CardServiceImpl.rebuildConfigInfo(x$0));
        }

        private void handleInvalidCard(List<Map<String, Object>> cardInfos) {
            for (Map<String, Object> cardInfo : cardInfos) {
                String appId;
                String formId;
                Object type = cardInfo.get(CardServiceImpl.TYPE);
                Map config = (Map)cardInfo.get(CardServiceImpl.CONFIG);
                String errMsg = "";
                if (Objects.equals(CardTypeEnum.FORM_LIST.toString(), type)) {
                    formId = (String)config.get(CardServiceImpl.FORM_ID);
                    appId = (String)config.get(CardServiceImpl.APP_ID);
                    errMsg = this.getInvalidErrMsg(formId, appId);
                } else if (Objects.equals(CardTypeEnum.STATISTICS.toString(), type)) {
                    formId = (String)((Map)cardInfo.get(CardServiceImpl.FORM)).get(CardServiceImpl.ID);
                    appId = (String)((Map)cardInfo.get(CardServiceImpl.APP)).get(CardServiceImpl.ID);
                    errMsg = this.getInvalidErrMsg(formId, appId);
                }
                config.put("errMsg", errMsg);
            }
        }

        private String getInvalidErrMsg(String formId, String appId) {
            String errMsg = "";
            if (!FormMetadataUtils.existByFormId((String)formId)) {
                errMsg = CardServiceImpl.getFormDeleted();
            } else if (!NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId, (long)RequestContext.get().getCurrUserId(), (String)appId)) {
                errMsg = this.getFormNotPermmit();
            }
            return errMsg;
        }

        private boolean filterUsedApp(DynamicObject obj) {
            String type = obj.getString(CardServiceImpl.TYPE);
            DynamicObject creator = obj.getDynamicObject(CardServiceImpl.CREATOR);
            long creatorId = Objects.isNull(creator) ? 0L : creator.getLong(CardServiceImpl.ID);
            return !Objects.equals(type, CardTypeEnum.FREQUENTLY_USED_APP.toString()) || Objects.equals(type, CardTypeEnum.FREQUENTLY_USED_APP.toString()) && RequestContext.get().getCurrUserId() == creatorId;
        }

        private void sort(List<Map<String, Object>> rows) {
            Comparator byCollected = (o1, o2) -> {
                int e1Collect = (Boolean)o1.get(CardServiceImpl.COLLECTED) != false ? 1 : 0;
                int e2Collect = (Boolean)o2.get(CardServiceImpl.COLLECTED) != false ? 1 : 0;
                return e2Collect - e1Collect;
            };
            Comparator byRefCount = (o1, o2) -> {
                long e1Count = (Long)o1.get(CardServiceImpl.REF_COUNT);
                long e2Count = (Long)o2.get(CardServiceImpl.REF_COUNT);
                return (int)(e2Count - e1Count);
            };
            Comparator byCreateDate = (o1, o2) -> {
                String createDate1 = (String)o1.get(CardServiceImpl.CREATE_DATE);
                String createDate2 = (String)o2.get(CardServiceImpl.CREATE_DATE);
                return DateTimeUtils.parseDate((String)createDate1).compareTo(DateTimeUtils.parseDate((String)createDate2));
            };
            rows.sort(byCollected.thenComparing(byRefCount).thenComparing(byCreateDate));
        }

        private void sureDefaultCardExist() {
            long currUserId = RequestContext.get().getCurrUserId();
            this.createFrequentlyUsedAppCard(currUserId);
            this.createWfStatCard(currUserId);
            this.createWfMyLaunch(currUserId);
            this.createWfMyHandle(currUserId);
        }

        private void createFrequentlyUsedAppCard(long currUserId) {
            if (this.notExistCardType(currUserId, CardTypeEnum.FREQUENTLY_USED_APP)) {
                this.createDefaultByCardType(currUserId, CardTypeEnum.FREQUENTLY_USED_APP, "\u5e38\u7528\u5e94\u7528");
            }
        }

        private void createWfStatCard(long currUserId) {
            if (this.notExistCardType(currUserId, CardTypeEnum.WF_STATISTICS)) {
                this.createDefaultByCardType(currUserId, CardTypeEnum.WF_STATISTICS, "\u6d41\u7a0b\u7edf\u8ba1");
            }
        }

        private void createWfMyLaunch(long currUserId) {
            if (this.notExistCardType(currUserId, CardTypeEnum.WF_MY_LAUNCH)) {
                this.createDefaultByCardType(currUserId, CardTypeEnum.WF_MY_LAUNCH, "\u6211\u7684\u7533\u8bf7");
            }
        }

        private void createWfMyHandle(long currUserId) {
            if (this.notExistCardType(currUserId, CardTypeEnum.WF_MY_HANDLE)) {
                this.createDefaultByCardType(currUserId, CardTypeEnum.WF_MY_HANDLE, "\u5f85\u529e\u4efb\u52a1");
            }
        }

        private boolean notExistCardType(long userId, CardTypeEnum cardType) {
            return !this.existCardType(userId, cardType);
        }

        private boolean existCardType(long userId, CardTypeEnum cardType) {
            QFilter userFilter = new QFilter(CardServiceImpl.CREATOR, "=", (Object)userId);
            QFilter cardTypeFilter = new QFilter(CardServiceImpl.TYPE, "=", (Object)cardType.toString());
            QFilter deletedFilter = new QFilter(CardServiceImpl.DELETED, "=", (Object)Boolean.FALSE);
            QFilter[] filters = new QFilter[]{userFilter, cardTypeFilter, deletedFilter};
            return ORM.create().exists("bos_nocode_card", filters);
        }

        private void createDefaultByCardType(long userId, CardTypeEnum cardType, String title) {
            DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_card");
            saveObj.set(CardServiceImpl.TITLE, (Object)title);
            saveObj.set(CardServiceImpl.TYPE, (Object)cardType.toString());
            saveObj.set(CardServiceImpl.CREATOR, (Object)userId);
            saveObj.set(CardServiceImpl.DELETED, (Object)Boolean.FALSE);
            if (cardType == CardTypeEnum.FREQUENTLY_USED_APP) {
                saveObj.set(CardServiceImpl.CONFIG, (Object)SerializationUtils.toJsonString(CardServiceImpl.getFrequentlyUsedAppDefaultConfig()));
            } else {
                saveObj.set(CardServiceImpl.CONFIG, (Object)"");
            }
            SaveServiceHelper.save((IDataEntityType)saveObj.getDataEntityType(), (Object[])new DynamicObject[]{saveObj});
        }

        private void populateData(List<Map<String, Object>> rows) {
            rows.forEach(CardServiceImpl::populateData);
        }

        @NotNull
        private List<QFilter> getQFilter(CardQueryDTO queryDto) {
            Object[] filterArray = FilterUtil.getQFilters("bos_nocode_card", queryDto.getFilter());
            ArrayList filterList = Lists.newArrayList((Object[])filterArray);
            return filterList;
        }

        private static void addExtendedField(List<Map<String, Object>> cardRows) {
            List<Long> cardIds = cardRows.stream().map(row -> (Long)row.get(CardServiceImpl.ID)).collect(Collectors.toList());
            for (Map<String, Object> cardRow : cardRows) {
                CardServiceQueryImpl.convertConfigField(cardRow);
            }
            CardServiceQueryImpl.addSchemaField(cardIds, cardRows);
        }

        private static void addSchemaField(List<Long> cardIds, List<Map<String, Object>> cardRows) {
            Map<String, List<Long>> cardId2SchemaIds = cardRepository.getCardId2SchemaIds(cardIds);
            for (Map<String, Object> cardRow : cardRows) {
                Long id = (Long)cardRow.get(CardServiceImpl.ID);
                cardRow.put("schemaIds", cardId2SchemaIds.getOrDefault(id + "", new ArrayList(0)));
            }
        }

        @NotNull
        private static List<String> getUsedCardIds() {
            long schemaId = CardSchemaService.create().getActiveSchemaId(RequestContext.get().getCurrUserId());
            QFilter schemaIdFilter = new QFilter("schemaid", "=", (Object)schemaId);
            DynamicObject[] cardRefObjs = BusinessDataServiceHelper.load((String)"bos_nocode_cardref", (String)CardServiceImpl.CARD_ID, (QFilter[])schemaIdFilter.toArray());
            return Arrays.stream(cardRefObjs).map(e -> e.getString(CardServiceImpl.CARD_ID)).collect(Collectors.toList());
        }

        public static void convertConfigJson2Object(List<Map<String, Object>> rows) {
            rows.forEach(CardServiceQueryImpl::convertConfigField);
        }

        public static void convertConfigField(Map<String, Object> row) {
            String config = (String)row.get(CardServiceImpl.CONFIG);
            if (StringUtils.isBlank((CharSequence)config)) {
                row.put(CardServiceImpl.CONFIG, new HashMap(0));
            } else {
                row.put(CardServiceImpl.CONFIG, SerializationUtils.fromJsonString((String)config, Map.class));
            }
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows, RestApiQueryParam param) {
            if (CardServiceQueryImpl.onlyData(param)) {
                rows = rows.stream().map(row -> row.getOrDefault(CardServiceImpl.DATA, new HashMap(0))).collect(Collectors.toList());
            }
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            return response;
        }

        public List<Map<String, Object>> getCardInfo(Object[] cardIds, RestApiQueryParam param, boolean page) {
            DynamicObject[] cards;
            long currUserId = RequestContext.get().getCurrUserId();
            HashSet selectSet = Sets.newHashSet((Object[])new String[]{CardServiceImpl.ID, CardServiceImpl.TITLE, CardServiceImpl.TYPE, CardServiceImpl.CONFIG, CardServiceImpl.IMAGE, CardServiceImpl.DELETED, CardServiceImpl.APP, CardServiceImpl.FORM});
            QFilter deletedFilter = new QFilter(CardServiceImpl.DELETED, "=", (Object)false);
            ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{deletedFilter});
            QFilter idFilter = new QFilter(CardServiceImpl.ID, "in", (Object)cardIds);
            filters.add(idFilter);
            if (!page) {
                QFilter creatorFilter = new QFilter(CardServiceImpl.CREATOR, "=", (Object)currUserId);
                filters.add(creatorFilter);
            }
            if ((cards = BusinessDataServiceHelper.load((String)"bos_nocode_card", (String)"title,type,config,deleted,app,form,image", (QFilter[])filters.toArray(new QFilter[0]))).length == 0) {
                return new ArrayList<Map<String, Object>>(0);
            }
            List<Map<String, Object>> cardInfos = PropertyHandleUtil.toMapListRoot((String)"bos_nocode_card", (String)"$", (DynamicObject[])cards, (Set)selectSet);
            CardServiceQueryImpl.addExtendedField(cardInfos);
            this.handleInvalidCard(cardInfos);
            CardServiceQueryImpl.rebuildConfigInfo(cardInfos);
            cardInfos = CardServiceQueryImpl.sortByIds(cardInfos, cardIds);
            boolean withData = CardServiceQueryImpl.withData(param);
            if (withData) {
                cardInfos.stream().filter(c -> (Boolean)c.get(CardServiceImpl.DELETED) == false).forEach(CardServiceImpl::populateData);
            }
            return cardInfos;
        }

        private static boolean withData(RestApiQueryParam param) {
            String withData = (String)param.getRequest().getHttpQueryString().get(CardServiceImpl.WITH_DATA);
            return StringUtils.isEmpty((CharSequence)withData) || Boolean.parseBoolean(withData);
        }

        private static boolean onlyData(RestApiQueryParam param) {
            String onlyData = (String)param.getRequest().getHttpQueryString().get(CardServiceImpl.ONLY_DATA);
            return Boolean.parseBoolean(onlyData);
        }

        private static List<Map<String, Object>> sortByIds(List<Map<String, Object>> cardInfo, Object[] cardIds) {
            Map id2Object = cardInfo.stream().collect(Collectors.toMap(e -> e.get(CardServiceImpl.ID), Function.identity()));
            ArrayList<Map<String, Object>> sortedCardInfoList = new ArrayList<Map<String, Object>>(cardInfo.size());
            for (Object cardId : cardIds) {
                Map card = (Map)id2Object.get(cardId);
                if (!Objects.nonNull(card)) continue;
                sortedCardInfoList.add(card);
            }
            return sortedCardInfoList;
        }

        public static boolean existCard(String cardId) {
            QFilter[] filters = new QFilter(CardServiceImpl.ID, "=", (Object)Long.parseLong(cardId)).and(new QFilter(CardServiceImpl.DELETED, "=", (Object)Boolean.FALSE)).toArray();
            return ORM.create().exists("bos_nocode_card", filters);
        }
    }

    public static class CardServiceSaveImpl
    implements SaveRestApiService {
        public static final String SIZE_INFO = "sizeInfo";

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            if (this.isCollect(param)) {
                return this.doCollect(param, startTime);
            }
            if (this.isCopy(param)) {
                return this.doCopy(param, startTime);
            }
            List dataList = param.getDataList();
            this.checkParam(dataList);
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(dataList.size());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (Map item : dataList) {
                        if (!this.existId(item)) {
                            saveItemDataList.add(this.doInsert(item));
                            continue;
                        }
                        saveItemDataList.add(this.doUpdate(item));
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private void checkParam(List<Map<String, Object>> dataList) {
            for (Map<String, Object> dataMap : dataList) {
                String title = (String)dataMap.get(CardServiceImpl.TITLE);
                if (StringUtils.isBlank((CharSequence)title)) {
                    throw new RestApiException("\u5361\u7247\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (title.length() <= 50) continue;
                throw new RestApiException(String.format("\u5361\u7247\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", 50));
            }
        }

        private boolean isCollect(RestApiSaveParam param) {
            String url = param.getRequest().getUrl();
            String[] tokens = url.split("/");
            return tokens.length >= 5 && tokens[4].equalsIgnoreCase(CardServiceImpl.COLLECT);
        }

        private boolean isCopy(RestApiSaveParam param) {
            String url = param.getRequest().getUrl();
            String[] tokens = url.split("/");
            return tokens.length >= 5 && tokens[4].equalsIgnoreCase(CardServiceImpl.COPY);
        }

        private RestApiServiceData<RestApiSaveResult> doCollect(RestApiSaveParam param, long startTime) {
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map item : dataList) {
                String carId = (String)item.get(CardServiceImpl.ID);
                if (!Objects.nonNull(carId)) continue;
                long currUserId = RequestContext.get().getCurrUserId();
                QFilter q1 = new QFilter(CardServiceImpl.CARD_ID, "=", (Object)Long.valueOf(carId));
                QFilter q2 = new QFilter(CardServiceImpl.USER_ID, "=", (Object)currUserId);
                QFilter[] qFilters = new QFilter[]{q1, q2};
                boolean exists = ORM.create().exists("bos_nocode_cardcollect", qFilters);
                if (exists) {
                    DeleteServiceHelper.delete((String)"bos_nocode_cardcollect", (QFilter[])qFilters);
                } else {
                    DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcollect");
                    dynObj.set(CardServiceImpl.USER_ID, (Object)currUserId);
                    dynObj.set(CardServiceImpl.CARD_ID, (Object)carId);
                    SaveServiceHelper.save((IDataEntityType)dynObj.getDataEntityType(), (Object[])new DynamicObject[]{dynObj});
                }
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(carId);
                apiSaveData.setBillStatus(true);
                apiSaveData.setType(CardServiceImpl.UPDATE);
                saveItemDataList.add(apiSaveData);
            }
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private RestApiServiceData<RestApiSaveResult> doCopy(RestApiSaveParam param, long startTime) {
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map item : dataList) {
                String cardId = (String)item.get(CardServiceImpl.ID);
                if (Objects.isNull(cardId)) {
                    return this.getSaveResultData(saveItemDataList, startTime);
                }
                DynamicObject srcObj = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)"bos_nocode_card");
                if (Objects.isNull(srcObj)) {
                    return this.getSaveResultData(saveItemDataList, startTime);
                }
                long currUserId = RequestContext.get().getCurrUserId();
                DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_card");
                saveObj.set(CardServiceImpl.TITLE, (Object)(this.getCopyTitle(srcObj.getString(CardServiceImpl.TITLE)) + "-\u526f\u672c"));
                saveObj.set(CardServiceImpl.TYPE, (Object)srcObj.getString(CardServiceImpl.TYPE));
                saveObj.set(CardServiceImpl.CONFIG, (Object)srcObj.getString(CardServiceImpl.CONFIG));
                saveObj.set(CardServiceImpl.IMAGE, (Object)srcObj.getString(CardServiceImpl.IMAGE));
                saveObj.set(CardServiceImpl.CREATOR, (Object)currUserId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveObj});
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(String.valueOf(saveObj.get(CardServiceImpl.ID)));
                apiSaveData.setBillStatus(true);
                apiSaveData.setType("Add");
                saveItemDataList.add(apiSaveData);
            }
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private String getCopyTitle(String title) {
            return title.length() > 47 ? title.substring(0, 47) : title;
        }

        private boolean existId(Map<String, Object> map) {
            Object id = map.get(CardServiceImpl.ID);
            return Objects.nonNull(id) && StringUtils.isNotBlank((CharSequence)String.valueOf(id));
        }

        private RestApiSaveItemData doInsert(Map<String, Object> data) {
            String qingCardId = this.rebuildQingCardConfig(data);
            boolean page = data.containsKey("pageId");
            if (page) {
                String pageId = (String)data.get("pageId");
                String appid = FormMetaUtil.getAppIdByFormId((String)pageId);
                NoCodePermHelper.verifyManage((String)appid);
            }
            DynamicObject saveObj = this.getSaveObj(data);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveObj});
            if (page) {
                this.updatePageContainer(saveObj, data);
            } else {
                this.updateSchemaContainer(saveObj, data);
            }
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setId(saveObj.getString(CardServiceImpl.ID));
            apiSaveData.getExtra().put(CardServiceImpl.QING_CARD_ID, qingCardId);
            String cardType = (String)data.get(CardServiceImpl.TYPE);
            apiSaveData.getExtra().put(SIZE_INFO, this.getSizeInfo(cardType));
            apiSaveData.setBillStatus(true);
            apiSaveData.setType("Add");
            return apiSaveData;
        }

        private Map<String, Object> getSizeInfo(String cardType) {
            HashMap<String, Object> sizeInfo = new HashMap<String, Object>(4);
            CardTypeEnum cardTypeEnum = CardTypeEnum.valueOf(cardType);
            sizeInfo.put("minW", cardTypeEnum.getMinW());
            sizeInfo.put("maxW", cardTypeEnum.getMaxW());
            sizeInfo.put("minH", cardTypeEnum.getMinH());
            return sizeInfo;
        }

        private String rebuildQingCardConfig(Map<String, Object> data) {
            String cardType = (String)data.get(CardServiceImpl.TYPE);
            CardTypeEnum cardTypeEnum = CardTypeEnum.valueOf(cardType);
            String qingCardId = "";
            if (cardTypeEnum == CardTypeEnum.STATISTICS) {
                Map configMap = (Map)data.get(CardServiceImpl.CONFIG);
                configMap.put("userId", RequestContext.get().getCurrUserId() + "");
                qingCardId = QING_PROXY_SERVICE.saveOrUpdateQingCard(configMap);
                HashMap<String, String> newConfigMap = new HashMap<String, String>(1);
                newConfigMap.put(CardServiceImpl.QING_CARD_ID, qingCardId);
                data.put(CardServiceImpl.CONFIG, newConfigMap);
                data.put(CardServiceImpl.APP, configMap.get(CardServiceImpl.CARD_PATH));
                data.put(CardServiceImpl.FORM, configMap.get(CardServiceImpl.FORM_ID));
            }
            return qingCardId;
        }

        private void updatePageContainer(DynamicObject saveObj, Map<String, Object> data) {
            String pageId = (String)data.get("pageId");
            QFilter filter = new QFilter("pageid", "=", (Object)Long.parseLong(pageId));
            HashSet selectSet = Sets.newHashSet((Object[])new String[]{CardServiceImpl.CARD_ID, "x", "y", "w", "h"});
            String selectProperties = String.join((CharSequence)",", selectSet);
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)selectProperties, (QFilter[])filter.toArray());
            List<DynamicObject> cards = Arrays.asList(rows);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcontainer");
            dynamicObject.set("x", (Object)0);
            dynamicObject.set("y", (Object)this.getY(cards));
            dynamicObject.set("w", (Object)4);
            dynamicObject.set("h", (Object)this.getH(data));
            dynamicObject.set(CardServiceImpl.CARD_ID, saveObj.getPkValue());
            dynamicObject.set("pageid", (Object)pageId);
            dynamicObject.set(CardServiceImpl.TYPE, (Object)1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }

        private void updateSchemaContainer(DynamicObject saveObj, Map<String, Object> data) {
            List schemaIdStringList = (List)data.get("schemaIds");
            List lastSchemaIds = schemaIdStringList.stream().map(Long::parseLong).collect(Collectors.toList());
            List<Long> oldSchemaIds = cardRepository.getSchemaIds((Long)saveObj.getPkValue());
            List deleteSchemaIds = oldSchemaIds.stream().filter(e -> !lastSchemaIds.contains(e)).collect(Collectors.toList());
            QFilter cardSchemaFilter = new QFilter(CardServiceImpl.CARD_ID, "=", saveObj.getPkValue()).and(CardServiceImpl.SCHEMA_ID, "in", deleteSchemaIds);
            DeleteServiceHelper.delete((String)"bos_nocode_cardcontainer", (QFilter[])cardSchemaFilter.toArray());
            List newSchemaIdLists = lastSchemaIds.stream().filter(e -> !oldSchemaIds.contains(e)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(newSchemaIdLists)) {
                return;
            }
            QFilter schemaFilter = new QFilter(CardServiceImpl.SCHEMA_ID, "in", newSchemaIdLists);
            HashSet selectSet = Sets.newHashSet((Object[])new String[]{CardServiceImpl.CARD_ID, "x", "y", "w", "h", CardServiceImpl.SCHEMA_ID});
            String selectProperties = String.join((CharSequence)",", selectSet);
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)selectProperties, (QFilter[])schemaFilter.toArray());
            Map<Long, List<DynamicObject>> schemaId2Cards = Arrays.stream(rows).collect(Collectors.groupingBy(row -> row.getLong(CardServiceImpl.SCHEMA_ID)));
            ArrayList<DynamicObject> newCardObjList = new ArrayList<DynamicObject>(newSchemaIdLists.size());
            for (Long schemaId : newSchemaIdLists) {
                List cardList = schemaId2Cards.getOrDefault(schemaId, new ArrayList(0));
                Map<String, Object> positionMap = this.getPositionMap(schemaId, cardList, data);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcontainer");
                dynamicObject.set("x", positionMap.get("x"));
                dynamicObject.set("y", positionMap.get("y"));
                dynamicObject.set("w", positionMap.get("w"));
                dynamicObject.set("h", positionMap.get("h"));
                dynamicObject.set(CardServiceImpl.CARD_ID, saveObj.getPkValue());
                dynamicObject.set(CardServiceImpl.SCHEMA_ID, (Object)schemaId);
                newCardObjList.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])newCardObjList.toArray(new DynamicObject[0]));
        }

        private Map<String, Object> getPositionMap(Long schemaId, List<DynamicObject> cardList, Map<String, Object> data) {
            Map<String, Object> positionMap = new HashMap<String, Integer>(4);
            long activeSchemaId = CARD_SCHEMA_SERVICE.getActiveSchemaId(RequestContext.get().getCurrUserId());
            if (schemaId == activeSchemaId) {
                positionMap = (Map)data.get("position");
                if (MapUtils.isNotEmpty(positionMap)) {
                    return positionMap;
                }
                positionMap = new HashMap(4);
            }
            positionMap.put("x", 0);
            positionMap.put("y", this.getY(cardList));
            positionMap.put("w", 4);
            positionMap.put("h", this.getH(data));
            return positionMap;
        }

        private int getH(Map<String, Object> data) {
            if (CardTypeEnum.WF_STATISTICS.toString().equalsIgnoreCase((String)data.get(CardServiceImpl.TYPE))) {
                return 3;
            }
            return 7;
        }

        private int getY(List<DynamicObject> value) {
            if (CollectionUtils.isEmpty(value)) {
                return 0;
            }
            return value.stream().max(Comparator.comparingInt(e -> e.getInt("y"))).map(e -> e.getInt("y") + e.getInt("h")).orElse(0);
        }

        private DynamicObject getSaveObj(Map<String, Object> data) {
            DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_card");
            long currUserId = RequestContext.get().getCurrUserId();
            String title = StringUtil.cleanXSSParam((String)((String)data.get(CardServiceImpl.TITLE)));
            saveObj.set(CardServiceImpl.TITLE, (Object)(title.length() > 50 ? title.substring(0, 47) + "..." : title));
            saveObj.set(CardServiceImpl.TYPE, data.get(CardServiceImpl.TYPE));
            saveObj.set(CardServiceImpl.APP, data.get(CardServiceImpl.APP));
            saveObj.set(CardServiceImpl.FORM, data.get(CardServiceImpl.FORM));
            saveObj.set(CardServiceImpl.CONFIG, (Object)SerializationUtils.toJsonString(data.getOrDefault(CardServiceImpl.CONFIG, new HashMap(0))));
            saveObj.set(CardServiceImpl.IMAGE, data.get(CardServiceImpl.IMAGE));
            saveObj.set(CardServiceImpl.CREATOR, (Object)currUserId);
            saveObj.set(CardServiceImpl.DELETED, (Object)Boolean.FALSE);
            return saveObj;
        }

        private RestApiSaveItemData doUpdate(Map<String, Object> data) {
            DynamicObject updateObj;
            String id = (String)data.get(CardServiceImpl.ID);
            boolean page = data.containsKey("pageId");
            if (page) {
                String pageId = (String)data.get("pageId");
                String appid = FormMetaUtil.getAppIdByFormId((String)pageId);
                NoCodePermHelper.verifyManage((String)appid);
            }
            if (Objects.nonNull(updateObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_nocode_card"))) {
                RestApiSaveItemData checkResult;
                if (!page && Objects.nonNull(checkResult = this.checkModifier(updateObj))) {
                    return checkResult;
                }
                String qingCardId = this.rebuildQingCardConfig(data);
                String title = StringUtil.cleanXSSParam((String)((String)data.get(CardServiceImpl.TITLE)));
                updateObj.set(CardServiceImpl.TITLE, (Object)(title.length() > 50 ? title.substring(0, 47) + "..." : title));
                updateObj.set(CardServiceImpl.CONFIG, (Object)SerializationUtils.toJsonString((Object)data.get(CardServiceImpl.CONFIG)));
                updateObj.set(CardServiceImpl.IMAGE, data.get(CardServiceImpl.IMAGE));
                updateObj.set(CardServiceImpl.APP, data.get(CardServiceImpl.APP));
                updateObj.set(CardServiceImpl.FORM, data.get(CardServiceImpl.FORM));
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{updateObj});
                if (!page) {
                    this.updateSchemaContainer(updateObj, data);
                }
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(id);
                apiSaveData.setBillStatus(true);
                apiSaveData.getExtra().put(CardServiceImpl.QING_CARD_ID, qingCardId);
                apiSaveData.getExtra().put(SIZE_INFO, this.getSizeInfo(updateObj.getString(CardServiceImpl.TYPE)));
                apiSaveData.setType(CardServiceImpl.UPDATE);
                return apiSaveData;
            }
            RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
            HashSet<String> msg = new HashSet<String>(1);
            msg.add("\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            errorData.setRowMsg(msg);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setId(id);
            apiSaveData.setBillStatus(false);
            apiSaveData.setType(CardServiceImpl.UPDATE);
            apiSaveData.getErrors().add(errorData);
            return apiSaveData;
        }

        private RestApiSaveItemData checkModifier(DynamicObject updateObj) {
            DynamicObject creator = updateObj.getDynamicObject(CardServiceImpl.CREATOR);
            long creatorId = creator.getLong(CardServiceImpl.ID);
            if (RequestContext.get().getCurrUserId() != creatorId) {
                RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
                HashSet<String> msg = new HashSet<String>(1);
                msg.add("\u4ec5\u5141\u8bb8\u521b\u5efa\u4eba\u4fee\u6539\u8be5\u5361\u7247");
                errorData.setRowMsg(msg);
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(updateObj.getString(CardServiceImpl.ID));
                apiSaveData.setBillStatus(false);
                apiSaveData.setType(CardServiceImpl.UPDATE);
                apiSaveData.getErrors().add(errorData);
                return apiSaveData;
            }
            return null;
        }

        private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
            RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            boolean allMatch = saveItemDataList.stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(endTime - startTime));
        }
    }
}

