/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.sys.common.ListConfigQueryImpl;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.FormAuthStatus;
import kd.bos.nocode.restapi.service.util.FormPublishHelper;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class FormAuthServiceImpl {
    private static final String BOS_NOCODE_FORM_AUTH = "bos_nocode_form_auth";
    private static final String UNKNOWN_REQUEST = "unknown request";
    private static final int MAX_LENGTH = 255;
    private static final String APPLY_APP_ID = "applyappid";
    private static final String APP_ID = "appid";
    private static final String APPLY_APP_NAME = "applyappname";
    private static final String FORM_ID = "formid";
    private static final String APP_NAME = "appname";
    private static final String STATUS = "status";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            AuthServiceSaveImpl roleServiceSave = new AuthServiceSaveImpl();
            return roleServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            AuthServiceQueryImpl roleServiceQuery = new AuthServiceQueryImpl();
            return roleServiceQuery.execute((RestApiQueryParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"FormAuthServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private String getRouter(RestApiParam param) {
        String code;
        String url = param.getRequest().getUrl();
        String router = url.substring(url.lastIndexOf(code = param.getAppNumber() + "/form_auth/") + code.length());
        if (router.contains("/")) {
            router = router.split("/")[0];
        }
        return router;
    }

    public class AuthServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            String router;
            switch (router = FormAuthServiceImpl.this.getRouter((RestApiParam)param)) {
                case "apply": {
                    return this.apply(param);
                }
                case "abstain": {
                    return this.abstain(param);
                }
                case "audit": {
                    return this.audit(param);
                }
                case "revoke": {
                    return this.revoke(param);
                }
            }
            throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
        }

        private RestApiServiceData<RestApiSaveResult> revoke(RestApiSaveParam param) {
            long start = System.currentTimeMillis();
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map data : dataList) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                try {
                    results.add(apiSaveData);
                    String id = (String)data.get("id");
                    apiSaveData.setId(id);
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    filters.add(new QFilter("id", "=", (Object)Long.parseLong(id)));
                    boolean exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                    if (!exists) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u672a\u77e5\u8bb0\u5f55,id:", (String)"FormAuthServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]) + id);
                    }
                    DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
                    String appid = dy.getString(FormAuthServiceImpl.APP_ID);
                    NoCodePermHelper.verifyManage((String)appid);
                    filters.add(new QFilter(FormAuthServiceImpl.STATUS, "=", (Object)FormAuthStatus.STATUS_3.getValue()));
                    exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                    if (!exists) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u6743\u9650,\u65e0\u6cd5\u64a4\u9500", (String)"FormAuthServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    String formid = dy.getString(FormAuthServiceImpl.FORM_ID);
                    String applyappid = dy.getString(FormAuthServiceImpl.APPLY_APP_ID);
                    FormPublishHelper.revoke(formid, applyappid);
                    String sql = "update t_nocode_form_auth set fstatus = ? where fid =? and fstatus = ?";
                    int i = DB.update((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{FormAuthStatus.STATUS_5.getValue(), Long.parseLong(id), FormAuthStatus.STATUS_3.getValue()});
                    if (i != 1) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25,\u8bf7\u5237\u65b0\u91cd\u8bd5", (String)"FormAuthServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    apiSaveData.setBillStatus(true);
                }
                catch (Exception e) {
                    apiSaveData.setBillStatus(false);
                    apiSaveData.addError(e);
                }
            }
            RestApiSaveResult ret = RestApiSaveResult.of(results);
            long modelTimeCost = System.currentTimeMillis() - start;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            boolean allMatch = ret.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private RestApiServiceData<RestApiSaveResult> abstain(RestApiSaveParam param) {
            long start = System.currentTimeMillis();
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map data : dataList) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                try {
                    results.add(apiSaveData);
                    String id = (String)data.get("id");
                    apiSaveData.setId(id);
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    filters.add(new QFilter("id", "=", (Object)Long.parseLong(id)));
                    boolean exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                    if (!exists) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u672a\u77e5\u8bb0\u5f55,id:", (String)"FormAuthServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]) + id);
                    }
                    DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
                    String applyappid = dy.getString(FormAuthServiceImpl.APPLY_APP_ID);
                    NoCodePermHelper.verifyManage((String)applyappid);
                    filters.add(new QFilter(FormAuthServiceImpl.STATUS, "=", (Object)FormAuthStatus.STATUS_3.getValue()));
                    exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                    if (!exists) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u6743\u9650,\u65e0\u6cd5\u5f03\u6743", (String)"FormAuthServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    String formid = dy.getString(FormAuthServiceImpl.FORM_ID);
                    FormPublishHelper.revoke(formid, applyappid);
                    String sql = "update t_nocode_form_auth set fstatus = ? where fid =? and fstatus = ?";
                    int i = DB.update((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{FormAuthStatus.STATUS_4.getValue(), Long.parseLong(id), FormAuthStatus.STATUS_3.getValue()});
                    if (i != 1) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u5f03\u6743\u5931\u8d25,\u8bf7\u5237\u65b0\u91cd\u8bd5", (String)"FormAuthServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    apiSaveData.setBillStatus(true);
                }
                catch (Exception e) {
                    apiSaveData.setBillStatus(false);
                    apiSaveData.addError(e);
                }
            }
            RestApiSaveResult ret = RestApiSaveResult.of(results);
            long modelTimeCost = System.currentTimeMillis() - start;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            boolean allMatch = ret.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private RestApiServiceData<RestApiSaveResult> audit(RestApiSaveParam param) {
            long start = System.currentTimeMillis();
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(dataList.size());
            Map data = (Map)dataList.get(0);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            try {
                results.add(apiSaveData);
                String id = (String)data.get("id");
                String auditText = (String)data.get("auditText");
                if (auditText != null && auditText.length() > 255) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1\u957f\u5ea6\u8d85\u8fc7\u9650\u5236,\u6700\u5927\u957f\u5ea6:%s", (String)"FormAuthServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[]{255}));
                }
                boolean agree = data.getOrDefault("agree", false);
                apiSaveData.setId(id);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("id", "=", (Object)Long.parseLong(id)));
                boolean exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                if (!exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u672a\u77e5\u8bb0\u5f55,id:", (String)"FormAuthServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]) + id);
                }
                DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
                String appid = dy.getString(FormAuthServiceImpl.APP_ID);
                NoCodePermHelper.verifyManage((String)appid);
                filters.add(new QFilter(FormAuthServiceImpl.STATUS, "=", (Object)FormAuthStatus.STATUS_1.getValue()));
                exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])filters.toArray(new QFilter[0]));
                if (!exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001,\u64cd\u4f5c\u5931\u8d25", (String)"FormAuthServiceImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                String formid = dy.getString(FormAuthServiceImpl.FORM_ID);
                exists = QueryServiceHelper.exists((String)"bos_objecttype", (Object)formid);
                if (!exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5df2\u5220\u9664", (String)"FormAuthServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                if (agree) {
                    String applyappid = dy.getString(FormAuthServiceImpl.APPLY_APP_ID);
                    FormPublishHelper.publish(formid, applyappid);
                }
                String sql = "update t_nocode_form_auth set fstatus = ? , faudittext = ? where fid =? and fstatus = ?";
                FormAuthStatus status = agree ? FormAuthStatus.STATUS_3 : FormAuthStatus.STATUS_2;
                int i = DB.update((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{status.getValue(), auditText, Long.parseLong(id), FormAuthStatus.STATUS_1.getValue()});
                if (i != 1) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25,\u8bf7\u5237\u65b0\u91cd\u8bd5", (String)"FormAuthServiceImpl_9", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                apiSaveData.setBillStatus(true);
            }
            catch (Exception e) {
                throw new RestApiException(RestApiErrorCode.ERROR.getStatusCode(), e.getMessage(), (Throwable)e);
            }
            RestApiSaveResult ret = RestApiSaveResult.of(results);
            long modelTimeCost = System.currentTimeMillis() - start;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
        }

        private RestApiServiceData<RestApiSaveResult> apply(RestApiSaveParam param) {
            long start = System.currentTimeMillis();
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(dataList.size());
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            Map data = (Map)dataList.get(0);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            try {
                results.add(apiSaveData);
                String appId = (String)data.get("appId");
                String applyAppId = (String)data.get("applyAppId");
                if (StringUtils.isEmpty((String)appId)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528id\u4e0d\u53ef\u4e3a\u7a7a", (String)"FormAuthServiceImpl_10", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)appId);
                if (!exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5b58\u5728", (String)"FormAuthServiceImpl_11", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                NoCodePermHelper.verifyManage((String)applyAppId);
                String formId = (String)data.get("formId");
                if (StringUtils.isEmpty((String)formId)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u8868\u5355id\u4e0d\u53ef\u4e3a\u7a7a", (String)"FormAuthServiceImpl_12", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                String applyReason = (String)data.get("applyReason");
                if (applyReason != null && applyReason.length() > 255) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u7533\u8bf7\u539f\u56e0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236,\u6700\u5927\u957f\u5ea6:%s", (String)"FormAuthServiceImpl_13", (String)"bos-nocode-service", (Object[])new Object[]{255}));
                }
                apiSaveData.setId(formId);
                QFilter f1 = new QFilter(FormAuthServiceImpl.APP_ID, "=", (Object)appId);
                QFilter f2 = new QFilter(FormAuthServiceImpl.APPLY_APP_ID, "=", (Object)applyAppId);
                QFilter f3 = new QFilter(FormAuthServiceImpl.FORM_ID, "=", (Object)formId);
                QFilter f4 = new QFilter(FormAuthServiceImpl.STATUS, "=", (Object)FormAuthStatus.STATUS_1.getValue());
                exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])new QFilter[]{f1, f2, f3, f4});
                if (exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5ba1\u6838\u72b6\u6001\u4e2d\u7684\u7533\u8bf7", (String)"FormAuthServiceImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                exists = QueryServiceHelper.exists((String)"bos_objecttype", (Object)formId);
                if (!exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5df2\u5220\u9664", (String)"FormAuthServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                QFilter f5 = new QFilter(FormAuthServiceImpl.STATUS, "=", (Object)FormAuthStatus.STATUS_3.getValue());
                exists = QueryServiceHelper.exists((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (QFilter[])new QFilter[]{f1, f2, f3, f5});
                if (exists) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5df2\u83b7\u5f97\u8be5\u8868\u5355\u6388\u6743", (String)"FormAuthServiceImpl_15", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
                dy.set(FormAuthServiceImpl.APP_ID, (Object)appId);
                dy.set(FormAuthServiceImpl.FORM_ID, (Object)formId);
                dy.set(FormAuthServiceImpl.APPLY_APP_ID, (Object)applyAppId);
                dy.set("applyreason", (Object)applyReason);
                dy.set(FormAuthServiceImpl.STATUS, (Object)FormAuthStatus.STATUS_1.getValue());
                list.add(dy);
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                apiSaveData.setBillStatus(true);
            }
            catch (Exception e) {
                throw new RestApiException(RestApiErrorCode.ERROR.getStatusCode(), e.getMessage(), (Throwable)e);
            }
            RestApiSaveResult ret = RestApiSaveResult.of(results);
            long modelTimeCost = System.currentTimeMillis() - start;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
        }
    }

    public class AuthServiceQueryImpl
    implements QueryRestApiService {
        private static final String PROP_BIZCLOUD = "bizcloud";
        private static final String PROP_NUMBER = "number";
        private static final String PROP_VISIBLE = "visible";
        private static final String PROP_ID = "id";

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            String router;
            switch (router = FormAuthServiceImpl.this.getRouter((RestApiParam)param)) {
                case "apply_config": {
                    return this.getApplyConfig(param);
                }
                case "list_apply": {
                    String url = param.getRequest().getFullRequestUrl();
                    Pattern compile = Pattern.compile("^(.*?/list_apply/)(.*)((\\?.*)?)$");
                    Matcher matcher = compile.matcher(url);
                    if (matcher.find()) {
                        String appid = matcher.group(2);
                        NoCodePermHelper.verifyManage((String)appid);
                        return this.listApply(param, appid);
                    }
                    throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
                }
                case "audit_config": {
                    return this.getAuditConfig(param);
                }
                case "list_audit": {
                    String url = param.getRequest().getFullRequestUrl();
                    Pattern compile = Pattern.compile("^(.*?/list_audit/)(.*)((\\?.*)?)$");
                    Matcher matcher = compile.matcher(url);
                    if (matcher.find()) {
                        String appid = matcher.group(2);
                        NoCodePermHelper.verifyManage((String)appid);
                        return this.listAudit(param, appid);
                    }
                    throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
                }
                case "list_app": {
                    String url = param.getRequest().getFullRequestUrl();
                    Pattern compile = Pattern.compile("^(.*?/list_app/)(.*)((\\?.*)?)$");
                    Matcher matcher = compile.matcher(url);
                    if (matcher.find()) {
                        String appid = matcher.group(2);
                        return this.listApp(param, appid);
                    }
                    throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
                }
                case "list_form": {
                    String url = param.getRequest().getFullRequestUrl();
                    Pattern compile = Pattern.compile("^(.*?/list_form/)(.*)((\\?.*)?)$");
                    Matcher matcher = compile.matcher(url);
                    if (matcher.find()) {
                        String appid = matcher.group(2);
                        return this.listForm(param, appid);
                    }
                    throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
                }
            }
            throw new RestApiException(FormAuthServiceImpl.UNKNOWN_REQUEST);
        }

        private RestApiServiceData<RestApiQueryResult> listForm(RestApiQueryParam param, String appid) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appid);
            List rows = appMetadata.getAppMenus().stream().filter(menu -> !"custom".equals(menu.getMenuType())).filter(menu -> !"bas_appstarted".equalsIgnoreCase(menu.getFormNumber())).filter(menu -> StringUtils.isNotEmpty((String)menu.getFormId())).filter(menu -> menu.getVisible().equalsIgnoreCase("true")).map(menu -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", menu.getFormId());
                map.put("name", menu.getName().toString());
                return map;
            }).collect(Collectors.toList());
            RestApiQueryResult result = new RestApiQueryResult();
            long startTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            result.setRows(rows);
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            result.setTotalCount(rows.size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private RestApiServiceData<RestApiQueryResult> listApp(RestApiQueryParam param, String appid) {
            long startTime = System.currentTimeMillis();
            param.setFormId("bos_devportal_bizapp");
            ArrayList<Object> filters = new ArrayList<Object>(Arrays.asList((Object[])FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param).getValue()));
            filters.add(new QFilter(PROP_BIZCLOUD, "=", (Object)RestApiServiceLocalCache.getNoCodeCloudId()));
            filters.add(new QFilter(PROP_NUMBER, "!=", (Object)"nocode_fromtemplate_app"));
            filters.add(new QFilter(PROP_VISIBLE, "=", (Object)true));
            Set hides = NoCodeTemplateUtil.queryTemplateAppIds();
            hides.add(appid);
            filters.add(new QFilter(PROP_ID, "not in", (Object)hides));
            String selectProperties = "id,name";
            String orderBy = "createdate desc";
            QFilter[] filterArray = filters.toArray(new QFilter[0]);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selectProperties, (QFilter[])filterArray, (String)orderBy);
            Set selectSet = Arrays.stream(selectProperties.split(",")).collect(Collectors.toSet());
            List rows = PropertyHandleUtil.toMapListRoot((String)"bos_devportal_bizapp", (String)"$", (DynamicObject[])dynamicObjects, selectSet);
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(rows);
            result.setTotalCount(rows.size());
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private RestApiServiceData<RestApiQueryResult> getApplyConfig(RestApiQueryParam param) {
            HashSet<String> hides = new HashSet<String>();
            hides.add(FormAuthServiceImpl.APPLY_APP_ID);
            hides.add(FormAuthServiceImpl.APP_ID);
            hides.add(FormAuthServiceImpl.APPLY_APP_NAME);
            hides.add(FormAuthServiceImpl.FORM_ID);
            return this.getConfig(param, hides);
        }

        private RestApiServiceData<RestApiQueryResult> getAuditConfig(RestApiQueryParam param) {
            HashSet<String> hides = new HashSet<String>();
            hides.add(FormAuthServiceImpl.APP_ID);
            hides.add(FormAuthServiceImpl.FORM_ID);
            hides.add(FormAuthServiceImpl.APPLY_APP_ID);
            hides.add(FormAuthServiceImpl.APP_NAME);
            return this.getConfig(param, hides);
        }

        private RestApiServiceData getConfig(RestApiQueryParam param, Set<String> keys) {
            String formId = MetadataDao.getIdByNumber((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (MetaCategory)MetaCategory.Entity);
            param.setFormId(formId);
            param.getRequest().setFormId(formId);
            param.getRequest().getHttpQueryString().put(FormAuthServiceImpl.APP_ID, "nocode_sys");
            param.getRequest().getHttpQueryString().put(FormAuthServiceImpl.FORM_ID, formId);
            param.getRequest().getHttpQueryString().put("env", NoCodeEnvironmentEnum.RUNTIME.getCode());
            ListConfigQueryImpl service = new ListConfigQueryImpl();
            RestApiServiceData<RestApiQueryResult> ret = service.execute(param);
            List rows = ((RestApiQueryResult)ret.getResponse().getData()).getRows();
            for (Map row : rows) {
                this.removeListConfig(row, keys);
                this.removeFilterConfig(row, keys);
            }
            return ret;
        }

        private void removeListConfig(Map<String, Object> row, Set<String> keys) {
            List listConfig = (List)row.get("listItemConfig");
            listConfig.removeIf(next -> keys.contains(next.get(PROP_NUMBER)));
        }

        private void removeFilterConfig(Map<String, Object> row, Set<String> keys) {
            List listConfig = (List)row.get("listFilterConfig");
            listConfig.removeIf(next -> keys.contains(next.get("fieldName")));
        }

        private RestApiServiceData<RestApiQueryResult> listAudit(RestApiQueryParam param, String appid) {
            QFilter filter = new QFilter(FormAuthServiceImpl.APP_ID, "=", (Object)appid);
            return this.list(param, filter);
        }

        private RestApiServiceData<RestApiQueryResult> listApply(RestApiQueryParam param, String appid) {
            QFilter filter = new QFilter(FormAuthServiceImpl.APPLY_APP_ID, "=", (Object)appid);
            return this.list(param, filter);
        }

        private RestApiServiceData<RestApiQueryResult> list(RestApiQueryParam param, QFilter filter) {
            param.setFormId(FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
            param.getRequest().setFormId(FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH);
            long startTime = System.currentTimeMillis();
            Object[] filters = (QFilter[])FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param).getValue();
            String orderBy = param.getOrder_by();
            if (StringUtils.isEmpty((String)orderBy)) {
                orderBy = "createdatefield desc";
            }
            ArrayList list = Lists.newArrayList((Object[])filters);
            list.add(filter);
            HashSet<String> selectSet = new HashSet<String>();
            selectSet.add(PROP_ID);
            selectSet.add(FormAuthServiceImpl.FORM_ID);
            selectSet.add("formname");
            selectSet.add(FormAuthServiceImpl.APP_ID);
            selectSet.add(FormAuthServiceImpl.APP_NAME);
            selectSet.add(FormAuthServiceImpl.APPLY_APP_ID);
            selectSet.add(FormAuthServiceImpl.APPLY_APP_NAME);
            selectSet.add("applyreason");
            selectSet.add("audittext");
            selectSet.add(FormAuthServiceImpl.STATUS);
            DynamicObject[] dao = param.getPage_no() - 1 == -1 ? BusinessDataServiceHelper.load((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (String)String.join((CharSequence)",", selectSet), (QFilter[])list.toArray(new QFilter[0]), (String)orderBy) : BusinessDataServiceHelper.load((String)FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, (String)String.join((CharSequence)",", selectSet), (QFilter[])list.toArray(new QFilter[0]), (String)orderBy, (int)(param.getPage_no() - 1), (int)param.getPage_size());
            ArrayList ret = new ArrayList((int)Arrays.stream(dao).count());
            for (DynamicObject dy : dao) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ret.add(map);
                for (String key : selectSet) {
                    map.put(key, dy.get(key));
                }
                DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
                ComboProp prop = (ComboProp)dy.getDataEntityType().getProperties().get((Object)FormAuthServiceImpl.STATUS);
                String status = (String)dy.get(FormAuthServiceImpl.STATUS);
                map.put("statusId", status);
                map.put(FormAuthServiceImpl.STATUS, prop.getItemByName(status));
                String appid = (String)map.get(FormAuthServiceImpl.APP_ID);
                map.put(FormAuthServiceImpl.APP_NAME, AppServiceHelper.getAppNameById(appid));
                String applyappid = (String)map.get(FormAuthServiceImpl.APPLY_APP_ID);
                map.put(FormAuthServiceImpl.APPLY_APP_NAME, AppServiceHelper.getAppNameById(applyappid));
                String formid = (String)map.get(FormAuthServiceImpl.FORM_ID);
                map.put("formname", FormHelper.getFormName((String)formid));
            }
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(ret);
            int totalCount = ORM.create().count("totalCount", FormAuthServiceImpl.BOS_NOCODE_FORM_AUTH, list.toArray(new QFilter[0]));
            result.setTotalCount(totalCount);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }
}

