/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.ImageRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiImageParam;
import kd.bos.nocode.restapi.api.result.RestApiImageResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.ImageAction;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.util.AttachExceptionHandler;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.FileRecord;
import kd.bos.servicehelper.util.FileRecordUtil;
import kd.bos.util.ImageUtils;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.bos.web.actions.utils.FileTypeUtil;
import kd.bos.web.actions.utils.FileUploadUrlUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public class ImageRestApiServiceImpl
implements ImageRestApiService {
    private static final Log log = LogFactory.getLog(ImageRestApiServiceImpl.class);
    private static final boolean ENABLE_LOG = Boolean.parseBoolean(System.getProperty("imageAction.logCostTime.enable", "true"));
    private static final List<String> SUPPORT_FORMAT = Arrays.asList(".bmp", ".gif", ".jpg", ".png", ".jpeg");
    public static final String FMT_IMAGE = "/%s/%s/%s/nocode/%s";
    public static final String IMG_1001 = "IMG_1001";
    public static final int FILE_FACTOR = 0x100000;
    private static final String THUMBNAILS_TAG = "thumbnailsTag";
    private static final String THUMBNAILS_SCALE = "scale";
    private static final String THUMBNAILS_PARAMS = "thumbparam";

    public RestApiServiceData<RestApiImageResult> execute(RestApiImageParam param) {
        if (ImageAction.UPLOAD.getCode().equalsIgnoreCase(param.getAction())) {
            return this.upload(param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u56fe\u7247\u64cd\u4f5c", (String)"ImageRestApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private RestApiServiceData<RestApiImageResult> upload(RestApiImageParam param) {
        long startTime = System.currentTimeMillis();
        RestApiImageResult result = new RestApiImageResult();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        FileItem fileItem = new FileItem(param.getFilename(), param.getFilename(), (InputStream)new ByteArrayInputStream(param.getFileData()));
        fileItem.setAppId(param.getAppNumber());
        fileItem.setFId(param.getFormId());
        String appId = fileItem.getAppId();
        String fId = fileItem.getFId();
        boolean unCompressPic = param.isUnCompressPic();
        boolean encryptStorage = param.isEncryptStorage();
        HashMap<String, Object> uploadParam = new HashMap<String, Object>(16);
        uploadParam.put("uncompresspic", unCompressPic);
        uploadParam.put("encryptstorage", encryptStorage);
        uploadParam.put(THUMBNAILS_PARAMS, param.getThumbParam());
        if (ENABLE_LOG) {
            log.debug("imageupload.received time : " + System.currentTimeMillis());
        }
        String fileName = fileItem.getFileName();
        if (!FileUploadUrlUtil.isFileUploadWithUrl()) {
            fileItem.setPath(FileUploadUrlUtil.getImageRandomUrl((String)fileName));
        }
        if (!fileName.contains(".")) {
            String errMsg = fileName + ResManager.loadKDString((String)"\u6587\u4ef6\u65e0\u540e\u7f00\u540d\uff0c\u4e0d\u652f\u6301\u4e0a\u4f20", (String)"ImageRestApiServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]);
            throw new RestApiException(errMsg);
        }
        String speSymbol = this.getSpeSymbol(fileName);
        if (StringUtils.isNotBlank((CharSequence)speSymbol)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a", (String)"ImageRestApiServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]) + speSymbol);
        }
        try {
            int fileByteSize = fileItem.getInputStream().available();
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Object)e);
            throw new RestApiException(e.getMessage());
        }
        try (InputStream inputStream1 = fileItem.getInputStream();
             ByteArrayOutputStream baos = FileTypeUtil.cloneInputStream((InputStream)inputStream1);
             ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
             ByteArrayInputStream inputStreamCheck = new ByteArrayInputStream(baos.toByteArray());){
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String path = fileItem.getPath();
            path = this.dealPath(path);
            String dateStr = this.getDateStr();
            path = String.format(FMT_IMAGE, tenantId, accountId, dateStr, path);
            fileItem = new FileItem(fileName, path, (InputStream)inputStream);
            fileItem.setFId(fId);
            fileItem.setAppId(appId);
            fileItem.setCreateNewFileWhenExists(true);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Object)e);
            throw new RestApiException(e.getMessage());
        }
        return this.upload(fileItem, uploadParam, (RestApiResponse<RestApiImageResult>)response, startTime);
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    @Nullable
    private String dealPath(String path) {
        try {
            path = FilePathUtil.dealPath((String)path, (String)"image");
        }
        catch (KDException e) {
            AttachExceptionHandler.dealException(e);
        }
        return path;
    }

    private RestApiServiceData<RestApiImageResult> upload(FileItem fileItem, Map<String, Object> uploadParam, RestApiResponse<RestApiImageResult> response, long startTime) {
        try (InputStream in = fileItem.getInputStream();){
            String path = fileItem.getPath();
            if (ENABLE_LOG) {
                log.debug("imageupload.beforupload time : " + System.currentTimeMillis());
            }
            byte[] srcPicData = ByteStreams.toByteArray((InputStream)in);
            try (ByteArrayInputStream srcPicStream = new ByteArrayInputStream(srcPicData);){
                String url;
                FileItem item = new FileItem(fileItem.getFileName(), ImageRestApiServiceImpl.processPathString(path, null, fileItem.getFileName()), (InputStream)srcPicStream);
                String thumbnailsParamsStr = (String)uploadParam.get(THUMBNAILS_PARAMS);
                if (StringUtils.isEmpty((CharSequence)thumbnailsParamsStr)) {
                    thumbnailsParamsStr = this.getDefaultThumbnailsParams();
                }
                List thumbnailsParams = (List)SerializationUtils.fromJsonString((String)thumbnailsParamsStr, List.class);
                ArrayList<FileItem> picItems = new ArrayList<FileItem>();
                picItems.add(0, item);
                long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
                int fileSize = srcPicStream.available() / 1024;
                Object encryptStorageParam = uploadParam.get("encryptStorage");
                boolean encryptStorage = Boolean.parseBoolean(String.valueOf(encryptStorageParam));
                if (encryptStorage) {
                    String pathPrefix = item.getPath().substring(0, StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/"));
                    String pathTwo = item.getPath().substring(StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/") + 1);
                    String kdImgPath = pathPrefix + "/kdimg" + pathTwo;
                    item = new FileItem(item.getFileName(), kdImgPath, fileItem.getInputStream());
                }
                if (!((Boolean)uploadParam.get("uncompresspic")).booleanValue() && compressPicSize != 0L && (long)fileSize > compressPicSize) {
                    url = this.getFileService().compressPicUpload(item, compressPicSize);
                } else {
                    List urls = this.getFileService().upload(picItems.toArray(new FileItem[0]));
                    url = (String)urls.get(0);
                }
                if (ENABLE_LOG) {
                    log.debug("imageupload.afterupload time : " + System.currentTimeMillis());
                }
                ((RestApiImageResult)response.getData()).setUrl(url);
                ((RestApiImageResult)response.getData()).setFilename(fileItem.getFileName());
                FileRecord fileRecord = new FileRecord();
                fileRecord.setUrl(url);
                fileRecord.setType("1");
                fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                fileRecord.setCreateTime(new Date());
                FileRecordUtil.doLog(Collections.singletonList(fileRecord));
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Object)e);
            throw new RestApiException(ResManager.loadKDString((String)"\u56fe\u7247\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"ImageRestApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        return RestApiServiceData.ofTrue(response, (long)this.getModelTimeCost(startTime));
    }

    private String getDefaultThumbnailsParams() {
        HashMap<String, String> thumbnailsParam = new HashMap<String, String>(2);
        thumbnailsParam.put(THUMBNAILS_TAG, "s50");
        thumbnailsParam.put(THUMBNAILS_SCALE, "0.5");
        ArrayList thumbnailsParams = Lists.newArrayList((Object[])new Map[]{thumbnailsParam});
        return SerializationUtils.toJsonString((Object)thumbnailsParams);
    }

    private static String processPathString(String srcPath, String thumbnailsTag, String fileName) {
        boolean isMatch;
        String distPath = srcPath.replace("//", "/");
        if (!distPath.contains(".")) {
            distPath = String.format("%s%s", distPath, fileName);
            isMatch = SUPPORT_FORMAT.stream().anyMatch(format -> fileName.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        } else {
            isMatch = SUPPORT_FORMAT.stream().anyMatch(format -> srcPath.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        }
        if (!isMatch) {
            String msgFormat = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u7c7b\u578b\uff1a%s", (String)"ImageRestApiServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]);
            String msg = String.format(msgFormat, StringUtils.join((Object[])SUPPORT_FORMAT.toArray()));
            throw new KDBizException(msg);
        }
        String prefixWithoutUuid = distPath.substring(0, distPath.lastIndexOf("/") + 1);
        String ext = distPath.substring(StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
        if (StringUtils.isNotBlank((CharSequence)thumbnailsTag)) {
            String prefix = distPath.substring(0, StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
            distPath = String.format("%s_thumbnails_%s%s", prefix, thumbnailsTag, ext);
        } else {
            distPath = prefixWithoutUuid + Uuid8.generateShortUuid() + ext;
        }
        return distPath;
    }

    public String getSpeSymbol(String fileFullName) {
        log.debug("kd.bos.nocode.restapi.service.sys.ImageRestApiServiceImpl.checkSpeSymbol fileName ---- " + fileFullName);
        return AttachmentServiceHelper.checkSpeSymbol((String)fileFullName);
    }

    protected FileService getFileService() {
        return FileServiceFactory.getImageFileService();
    }

    private long getModelTimeCost(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    private List<FileItem> createThumbnails(FileItem srcPic, List<Map<String, Object>> thumbnailParams, byte[] srcPicBtyes) throws IOException {
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>(10);
        for (int i = 0; i < thumbnailParams.size(); ++i) {
            ByteArrayInputStream bis = new ByteArrayInputStream(srcPicBtyes);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Map<String, Object> thumbnailsParam = thumbnailParams.get(i);
            String thumbTag = (String)thumbnailsParam.get(THUMBNAILS_TAG);
            if (StringUtils.isBlank((CharSequence)thumbTag)) {
                throw new IllegalArgumentException("params error: thumbnails tag is blank");
            }
            String scale = (String)thumbnailsParam.get(THUMBNAILS_SCALE);
            Integer width = (Integer)thumbnailsParam.get("width");
            Integer height = (Integer)thumbnailsParam.get("height");
            double rotateDegree = 0.0;
            if (bis.available() > 0x500000) {
                this.createThumbnailsForBigImage(bos, width, height, Double.parseDouble(scale), srcPicBtyes);
            } else {
                this.createThumbnailsForSmallImage(bis, bos, scale, width, height, rotateDegree);
            }
            String tmpUrl = ImageRestApiServiceImpl.processPathString(srcPic.getPath(), thumbTag, srcPic.getFileName());
            fileItems.add(this.createFileItem(srcPic.getFileName(), tmpUrl, new ByteArrayInputStream(bos.toByteArray())));
        }
        return fileItems;
    }

    private void createThumbnailsForSmallImage(ByteArrayInputStream bis, ByteArrayOutputStream bos, String scale, Integer width, Integer height, double rotateDegree) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)scale) && NumberUtils.isNumber((String)scale)) {
            if (rotateDegree > 1.0) {
                ImageUtils.rotateAndscale((InputStream)bis, (OutputStream)bos, (double)rotateDegree, (double)Double.parseDouble(scale));
            } else {
                ImageUtils.scale((InputStream)bis, (OutputStream)bos, (double)Double.parseDouble(scale));
            }
        } else if (width != null && height != null) {
            ImageUtils.scale((InputStream)bis, (OutputStream)bos, (int)width, (int)height);
        } else {
            throw new IllegalArgumentException("params error: thumbnails scale is Illegal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThumbnailsForBigImage(OutputStream out, Integer widthDist, Integer heightDist, Double rate, byte[] srcPicBytes) throws IOException {
        int srcWidth = 0;
        int srcHeight = 0;
        Graphics graphics = null;
        try {
            ImageIcon imageIcon = new ImageIcon(srcPicBytes);
            Image srcImage = imageIcon.getImage();
            srcWidth = imageIcon.getIconWidth();
            srcHeight = imageIcon.getIconHeight();
            if (srcWidth == 0 || srcHeight == 0 || srcWidth == -1 || srcHeight == -1) {
                return;
            }
            if (rate != null && rate > 0.0) {
                widthDist = (int)((double)srcWidth * rate);
                heightDist = (int)((double)srcHeight * rate);
            }
            BufferedImage bufferedImage = new BufferedImage(widthDist, heightDist, 1);
            graphics = bufferedImage.getGraphics();
            graphics.drawImage(srcImage, 0, 0, widthDist, heightDist, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            srcImage.flush();
            bufferedImage.flush();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            out.close();
        }
    }

    private FileItem createFileItem(String fileName, String path, InputStream in) {
        FileItemExt fileItemExt = new FileItemExt(fileName, path, in);
        fileItemExt.setSource(FileSource.PICTURE_FIELD);
        return fileItemExt;
    }
}

