/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.sys.ListPageServiceImpl;
import kd.bos.nocode.util.ListConfigUtils;

public class ListOrderServiceImpl {
    private static final Log log = LogFactory.getLog(ListPageServiceImpl.class);

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a{}", param);
        if (param instanceof RestApiSaveParam) {
            ListOrderServiceSaveImpl saveService = new ListOrderServiceSaveImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"ListOrderServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private static class ListOrderServiceSaveImpl
    implements SaveRestApiService {
        private ListOrderServiceSaveImpl() {
        }

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            RestApiSaveResult result = new RestApiSaveResult();
            RestApiResponse response = new RestApiResponse();
            String orderBy = "";
            for (Map item : param.getDataList()) {
                List orderInfo = (List)item.get("orderInfo");
                orderBy = ListConfigUtils.buildOrderInfo((List)orderInfo);
            }
            response.setData((Object)result);
            result.setSuccessCount((long)param.getDataList().size());
            result.getExtra().put("orderBy", orderBy);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }
}

