/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.sys.repository.ListPageRepository;
import kd.bos.nocode.restapi.service.sys.repository.impl.ListPageRepositoryImpl;
import kd.bos.nocode.util.ListConfigUtils;

public class ListPageServiceImpl {
    private static final Log log = LogFactory.getLog(ListPageServiceImpl.class);
    private final ListPageRepository listPageRepository = new ListPageRepositoryImpl();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a{}", param);
        if (param instanceof RestApiSaveParam) {
            ListPageServiceSaveImpl saveService = new ListPageServiceSaveImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"ListPageServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private class ListPageServiceSaveImpl
    implements SaveRestApiService {
        private ListPageServiceSaveImpl() {
        }

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            RestApiSaveResult result = new RestApiSaveResult();
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            String env = (String)param.getRequest().getHttpQueryString().get("env");
            for (Map item : param.getDataList()) {
                String appId = (String)item.get("appId");
                String formId = (String)item.get("formId");
                long userId = ListConfigUtils.getDBUserIdByEnv((String)env);
                int pageSize = (Integer)item.get("pageSize");
                ListPageServiceImpl.this.listPageRepository.save(appId, formId, userId, pageSize);
            }
            result.setSuccessCount((long)param.getDataList().size());
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }
}

