/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.NotNull;

public class ListSchemaApiServiceImpl {
    private static final Log log = LogFactory.getLog(ListSchemaApiServiceImpl.class);
    public static final String FORM_ID = "formId";
    public static final String SORT = "sort";
    public static final String SCHEMA_IDS = "schemaIds";
    public static final String USER_ID = "userId";
    public static final String SCHEMA_ID = "schemaId";
    public static final String INDEX = "index";
    private final ListSchemaService listSchemaService = ListSchemaService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            ListSchemaSaveApiServiceImpl saveService = new ListSchemaSaveApiServiceImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            ListSchemaQueryApiServiceImpl queryService = new ListSchemaQueryApiServiceImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            ListSchemaDeleteApiServiceImpl deleteService = new ListSchemaDeleteApiServiceImpl();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"ListSchemaApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private class ListSchemaDeleteApiServiceImpl
    implements DeleteRestApiService {
        private ListSchemaDeleteApiServiceImpl() {
        }

        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListSchemaApiServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"ListSchemaApiServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s\uff0c\u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"ListSchemaApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[]{Integer.MAX_VALUE}));
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            for (Object pkId : pkIds) {
                try {
                    ListSchemaApiServiceImpl.this.listSchemaService.delete((Long)pkId);
                    RestBaseFilterItemData data = new RestBaseFilterItemData();
                    data.setId(String.valueOf(pkId));
                    data.setBillStatus(true);
                    resultsData.add(data);
                }
                catch (Exception e) {
                    log.debug("\u5220\u9664\u5217\u8868\u89c6\u56fe\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                    RestBaseFilterItemData data = new RestBaseFilterItemData();
                    data.setId(String.valueOf(pkId));
                    data.setBillStatus(false);
                    data.getErrors().add(e.getMessage());
                    resultsData.add(data);
                }
            }
            long endTime = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(endTime - start));
        }
    }

    private class ListSchemaQueryApiServiceImpl
    implements QueryRestApiService {
        private ListSchemaQueryApiServiceImpl() {
        }

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            long userId = RequestContext.get().getCurrUserId();
            String formId = (String)param.getRequest().getHttpQueryString().get(ListSchemaApiServiceImpl.FORM_ID);
            List<Map<String, Object>> rows = ListSchemaApiServiceImpl.this.listSchemaService.get(userId, formId);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(rows), (long)startTime, (long)endTime);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            return response;
        }
    }

    private class ListSchemaSaveApiServiceImpl
    implements SaveRestApiService {
        private ListSchemaSaveApiServiceImpl() {
        }

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            if (param.getRequest().getUrl().endsWith(ListSchemaApiServiceImpl.SORT)) {
                return this.sortSchema(param);
            }
            List dataList = param.getDataList();
            ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(dataList.size());
            for (Map dataItem : dataList) {
                DynamicObject schemaObj;
                boolean existPkId = this.existPkId(dataItem);
                try {
                    String copySchemaId;
                    schemaObj = !existPkId ? (StringUtils.isEmpty((CharSequence)(copySchemaId = (String)dataItem.get("copySchemaId"))) ? ListSchemaApiServiceImpl.this.listSchemaService.add(dataItem) : ListSchemaApiServiceImpl.this.listSchemaService.copy(dataItem)) : ListSchemaApiServiceImpl.this.listSchemaService.update(dataItem);
                }
                catch (Exception e) {
                    log.debug("\u4fdd\u5b58\u5217\u8868\u89c6\u56fe\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                    RestApiSaveItemData apiSaveData = this.getErrorSaveItemData(dataItem, existPkId, e);
                    saveItemDataList.add(apiSaveData);
                    continue;
                }
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                apiSaveData.setId(String.valueOf(schemaObj.getPkValue()));
                apiSaveData.setBillStatus(true);
                apiSaveData.setType(existPkId ? "Update" : "Add");
                saveItemDataList.add(apiSaveData);
            }
            return this.getSaveResultData(saveItemDataList, startTime);
        }

        private RestApiServiceData<RestApiSaveResult> sortSchema(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            long userId = RequestContext.get().getCurrUserId();
            for (Map dataItem : param.getDataList()) {
                DynamicObject[] schemas;
                String formId = (String)dataItem.get(ListSchemaApiServiceImpl.FORM_ID);
                List schemaIds = (List)dataItem.get(ListSchemaApiServiceImpl.SCHEMA_IDS);
                QFilter userFilter = new QFilter(ListSchemaApiServiceImpl.USER_ID, "=", (Object)userId);
                QFilter formFilter = new QFilter(ListSchemaApiServiceImpl.FORM_ID, "=", (Object)formId);
                QFilter[] filters = new QFilter[]{formFilter, userFilter};
                for (DynamicObject schema : schemas = BusinessDataServiceHelper.load((String)"bos_nocode_userschema", (String)"schemaId,index", (QFilter[])filters)) {
                    long schemaId = schema.getLong(ListSchemaApiServiceImpl.SCHEMA_ID);
                    schema.set(ListSchemaApiServiceImpl.INDEX, (Object)schemaIds.indexOf(schemaId + ""));
                }
                SaveServiceHelper.save((DynamicObject[])schemas);
            }
            return this.getSaveResultData(new ArrayList<RestApiSaveItemData>(), startTime);
        }

        private boolean existPkId(Map<String, Object> dataItem) {
            String id = (String)dataItem.get("id");
            return StringUtils.isNotEmpty((CharSequence)id);
        }

        @NotNull
        private RestApiSaveItemData getErrorSaveItemData(Map<String, Object> dataItem, boolean existPkId, Exception e) {
            RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
            HashSet<String> msg = new HashSet<String>(1);
            msg.add(e.getMessage());
            errorData.setRowMsg(msg);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setId(existPkId ? (String)dataItem.get("id") : "");
            apiSaveData.setBillStatus(false);
            apiSaveData.setType(existPkId ? "Update" : "Add");
            apiSaveData.getErrors().add(errorData);
            return apiSaveData;
        }

        private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
            RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            boolean allMatch = saveItemDataList.stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(endTime - startTime));
        }
    }
}

