/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.bo.ListStatConfigBO;
import kd.bos.nocode.restapi.bo.ListStatValidateBO;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandler;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsHandlerRegistry;
import kd.bos.nocode.restapi.service.statistics.FieldStatisticsService;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.constant.StatPanelTypeEnum;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.validator.BeanValidator;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ListStatConfigServiceImpl {
    private static final Log log = LogFactory.getLog(ListStatConfigServiceImpl.class);
    private static final String STAT_INFO = "statinfo";
    private static final String SELECTED_PROPERTIES = "id,appid,formid,userid,statinfo,creator,createdate,modifier,modifydate";
    public static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a{}", param);
        if (param instanceof RestApiQueryParam) {
            ListStatConfigServiceQueryImpl queryService = new ListStatConfigServiceQueryImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiSaveParam) {
            ListStatConfigServiceSaveImpl saveService = new ListStatConfigServiceSaveImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"ListStatConfigServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static void checkParam(String appId, String formId, String env) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)ResManager.loadKDString((String)"appId\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListStatConfigServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)formId), (Object)ResManager.loadKDString((String)"formId\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListStatConfigServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)env), (Object)ResManager.loadKDString((String)"env\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListStatConfigServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private static class ListStatConfigServiceSaveImpl
    implements SaveRestApiService {
        private ListStatConfigServiceSaveImpl() {
        }

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            RestApiSaveResult result = new RestApiSaveResult();
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            for (Map map : param.getDataList()) {
                String appId = (String)map.get("appid");
                String formId = (String)map.get("formid");
                String env = (String)param.getRequest().getHttpQueryString().get("env");
                ListStatConfigServiceImpl.checkParam(appId, formId, env);
                long userId = ListConfigUtils.getDBUserIdByEnv((String)env);
                JSONArray statInfo = (JSONArray)map.get(ListStatConfigServiceImpl.STAT_INFO);
                if (CollectionUtils.isEmpty((Collection)statInfo)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (String)"ListStatConfigServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                List statRows = statInfo.toJavaList(ListStatConfigBO.class);
                QFilter[] qFilters = ListConfigUtils.getQFilters((String)appId, (String)formId, (long)userId);
                DynamicObject saveObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_statconfig", (String)ListStatConfigServiceImpl.SELECTED_PROPERTIES, (QFilter[])qFilters);
                if (Objects.isNull(saveObj)) {
                    saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_statconfig");
                    saveObj.set("appid", (Object)appId);
                    saveObj.set("formid", (Object)formId);
                    saveObj.set("userid", (Object)userId);
                    saveObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                    saveObj.set("createdate", (Object)new Date());
                }
                saveObj.set(ListStatConfigServiceImpl.STAT_INFO, (Object)this.getStatRowStr(statRows, saveObj.getString(ListStatConfigServiceImpl.STAT_INFO)));
                saveObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                saveObj.set("modifydate", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveObj});
            }
            result.setSuccessCount((long)param.getDataList().size());
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private String getStatRowStr(List<ListStatConfigBO> statRows, String oldStatInfo) {
            if (StringUtils.isEmpty((CharSequence)oldStatInfo)) {
                return SerializationUtils.toJsonString(statRows);
            }
            Set fieldNameSet = statRows.stream().map(ListStatConfigBO::getFieldName).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(fieldNameSet) || fieldNameSet.size() > 1) {
                throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (String)"ListStatConfigServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            this.checkStatRows(statRows);
            ListStatConfigBO requestConfigBO = statRows.get(0);
            String fieldName = requestConfigBO.getFieldName();
            String rptType = requestConfigBO.getRptType();
            List oldStatInfoList = SerializationUtils.fromJsonStringToList((String)oldStatInfo, ListStatConfigBO.class);
            oldStatInfoList.removeIf(e -> Objects.equals(fieldName, e.getFieldName()));
            if (!Objects.equals("none", rptType)) {
                oldStatInfoList.add(requestConfigBO);
            }
            return SerializationUtils.toJsonString((Object)oldStatInfoList);
        }

        private void checkStatRows(List<ListStatConfigBO> statRows) {
            Set<ConstraintViolation<ListStatValidateBO>> violations = BeanValidator.validate(new ListStatValidateBO(statRows));
            if (CollectionUtils.isNotEmpty(violations)) {
                StringBuilder sb = new StringBuilder();
                for (ConstraintViolation<ListStatValidateBO> violation : violations) {
                    sb.append(String.format("%s%s", violation.getPropertyPath(), violation.getMessage()));
                }
                throw new RestApiException(sb.toString());
            }
        }
    }

    public static class ListStatConfigServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            long startTime = System.currentTimeMillis();
            String appId = (String)param.getRequest().getHttpQueryString().get("appid");
            String formId = (String)param.getRequest().getHttpQueryString().get("formid");
            String env = (String)param.getRequest().getHttpQueryString().get("env");
            ListStatConfigServiceImpl.checkParam(appId, formId, env);
            List<Map<String, Object>> configuredStatInfo = this.getConfiguredStatInfo(appId, formId, env);
            Map httpQueryString = param.getRequest().getHttpQueryString();
            String filterStr = param.getRequest().getFilter();
            String searchText = (String)httpQueryString.get("search");
            Object[] filters = FilterUtil.getQFilters(formId, filterStr, searchText);
            String schemaId = (String)httpQueryString.get("schemaId");
            if (StringUtils.isNotEmpty((CharSequence)schemaId)) {
                filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])ListSchemaService.create().getSchemaFilters(Long.parseLong(schemaId)));
            }
            List<Map<String, Object>> listStatInfo = this.getStatInfo(configuredStatInfo, formId, (QFilter[])filters);
            result.setRows(listStatInfo);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        public List<Map<String, Object>> getStatInfo(String appId, String formId, String filterStr, String searchText) {
            List<Map<String, Object>> configuredStatInfo = this.getConfiguredStatInfo(appId, formId, NoCodeEnvironmentEnum.RUNTIME.getCode());
            return this.getStatInfo(configuredStatInfo, formId, FilterUtil.getQFilters(formId, filterStr, searchText));
        }

        private List<Map<String, Object>> getStatInfo(List<Map<String, Object>> listStatConfig, String formId, QFilter[] qFilters) {
            QFilter[] allFilters = NoCodePermHelper.combinePermFilter((String)FormMetaUtil.getAppIdByFormId((String)formId), (String)formId, (QFilter[])qFilters);
            ArrayList<Map<String, Object>> newRows = new ArrayList<Map<String, Object>>(listStatConfig.size());
            MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)formId);
            for (Map<String, Object> configRow : listStatConfig) {
                String rptType = (String)configRow.get("rptType");
                String fieldName = (String)configRow.get("fieldName");
                String panelType = (String)configRow.get("panelType");
                Optional<ReportTypeEnum> reportTypeEnumOptional = ReportTypeEnum.getByCode(rptType);
                HashMap<String, String> fieldStatInfo = new HashMap<String, String>(3);
                fieldStatInfo.put("fieldName", fieldName);
                IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldName);
                StatPanelTypeEnum currentPanelType = FieldStatisticsService.getStatPanelType(property);
                if (!currentPanelType.toString().equalsIgnoreCase(panelType)) continue;
                reportTypeEnumOptional.ifPresent(reportTypeEnum -> {
                    Map details = null;
                    if (ReportTypeEnum.GROUP == reportTypeEnum) {
                        String fieldValue = (String)configRow.get("fieldValue");
                        FieldStatisticsHandler handler = FieldStatisticsHandlerRegistry.getHandler(ReportTypeEnum.SPECIAL_GROUP_VALUE);
                        Map<String, Object> infos = handler.handle(formId, fieldName, allFilters, fieldValue);
                        details = (Map)infos.get(ReportTypeEnum.GROUP.getCode());
                    } else {
                        FieldStatisticsHandler handler = FieldStatisticsHandlerRegistry.getHandler(reportTypeEnum);
                        if (Objects.nonNull(handler)) {
                            Map<String, Object> infos = handler.handle(formId, fieldName, allFilters);
                            details = (Map)infos.get(reportTypeEnum.getCode());
                        }
                    }
                    if (details != null) {
                        details.put("rptType", rptType);
                        fieldStatInfo.put("details", (String)((Object)details));
                        newRows.add(fieldStatInfo);
                    }
                });
            }
            return newRows;
        }

        private List<Map<String, Object>> getConfiguredStatInfo(String appId, String formId, String env) {
            DynamicObject dynObj;
            long userId = RequestContext.get().getCurrUserId();
            QFilter[] designEnvFilters = ListConfigUtils.getQFilters((String)appId, (String)formId, (long)0L);
            QFilter[] runtimeEnvFilters = ListConfigUtils.getQFilters((String)appId, (String)formId, (long)userId);
            if (NoCodeEnvironmentEnum.DESIGN.getCode().equalsIgnoreCase(env)) {
                dynObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_statconfig", (String)ListStatConfigServiceImpl.SELECTED_PROPERTIES, (QFilter[])designEnvFilters);
            } else {
                dynObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_statconfig", (String)ListStatConfigServiceImpl.SELECTED_PROPERTIES, (QFilter[])runtimeEnvFilters);
                if (Objects.isNull(dynObj)) {
                    dynObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_statconfig", (String)ListStatConfigServiceImpl.SELECTED_PROPERTIES, (QFilter[])designEnvFilters);
                }
            }
            if (Objects.isNull(dynObj)) {
                return new ArrayList<Map<String, Object>>(0);
            }
            String statInfoStr = dynObj.getString(ListStatConfigServiceImpl.STAT_INFO);
            List maps = SerializationUtils.fromJsonStringToList((String)statInfoStr, Map.class);
            ListConfigUtils.clearNoExistField((String)formId, (List)maps);
            return maps;
        }
    }
}

