/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.cache.NoCodeCacheHelper;
import kd.bos.nocode.cache.NoCodeCacheService;
import kd.bos.nocode.ext.property.NoCodeGraphicDisplayProp;
import kd.bos.nocode.ext.property.NoCodeRichTextProp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.qing.QingProxyService;
import kd.bos.nocode.restapi.service.qing.StatCardRepository;
import kd.bos.nocode.restapi.service.qing.impl.QingProxyServiceImpl;
import kd.bos.nocode.restapi.service.qing.impl.StatCardRepositoryImpl;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class StatCardApiServiceImpl {
    private static final Log log = LogFactory.getLog(StatCardApiServiceImpl.class);
    public static final String ENV = "env";
    public static final String CARD_ID = "cardId";
    public static final String APP_ID = "appId";
    public static final String FORM_ID = "formId";
    public static final String USER_ID = "userId";
    public static final String CONFIG = "config";
    public static final String CACHE_PREFIX = "nc/statCard/";
    public static final String SORT = "sort";
    public static final String CACHE = "cache";
    private static final String FILTERS = "filters";
    private static final String QING_CARD_PARAMS = "qingCardParams";
    private static final String MEASURES = "measures";
    private static final String FIELD_ID = "fieldId";
    private static final String DIMENSIONS = "dimensions";
    private final QingProxyService qingProxyService;
    private final StatCardRepository statCardRepository;

    private String getArgsException() {
        return "\u53c2\u6570\u5f02\u5e38";
    }

    public StatCardApiServiceImpl() {
        this.qingProxyService = new QingProxyServiceImpl();
        this.statCardRepository = new StatCardRepositoryImpl();
    }

    public StatCardApiServiceImpl(QingProxyService qingProxyService, StatCardRepository statCardRepository) {
        this.qingProxyService = qingProxyService;
        this.statCardRepository = statCardRepository;
    }

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            StatCardServiceSaveImpl saveService = new StatCardServiceSaveImpl();
            if (Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get(SORT))) {
                return saveService.sort((RestApiSaveParam)param);
            }
            if (Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get(CACHE))) {
                return saveService.cacheParam((RestApiSaveParam)param);
            }
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            StatCardServiceQueryImpl queryService = new StatCardServiceQueryImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            StatCardServiceDeleteImpl deleteService = new StatCardServiceDeleteImpl();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.LoadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"StatCardServiceImpl_1"));
    }

    private void clearSchemaConfigCache(long userId, String formId, long schemaId) {
        String listSchemaKey = NoCodeCacheHelper.getCacheKey((String[])new String[]{"list/schema", formId});
        String cacheField = NoCodeCacheHelper.getCacheKey((String[])new String[]{formId, userId + "", schemaId + ""});
        NoCodeCacheService.getInstance().remove(listSchemaKey, cacheField);
    }

    public class StatCardServiceDeleteImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long startTime = System.currentTimeMillis();
            List cardIds = ((Map)param.getRequest().getData()).getOrDefault("cardIds", new ArrayList(0));
            if (CollectionUtils.isEmpty((Collection)cardIds)) {
                throw new RestApiException(StatCardApiServiceImpl.this.getArgsException());
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(cardIds.size());
            long userId = RequestContext.get().getCurrUserId();
            ArrayList<String> canDeleteCardIds = new ArrayList<String>(cardIds.size());
            for (String cardId : cardIds) {
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                data.setId(cardId);
                String errMsg = this.checkCardId(cardId, userId);
                if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                    data.getErrors().add(errMsg);
                    data.setBillStatus(false);
                    resultsData.add(data);
                    continue;
                }
                try {
                    List<String> deletedIds = StatCardApiServiceImpl.this.qingProxyService.deleteQingCard(Lists.newArrayList((Object[])new String[]{cardId}));
                    if (deletedIds.size() != 1) {
                        data.getErrors().add(String.format("\u8f7b\u5206\u6790\u5220\u9664\u5361\u7247\u5931\u8d25\uff0ccardId\uff1a%s", cardId));
                        data.setBillStatus(false);
                    } else {
                        data.setBillStatus(true);
                        canDeleteCardIds.add(cardId);
                    }
                }
                catch (Exception e) {
                    log.debug("\u5220\u9664\u5361\u7247\u5931\u8d25\uff1a{}\uff0ccardId: {}", new Object[]{e.getMessage(), cardId, e});
                    data.getErrors().add(e.getMessage());
                    data.setBillStatus(false);
                }
                resultsData.add(data);
            }
            if (CollectionUtils.isNotEmpty(canDeleteCardIds)) {
                StatCardApiServiceImpl.this.statCardRepository.deleteCards(canDeleteCardIds);
            }
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setTotalCount((long)cardIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(endTime - startTime));
        }

        private String checkCardId(String cardId, long currentUserId) {
            boolean isCreator;
            DynamicObject cardObj = StatCardApiServiceImpl.this.statCardRepository.getByCardId(cardId);
            boolean bl = isCreator = currentUserId == cardObj.getLong(StatCardApiServiceImpl.USER_ID);
            if (!isCreator) {
                return "\u53ea\u6709\u521b\u5efa\u4eba\u80fd\u5220\u9664\u8be5\u5361\u7247";
            }
            return "";
        }
    }

    public class StatCardServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            long userId = RequestContext.get().getCurrUserId();
            boolean isInsert = false;
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            try {
                Map<String, Object> dataMap = this.getDataMap(param);
                String formId = (String)dataMap.get(StatCardApiServiceImpl.FORM_ID);
                NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.statistic, (String)formId);
                dataMap.put(StatCardApiServiceImpl.USER_ID, userId + "");
                String cardId = (String)dataMap.get(StatCardApiServiceImpl.CARD_ID);
                if (StringUtils.isBlank((CharSequence)cardId)) {
                    isInsert = true;
                }
                if (dataMap.containsKey(StatCardApiServiceImpl.QING_CARD_PARAMS)) {
                    cardId = StatCardApiServiceImpl.this.qingProxyService.saveOrUpdateQingCard(dataMap);
                }
                dataMap.put(StatCardApiServiceImpl.CARD_ID, cardId);
                StatCardApiServiceImpl.this.statCardRepository.saveOrUpdateCard(dataMap);
                long schemaId = StatCardRepositoryImpl.LIST_SCHEMA_SERVICE.getActiveSchemaId(userId, formId);
                StatCardApiServiceImpl.this.clearSchemaConfigCache(userId, formId, schemaId);
                apiSaveData.setId(cardId);
                apiSaveData.setBillStatus(true);
            }
            catch (RestApiException e) {
                log.debug(e.getMessage(), (Object)e);
                apiSaveData.setBillStatus(false);
                apiSaveData.addError((Exception)((Object)e));
            }
            ArrayList<RestApiSaveItemData> resultList = new ArrayList<RestApiSaveItemData>(1);
            resultList.add(apiSaveData);
            RestApiSaveResult apiSaveResult = isInsert ? RestApiSaveResult.of(resultList) : RestApiSaveResult.of(null, resultList);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            if (apiSaveData.isBillStatus()) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private Map<String, Object> getDataMap(RestApiSaveParam param) {
            List dataList = param.getDataList();
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                throw new RestApiException(StatCardApiServiceImpl.this.getArgsException());
            }
            return (Map)dataList.get(0);
        }

        private boolean isDesignCard(Map<String, Object> dataMap) {
            String appId = (String)dataMap.get("cardPath");
            String formId = (String)dataMap.get(StatCardApiServiceImpl.FORM_ID);
            String cardId = (String)dataMap.get(StatCardApiServiceImpl.CARD_ID);
            long userId = 0L;
            QFilter[] qFilters = ListConfigUtils.getQFilters((String)appId, (String)formId, (long)userId);
            DynamicObject designObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_stat_card", (QFilter[])qFilters);
            if (Objects.nonNull(designObj)) {
                String config = designObj.getString(StatCardApiServiceImpl.CONFIG);
                List configInfoList = SerializationUtils.fromJsonStringToList((String)config, Map.class);
                return configInfoList.stream().anyMatch(e -> Objects.equals(e.get(StatCardApiServiceImpl.CARD_ID), cardId));
            }
            return false;
        }

        private RestApiServiceData<RestApiSaveResult> cacheParam(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            Map<String, Object> dataMap = this.getDataMap(param);
            String dataMapStr = SerializationUtils.toJsonString(dataMap);
            String cacheKey = StatCardApiServiceImpl.CACHE_PREFIX + ID.genLongId();
            NoCodeCacheService.getInstance().put(cacheKey, dataMapStr);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            apiSaveData.setBillStatus(true);
            apiSaveData.setId(cacheKey);
            ArrayList<RestApiSaveItemData> resultList = new ArrayList<RestApiSaveItemData>(1);
            resultList.add(apiSaveData);
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(resultList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
        }

        public RestApiServiceData<RestApiSaveResult> sort(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            String appId = (String)param.getRequest().getHttpQueryString().get(StatCardApiServiceImpl.APP_ID);
            String formId = (String)param.getRequest().getHttpQueryString().get(StatCardApiServiceImpl.FORM_ID);
            long userId = RequestContext.get().getCurrUserId();
            DynamicObject statCard = StatCardApiServiceImpl.this.statCardRepository.getStatCard(appId, formId, userId);
            if (Objects.isNull(statCard)) {
                throw new RestApiException("\u8be5\u8868\u5355\u6ca1\u6709\u914d\u7f6e\u7edf\u8ba1\u5361\u7247\uff0c\u65e0\u6cd5\u6392\u5e8f");
            }
            statCard.set(StatCardApiServiceImpl.CONFIG, (Object)SerializationUtils.toJsonString((Object)param.getDataList()));
            StatCardApiServiceImpl.this.statCardRepository.saveStatCard(statCard);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)new RestApiSaveResult());
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)System.currentTimeMillis());
        }
    }

    public class StatCardServiceQueryImpl
    implements QueryRestApiService {
        public static final String FORM_ID = "formId";

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            if (this.isGetQingCardParams(param)) {
                return this.getQingCardParams(param, startTime);
            }
            if (this.isGetQingCardFilterParams(param)) {
                return this.getQingCardFilterParams(param, startTime);
            }
            if (this.isGetCacheParam(param)) {
                return this.getCacheParam(param, startTime);
            }
            if (this.isGetStatField(param)) {
                return this.getStatField(param, startTime);
            }
            String formId = (String)param.getRequest().getHttpQueryString().get("formId");
            long userId = RequestContext.get().getCurrUserId();
            long activeSchemaId = StatCardRepositoryImpl.LIST_SCHEMA_SERVICE.getActiveSchemaId(userId, formId);
            List<Map<String, Object>> statCards = StatCardApiServiceImpl.this.statCardRepository.getStatCards(activeSchemaId);
            statCards = statCards.stream().filter(e -> (Boolean)e.get("display")).collect(Collectors.toList());
            return this.getQueryResponse(statCards, startTime);
        }

        private RestApiServiceData<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows, long startTime) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private RestApiServiceData<RestApiQueryResult> getStatField(RestApiQueryParam param, long startTime) {
            String formId = (String)param.getRequest().getHttpQueryString().get("formId");
            Map directFields = ListConfigUtils.getDirectFields((String)formId);
            String appId = FormMetaUtil.getAppIdByFormId((String)formId);
            Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
            for (String field : hides) {
                directFields.remove(field);
            }
            List<Map<String, Object>> dimensionsField = this.getDimensionsField(directFields);
            List<Map<String, Object>> measuresField = this.getMeasuresField(directFields);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(directFields.size());
            HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(2);
            map.put("dimensionsField", dimensionsField);
            map.put("measuresField", measuresField);
            rows.add(map);
            return this.getQueryResponse(rows, startTime);
        }

        private List<Map<String, Object>> getDimensionsField(Map<String, IDataEntityProperty> directFields) {
            ArrayList<Map<String, Object>> dimensionsField = new ArrayList<Map<String, Object>>(directFields.size());
            directFields.forEach((key, value) -> {
                if (this.canDimension((IDataEntityProperty)value)) {
                    HashMap<String, String> map = new HashMap<String, String>(3);
                    map.put("number", (String)key);
                    map.put("name", value.getDisplayName().getLocaleValue());
                    map.put("type", this.getStatCardFieldType((IDataEntityProperty)value));
                    dimensionsField.add(map);
                }
            });
            return dimensionsField;
        }

        private List<Map<String, Object>> getMeasuresField(Map<String, IDataEntityProperty> directFields) {
            ArrayList<Map<String, Object>> measuresField = new ArrayList<Map<String, Object>>(directFields.size());
            directFields.forEach((key, value) -> {
                if (this.canMeasure((IDataEntityProperty)value)) {
                    HashMap<String, String> map = new HashMap<String, String>(3);
                    map.put("number", (String)key);
                    map.put("name", value.getDisplayName().getLocaleValue());
                    map.put("type", this.getStatCardFieldType((IDataEntityProperty)value));
                    measuresField.add(map);
                }
            });
            return measuresField;
        }

        private String getStatCardFieldType(IDataEntityProperty property) {
            if (property instanceof DecimalProp) {
                return "decimal";
            }
            if (property instanceof DateTimeProp) {
                return "datetime";
            }
            return "general";
        }

        private boolean canDimension(IDataEntityProperty value) {
            return this.canMeasure(value);
        }

        private boolean canMeasure(IDataEntityProperty value) {
            return !this.canNotMeasure(value);
        }

        private boolean canNotMeasure(IDataEntityProperty value) {
            return value instanceof PictureProp || value instanceof AttachmentProp || value instanceof EntryProp || value instanceof NoCodeRichTextProp || value instanceof NoCodeGraphicDisplayProp;
        }

        private List<Map<String, Object>> getInitRuntimeConfig(RestApiQueryParam param, String selectProperties) {
            List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(10);
            QFilter[] filters = this.getQFilters(param, NoCodeEnvironmentEnum.DESIGN);
            DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_stat_card", (String)selectProperties, (QFilter[])filters);
            if (Objects.isNull(dynObj)) {
                return rows;
            }
            String config = (dynObj = this.copyToRuntime(dynObj)).getString(StatCardApiServiceImpl.CONFIG);
            if (StringUtils.isNotBlank((CharSequence)config)) {
                rows = SerializationUtils.fromJsonStringToList((String)config, Map.class);
            }
            return rows;
        }

        private boolean existRuntimeConfig(RestApiQueryParam param) {
            QFilter[] filters = this.getQFilters(param, NoCodeEnvironmentEnum.RUNTIME);
            return ORM.create().exists("bos_nocode_stat_card", filters);
        }

        private List<Map<String, Object>> mergeRows(List<Map<String, Object>> designRows, List<Map<String, Object>> runtimeRows) {
            String cardId;
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(10);
            Map designCardId2Row = designRows.stream().collect(Collectors.toMap(e -> (String)e.get(StatCardApiServiceImpl.CARD_ID), Function.identity()));
            Map runtimeCardId2Row = runtimeRows.stream().collect(Collectors.toMap(e -> (String)e.get(StatCardApiServiceImpl.CARD_ID), Function.identity()));
            Set<String> runtimeCardIds = runtimeCardId2Row.keySet();
            for (Map<String, Object> runtimeRow : runtimeRows) {
                cardId = (String)runtimeRow.get(StatCardApiServiceImpl.CARD_ID);
                if (this.isDesignCard(runtimeRow)) {
                    Map designRow = (Map)designCardId2Row.get(cardId);
                    if (!Objects.nonNull(designRow)) continue;
                    rows.add(designRow);
                    continue;
                }
                rows.add(runtimeRow);
            }
            for (Map<String, Object> designRow : designRows) {
                cardId = (String)designRow.get(StatCardApiServiceImpl.CARD_ID);
                if (runtimeCardIds.contains(cardId)) continue;
                rows.add(designRow);
            }
            return rows;
        }

        private boolean isDesignCard(Map<String, Object> runtimeRow) {
            return false;
        }

        private DynamicObject copyToRuntime(DynamicObject dynObj) {
            DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_stat_card");
            newDynObj.set(StatCardApiServiceImpl.APP_ID, dynObj.get(StatCardApiServiceImpl.APP_ID));
            newDynObj.set("formId", dynObj.get("formId"));
            newDynObj.set(StatCardApiServiceImpl.USER_ID, (Object)RequestContext.get().getCurrUserId());
            newDynObj.set(StatCardApiServiceImpl.CONFIG, dynObj.get(StatCardApiServiceImpl.CONFIG));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynObj});
            return newDynObj;
        }

        private QFilter[] getQFilters(RestApiQueryParam param, NoCodeEnvironmentEnum env) {
            Pair<Boolean, QFilter[]> filterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])filterPair.getValue();
            ArrayList filterList = Lists.newArrayList((Object[])filters);
            long userId = ListConfigUtils.getDBUserIdByEnv((NoCodeEnvironmentEnum)NoCodeEnvironmentEnum.RUNTIME);
            filterList.add(new QFilter(StatCardApiServiceImpl.USER_ID, "=", (Object)userId));
            if (param.getRequest().getHttpQueryString().containsKey(StatCardApiServiceImpl.APP_ID) && filters.length == 0) {
                filterList.add(new QFilter(StatCardApiServiceImpl.APP_ID, "=", param.getRequest().getHttpQueryString().get(StatCardApiServiceImpl.APP_ID)));
            }
            if (param.getRequest().getHttpQueryString().containsKey("formId") && filters.length == 0) {
                filterList.add(new QFilter("formId", "=", param.getRequest().getHttpQueryString().get("formId")));
            }
            return filterList.toArray(new QFilter[0]);
        }

        private boolean isGetCacheParam(RestApiQueryParam param) {
            String cacheId = (String)param.getRequest().getHttpQueryString().get("cacheId");
            return StringUtils.isNotBlank((CharSequence)cacheId);
        }

        private boolean isGetQingCardFilterParams(RestApiQueryParam param) {
            String getQingCardFilterParams = (String)param.getRequest().getHttpQueryString().get("getQingCardFilterParams");
            return Boolean.parseBoolean(getQingCardFilterParams);
        }

        private boolean isGetQingCardParams(RestApiQueryParam param) {
            String getQingCardParams = (String)param.getRequest().getHttpQueryString().get("getQingCardParams");
            return Boolean.parseBoolean(getQingCardParams);
        }

        private boolean isGetStatField(RestApiQueryParam param) {
            String getQingCardParams = (String)param.getRequest().getHttpQueryString().get("getStatField");
            return Boolean.parseBoolean(getQingCardParams);
        }

        private RestApiServiceData<RestApiQueryResult> getCacheParam(RestApiQueryParam param, long startTime) {
            String cacheId = (String)param.getRequest().getHttpQueryString().get("cacheId");
            String dataMapStr = NoCodeCacheService.getInstance().get(cacheId);
            Map dataMap = StringUtils.isEmpty((CharSequence)dataMapStr) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)dataMapStr, Map.class);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            rows.add(dataMap);
            return this.getQueryResponse(rows, startTime);
        }

        private RestApiServiceData<RestApiQueryResult> getQingCardParams(RestApiQueryParam param, long startTime) {
            String id = (String)param.getRequest().getHttpQueryString().get("id");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RestApiException(StatCardApiServiceImpl.this.getArgsException());
            }
            Map<String, Object> allParams = StatCardApiServiceImpl.this.qingProxyService.getQingCardParams(id);
            String formId = (String)allParams.get("formId");
            if (!FormMetadataUtils.existByFormNumber((String)formId)) {
                throw new RestApiException("\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
            }
            if (!NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId)) {
                throw new RestApiException("\u65e0\u8868\u5355\u6743\u9650");
            }
            this.clearInvalidParams(allParams, formId);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            rows.add(allParams);
            return this.getQueryResponse(rows, startTime);
        }

        private void clearInvalidParams(Map<String, Object> allParams, String formId) {
            Optional.ofNullable(allParams.get(StatCardApiServiceImpl.FILTERS)).map(e -> (List)e).ifPresent(e -> ListFilterConfigUtils.clearInvalidFilterRows(formId, e));
            Optional.ofNullable(allParams.get(StatCardApiServiceImpl.QING_CARD_PARAMS)).map(e -> ((Map)e).get(StatCardApiServiceImpl.MEASURES)).map(e -> (List)e).ifPresent(e -> ListConfigUtils.clearNoExistField((String)formId, (List)e, (String)StatCardApiServiceImpl.FIELD_ID));
            Optional.ofNullable(allParams.get(StatCardApiServiceImpl.QING_CARD_PARAMS)).map(e -> ((Map)e).get(StatCardApiServiceImpl.DIMENSIONS)).map(e -> (List)e).ifPresent(e -> ListConfigUtils.clearNoExistField((String)formId, (List)e, (String)StatCardApiServiceImpl.FIELD_ID));
        }

        private RestApiServiceData<RestApiQueryResult> getQingCardFilterParams(RestApiQueryParam param, long startTime) {
            String id = (String)param.getRequest().getHttpQueryString().get("id");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RestApiException(StatCardApiServiceImpl.this.getArgsException());
            }
            Map<String, Object> cardFilterParams = StatCardApiServiceImpl.this.qingProxyService.getQingCardFilterParams(id);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            rows.add(cardFilterParams);
            return this.getQueryResponse(rows, startTime);
        }
    }
}

