/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.entity.AdminOrgTreeNode;
import kd.bos.nocode.restapi.api.TreeQueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiTreeQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestApiTreeQueryResult;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NoCodeOrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SysAdminOrgServiceImpl {
    private static final Log log = LogFactory.getLog(SysAdminOrgServiceImpl.class);
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ISLEAF = "isleaf";
    private static final String PARENTID = "parentid";
    private static final String PARENTNAME = "parentname";
    private static final String CHILDREN = "children";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        log.debug(ResManager.loadKDString((String)"\u4f01\u4e1a\u4fe1\u606f\u5904\u7406\u8bf7\u6c42\u53c2\u6570\uff1a%s", (String)"SysAdminOrgServiceImpl_0", (String)"BOS_NOCODE", (Object[])new Object[]{param}));
        if (param instanceof RestApiTreeQueryParam) {
            AdminOrgServiceQueryImpl adminOrgServiceQuery = new AdminOrgServiceQueryImpl();
            return adminOrgServiceQuery.execute((RestApiTreeQueryParam)param);
        }
        throw new RestApiException(CommonConstants.getUnSupportedRequest());
    }

    private static class AdminOrgServiceQueryImpl
    implements TreeQueryRestApiService {
        private AdminOrgServiceQueryImpl() {
        }

        public RestApiServiceData<RestApiTreeQueryResult> execute(RestApiTreeQueryParam param) {
            long startTime = System.currentTimeMillis();
            String scope = param.getRequest().getHttpQueryString().getOrDefault("withScope", "false");
            List orgTree = NoCodeOrgServiceHelper.getOrgTreeFromCosmic((boolean)"true".equals(scope));
            List<Map<String, Object>> rows = this.toRows(orgTree);
            RestApiResponse response = new RestApiResponse();
            RestApiTreeQueryResult result = new RestApiTreeQueryResult();
            result.setRows(rows);
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private List<Map<String, Object>> toRows(List<AdminOrgTreeNode> nodes) {
            if (CollectionUtils.isEmpty(nodes)) {
                return Lists.newArrayList();
            }
            return nodes.stream().map(node -> {
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                map.put(SysAdminOrgServiceImpl.ID, node.getId());
                map.put(SysAdminOrgServiceImpl.NUMBER, node.getNumber());
                map.put(SysAdminOrgServiceImpl.NAME, node.getName());
                map.put(SysAdminOrgServiceImpl.ISLEAF, node.getLeaf());
                map.put(SysAdminOrgServiceImpl.PARENTID, node.getParentId());
                map.put(SysAdminOrgServiceImpl.PARENTNAME, node.getParentName());
                map.put(SysAdminOrgServiceImpl.CHILDREN, this.toRows(node.getChildren()));
                return map;
            }).collect(Collectors.toList());
        }
    }
}

