/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.DataRule;
import kd.bos.permission.nocode.model.DataRuleTypeEnum;
import kd.bos.permission.nocode.model.EntityPerm;
import kd.bos.permission.nocode.model.PermItem;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.permission.nocode.model.RoleTypeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import org.jetbrains.annotations.NotNull;

public class SysAdminServiceImpl {
    private static final Log log = LogFactory.getLog(SysAdminServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_DESC = "desc";
    private static final String PROP_SEQ = "seq";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            AdminServiceSaveImpl adminServiceSave = new AdminServiceSaveImpl();
            return adminServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            AdminServiceQueryImpl adminServiceQuery = new AdminServiceQueryImpl();
            return adminServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            AdminDeleteServiceImpl adminServiceDelete = new AdminDeleteServiceImpl();
            return adminServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysAdminServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class AdminDeleteServiceImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long start = System.currentTimeMillis();
            NoCodePermHelper.verifyPlatManage();
            Map data = (Map)param.getRequest().getData();
            List list = (List)data.get("data");
            String id = (String)((Map)list.get(0)).get(SysAdminServiceImpl.PROP_ID);
            RolePerm role = NoCodePermissionServiceHelper.getRolePerm((String)id);
            if (role == null) {
                throw new RestApiException("unknown role");
            }
            NoCodePermissionServiceHelper.deleteRole((Role)role);
            RestApiDeleteResult ret = new RestApiDeleteResult();
            RestBaseFilterItemData item = new RestBaseFilterItemData();
            if (!role.getErrors().isEmpty()) {
                item.setBillStatus(false);
                item.setErrors(new ArrayList(role.getErrors()));
                ret.setSuccessCount(0L);
                ret.setFailCount(1L);
            } else {
                item.setId(id);
                item.setBillStatus(true);
                ret.setSuccessCount(1L);
                ret.setFailCount(0L);
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(1);
            resultsData.add(item);
            long end = System.currentTimeMillis();
            ret.setTotalCount(1L);
            ret.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }
    }

    public static class AdminServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            log.debug("nocode AppServiceQueryImpl execute begin");
            long startTime = System.currentTimeMillis();
            NoCodePermHelper.verifyPlatManage();
            ArrayList ret = new ArrayList(64);
            List<Object> roles = new ArrayList();
            String appid = "2HGKTA7HH43C";
            if (param.getRequest().getHttpQueryString().containsKey("roleId")) {
                String roleId = (String)param.getRequest().getHttpQueryString().get("roleId");
                RolePerm role = NoCodePermissionServiceHelper.getRolePerm((String)roleId);
                if (role != null) {
                    roles = Collections.singletonList(role);
                }
            } else {
                roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
            }
            Set<Long> uids = roles.stream().filter(RolePerm.class::isInstance).map(r -> (RolePerm)r).map(RolePerm::getAssignUserIds).flatMap(Collection::stream).collect(Collectors.toSet());
            Set<Long> oids = roles.stream().filter(RolePerm.class::isInstance).map(r -> (RolePerm)r).map(RolePerm::getAssignOrgIds).flatMap(Collection::stream).collect(Collectors.toSet());
            Map<Long, Pair<String, String>> userInfos = AdminServiceQueryImpl.getInfos(uids, "bos_user");
            Map<Long, Pair<String, String>> orgInfos = AdminServiceQueryImpl.getInfos(oids, "bos_org");
            roles.sort(Comparator.comparingInt(Role::getSortCode));
            for (Role role : roles) {
                LinkedHashMap<String, Object> role2 = new LinkedHashMap<String, Object>();
                ret.add(role2);
                role2.put(SysAdminServiceImpl.PROP_ID, role.getId());
                role2.put(SysAdminServiceImpl.PROP_NAME, NoCodePermHelper.getRoleName((String)role.getName()));
                role2.put(SysAdminServiceImpl.PROP_DESC, role.getDescription());
                role2.put(SysAdminServiceImpl.PROP_SEQ, role.getSortCode());
                if (role instanceof RolePerm) {
                    HashMap<String, Object> map;
                    RolePerm _role = (RolePerm)role;
                    for (Long orgId : _role.getAssignOrgIds()) {
                        List orgs = (List)role2.computeIfAbsent("orgs", s -> new ArrayList());
                        map = new HashMap<String, Object>();
                        if (!orgInfos.containsKey(orgId)) continue;
                        orgs.add(map);
                        map.put(SysAdminServiceImpl.PROP_ID, orgId);
                        map.put(SysAdminServiceImpl.PROP_NAME, orgInfos.get(orgId).getKey());
                        map.put(SysAdminServiceImpl.PROP_NUMBER, orgInfos.get(orgId).getValue());
                    }
                    for (Long userId : _role.getAssignUserIds()) {
                        List users = (List)role2.computeIfAbsent("users", s -> new ArrayList());
                        map = new HashMap();
                        if (!userInfos.containsKey(userId)) continue;
                        users.add(map);
                        map.put(SysAdminServiceImpl.PROP_ID, userId);
                        map.put(SysAdminServiceImpl.PROP_NAME, userInfos.get(userId).getKey());
                        map.put(SysAdminServiceImpl.PROP_NUMBER, userInfos.get(userId).getValue());
                    }
                    Map entityPermMap = _role.getEntityNumberPermMap();
                    if (_role.getAppManageType() != AppManageTypeEnum.ALL) {
                        for (Map.Entry entry : entityPermMap.entrySet()) {
                            String key;
                            Map<Long, Pair<String, String>> info;
                            EntityPerm perm = (EntityPerm)entry.getValue();
                            String rule = perm.getDataRule().getNoCodeRule();
                            JSONArray array = JSONArray.parseArray((String)rule);
                            JSONArray value = array.getJSONObject(0).getJSONArray("value");
                            ArrayList<Long> ids = new ArrayList<Long>();
                            for (int i = 0; i < value.size(); ++i) {
                                JSONObject json = value.getJSONObject(i);
                                String id = json.getString("fieldValue");
                                ids.add(Long.parseLong(id));
                            }
                            if (perm.getEntityNumber().equals(EntityPerm.createOrgEntityInstance().getEntityNumber())) {
                                info = AdminServiceQueryImpl.getInfos(ids, "bos_org");
                                key = "orgScope";
                            } else {
                                info = AdminServiceQueryImpl.getInfos(ids, "bos_user");
                                key = "userScope";
                            }
                            for (Long id : ids) {
                                List list = (List)role2.computeIfAbsent(key, s -> new ArrayList());
                                HashMap<String, Object> map2 = new HashMap<String, Object>();
                                if (!info.containsKey(id)) continue;
                                list.add(map2);
                                map2.put(SysAdminServiceImpl.PROP_ID, id);
                                map2.put(SysAdminServiceImpl.PROP_NAME, info.get(id).getKey());
                                map2.put(SysAdminServiceImpl.PROP_NUMBER, info.get(id).getValue());
                            }
                        }
                    }
                }
                role2.put("manage", role.getAppManageType() == AppManageTypeEnum.ALL);
                role2.put("create", role.getAppUseType() == AppUseTypeEnum.CUSTOM);
            }
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(ret);
            result.setTotalCount(roles.size());
            RestApiResponse restApiResponse = new RestApiResponse();
            restApiResponse.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)restApiResponse, (long)startTime, (long)endTime);
        }

        @NotNull
        private static Map<Long, Pair<String, String>> getInfos(Collection<Long> uids, String entity) {
            HashMap<Long, Pair<String, String>> ret = new HashMap<Long, Pair<String, String>>();
            if (!uids.isEmpty()) {
                QFilter[] filters = new QFilter[]{new QFilter(SysAdminServiceImpl.PROP_ID, "in", uids)};
                String select = String.join((CharSequence)",", SysAdminServiceImpl.PROP_NUMBER, SysAdminServiceImpl.PROP_NAME);
                Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)entity, (String)select, (QFilter[])filters);
                for (Map.Entry entry : dynamicObjects.entrySet()) {
                    String name = ((DynamicObject)entry.getValue()).getString(SysAdminServiceImpl.PROP_NAME);
                    String number = ((DynamicObject)entry.getValue()).getString(SysAdminServiceImpl.PROP_NUMBER);
                    ret.put((Long)entry.getKey(), (Pair<String, String>)new Pair((Object)name, (Object)number));
                }
            }
            return ret;
        }
    }

    public static class AdminServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            NoCodePermHelper.verifyPlatManage();
            boolean reorder = ((Map)param.getRequest().getData()).getOrDefault("reorder", false);
            List<RestApiSaveItemData> saveIds = this.executeSave(param.getDataList(), reorder);
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(saveIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean reorder) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            if (reorder) {
                this.reorder(sourceDatas);
                return results;
            }
            Map<String, Object> dataMap = sourceDatas.get(0);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            if (((Boolean)dataMap.getOrDefault("copy", false)).booleanValue()) {
                AdminServiceSaveImpl.copyRole(dataMap, apiSaveData);
            } else {
                RolePerm role;
                String id = (String)dataMap.get(SysAdminServiceImpl.PROP_ID);
                boolean add = false;
                String appid = "2HGKTA7HH43C";
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    role = NoCodePermissionServiceHelper.getRolePerm((String)id);
                    apiSaveData.setType("Update");
                } else {
                    add = true;
                    role = new RolePerm();
                    role.setAppId(appid);
                    role.setSortCode(1);
                }
                String name = (String)dataMap.get(SysAdminServiceImpl.PROP_NAME);
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    if (name.contains("$")) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u4e0d\u53ef\u5305\u542b\u7279\u6b8a\u5b57\u7b26", (String)"SysAdminServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    name = StringUtil.cleanXSSParam((String)name);
                }
                apiSaveData.setNumber(name);
                name = NoCodePermHelper.setRoleName((String)name, (String)ID.genStringId());
                role.setName(name);
                String desc = (String)dataMap.get(SysAdminServiceImpl.PROP_DESC);
                role.setDescription(desc);
                if (add) {
                    if (!dataMap.containsKey(SysAdminServiceImpl.PROP_SEQ)) {
                        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
                        int seq = roles.stream().mapToInt(Role::getSortCode).max().orElse(0) + 1;
                        role.setSortCode(seq);
                    } else {
                        int seq = (Integer)dataMap.get(SysAdminServiceImpl.PROP_SEQ);
                        role.setSortCode(seq);
                    }
                }
                if (dataMap.containsKey("manage")) {
                    boolean manage = (Boolean)dataMap.get("manage");
                    role.setAppManageType(manage ? AppManageTypeEnum.ALL : AppManageTypeEnum.NONE);
                } else {
                    role.setAppManageType(AppManageTypeEnum.NONE);
                }
                if (dataMap.containsKey("create")) {
                    boolean manage = (Boolean)dataMap.get("create");
                    if (!manage) {
                        if (role.getAppManageType() == AppManageTypeEnum.NONE) {
                            throw new RestApiException(ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5\u7684\u914d\u7f6e", (String)"SysAdminServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
                        }
                    } else {
                        role.setAppUseType(AppUseTypeEnum.CUSTOM);
                    }
                }
                role.setRoleType(RoleTypeEnum.SYSTEM);
                role.setEntityNumberPermMap(new HashMap());
                if (role.getAppManageType().equals((Object)AppManageTypeEnum.NONE)) {
                    this.setUpScope(dataMap, role);
                }
                if (dataMap.containsKey("users")) {
                    List users = (List)dataMap.get("users");
                    Set uids = users.stream().map(u -> (String)u.get(SysAdminServiceImpl.PROP_ID)).map(Long::parseLong).collect(Collectors.toSet());
                    role.setAssignUserIds(uids);
                }
                if (dataMap.containsKey("orgs")) {
                    List orgs = (List)dataMap.get("orgs");
                    Set oids = orgs.stream().map(u -> (String)u.get(SysAdminServiceImpl.PROP_ID)).map(Long::parseLong).collect(Collectors.toSet());
                    role.setAssignOrgIds(oids);
                }
                NoCodePermissionServiceHelper.saveRolePerm((RolePerm)role);
                apiSaveData.setId(role.getId());
                if (!role.getErrors().isEmpty()) {
                    throw new RestApiException(JSON.toJSONString((Object)role.getErrors()));
                }
                apiSaveData.setBillStatus(true);
            }
            results.add(apiSaveData);
            return results;
        }

        private void setUpScope(Map<String, Object> dataMap, RolePerm role) {
            EntityPerm perm1 = EntityPerm.createUserEntityInstance();
            EntityPerm perm2 = EntityPerm.createOrgEntityInstance();
            Map map = role.getEntityNumberPermMap();
            DataRule dataRule1 = new DataRule();
            dataRule1.setType(DataRuleTypeEnum.CUSTOM);
            List users = dataMap.getOrDefault("userScope", new ArrayList());
            List collect1 = users.stream().map(u -> u.get(SysAdminServiceImpl.PROP_ID)).map(Object::toString).map(i -> Maps.of((Object)"fieldValue", (Object)i)).collect(Collectors.toList());
            JSONObject object1 = new JSONObject();
            object1.put("fieldName", (Object)SysAdminServiceImpl.PROP_ID);
            object1.put("compareType", (Object)"1501");
            object1.put("value", collect1);
            JSONArray array1 = new JSONArray();
            array1.add((Object)object1);
            dataRule1.setNoCodeRule(array1.toJSONString());
            perm1.setDataRule(dataRule1);
            map.put(perm1.getEntityNumber(), perm1);
            Map permItemMap1 = perm1.getPermItemMap();
            permItemMap1.put(FuncPermItemEnum.view.getId(), new PermItem(FuncPermItemEnum.view.getId()));
            DataRule dataRule2 = new DataRule();
            dataRule2.setType(DataRuleTypeEnum.CUSTOM);
            List orgs = dataMap.getOrDefault("orgScope", new ArrayList());
            List collect2 = orgs.stream().map(u -> u.get(SysAdminServiceImpl.PROP_ID)).map(Object::toString).map(o -> Maps.of((Object)"fieldValue", (Object)o)).collect(Collectors.toList());
            JSONObject object2 = new JSONObject();
            object2.put("fieldName", (Object)SysAdminServiceImpl.PROP_ID);
            object2.put("compareType", (Object)"1501");
            object2.put("value", collect2);
            JSONArray array2 = new JSONArray();
            array2.add((Object)object2);
            dataRule2.setNoCodeRule(array2.toJSONString());
            perm2.setDataRule(dataRule2);
            map.put(perm2.getEntityNumber(), perm2);
            Map permItemMap2 = perm2.getPermItemMap();
            permItemMap2.put(FuncPermItemEnum.view.getId(), new PermItem(FuncPermItemEnum.view.getId()));
        }

        private static void copyRole(Map<String, Object> dataMap, RestApiSaveItemData apiSaveData) {
            String id = (String)dataMap.get(SysAdminServiceImpl.PROP_ID);
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u590d\u5236\u65f6\u89d2\u8272id\u4e0d\u53ef\u4e3a\u7a7a", (String)"SysAdminServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            Role old = NoCodePermissionServiceHelper.getRole((String)id);
            String name = NoCodePermHelper.getRoleName((String)old.getName());
            name = name + ResManager.loadKDString((String)"-\u590d\u5236", (String)"SysAdminServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]);
            RolePerm rolePerm = NoCodePermissionServiceHelper.copyRolePerm((String)id, (String)(name = NoCodePermHelper.setRoleName((String)name, (String)ID.genStringId())));
            if (!rolePerm.getErrors().isEmpty()) {
                throw new RestApiException(String.join((CharSequence)",", rolePerm.getErrors()));
            }
            apiSaveData.setBillStatus(true);
        }

        private void reorder(List<Map<String, Object>> sourceDatas) {
            if (sourceDatas.isEmpty()) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (Map<String, Object> dataMap : sourceDatas) {
                String id = (String)dataMap.get(SysAdminServiceImpl.PROP_ID);
                ids.add(id);
            }
            String res = NoCodePermissionServiceHelper.updateRoleSort(ids);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                throw new RestApiException(res);
            }
        }
    }
}

