/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.constant.AppFilterEnum;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.service.qing.QingProxyService;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.restapi.service.sys.helper.MenuServiceHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcAppVersionUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.RuleServiceHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.model.EntityPerm;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.api.model.ProcessTemplate;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SysAppServiceImpl {
    private static final Log log = LogFactory.getLog(SysAppServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_VISIBLE = "visible";
    private static final String FLAG_SAVEASTEMPLATE = "saveAsTemplate";
    private static final String PROP_BIZAPPID = "bizappid";
    private static final String TEMPLATE_CONFIG = "templateConfig";
    private static final String PROP_APPID = "appid";
    private static final String PROP_LABEL = "label";
    private static final String PROP_VALUE = "value";
    private static final String ENTITY_META = "entitymeta";
    private static final String FORM_META = "formmeta";
    private static final String ITEMS = "Items";
    private static final String TABLE_NAME = "TableName";
    private static final String TYPE = "_Type_";
    private static final String BILL_ENTITY_ID_EX = "BillEntityIdEx";
    private static final String BILL_ENTITY_ID = "BillEntityId";
    private static final String PROPS_DISPLAY = "PropsDisplay";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_NAME = "name";
    private static final String PROP_ICON = "icon";
    private static final String PROP_TEMPLATEID = "templateId";
    private static final String PROP_COPYDATA = "copyData";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_DBROUTE = "dbroute";
    private static final String PROP_VERSION = "version";
    private static final String PROP_BIZCLOUD = "bizcloud";
    private static final String PROP_USERTYPE = "usertype";
    private static final String PROP_DEPLOYSTATUS = "deploystatus";
    private static final String PROP_MAINFORMTYPE = "mainformtype";
    private static final String PROP_ISV = "isv";
    private static final String PROP_CREATER = "creater";
    private static final String SHORTCUT_USER = "user";
    private static final String SHORTCUT_BIZAPP = "bizapp";
    private static final String SHORTCUT_BIZPAGE = "bizpage";
    private static final String SHORTCUT_COLLECT = "collect";
    private static final String APP_FILTER = "app_filter";
    private static final String BIZAPP = "bizapp";
    private static final String FORM = "form";
    private static final String BIZUNIT = "bizunit";
    private static final String KEY_SUCCESS = "success";
    private static final String BOS_DEVP_METADATAUNIT = "bos_devp_metadataunit";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String BOS_NOCODE_SERVICE = "bos-nocode-service";
    private static final int APP_NAME_MAX_LENGTH = 50;
    public static final int IMAGE_MAX_LENGTH = 500;
    private static final String PROP_TYPE = "type";
    private static final String PROP_CONFIG = "config";
    private static final String PROP_QING_CARD_ID = "qingCardId";
    private static final String T_META_MENURUNTIME = "T_META_MENURUNTIME";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            AppServiceSaveImpl appServiceSave = new AppServiceSaveImpl();
            return appServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            AppServiceQueryImpl appServiceQuery = new AppServiceQueryImpl();
            return appServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            AppDeleteServiceImpl appServiceDelete = new AppDeleteServiceImpl();
            return appServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysAppServiceImpl_0", (String)BOS_NOCODE_SERVICE, (Object[])new Object[0]));
    }

    public static class AppDeleteServiceImpl
    implements DeleteRestApiService {
        private static final String MULTI_TXT_NAME = "multi_txt_name";
        private static final String IDE_UNIT_TEST_DETAIL = "ide_unit_test_detail";
        private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";

        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysAppServiceImpl_16", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"SysAppServiceImpl_17", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"DeleteApiServiceImpl_1"), new Object[]{Integer.MAX_VALUE});
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            String force = param.getRequest().getHttpQueryString().getOrDefault("force", "true");
            boolean isForce = Boolean.parseBoolean(force);
            for (Object pkId : pkIds) {
                String appId = (String)pkId;
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                data.setId(appId);
                if (!NoCodePermHelper.checkUserAppManageInNoCode((Long)RequestContext.get().getCurrUserId(), (String)appId)) {
                    data.getErrors().add(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"SysAppServiceImpl_19", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
                    data.setBillStatus(false);
                    resultsData.add(data);
                    continue;
                }
                if (isForce) {
                    try {
                        AppServiceHelper.deleteApp(appId);
                    }
                    catch (Exception e) {
                        data.setBillStatus(false);
                        data.getErrors().add(e.getMessage());
                        continue;
                    }
                    data.setBillStatus(true);
                } else {
                    String deleteMsg = this.deleteAppChecking(appId);
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)deleteMsg)) {
                        try {
                            AppServiceHelper.deleteApp(appId);
                        }
                        catch (Exception e) {
                            data.setBillStatus(false);
                            data.getErrors().add(e.getMessage());
                            continue;
                        }
                        data.setBillStatus(true);
                    } else {
                        data.getErrors().add(deleteMsg);
                        data.setBillStatus(false);
                    }
                }
                resultsData.add(data);
            }
            long end = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }

        private String deleteAppChecking(String bizAppId) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> pageArray = new ArrayList<String>(10);
            ArrayList<String> scriptArray = new ArrayList<String>(10);
            ArrayList<String> unittestArray = new ArrayList<String>(10);
            String selectUnittestFields = MULTI_TXT_NAME;
            QFilter unittestFilter = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "=", (Object)bizAppId);
            QFilter[] unittestFilters = new QFilter[]{unittestFilter};
            DynamicObjectCollection docUnittest = QueryServiceHelper.query((String)IDE_UNIT_TEST_DETAIL, (String)selectUnittestFields, (QFilter[])unittestFilters);
            if (!docUnittest.isEmpty()) {
                for (DynamicObject dynamicObject : docUnittest) {
                    unittestArray.add((String)dynamicObject.get(MULTI_TXT_NAME));
                }
            }
            QFilter formFilter = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "=", (Object)bizAppId);
            String selectFormFields = "name,id";
            QFilter[] formFilters = new QFilter[]{formFilter};
            DynamicObjectCollection docForms = QueryServiceHelper.query((String)"bos_formmeta", (String)selectFormFields, (QFilter[])formFilters);
            if (!docForms.isEmpty()) {
                for (DynamicObject docForm : docForms) {
                    pageArray.add((String)docForm.get(SysAppServiceImpl.PROP_NAME));
                }
            }
            String selectScriptFields = "txt_scriptname";
            QFilter scriptFilter = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "=", (Object)bizAppId);
            QFilter[] scriptFilters = new QFilter[]{scriptFilter};
            DynamicObjectCollection docScripts = QueryServiceHelper.query((String)IDE_PLUGINSCRIPT, (String)selectScriptFields, (QFilter[])scriptFilters);
            if (!docScripts.isEmpty()) {
                for (DynamicObject docScript : docScripts) {
                    scriptArray.add((String)docScript.get("txt_scriptname"));
                }
            }
            if (!unittestArray.isEmpty()) {
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5355\u5143\u6d4b\u8bd5\uff1a", (String)"SysAppServiceImpl_20", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0])).append(String.join((CharSequence)"\u3001", unittestArray)).append("; ");
            }
            if (!pageArray.isEmpty()) {
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u9875\u9762\uff1a", (String)"SysAppServiceImpl_21", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0])).append(String.join((CharSequence)"\u3001", pageArray)).append("; ");
            }
            if (!scriptArray.isEmpty()) {
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u811a\u672c\uff1a", (String)"SysAppServiceImpl_22", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0])).append(String.join((CharSequence)"\u3001", scriptArray)).append("; ");
            }
            return sb.toString();
        }

        private boolean menuExisted(String appId) {
            String sql = String.format("Select 1 from %s where fappid='%s'", SysAppServiceImpl.T_META_MENURUNTIME, appId);
            return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> rs.next());
        }
    }

    public static class AppServiceQueryImpl
    implements QueryRestApiService {
        private static final String MODEL_TYPE = "modeltype";

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            String orderBy;
            log.debug("nocode AppServiceQueryImpl execute begin");
            if (this.isGetAppTree(param)) {
                return this.getAppTree(param);
            }
            if (this.isGetUsualApp(param)) {
                return this.getUsualApp();
            }
            long startTime = System.currentTimeMillis();
            List<QFilter> filters = this.getFilters(param);
            String selectFields = "id,number,name,image,visible,version,description,deploystatus,creater,createdate,modifier,modifydate,alluserapp";
            if (param.getSelect() != null && !param.getSelect().isEmpty()) {
                selectFields = String.join((CharSequence)",", param.getSelect());
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)(orderBy = param.getOrder_by()))) {
                orderBy = "createdate desc";
            }
            RestApiQueryResult result = new RestApiQueryResult();
            List<Map<String, Object>> rows = AppServiceHelper.getAppInfoList(filters, selectFields, orderBy, param.isDyObjResult(), param.getPage_no() - 1, param.getPage_size());
            result.setRows(rows);
            try {
                QFilter[] filterArray = filters.toArray(new QFilter[0]);
                int totalCount = ORM.create().count("totalCount", "bos_devportal_bizapp", filterArray);
                result.setTotalCount(totalCount);
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
            }
            catch (Exception e) {
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
                log.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e));
            }
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private RestApiServiceData<RestApiQueryResult> getUsualApp() {
            long startTime = System.currentTimeMillis();
            List<Map<String, Object>> rows = AppServiceHelper.getUsualAppList(-1);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(rows), (long)startTime, (long)endTime);
        }

        private boolean isGetUsualApp(RestApiQueryParam param) {
            return "true".equalsIgnoreCase((String)param.getRequest().getHttpQueryString().get("getUsualApp"));
        }

        private boolean isGetAppTree(RestApiQueryParam param) {
            return "true".equalsIgnoreCase((String)param.getRequest().getHttpQueryString().get("getAppTree"));
        }

        private RestApiServiceData<RestApiQueryResult> getAppTree(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            boolean withFormData = Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("withFormData"));
            List<Map<String, Object>> dataRows = withFormData ? this.getDataRowsWithFormData(param) : this.getDataRowsWithoutFormData();
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(dataRows);
            result.setTotalCount(dataRows.size());
            result.setLastPage(Boolean.valueOf(true));
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            return response;
        }

        private List<Map<String, Object>> getDataRowsWithoutFormData() {
            List<Map<String, Object>> appInfoList = AppServiceHelper.getAppInfoList(new ArrayList<QFilter>(0));
            return this.buildAppInfoVo(appInfoList);
        }

        private List<Map<String, Object>> buildAppInfoVo(List<Map<String, Object>> appInfoList) {
            return appInfoList.stream().map(e -> {
                HashMap map = new HashMap(3);
                map.put(SysAppServiceImpl.PROP_LABEL, e.get(SysAppServiceImpl.PROP_NAME));
                map.put(SysAppServiceImpl.PROP_VALUE, e.get(SysAppServiceImpl.PROP_ID));
                map.put(SysAppServiceImpl.PROP_IMAGE, e.get(SysAppServiceImpl.PROP_IMAGE));
                return map;
            }).collect(Collectors.toList());
        }

        private List<Map<String, Object>> getDataRowsWithFormData(RestApiQueryParam param) {
            QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)false);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            filters.add(isTemplateFilter);
            QFilter modeltypeFilter = new QFilter(MODEL_TYPE, "=", (Object)"NoCodeModel").and(new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "!=", (Object)"2HGKTA7HH43C"));
            String includeCustomPage = (String)param.getRequest().getHttpQueryString().get("includeCustomPage");
            if (Boolean.parseBoolean(includeCustomPage)) {
                QFilter customPageFilter = new QFilter(MODEL_TYPE, "=", (Object)"DynamicFormModel").and(new QFilter("bizappid.bizcloud", "=", (Object)"2HGKCE94QELW")).and(new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "!=", (Object)"2HGKTA7HH43C"));
                modeltypeFilter = modeltypeFilter.or(customPageFilter);
            }
            filters.add(modeltypeFilter);
            QFilter templateFilter = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "not in", (Object)NoCodeTemplateUtil.queryTemplateAppIds());
            filters.add(templateFilter);
            Set uids = NoCodePermissionServiceHelper.getUsableAppIds((long)RequestContext.get().getCurrUserId());
            QFilter ids = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "in", (Object)uids);
            filters.add(ids);
            filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            filters.add(new QFilter(SysAppServiceImpl.PROP_ID, "in", (Object)FormMetaUtil.getAllFormIds()));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"bos_devpn_formmeta", (String)"id, name, bizappid, bizappid.name, bizappid.image", (QFilter[])filters.toArray(new QFilter[0]), (String)"bizappid.name asc, bizappid asc, name asc");
            ArrayList<Map<String, Object>> dataRows = new ArrayList<Map<String, Object>>(10);
            long uid = RequestContext.get().getCurrUserId();
            ArrayList permItemIds = Lists.newArrayList((Object[])new String[]{FuncPermItemEnum.view.getId(), FuncPermItemEnum.input.getId()});
            Map checker = NoCodePermissionServiceHelper.getAuthorizedAppEntityNumbers((long)uid, (List)permItemIds);
            this.buildAppBillTree(bills, dataRows, null, null, param, checker);
            return dataRows;
        }

        private void buildAppBillTree(DynamicObjectCollection bills, List<Map<String, Object>> dataRows, String appId, List<Map<String, Object>> billRows, RestApiQueryParam param, Map<String, Map<String, Set<String>>> checker) {
            String op = (String)param.getRequest().getHttpQueryString().get("op");
            if (appId == null) {
                String lastAppId = null;
                for (DynamicObject bill : bills) {
                    String theAppId = (String)bill.get(SysAppServiceImpl.PROP_BIZAPPID);
                    String formid = (String)bill.get(SysAppServiceImpl.PROP_ID);
                    if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)theAppId, lastAppId) || !checker.containsKey(theAppId)) continue;
                    Map<String, Set<String>> map = checker.get(theAppId);
                    if (!map.isEmpty()) {
                        if (!map.containsKey(formid) && !map.containsKey("perm_nocode_publicentity")) continue;
                        Set<String> set = map.containsKey("perm_nocode_publicentity") ? map.get("perm_nocode_publicentity") : map.get(formid);
                        if ("input".equalsIgnoreCase(op) ? !set.contains(FuncPermItemEnum.input.getId()) : !set.contains(FuncPermItemEnum.view.getId())) continue;
                    }
                    lastAppId = theAppId;
                    JSONObject appRowData = new JSONObject();
                    appRowData.put(SysAppServiceImpl.PROP_VALUE, bill.get(SysAppServiceImpl.PROP_BIZAPPID));
                    appRowData.put(SysAppServiceImpl.PROP_LABEL, bill.get("bizappid.name"));
                    appRowData.put(SysAppServiceImpl.PROP_IMAGE, bill.get("bizappid.image"));
                    billRows = new ArrayList<Map<String, Object>>(10);
                    appRowData.put("children", billRows);
                    this.buildAppBillTree(bills, dataRows, theAppId, billRows, param, checker);
                    dataRows.add((Map<String, Object>)appRowData);
                }
            } else {
                for (DynamicObject bill : bills) {
                    String theAppId = (String)bill.get(SysAppServiceImpl.PROP_BIZAPPID);
                    String formid = (String)bill.get(SysAppServiceImpl.PROP_ID);
                    if (!kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)theAppId, (CharSequence)appId) || !checker.containsKey(theAppId)) continue;
                    Map<String, Set<String>> map = checker.get(theAppId);
                    if (!map.isEmpty()) {
                        if (!map.containsKey(formid) && !map.containsKey("perm_nocode_publicentity")) continue;
                        Set<String> set = map.containsKey("perm_nocode_publicentity") ? map.get("perm_nocode_publicentity") : map.get(formid);
                        if ("input".equalsIgnoreCase(op) ? !set.contains(FuncPermItemEnum.input.getId()) : !set.contains(FuncPermItemEnum.view.getId())) continue;
                    }
                    JSONObject row = new JSONObject();
                    String formId = (String)bill.get(SysAppServiceImpl.PROP_ID);
                    row.put(SysAppServiceImpl.PROP_VALUE, (Object)formId);
                    row.put(SysAppServiceImpl.PROP_LABEL, bill.get(SysAppServiceImpl.PROP_NAME));
                    row.put(SysAppServiceImpl.PROP_IMAGE, (Object)MenuServiceHelper.getMenuImage(theAppId, formId).orElse(""));
                    billRows.add((Map<String, Object>)row);
                }
            }
        }

        private List<QFilter> getFilters(RestApiQueryParam param) {
            String appFilter = (String)param.getRequest().getHttpQueryString().remove(SysAppServiceImpl.APP_FILTER);
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (Objects.equals(appFilter, AppFilterEnum.MY_COLLECT.getCode())) {
                QFilter myCollectFilter = this.getMyCollectFilter();
                filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)myCollectFilter);
            } else if (Objects.equals(appFilter, AppFilterEnum.MY_CREATE.getCode())) {
                QFilter myCreateFilter = new QFilter(SysAppServiceImpl.PROP_CREATER, "=", (Object)RequestContext.get().getCurrUserId());
                filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)myCreateFilter);
            }
            Set templateApps = NoCodeTemplateUtil.queryTemplateAppIds();
            QFilter notTempFilter = new QFilter(SysAppServiceImpl.PROP_ID, "not in", (Object)templateApps);
            QFilter visibleFilter = new QFilter(SysAppServiceImpl.PROP_VISIBLE, "=", (Object)"1");
            QFilter f1 = notTempFilter.and(visibleFilter);
            QFilter tempFilter = new QFilter(SysAppServiceImpl.PROP_ID, "in", (Object)templateApps);
            QFilter f2 = f1.or(tempFilter);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)f2);
            return Lists.newArrayList((Object[])filters);
        }

        private QFilter getMyCollectFilter() {
            List<String> collectBizAppIds = AppServiceHelper.getCollectedAppIdList(RequestContext.get().getCurrUserId());
            return new QFilter(SysAppServiceImpl.PROP_ID, "in", collectBizAppIds);
        }
    }

    private static class CloneResult {
        DynamicObject clone;
        Map<String, String> refMap;
        Map<String, String> roleMap;
        Set<String> pSet;

        private CloneResult() {
        }
    }

    public static class AppServiceSaveImpl
    implements SaveRestApiService {
        protected static ExecutorService pool = ThreadPools.newExecutorService((String)"NoCode-MetaData-Copy-Thread", (int)3);

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> templateList = new ArrayList<Map<String, Object>>();
            if (!param.getDataList().isEmpty() && ((Map)param.getDataList().get(0)).containsKey("createrId")) {
                Map map = (Map)param.getDataList().get(0);
                String appId = map.get("appId").toString();
                Long creatorId = Long.parseLong(map.get("createrId").toString());
                Long oldCreatorId = Long.parseLong(map.get("oldCreatorId").toString());
                RestApiResponse response = new RestApiResponse();
                try {
                    this.updateCreator(appId, creatorId, oldCreatorId);
                    long modelTimeCost = System.currentTimeMillis() - startTime;
                    ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(10);
                    RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                    apiSaveData.setId(appId);
                    results.add(apiSaveData);
                    RestApiSaveResult apiSaveResult = RestApiSaveResult.of(results);
                    response.setData((Object)apiSaveResult);
                    return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
                }
                catch (Exception e) {
                    long modelTimeCost = System.currentTimeMillis() - startTime;
                    return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)e.getMessage(), (RestApiResponse)response, (long)modelTimeCost);
                }
            }
            this.checkParam(param);
            this.classifyByKey(param, insertList, updateList, templateList);
            List<RestApiSaveItemData> insertIds = this.batchInsert(insertList);
            List<RestApiSaveItemData> updateIds = this.batchUpdate(updateList);
            List<RestApiSaveItemData> templates = this.addTemplates(templateList);
            if (insertIds.isEmpty()) {
                insertIds = new ArrayList<RestApiSaveItemData>(templates);
            } else {
                insertIds.addAll(templates);
            }
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(insertIds, updateIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            String errorMessage = apiSaveResult.getResult().stream().filter(this::isBillStatusFalse).map(this::getErrorString).collect(Collectors.joining("\uff1b"));
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)errorMessage, (RestApiResponse)response, (long)modelTimeCost);
        }

        private void updateCreator(String appId, Long creatorId, Long oldCreatorId) {
            if (creatorId.equals(oldCreatorId)) {
                return;
            }
            NoCodePermHelper.changeAdminRole((String)appId, (long)creatorId, (long)oldCreatorId);
            try {
                String sql = "update t_meta_bizapp set fcreater = ? where fid = ?";
                DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{creatorId, appId});
            }
            catch (Exception e) {
                log.debug("\u4fee\u6539\u521b\u5efa\u4eba\u5931\u8d25:" + e.getMessage());
            }
            AppMetaServiceHelper.cleanAppMetaCache((String)appId);
        }

        private String getErrorString(RestApiSaveItemData restApiSaveItemData) {
            StringBuilder sb = new StringBuilder();
            List errors = restApiSaveItemData.getErrors();
            if (!CollectionUtils.isEmpty((Collection)errors)) {
                for (RestApiSaveRowErrorData error : errors) {
                    Set rowMsg = error.getRowMsg();
                    if (CollectionUtils.isEmpty((Collection)rowMsg)) continue;
                    sb.append(String.join((CharSequence)",", rowMsg));
                }
            }
            return sb.toString();
        }

        private boolean isBillStatusFalse(RestApiSaveItemData restApiSaveItemData) {
            return !restApiSaveItemData.isBillStatus();
        }

        private void checkParam(RestApiSaveParam param) {
            for (Map dataMap : param.getDataList()) {
                if (dataMap.size() == 2 && dataMap.containsKey(SysAppServiceImpl.PROP_ID) && dataMap.containsKey(SysAppServiceImpl.SHORTCUT_COLLECT)) {
                    return;
                }
                if (dataMap.size() == 2 && dataMap.containsKey(SysAppServiceImpl.PROP_ID) && dataMap.containsKey(SysAppServiceImpl.PROP_DEPLOYSTATUS)) {
                    return;
                }
                if (dataMap.containsKey(SysAppServiceImpl.PROP_TEMPLATEID)) {
                    return;
                }
                if (dataMap.containsKey(SysAppServiceImpl.FLAG_SAVEASTEMPLATE) && ((Boolean)dataMap.get(SysAppServiceImpl.FLAG_SAVEASTEMPLATE)).booleanValue()) {
                    Map config = (Map)dataMap.get(SysAppServiceImpl.TEMPLATE_CONFIG);
                    String name = (String)config.get(SysAppServiceImpl.PROP_NAME);
                    String desc = (String)config.get("desc");
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)name)) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysAppServiceImpl_1", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
                    }
                    if (name.length() > 50) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"SysAppServiceImpl_2", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{50}));
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)desc) && desc.length() > 500) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u6a21\u677f\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"SysAppServiceImpl_3", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{500}));
                    }
                    return;
                }
                String name = (String)dataMap.get(SysAppServiceImpl.PROP_NAME);
                String image = (String)dataMap.get(SysAppServiceImpl.PROP_IMAGE);
                String description = (String)dataMap.get(SysAppServiceImpl.PROP_DESCRIPTION);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)name)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysAppServiceImpl_4", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
                }
                if (name.length() > 50) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"SysAppServiceImpl_5", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{50}));
                }
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)image)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysAppServiceImpl_6", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
                }
                if (image.length() > 500) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u56fe\u6807\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"SysAppServiceImpl_7", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{500}));
                }
                if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)description) || description.length() <= 500) continue;
                throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"SysAppServiceImpl_8", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{500}));
            }
        }

        protected void classifyByKey(RestApiSaveParam param, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList, List<Map<String, Object>> templateList) {
            for (Map dataMap : param.getDataList()) {
                String id = (String)dataMap.get(SysAppServiceImpl.PROP_ID);
                if (dataMap.containsKey(SysAppServiceImpl.FLAG_SAVEASTEMPLATE) && ((Boolean)dataMap.get(SysAppServiceImpl.FLAG_SAVEASTEMPLATE)).booleanValue()) {
                    templateList.add(dataMap);
                    continue;
                }
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)id)) {
                    insertList.add(dataMap);
                    continue;
                }
                dataMap.put(SysAppServiceImpl.PROP_ID, id);
                updateList.add(dataMap);
            }
        }

        private List<RestApiSaveItemData> batchInsert(List<Map<String, Object>> insertList) {
            if (CollectionUtils.isEmpty(insertList)) {
                return Collections.emptyList();
            }
            boolean check = NoCodePermHelper.checkUserAppCreateInNoCode();
            if (!check) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u521b\u5efa\u5e94\u7528", (String)"SysAppServiceImpl_9", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
            }
            return this.executeSave(insertList, true);
        }

        private List<RestApiSaveItemData> batchUpdate(List<Map<String, Object>> updateList) {
            if (CollectionUtils.isEmpty(updateList)) {
                return Collections.emptyList();
            }
            return this.executeSave(updateList, false);
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            int len = sourceDatas.size();
            for (int i = 0; i < len; ++i) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                Map<String, Object> dataMap = sourceDatas.get(i);
                if (dataMap.containsKey(SysAppServiceImpl.SHORTCUT_COLLECT) && dataMap.containsKey(SysAppServiceImpl.PROP_ID) && dataMap.size() == 2) {
                    NoCodePermHelper.verifyUsePerm((String)((String)dataMap.get(SysAppServiceImpl.PROP_ID)));
                    this.updateMyCollect(dataMap);
                    apiSaveData.setId((String)dataMap.get(SysAppServiceImpl.PROP_ID));
                    apiSaveData.setNumber((String)dataMap.get(SysAppServiceImpl.PROP_ID));
                    apiSaveData.setBillStatus(true);
                    results.add(apiSaveData);
                    continue;
                }
                DynamicObject app = null;
                try {
                    HashSet<String> msg;
                    RestApiSaveRowErrorData restApiSaveRowErrorData;
                    String name = (String)dataMap.get(SysAppServiceImpl.PROP_NAME);
                    String templateid = (String)dataMap.get(SysAppServiceImpl.PROP_TEMPLATEID);
                    if (isInsert) {
                        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)templateid)) {
                            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bos_nocode_templateconfig");
                            if (template == null) {
                                restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                                msg = new HashSet<String>(1);
                                msg.add(ResManager.loadKDString((String)"\u8bfb\u53d6\u5e94\u7528\u6a21\u677fid\u5931\u8d25:%s", (String)"SysAppServiceImpl_10", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{templateid}));
                                restApiSaveRowErrorData.setRowMsg(msg);
                                apiSaveData.getErrors().add(restApiSaveRowErrorData);
                                results.add(apiSaveData);
                                continue;
                            }
                            String appid = template.getString(SysAppServiceImpl.PROP_APPID);
                            String icon = template.getString(SysAppServiceImpl.PROP_ICON);
                            boolean copyData = (Boolean)dataMap.getOrDefault(SysAppServiceImpl.PROP_COPYDATA, false);
                            CloneResult result = this.cloneAnApp(appid, dataMap, copyData, icon, false);
                            app = result.clone;
                            Map<String, String> refMap = result.refMap;
                            List templates_workflow = NoCodeWorkflowServiceHelper.getProcessTemplatesByAppId((String)appid);
                            if (!templates_workflow.isEmpty()) {
                                List ids = templates_workflow.stream().map(ProcessTemplate::getId).collect(Collectors.toList());
                                log.info("invoke NoCodeWorkflowServiceHelper.createProcessesByTemplates, appId={}, ids={}, refMap={}, result.roleMap={}.", new Object[]{app.getString(SysAppServiceImpl.PROP_ID), ids, refMap, result.roleMap});
                                Map res = NoCodeWorkflowServiceHelper.createProcessesByTemplates((String)app.getString(SysAppServiceImpl.PROP_ID), ids, refMap, result.roleMap);
                                log.info("invoke NoCodeWorkflowServiceHelper.createProcessesByTemplates, res={}", (Object)res);
                                res.values().forEach(id -> {
                                    try {
                                        NoCodeWorkflowServiceHelper.publishProcess((Long)id, (Map)kd.bos.nocode.restapi.common.util.Maps.of((Object)"ignoreValidateInfo", (Object)true));
                                    }
                                    catch (Exception e) {
                                        log.warn((Throwable)e);
                                    }
                                });
                                if (!result.pSet.isEmpty()) {
                                    this.fixupMetaAfterProcess(result.pSet, res);
                                }
                            }
                            app.set(SysAppServiceImpl.PROP_VISIBLE, (Object)true);
                            NoCodeTemplateUtil.addUseTimes((String)templateid);
                        } else {
                            app = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_bizapp");
                            String version = NcAppVersionUtil.getAppVersion();
                            app.set(SysAppServiceImpl.PROP_VERSION, (Object)version);
                            app.set(SysAppServiceImpl.PROP_DBROUTE, (Object)"secd");
                            DynamicObject noCodeCloud = RestApiServiceLocalCache.getNoCodeCloudObj();
                            app.set(SysAppServiceImpl.PROP_BIZCLOUD, (Object)noCodeCloud);
                            app.set(SysAppServiceImpl.PROP_USERTYPE, (Object)1);
                            app.set(SysAppServiceImpl.PROP_DEPLOYSTATUS, (Object)2);
                            app.set(SysAppServiceImpl.PROP_MAINFORMTYPE, (Object)0);
                            app.set(SysAppServiceImpl.PROP_ISV, (Object)ISVService.getISVInfo().getId());
                            String number = this.genAppNumber(name);
                            app.set(SysAppServiceImpl.PROP_NUMBER, (Object)number);
                            app.set(SysAppServiceImpl.PROP_ID, (Object)number);
                        }
                    } else {
                        NoCodePermHelper.verifyManage((String)((String)dataMap.get(SysAppServiceImpl.PROP_ID)));
                        app = BusinessDataServiceHelper.loadSingle((Object)dataMap.get(SysAppServiceImpl.PROP_ID), (String)"bos_devportal_bizapp");
                    }
                    String sError = this.saveMetaOfApp(app, isInsert, dataMap);
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sError)) {
                        restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                        msg = new HashSet(1);
                        msg.add(sError);
                        restApiSaveRowErrorData.setRowMsg(msg);
                        apiSaveData.getErrors().add(restApiSaveRowErrorData);
                    }
                    if (isInsert) {
                        NoCodePermHelper.genAdminRole((String)app.getString(SysAppServiceImpl.PROP_ID));
                    }
                    apiSaveData.setId(app.getString(SysAppServiceImpl.PROP_ID));
                    apiSaveData.setNumber(app.getString(SysAppServiceImpl.PROP_NUMBER));
                    if (apiSaveData.getErrors().isEmpty()) {
                        apiSaveData.setBillStatus(true);
                    }
                }
                catch (Exception e) {
                    if (isInsert && app != null) {
                        try {
                            AppServiceHelper.deleteApp(app.getString(SysAppServiceImpl.PROP_ID));
                        }
                        catch (Exception ex) {
                            log.debug(ex.getMessage(), (Object)ex);
                        }
                    }
                    log.debug(e.getMessage(), (Object)e);
                    apiSaveData.addError(e);
                    apiSaveData.setBillStatus(false);
                }
                results.add(apiSaveData);
            }
            return results;
        }

        private void updateAppInfo(DynamicObject app, Map<String, Object> dataMap) {
            String deployStatus;
            String description;
            String name = (String)dataMap.get(SysAppServiceImpl.PROP_NAME);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)name)) {
                String propName = StringUtil.cleanXSSParam((String)name);
                app.set(SysAppServiceImpl.PROP_NAME, (Object)new LocaleString(propName.length() > 50 ? propName.substring(0, 47) + "..." : propName));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(description = (String)dataMap.get(SysAppServiceImpl.PROP_DESCRIPTION)))) {
                String propDesc = StringUtil.cleanXSSParam((String)description);
                app.set(SysAppServiceImpl.PROP_DESCRIPTION, (Object)new LocaleString(propDesc.length() > 500 ? propDesc.substring(0, 497) + "..." : propDesc));
            } else {
                app.set(SysAppServiceImpl.PROP_DESCRIPTION, (Object)new LocaleString());
            }
            String imageUrl = (String)dataMap.get(SysAppServiceImpl.PROP_IMAGE);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)imageUrl)) {
                app.set(SysAppServiceImpl.PROP_IMAGE, (Object)imageUrl);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(deployStatus = (String)dataMap.get(SysAppServiceImpl.PROP_DEPLOYSTATUS)))) {
                app.set(SysAppServiceImpl.PROP_DEPLOYSTATUS, (Object)deployStatus);
            }
        }

        private void fixupMetaAfterProcess(Set<String> set, Map<Long, Long> pRef) {
            NoCodeDesignerData designerData = new NoCodeDesignerData();
            String local = RequestContext.get().getLang().toString();
            for (String formId : set) {
                Map metadata = MetadataDao.loadDesignerMetadata((String)formId, (String)local);
                Map fm = (Map)metadata.get(SysAppServiceImpl.FORM_META);
                List formItems = (List)fm.get(SysAppServiceImpl.ITEMS);
                for (Map formItem : formItems) {
                    JSONObject json;
                    Long value;
                    Long newProcess;
                    String triggerProcess;
                    if (!formItem.containsKey(SysAppServiceImpl.TYPE) || !formItem.get(SysAppServiceImpl.TYPE).equals("NoCodeBizButtonAp")) continue;
                    if (formItem.containsKey("TriggerProcess") && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(triggerProcess = (String)formItem.get("TriggerProcess"))) && (newProcess = pRef.get(Long.parseLong(triggerProcess))) != null) {
                        formItem.put("TriggerProcess", newProcess.toString());
                    }
                    if (!formItem.containsKey("TriggerProcessAfterInput") || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(triggerProcess = (String)formItem.get("TriggerProcessAfterInput"))) || (value = (json = JSONObject.parseObject((String)triggerProcess)).getLong(SysAppServiceImpl.PROP_VALUE)) == null || !pRef.containsKey(value)) continue;
                    json.put(SysAppServiceImpl.PROP_VALUE, (Object)pRef.get(value).toString());
                    formItem.put("TriggerProcessAfterInput", json.toJSONString());
                }
                metadata.put("template", true);
                designerData.save(metadata);
            }
        }

        private void updateMyCollect(Map<String, Object> dataMap) {
            String id = (String)dataMap.get(SysAppServiceImpl.PROP_ID);
            boolean isCollect = (Boolean)dataMap.get(SysAppServiceImpl.SHORTCUT_COLLECT);
            long userId = RequestContext.get().getCurrUserId();
            if (isCollect) {
                QFilter q1 = new QFilter("bizapp", "=", (Object)id);
                QFilter q2 = new QFilter(SysAppServiceImpl.SHORTCUT_USER, "=", (Object)userId);
                QFilter q3 = new QFilter(SysAppServiceImpl.SHORTCUT_BIZPAGE, "=", (Object)" ");
                QFilter[] filters = new QFilter[]{q1, q2, q3};
                boolean exists = QueryServiceHelper.exists((String)SysAppServiceImpl.BOS_DEVPORTAL_SHORTCUT, (QFilter[])filters);
                if (exists) {
                    return;
                }
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)SysAppServiceImpl.BOS_DEVPORTAL_SHORTCUT);
                DynamicObject dynamicObject = ORM.create().newDynamicObject((DynamicObjectType)dataEntityType);
                dynamicObject.set(SysAppServiceImpl.SHORTCUT_USER, (Object)userId);
                dynamicObject.set("bizapp", (Object)id);
                dynamicObject.set(SysAppServiceImpl.SHORTCUT_BIZPAGE, (Object)" ");
                SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])new Object[]{dynamicObject});
            } else {
                QFilter userFilter = new QFilter(SysAppServiceImpl.SHORTCUT_USER, "=", (Object)userId);
                QFilter bizPageFilter = new QFilter("bizapp", "=", (Object)id);
                DeleteServiceHelper.delete((String)SysAppServiceImpl.BOS_DEVPORTAL_SHORTCUT, (QFilter[])userFilter.and(bizPageFilter).toArray());
            }
        }

        protected String saveMetaOfApp(DynamicObject appObject, boolean isInsert, Map<String, Object> dataMap) {
            this.updateAppInfo(appObject, dataMap);
            Map resultMap = null;
            if (isInsert) {
                AppMetadata appMetadata = FormMetaUtil.createNewAppMeta((DynamicObject)appObject);
                resultMap = AppMetaServiceHelper.save((AppMetadata)appMetadata);
            } else {
                resultMap = AppMetaServiceHelper.save((DynamicObject)appObject);
            }
            if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get(SysAppServiceImpl.KEY_SUCCESS).toString())) {
                return resultMap.get("message").toString();
            }
            return null;
        }

        protected String genAppNumber(String appName) {
            String appNumber = FormMetaUtil.genIdUrlFriendly();
            return appNumber;
        }

        private List<RestApiSaveItemData> addTemplates(List<Map<String, Object>> templateList) {
            Object image;
            if (CollectionUtils.isEmpty(templateList)) {
                return Collections.emptyList();
            }
            boolean check = NoCodePermHelper.checkUserPlatManageInNoCode();
            if (!check) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u4fdd\u5b58\u5e94\u7528\u6a21\u677f", (String)"SysAppServiceImpl_11", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
            }
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            Map<String, Object> dataMap = templateList.get(0);
            String id = (String)dataMap.get(SysAppServiceImpl.PROP_ID);
            NoCodePermHelper.verifyManage((String)id);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)id)) {
                String info = ResManager.loadKDString((String)"\u5e94\u7528id\u5fc5\u987b\u5f55\u5165", (String)"SysAppServiceImpl_12", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]);
                throw new RestApiException(info);
            }
            Map config = (Map)dataMap.get(SysAppServiceImpl.TEMPLATE_CONFIG);
            boolean copyData = config.getOrDefault(SysAppServiceImpl.PROP_COPYDATA, false);
            CloneResult result = this.cloneAnApp(id, dataMap, copyData, null, false);
            DynamicObject app = result.clone;
            apiSaveData.setId(app.getString(SysAppServiceImpl.PROP_ID));
            apiSaveData.setNumber(app.getString(SysAppServiceImpl.PROP_NUMBER));
            apiSaveData.setBillStatus(true);
            if (!config.containsKey(SysAppServiceImpl.PROP_ICON)) {
                image = app.get(SysAppServiceImpl.PROP_IMAGE);
                config.put(SysAppServiceImpl.PROP_ICON, image);
            }
            if (!config.containsKey(SysAppServiceImpl.PROP_IMAGE)) {
                image = app.get(SysAppServiceImpl.PROP_IMAGE);
                config.put(SysAppServiceImpl.PROP_IMAGE, image);
            }
            try {
                List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)id);
                if (!processModels.isEmpty()) {
                    List models = processModels.stream().map(ProcessModel::getId).collect(Collectors.toList());
                    Map res = NoCodeWorkflowServiceHelper.saveProcessesAsTemplates((String)app.getString(SysAppServiceImpl.PROP_ID), models, result.refMap, result.roleMap);
                    log.debug(SerializationUtils.toJsonString((Object)res));
                    if (!result.pSet.isEmpty()) {
                        this.fixupMetaAfterProcess(result.pSet, res);
                    }
                }
                this.insertRecord(config, id, app);
            }
            catch (Exception e) {
                AppServiceHelper.deleteApp(app.getPkValue().toString());
                throw e;
            }
            return Collections.singletonList(apiSaveData);
        }

        private void insertRecord(Map<String, Object> dataMap, String id, DynamicObject app) {
            dataMap.put(SysAppServiceImpl.PROP_APPID, app.get(SysAppServiceImpl.PROP_ID));
            dataMap.put("sourceId", id);
            NoCodeTemplateUtil.saveAppTemplate(dataMap);
        }

        private CloneResult cloneAnApp(String src, Map<String, Object> dataMap, boolean copyData, String icon, boolean visible) {
            Map<String, String> roleMap;
            Map<String, String> formIdRefMap;
            DynamicObject clone;
            CloneResult ret = new CloneResult();
            try (TXHandle handle = TX.required();){
                try {
                    clone = this.cloneApp(src, dataMap, icon, visible);
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
            ret.clone = clone;
            HashSet<String> pSet = new HashSet<String>();
            ret.pSet = pSet;
            String newAppId = clone.getString(SysAppServiceImpl.PROP_ID);
            try {
                formIdRefMap = this.cloneForms(src, clone, pSet);
                roleMap = this.cloneRoles(src, newAppId, formIdRefMap);
            }
            catch (Exception e) {
                try {
                    AppServiceHelper.deleteApp(newAppId);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                }
                throw e;
            }
            ret.refMap = formIdRefMap;
            ret.roleMap = roleMap;
            HashSet<String> pages = new HashSet<String>();
            try (TXHandle handle = TX.required();){
                try {
                    if (copyData) {
                        this.cloneData(formIdRefMap);
                    }
                    this.cloneMenu(src, clone, formIdRefMap, pages);
                    this.cloneRefData(clone, formIdRefMap);
                }
                catch (Exception e) {
                    handle.markRollback();
                    handle.close();
                    try {
                        AppServiceHelper.deleteApp(newAppId);
                    }
                    catch (Exception ex) {
                        log.warn((Throwable)ex);
                    }
                    throw e;
                }
            }
            handle = TX.required();
            var14_21 = null;
            try {
                RuleServiceHelper.cloneRules(formIdRefMap);
                this.clonePages(pages, formIdRefMap, newAppId, src);
                this.cloneAssociations(formIdRefMap);
                CloneResult e = ret;
                return e;
            }
            catch (Exception e) {
                try {
                    handle.markRollback();
                    handle.close();
                    try {
                        AppServiceHelper.deleteApp(newAppId);
                    }
                    catch (Exception ex) {
                        log.warn((Throwable)ex);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    var14_21 = throwable;
                    throw throwable;
                }
            }
            finally {
                if (handle != null) {
                    if (var14_21 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var14_21.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
        }

        private void cloneAssociations(Map<String, String> formIdRefMap) {
            Set<String> fids = formIdRefMap.keySet();
            QFilter f = new QFilter("first_formid", "in", fids);
            String selects = "id,first_formid,first_form_ref_fieldkey,second_formid,second_form_ref_fieldkey";
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_nocode_association", (String)selects, (QFilter[])new QFilter[]{f});
            Set<DynamicObject> collect = Arrays.stream(load).map(d -> (DynamicObject)OrmUtils.clone((IDataEntityBase)d, (boolean)false, (boolean)true)).peek(d -> d.set("first_formid", formIdRefMap.get(d.getString("first_formid")))).peek(d -> d.set("second_formid", formIdRefMap.get(d.getString("second_formid")))).collect(Collectors.toSet());
            if (!collect.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])collect.toArray(new DynamicObject[0]));
            }
        }

        private void clonePages(Set<String> pages, Map<String, String> formIdRefMap, String newAppId, String oldAppId) {
            if (!pages.isEmpty()) {
                Set forms = pages.stream().map(Long::parseLong).collect(Collectors.toSet());
                QFilter filter = new QFilter("pageid", "in", forms);
                DynamicObject[] containers = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)"id,cardid,pageid", (QFilter[])new QFilter[]{filter});
                Set cardIds = Arrays.stream(containers).map(dy -> dy.getString("cardid")).collect(Collectors.toSet());
                if (!cardIds.isEmpty()) {
                    HashMap<String, String> cardMap = new HashMap<String, String>();
                    ArrayList<DynamicObject> cards = new ArrayList<DynamicObject>(8);
                    for (String cardId : cardIds) {
                        boolean exists = QueryServiceHelper.exists((String)"bos_nocode_card", (Object)Long.parseLong(cardId));
                        if (!exists) continue;
                        DynamicObject dy2 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(cardId), (String)"bos_nocode_card");
                        DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dy2, (boolean)false, (boolean)true);
                        long id = ID.genLongId();
                        cardMap.put(cardId, String.valueOf(id));
                        clone.set(SysAppServiceImpl.PROP_ID, (Object)id);
                        cards.add(clone);
                    }
                    List<DynamicObject> qingCards = cards.stream().filter(this::isQingCard).collect(Collectors.toList());
                    this.replaceQingCardInfo(qingCards, formIdRefMap, newAppId, oldAppId);
                    this.replaceCardInfo(cards, formIdRefMap, newAppId, oldAppId);
                    SaveServiceHelper.save((DynamicObject[])cards.toArray(new DynamicObject[0]));
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
                    for (DynamicObject dy3 : containers) {
                        Object pk = dy3.getPkValue();
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bos_nocode_cardcontainer");
                        DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dynamicObject, (boolean)false, (boolean)true);
                        String pageid = dynamicObject.getString("pageid");
                        clone.set("pageid", (Object)formIdRefMap.get(pageid));
                        String cardid = clone.getString("cardid");
                        clone.set("cardid", cardMap.get(cardid));
                        list.add(clone);
                    }
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
            }
        }

        private void replaceQingCardInfo(List<DynamicObject> qingCards, Map<String, String> formIdRefMap, String newAppId, String oldAppId) {
            HashMap<String, Map<String, String>> cardInfos = new HashMap<String, Map<String, String>>(qingCards.size());
            for (DynamicObject qingCard : qingCards) {
                String cardAppId = qingCard.getString("app_id");
                String oldFormId = qingCard.getString("form_id");
                String newFormId = formIdRefMap.get(oldFormId);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)newFormId)) {
                    newFormId = oldFormId;
                }
                if (Objects.equals(cardAppId, oldAppId)) {
                    qingCard.set("app", (Object)newAppId);
                    qingCard.set("app_id", (Object)newAppId);
                }
                qingCard.set(SysAppServiceImpl.FORM, (Object)newFormId);
                qingCard.set("form_id", (Object)newFormId);
                String qingCardId = (String)this.getConfigMap(qingCard).get(SysAppServiceImpl.PROP_QING_CARD_ID);
                HashMap<String, String> paramMap = new HashMap<String, String>(4);
                paramMap.put("appId", newAppId);
                paramMap.put("formId", newFormId);
                cardInfos.put(qingCardId, paramMap);
            }
            Map<String, String> oldId2newId = QingProxyService.create().createFromExistQingCard(cardInfos);
            qingCards.forEach(dy -> {
                Map<String, Object> configMap = this.getConfigMap((DynamicObject)dy);
                String qingCardId = (String)configMap.get(SysAppServiceImpl.PROP_QING_CARD_ID);
                String newQingCardId = (String)oldId2newId.get(qingCardId);
                if (StringUtils.isNotBlank((CharSequence)newQingCardId)) {
                    configMap.put(SysAppServiceImpl.PROP_QING_CARD_ID, newQingCardId);
                    dy.set(SysAppServiceImpl.PROP_CONFIG, (Object)SerializationUtils.toJsonString(configMap));
                }
            });
        }

        private void replaceCardInfo(List<DynamicObject> cards, Map<String, String> formIdRefMap, String newAppId, String oldAppId) {
            for (DynamicObject card : cards) {
                String formId;
                if (this.isQingCard(card) || this.isWfCard(card)) continue;
                Map<String, Object> configMap = this.getConfigMap(card);
                String type = card.getString(SysAppServiceImpl.PROP_TYPE);
                CardTypeEnum typeEnum = CardTypeEnum.valueOf(type);
                if (typeEnum == CardTypeEnum.APP_ENTRY) {
                    ArrayList appList = (ArrayList)configMap.get("appList");
                    ArrayList newlist = new ArrayList(appList.size());
                    for (String app : appList) {
                        if (app.equals(oldAppId)) {
                            newlist.add(newAppId);
                            continue;
                        }
                        newlist.add(app);
                    }
                    configMap.put("appList", newlist);
                } else if (typeEnum == CardTypeEnum.FORM_ENTRY || typeEnum == CardTypeEnum.OPERATION_ENTRY) {
                    ArrayList formList = (ArrayList)configMap.get("formList");
                    for (Map map : formList) {
                        String formId2 = (String)map.get("formId");
                        if (!formIdRefMap.containsKey(formId2)) continue;
                        map.put("formId", formIdRefMap.get(formId2));
                        map.put("appId", newAppId);
                    }
                } else if (typeEnum == CardTypeEnum.FORM_LIST && formIdRefMap.containsKey(formId = (String)configMap.get("formId"))) {
                    configMap.put("formId", formIdRefMap.get(formId));
                    configMap.put("appId", newAppId);
                    ArrayList<String> newForm = new ArrayList<String>(2);
                    newForm.add(newAppId);
                    newForm.add(formIdRefMap.get(formId));
                    configMap.put(SysAppServiceImpl.FORM, newForm);
                }
                card.set(SysAppServiceImpl.PROP_CONFIG, (Object)SerializationUtils.toJsonString(configMap));
            }
        }

        private boolean isWfCard(DynamicObject cardDy) {
            String type = cardDy.getString(SysAppServiceImpl.PROP_TYPE);
            CardTypeEnum typeEnum = CardTypeEnum.valueOf(type);
            return typeEnum == CardTypeEnum.WF_STATISTICS || typeEnum == CardTypeEnum.WF_MY_HANDLE || typeEnum == CardTypeEnum.WF_MY_LAUNCH;
        }

        private Map<String, Object> getConfigMap(DynamicObject cardDy) {
            String config = cardDy.getString(SysAppServiceImpl.PROP_CONFIG);
            if (StringUtils.isNotBlank((CharSequence)config)) {
                return (Map)SerializationUtils.fromJsonString((String)config, Map.class);
            }
            return Maps.newHashMap();
        }

        private boolean isQingCard(DynamicObject cardDy) {
            String type = cardDy.getString(SysAppServiceImpl.PROP_TYPE);
            CardTypeEnum typeEnum = CardTypeEnum.valueOf(type);
            return typeEnum == CardTypeEnum.STATISTICS;
        }

        private Map<String, String> cloneRoles(String src, String clone, Map<String, String> formIdRefMap) {
            HashMap<String, String> ret = new HashMap<String, String>();
            List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)src);
            for (Role r : roles) {
                String id = r.getId();
                RolePerm role = NoCodePermissionServiceHelper.getRolePerm((String)id);
                role.setId(null);
                role.setAppId(clone);
                role.getAssignUserIds().clear();
                if (role.isSystem()) {
                    role.getAssignUserIds().add(RequestContext.get().getCurrUserId());
                }
                role.getAssignOrgIds().clear();
                Map map = role.getEntityNumberPermMap();
                role.setEntityNumberPermMap(new HashMap());
                for (Map.Entry entry : map.entrySet()) {
                    String srcFormId = (String)entry.getKey();
                    if (!formIdRefMap.containsKey(srcFormId)) continue;
                    String refFormId = formIdRefMap.get(srcFormId);
                    EntityPerm entityPerm = (EntityPerm)entry.getValue();
                    entityPerm.setEntityId(refFormId);
                    entityPerm.setEntityNumber(refFormId);
                    role.getEntityNumberPermMap().put(refFormId, entityPerm);
                }
                if (map.containsKey("perm_nocode_publicentity")) {
                    role.getEntityNumberPermMap().put("perm_nocode_publicentity", map.get("perm_nocode_publicentity"));
                }
                NoCodePermissionServiceHelper.saveRolePerm((RolePerm)role);
                ret.put(id, role.getId());
                if (role.getErrors().isEmpty()) continue;
                throw new RestApiException(String.join((CharSequence)",", role.getErrors()));
            }
            return ret;
        }

        private void cloneRefData(DynamicObject clone, Map<String, String> formIdRefMap) {
            String appid = clone.getString(SysAppServiceImpl.PROP_ID);
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appid, (boolean)false);
            AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appMetadata.getAppFunctionPackets().get(0);
            String bizUnitId = appFunctionPacketElement.getId();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (String formid : formIdRefMap.values()) {
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)appid);
                dObject.set(SysAppServiceImpl.BIZUNIT, (Object)bizUnitId);
                dObject.set(SysAppServiceImpl.FORM, (Object)formid);
                list.add(dObject);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }

        private void cloneMenu(String src, DynamicObject clone, Map<String, String> formIdRefMap, Set<String> pages) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)src);
            String appid = clone.getString(SysAppServiceImpl.PROP_ID);
            List oldMenus = appMetadata.getAppMenus();
            HashMap<String, String> menuIdRefMap = new HashMap<String, String>(oldMenus.size());
            for (Object oldMenu : oldMenus) {
                menuIdRefMap.put(oldMenu.getId(), FormMetaUtil.genIdUrlFriendly());
                if (!"custom".equals(oldMenu.getMenuType())) continue;
                pages.add(oldMenu.getFormId());
            }
            AppMetadata meta = AppMetaServiceHelper.loadAppMetadataById((String)appid);
            meta.getAppMenus().clear();
            for (AppMenuElement oldMenu : oldMenus) {
                AppMenuElement menu = new AppMenuElement();
                menu.setId((String)menuIdRefMap.get(oldMenu.getId()));
                if (oldMenu.getParentId().equals(src)) {
                    menu.setParentId(appid);
                } else {
                    menu.setParentId((String)menuIdRefMap.get(oldMenu.getParentId()));
                }
                menu.setVisible(oldMenu.getVisible());
                menu.setNumber((String)menuIdRefMap.get(oldMenu.getId()));
                menu.setFormNumber(oldMenu.getFormId() == null ? null : formIdRefMap.get(oldMenu.getFormId()));
                menu.setFormId(oldMenu.getFormId() == null ? null : formIdRefMap.get(oldMenu.getFormId()));
                menu.setParameter(oldMenu.getParameter());
                menu.setCaption(oldMenu.getCaption());
                menu.setName(oldMenu.getName());
                menu.setDescription(oldMenu.getDescription());
                menu.setSeq(oldMenu.getSeq());
                menu.setMenuType(oldMenu.getMenuType());
                meta.getAppMenus().add(menu);
            }
            Map resultMap = AppMetaServiceHelper.save((AppMetadata)meta);
            if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get(SysAppServiceImpl.KEY_SUCCESS).toString())) {
                throw new RestApiException(ResManager.loadKDString((String)"\u590d\u5236\u5e94\u83dc\u5355\u6570\u636e\u5931\u8d25:%s", (String)"SysAppServiceImpl_13", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{resultMap.get("message").toString()}));
            }
        }

        private void cloneData(Map<String, String> formIdRefMap) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    HashMap<String, Map> subTables = new HashMap<String, Map>();
                    HashMap<String, Map> entryTables = new HashMap<String, Map>();
                    String sql = "insert into %s(%s) select %s from %s";
                    for (Map.Entry<String, String> entry : formIdRefMap.entrySet()) {
                        String string = entry.getKey();
                        String nid = entry.getValue();
                        Map metadata = MetadataDao.loadDesignerMetadata((String)string);
                        String string2 = metadata.getOrDefault("modelType", "");
                        if (!"NoCodeModel".equals(string2)) continue;
                        EntityMetadataCache.removeDataEntityTypeLocalCache((String)string);
                        MainEntityType oldType = EntityMetadataCache.getDataEntityType((String)string);
                        String oldTable = oldType.getAlias();
                        EntityMetadataCache.removeDataEntityTypeLocalCache((String)nid);
                        MainEntityType newType = EntityMetadataCache.getDataEntityType((String)nid);
                        String newTable = newType.getAlias();
                        HashSet<String> keys = new HashSet<String>();
                        for (IDataEntityProperty property : newType.getProperties()) {
                            if (!oldType.getProperties().containsKey((Object)property.getName())) continue;
                            String alias = property.getAlias();
                            if (property instanceof MulBasedataProp) {
                                subTables.computeIfAbsent(string, s -> new HashMap()).put(property.getName(), alias);
                                continue;
                            }
                            if (property instanceof NoCodeRefBillTableProp) continue;
                            if (property instanceof EntryProp) {
                                String entryTable = ((EntityType)newType.getAllEntities().get(property.getName())).getAlias();
                                entryTables.computeIfAbsent(string, s -> new HashMap()).put(property.getName(), entryTable);
                                continue;
                            }
                            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)alias)) continue;
                            keys.add(alias);
                        }
                        String lockStatusKey = String.format("%s%s", "f", WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
                        keys.remove(lockStatusKey);
                        String fields = String.join((CharSequence)",", keys);
                        String format = String.format(sql, newTable, fields, fields, oldTable);
                        DB.execute((DBRoute)DBRoute.of((String)newType.getDBRouteKey()), (String)format);
                    }
                    String sql2 = "insert into %s select fpkid,fid,fbasedataid from %s";
                    if (!subTables.isEmpty()) {
                        for (Map.Entry entry : subTables.entrySet()) {
                            String oid = (String)entry.getKey();
                            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                                String propName = (String)entry2.getKey();
                                String newTable = (String)entry2.getValue();
                                MainEntityType oldType = EntityMetadataCache.getDataEntityType((String)oid);
                                MainEntityType newType = EntityMetadataCache.getDataEntityType((String)formIdRefMap.get(oid));
                                IDataEntityProperty property = oldType.findProperty(propName);
                                String oldTable = property.getAlias();
                                String format = String.format(sql2, newTable, oldTable);
                                DB.execute((DBRoute)DBRoute.of((String)newType.getDBRouteKey()), (String)format);
                            }
                        }
                    }
                    String string = "insert into %s(%s) select %s from %s";
                    String string3 = "insert into %s select fpkid,fentryid,fbasedataid from %s";
                    if (!entryTables.isEmpty()) {
                        for (Map.Entry entry : entryTables.entrySet()) {
                            String string4 = (String)entry.getKey();
                            for (Map.Entry map : ((Map)entry.getValue()).entrySet()) {
                                HashMap subTableMap = new HashMap();
                                String propName = (String)map.getKey();
                                String newTable = (String)map.getValue();
                                MainEntityType oldType = EntityMetadataCache.getDataEntityType((String)string4);
                                String nid = formIdRefMap.get(string4);
                                MainEntityType newType = EntityMetadataCache.getDataEntityType((String)nid);
                                EntityType oldEntityType = (EntityType)oldType.getAllEntities().get(propName);
                                String oldTable = oldEntityType.getAlias();
                                Set keys = oldEntityType.getProperties().stream().filter(prop -> {
                                    if (prop instanceof MulBasedataProp) {
                                        subTableMap.put(prop.getName(), prop.getAlias());
                                        return false;
                                    }
                                    return true;
                                }).map(IMetadata::getAlias).collect(Collectors.toSet());
                                keys.remove(null);
                                keys.remove("");
                                keys.add("fid");
                                String fields = String.join((CharSequence)",", keys);
                                String format = String.format(string, newTable, fields, fields, oldTable);
                                DB.execute((DBRoute)DBRoute.of((String)newType.getDBRouteKey()), (String)format);
                                if (subTableMap.isEmpty()) continue;
                                EntityType newEntityType = (EntityType)newType.getAllEntities().get(propName);
                                for (Map.Entry e : subTableMap.entrySet()) {
                                    String multiName = (String)e.getKey();
                                    String oldMultiTable = (String)e.getValue();
                                    String newMultiTable = newEntityType.getProperty(multiName).getAlias();
                                    String exec = String.format(string3, newMultiTable, oldMultiTable);
                                    DB.execute((DBRoute)DBRoute.of((String)newEntityType.getDBRouteKey()), (String)exec);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw new RestApiException((Throwable)e);
                }
            }
        }

        private DynamicObject cloneApp(String appid, Map<String, Object> dataMap, String icon, boolean visible) {
            String deployStatus;
            String description;
            DynamicObject app = BusinessDataServiceHelper.loadSingle((Object)appid, (String)"bos_devportal_bizapp");
            DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)app, (boolean)false, (boolean)true);
            this.setAppInfo(clone, (Map)dataMap.get(SysAppServiceImpl.TEMPLATE_CONFIG));
            String ic = (String)dataMap.get(SysAppServiceImpl.PROP_ICON);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)ic)) {
                clone.set(SysAppServiceImpl.PROP_IMAGE, (Object)ic);
            } else if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)icon)) {
                clone.set(SysAppServiceImpl.PROP_IMAGE, (Object)icon);
            }
            String name = (String)dataMap.get(SysAppServiceImpl.PROP_NAME);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)name)) {
                clone.set(SysAppServiceImpl.PROP_NAME, (Object)new LocaleString(name));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(description = (String)dataMap.get(SysAppServiceImpl.PROP_DESCRIPTION)))) {
                clone.set(SysAppServiceImpl.PROP_DESCRIPTION, (Object)new LocaleString(description));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(deployStatus = (String)dataMap.get(SysAppServiceImpl.PROP_DEPLOYSTATUS)))) {
                clone.set(SysAppServiceImpl.PROP_DEPLOYSTATUS, (Object)deployStatus);
            }
            String number = this.genAppNumber(app.getString(SysAppServiceImpl.PROP_NAME));
            clone.set(SysAppServiceImpl.PROP_NUMBER, (Object)number);
            clone.set(SysAppServiceImpl.PROP_ID, (Object)number);
            clone.set(SysAppServiceImpl.PROP_VISIBLE, (Object)visible);
            String errors = this.saveMetaOfApp(clone, true, new HashMap<String, Object>(0));
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)errors)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u590d\u5236\u5e94\u7528\u5143\u6570\u636e\u5931\u8d25:%s", (String)"SysAppServiceImpl_14", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[]{errors}));
            }
            return clone;
        }

        private void setAppInfo(DynamicObject clone, Map<String, Object> templateConfig) {
            if (MapUtils.isEmpty(templateConfig)) {
                return;
            }
            String icon = (String)templateConfig.get(SysAppServiceImpl.PROP_ICON);
            String name = (String)templateConfig.get(SysAppServiceImpl.PROP_NAME);
            String description = (String)templateConfig.get("desc");
            clone.set(SysAppServiceImpl.PROP_IMAGE, (Object)(kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)icon) ? "" : icon));
            clone.set(SysAppServiceImpl.PROP_NAME, (Object)new LocaleString(kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)name) ? "" : name));
            clone.set(SysAppServiceImpl.PROP_DESCRIPTION, (Object)new LocaleString(kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)description) ? "" : description));
        }

        private Map<String, String> cloneForms(String appid, DynamicObject clone, Set<String> pSet) {
            HashSet refSet = new HashSet();
            QFilter filter = new QFilter(SysAppServiceImpl.PROP_BIZAPPID, "=", (Object)appid);
            QFilter istemplateFilter = new QFilter("istemplate", "=", (Object)false);
            DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)SysAppServiceImpl.PROP_ID, (QFilter[])new QFilter[]{filter, istemplateFilter});
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ConcurrentHashMap<String, String> formIdRefMap = new ConcurrentHashMap<String, String>();
            String local = RequestContext.get().getLang().toString();
            Set formSet = Arrays.stream(forms).map(dy -> dy.getString(SysAppServiceImpl.PROP_ID)).collect(Collectors.toSet());
            for (DynamicObject form : forms) {
                CompletableFuture<Void> f = CompletableFuture.runAsync(() -> {
                    String src = form.getString(SysAppServiceImpl.PROP_ID);
                    Map metadata = MetadataDao.loadDesignerMetadata((String)src, (String)local);
                    String modelType = metadata.getOrDefault("modelType", "");
                    if ("NoCodeModel".equals(modelType)) {
                        this.copyNocodeBillMeta(clone, refSet, formIdRefMap, local, formSet, src, metadata, pSet);
                    } else if ("DynamicFormModel".equals(modelType)) {
                        this.copyOtherMeta(clone, formIdRefMap, local, src, metadata);
                    }
                }, pool);
                futures.add(f);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            if (!refSet.isEmpty()) {
                futures.clear();
                for (String formid : refSet) {
                    CompletableFuture<Void> f = CompletableFuture.runAsync(() -> {
                        NoCodeDesignerData designerData = new NoCodeDesignerData();
                        Map metadata = MetadataDao.loadDesignerMetadata((String)formid, (String)local);
                        Map em = (Map)metadata.get(SysAppServiceImpl.ENTITY_META);
                        List entityItems = (List)em.get(SysAppServiceImpl.ITEMS);
                        for (Map entityItem : entityItems) {
                            String oldRefId;
                            Object type;
                            if (entityItem == null || !entityItem.containsKey(SysAppServiceImpl.TYPE) || !"NoCodeRefBillField".equals(type = (String)entityItem.get(SysAppServiceImpl.TYPE)) && !"NoCodeMulRefBillField".equals(type) && !"NoCodeRefBillTable".equals(type) || (oldRefId = (String)entityItem.get(SysAppServiceImpl.BILL_ENTITY_ID_EX)) == null || !formIdRefMap.containsKey(oldRefId)) continue;
                            entityItem.put(SysAppServiceImpl.BILL_ENTITY_ID_EX, formIdRefMap.get(oldRefId));
                            entityItem.put(SysAppServiceImpl.BILL_ENTITY_ID, formIdRefMap.get(oldRefId));
                        }
                        Map fm = (Map)metadata.get(SysAppServiceImpl.FORM_META);
                        List formItems = (List)fm.get(SysAppServiceImpl.ITEMS);
                        for (Map formItem : formItems) {
                            String inputContent;
                            String type = (String)formItem.get(SysAppServiceImpl.TYPE);
                            if (!"NoCodeBizButtonAp".equals(type)) continue;
                            String inputForm = (String)formItem.get("InputForm");
                            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)inputForm)) {
                                for (Map.Entry entry : formIdRefMap.entrySet()) {
                                    String s = (String)entry.getKey();
                                    if (!inputForm.contains(s)) continue;
                                    inputForm = inputForm.replaceAll(s, (String)entry.getValue());
                                }
                                formItem.put("InputForm", inputForm);
                            }
                            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(inputContent = (String)formItem.get("InputContent")))) continue;
                            for (Map.Entry entry : formIdRefMap.entrySet()) {
                                String s = (String)entry.getKey();
                                if (!inputContent.contains(s)) continue;
                                inputContent = inputContent.replaceAll(s, (String)entry.getValue());
                            }
                            formItem.put("InputContent", inputContent);
                        }
                        metadata.put("template", true);
                        Map result = designerData.save(metadata);
                        List errors = result.getOrDefault("errors", Collections.emptyList());
                        boolean error = errors.stream().anyMatch(e -> e.getLevel() == 2);
                        if (error) {
                            throw new RestApiException(SerializationUtils.toJsonString(errors));
                        }
                    }, pool);
                    futures.add(f);
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            }
            log.debug("\u8868\u5355id\u6620\u5c04:\n" + SerializationUtils.toJsonString(formIdRefMap));
            return formIdRefMap;
        }

        private void copyNocodeBillMeta(DynamicObject clone, Set<String> refSet, Map<String, String> formIdRefMap, String local, Set<String> formSet, String src, Map<String, Object> metadata, Set<String> pSet) {
            NoCodeDesignerData designerData = new NoCodeDesignerData();
            String id = FormMetaUtil.genIdUrlFriendly();
            FormMetadata meta = designerData.generateTemplateMeta(metadata, id);
            meta.getEntityMetadata().getRootEntity().setTemplate(false);
            meta.setBizappId(clone.getString(SysAppServiceImpl.PROP_ID));
            Map<String, Object> content = this.fixUpProps(id, meta, formSet, refSet, local, pSet);
            Map result = designerData.save(content);
            List errors = result.getOrDefault("errors", Collections.emptyList());
            boolean error = errors.stream().anyMatch(e -> e.getLevel() == 2);
            if (error) {
                throw new RestApiException(SerializationUtils.toJsonString(errors));
            }
            formIdRefMap.put(src, id);
        }

        private void copyOtherMeta(DynamicObject clone, Map<String, String> formIdRefMap, String local, String src, Map<String, Object> metadata) {
            NoCodeDesignerData designerData = new NoCodeDesignerData();
            String id = FormMetaUtil.genIdUrlFriendly();
            FormMetadata meta = this.generateTemplateMeta(metadata, id, designerData);
            meta.getEntityMetadata().getRootEntity().setTemplate(false);
            meta.setBizappId(clone.getString(SysAppServiceImpl.PROP_ID));
            Map content = meta.buildDesignMeta(local);
            Map result = designerData.save(content);
            List errors = result.getOrDefault("errors", Collections.emptyList());
            boolean error = errors.stream().anyMatch(e -> e.getLevel() == 2);
            if (error) {
                throw new RestApiException(SerializationUtils.toJsonString(errors));
            }
            formIdRefMap.put(src, id);
        }

        public FormMetadata generateTemplateMeta(Map<String, Object> content, String id, NoCodeDesignerData designerData) {
            FormMetadata formMeta = (FormMetadata)designerData.convertTo(content, "DynamicFormModel");
            formMeta.setId(id);
            formMeta.setKey(id);
            EntityMetadata entityMeta = formMeta.getEntityMetadata();
            entityMeta.setId(id);
            entityMeta.setKey(id);
            entityMeta.getRootEntity().setKey(id);
            formMeta.setEntityId(id);
            return formMeta;
        }

        private Map<String, Object> fixUpProps(String id, FormMetadata meta, Set<String> idSet, Set<String> fixUpSet, String local, Set<String> pSet) {
            meta.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).forEach(i -> {
                NoCodeBizButtonAp button = (NoCodeBizButtonAp)i;
                String form = button.getInputForm();
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)form) && !form.startsWith("$") && form.contains(".")) {
                    button.setInputForm("");
                    button.setInputContent("");
                } else {
                    fixUpSet.add(id);
                }
                String triggerProcess = button.getTriggerProcess();
                String processAfterInput = button.getTriggerProcessAfterInput();
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)triggerProcess) || kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)processAfterInput)) {
                    pSet.add(id);
                }
            });
            Map copy = meta.buildDesignMeta(local);
            copy.put("template", true);
            Map em = (Map)copy.get(SysAppServiceImpl.ENTITY_META);
            List entityItems = (List)em.get(SysAppServiceImpl.ITEMS);
            Map noCodeBillEntity = (Map)entityItems.get(0);
            noCodeBillEntity.remove(SysAppServiceImpl.TABLE_NAME);
            Map fm = (Map)copy.get(SysAppServiceImpl.FORM_META);
            List formItems = (List)fm.get(SysAppServiceImpl.ITEMS);
            Map noCodeBillForm = (Map)formItems.get(0);
            noCodeBillForm.remove(SysAppServiceImpl.TABLE_NAME);
            for (Map entityItem : entityItems) {
                if (entityItem.containsKey(SysAppServiceImpl.TYPE) && (entityItem.get(SysAppServiceImpl.TYPE).equals("NoCodeAttachmentUploadField") || entityItem.get(SysAppServiceImpl.TYPE).equals("NoCodeEntryEntity"))) {
                    entityItem.remove(SysAppServiceImpl.TABLE_NAME);
                }
                if (!entityItem.containsKey(SysAppServiceImpl.TYPE) || !entityItem.get(SysAppServiceImpl.TYPE).equals("NoCodeRefBillField") && !entityItem.get(SysAppServiceImpl.TYPE).equals("NoCodeMulRefBillField") && !entityItem.get(SysAppServiceImpl.TYPE).equals("NoCodeRefBillTable") || !entityItem.containsKey(SysAppServiceImpl.BILL_ENTITY_ID_EX)) continue;
                String refId = (String)entityItem.get(SysAppServiceImpl.BILL_ENTITY_ID_EX);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)refId)) {
                    log.debug("Associated form id is empty");
                    continue;
                }
                if (idSet.contains(refId)) {
                    fixUpSet.add(id);
                    continue;
                }
                if ("bos_adminorg".equals(refId) || "bos_user".equals(refId)) continue;
                log.debug("Associated external form: {}", (Object)refId);
                throw new RestApiException(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5b58\u5728\u5176\u4ed6\u5e94\u7528\u8868\u5355\uff0c\u65e0\u6cd5\u4fdd\u5b58\u4e3a\u6a21\u677f", (String)"SysAppServiceImpl_15", (String)SysAppServiceImpl.BOS_NOCODE_SERVICE, (Object[])new Object[0]));
            }
            for (Map formItem : formItems) {
                if (!formItem.containsKey(SysAppServiceImpl.TYPE) || !formItem.get(SysAppServiceImpl.TYPE).equals("NoCodeAttachmentUploadFieldAp")) continue;
                formItem.remove(SysAppServiceImpl.TABLE_NAME);
            }
            return copy;
        }
    }
}

