/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.api.PrintRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.RestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiPrintParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.customimport.CustomImportServiceImpl;
import kd.bos.nocode.restapi.service.impt.ExcelCreateFormSaveApiServiceImpl;
import kd.bos.nocode.restapi.service.impt.ExcelCreatePreviewApiServiceImpl;
import kd.bos.nocode.restapi.service.impt.ImportDataServiceImpl;
import kd.bos.nocode.restapi.service.print.PrintRestApiServiceImpl;
import kd.bos.nocode.restapi.service.sys.common.ApiDocServiceQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ApiDocServiceSaveImpl;
import kd.bos.nocode.restapi.service.sys.common.ApiMenuServiceQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.AppImportServiceImpl;
import kd.bos.nocode.restapi.service.sys.common.BizButtonQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ListCommonConfigQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ListConfigQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ListConfigSaveImpl;
import kd.bos.nocode.restapi.service.sys.common.ListExportServiceImpl;
import kd.bos.nocode.restapi.service.sys.common.PermissionQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.RefBillQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ShareServiceQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.ShareServiceSaveImpl;
import kd.bos.nocode.restapi.service.sys.common.SvgServiceQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.TemplateInfoServiceQueryImpl;
import kd.bos.nocode.restapi.service.sys.common.TemplateInfoServiceSaveImpl;
import kd.bos.nocode.restapi.service.sys.common.ThemeServiceSaveImpl;
import kd.bos.nocode.restapi.service.sys.common.UserServiceQueryImpl;

public class SysCommonServiceImpl {
    private static final Map<String, List<? extends RestApiService>> CONTAINER = new HashMap<String, List<? extends RestApiService>>(8);
    private static final String QUERY = "query";
    private static final String SAVE = "save";
    private static final String PRINT = "print";

    private SysCommonServiceImpl() {
    }

    public static <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        block4: {
            String router;
            block5: {
                block3: {
                    router = SysCommonServiceImpl.getRouter(param);
                    if (!(param instanceof RestApiQueryParam)) break block3;
                    for (QueryRestApiService queryRestApiService : CONTAINER.get(QUERY)) {
                        if (!queryRestApiService.match(router)) continue;
                        return queryRestApiService.execute((RestApiParam)((RestApiQueryParam)param));
                    }
                    break block4;
                }
                if (!(param instanceof RestApiSaveParam)) break block5;
                for (SaveRestApiService saveRestApiService : CONTAINER.get(SAVE)) {
                    if (!saveRestApiService.match(router)) continue;
                    return saveRestApiService.execute((RestApiParam)((RestApiSaveParam)param));
                }
                break block4;
            }
            if (!(param instanceof RestApiPrintParam)) break block4;
            for (PrintRestApiService printRestApiService : CONTAINER.get(PRINT)) {
                if (!printRestApiService.match(router)) continue;
                return printRestApiService.execute((RestApiParam)((RestApiPrintParam)param));
            }
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysCommonServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private static String getRouter(RestApiParam param) {
        String url = param.getRequest().getUrl();
        String code = param.getAppNumber() + "/" + param.getFormId();
        return url.substring(url.lastIndexOf(code) + code.length());
    }

    static {
        List queryRestApiServices = CONTAINER.computeIfAbsent(QUERY, s -> new ArrayList());
        queryRestApiServices.add(new SvgServiceQueryImpl());
        queryRestApiServices.add(new ListConfigQueryImpl());
        queryRestApiServices.add(new BizButtonQueryImpl());
        queryRestApiServices.add(new ShareServiceQueryImpl());
        queryRestApiServices.add(new TemplateInfoServiceQueryImpl());
        queryRestApiServices.add(new ListCommonConfigQueryImpl());
        queryRestApiServices.add(new PermissionQueryImpl());
        queryRestApiServices.add(new UserServiceQueryImpl());
        queryRestApiServices.add(new ExcelCreatePreviewApiServiceImpl());
        queryRestApiServices.add(new RefBillQueryImpl());
        queryRestApiServices.add(new ApiDocServiceQueryImpl());
        queryRestApiServices.add(new ApiMenuServiceQueryImpl());
        List saveRestApiServices = CONTAINER.computeIfAbsent(SAVE, s -> new ArrayList());
        saveRestApiServices.add(new ListConfigSaveImpl());
        saveRestApiServices.add(new ListExportServiceImpl());
        saveRestApiServices.add(new ShareServiceSaveImpl());
        saveRestApiServices.add(new ImportDataServiceImpl());
        saveRestApiServices.add(new CustomImportServiceImpl());
        saveRestApiServices.add(new ThemeServiceSaveImpl());
        saveRestApiServices.add(new TemplateInfoServiceSaveImpl());
        saveRestApiServices.add(new ExcelCreateFormSaveApiServiceImpl());
        saveRestApiServices.add(new AppImportServiceImpl());
        saveRestApiServices.add(new ApiDocServiceSaveImpl());
        List printRestApiServices = CONTAINER.computeIfAbsent(PRINT, s -> new ArrayList());
        printRestApiServices.add(new PrintRestApiServiceImpl());
    }
}

