/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.nocode.ext.constant.CompareTypeEnum;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeAttachmentUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreatorField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImageUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextAreaField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.entity.filter.CompareGroupMapper;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.ListFilterRequestBO;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.statistics.StatMapUtils;
import kd.bos.nocode.restapi.service.statistics.constant.ReportTypeEnum;
import kd.bos.nocode.restapi.service.statistics.handler.GroupStatHandler;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SysFilterConfigServiceImpl {
    private static final Log log = LogFactory.getLog(SysFilterConfigServiceImpl.class);
    public static final String FBASEDATAID_NAME = ".fbasedataid.name";
    public static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        log.debug("\u8bf7\u6c42\u53c2\u6570\uff1a{}", param);
        if (param instanceof RestApiQueryParam) {
            SysFilterConfigServiceQueryImpl queryService = new SysFilterConfigServiceQueryImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiSaveParam) {
            return this.handleSaveParam((RestApiSaveParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysFilterConfigServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private <R> RestApiServiceData<R> handleSaveParam(RestApiSaveParam param) {
        if (Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("getEnumData"))) {
            SysFilterConfigServiceQueryImpl appServiceQuery = new SysFilterConfigServiceQueryImpl();
            return appServiceQuery.getEnumData(param);
        }
        if (Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("getFilter"))) {
            SysFilterConfigServiceQueryImpl appServiceQuery = new SysFilterConfigServiceQueryImpl();
            return appServiceQuery.getFilter(param);
        }
        SysFilterConfigServiceSaveImpl appServiceSave = new SysFilterConfigServiceSaveImpl();
        return appServiceSave.execute(param);
    }

    public static boolean existHeadField(ListFilterRequestBO requestBO) {
        return StringUtils.isNotBlank((CharSequence)requestBO.getHeadField());
    }

    public static class SysFilterConfigServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            ListFilterRequestBO requestBO = ListFilterRequestBO.build((RestApiSaveParam)param);
            this.rebuild(requestBO);
            long startTime = System.currentTimeMillis();
            ArrayList<String> filters = new ArrayList<String>(1);
            for (Map map : param.getDataList()) {
                try {
                    NoCodePermHelper.verifyFuncPermPassTemp((FuncPermItemEnum)FuncPermItemEnum.view, (String)requestBO.getAppId(), (String)requestBO.getFormId());
                }
                catch (Exception e) {
                    continue;
                }
                ArrayList currentFilterRows = (ArrayList)map.get("filterrows");
                if (Objects.isNull(currentFilterRows)) {
                    currentFilterRows = new ArrayList(0);
                }
                List<Map<String, Object>> filterRows = this.buildFilterRows(currentFilterRows);
                String filterStr = ListFilterConfigUtils.buildFilter(filterRows, requestBO.getFormId());
                log.debug("build filter str: {}", (Object)filterStr);
                filters.add(filterStr);
            }
            long endTime = System.currentTimeMillis();
            RestApiResponse<RestApiSaveResult> response = this.getSaveResponse(filters, param.getDataList().size());
            return RestApiServiceData.ofTrue(response, (long)startTime, (long)endTime);
        }

        private ListFilterRequestBO rebuild(ListFilterRequestBO requestBO) {
            IDataEntityProperty groupFieldProperty;
            IDataEntityProperty headFieldProperty;
            String headField = requestBO.getHeadField();
            String groupField = requestBO.getGroupField();
            String formId = requestBO.getFormId();
            MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)formId);
            if (StringUtils.isNotEmpty((CharSequence)headField) && (headFieldProperty = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)headField)) instanceof AttachmentProp) {
                requestBO.setHeadField(requestBO.getHeadField() + SysFilterConfigServiceImpl.FBASEDATAID_NAME);
            }
            if (StringUtils.isNotEmpty((CharSequence)groupField) && (groupFieldProperty = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)groupField)) instanceof AttachmentProp) {
                requestBO.setGroupField(requestBO.getGroupField() + SysFilterConfigServiceImpl.FBASEDATAID_NAME);
            }
            return requestBO;
        }

        private List<Map<String, Object>> buildFilterRows(List<Map<String, Object>> currentFilterRows) {
            List<Map<String, Object>> resultFilterRows = currentFilterRows;
            this.checkFieldEnumOp(resultFilterRows);
            return resultFilterRows;
        }

        private void checkFieldEnumOp(List<Map<String, Object>> resultFilterRows) {
            Map<String, Long> fieldCountMap = resultFilterRows.stream().filter(row -> Objects.equals(row.get("compareType"), CompareTypeEnum.ENUM_EQ.getId())).collect(Collectors.groupingBy(row -> (String)row.get("fieldName"), Collectors.counting()));
            fieldCountMap.forEach((field, count) -> {
                if (count > 1L) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u914d\u7f6e\u4e86\u591a\u4e2a\u679a\u4e3e\u64cd\u4f5c", (String)"SysFilterConfigServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[]{field}));
                }
            });
        }

        private RestApiResponse<RestApiSaveResult> getSaveResponse(List<String> filters, int size) {
            RestApiSaveResult result = new RestApiSaveResult();
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            result.getExtra().put("filters", filters);
            result.setSuccessCount((long)size);
            return response;
        }
    }

    public static class SysFilterConfigServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            if (Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("getCompareTypes"))) {
                return this.getCompareTypes();
            }
            ListFilterRequestBO requestBO = ListFilterRequestBO.build((RestApiQueryParam)param);
            if (SysFilterConfigServiceImpl.existHeadField(requestBO)) {
                return this.getHeadFieldFilterInfo(requestBO, param);
            }
            long startTime = System.currentTimeMillis();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)requestBO.getFormId());
            List<Map<String, Object>> filterColumns = ListFilterConfigUtils.getFilterColumns((IDataEntityType)dt);
            ArrayList<Map<String, Object>> configuredFilterItems = new ArrayList<Map<String, Object>>(0);
            String filterStr = ListFilterConfigUtils.buildFilter(configuredFilterItems, requestBO.getFormId());
            HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
            resultMap.put("listFilterConfig", filterColumns);
            resultMap.put("filters", Lists.newArrayList((Object[])new String[]{filterStr}));
            resultMap.put("configuredFilterItems", configuredFilterItems);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }

        private RestApiServiceData<RestApiQueryResult> getCompareTypes() {
            long startTime = System.currentTimeMillis();
            Map compareTypes = CompareGroupMapper.getCompareTypesForQueryResult();
            this.addTypeForWf(compareTypes);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(compareTypes), (long)startTime, (long)endTime);
        }

        private void addTypeForWf(Map<String, Object> compareTypes) {
            compareTypes.put("text", NoCodeTextField.class.getSimpleName().toLowerCase());
            compareTypes.put("number", NoCodeDecimalField.class.getSimpleName().toLowerCase());
            compareTypes.put("date", NoCodeDateField.class.getSimpleName().toLowerCase());
            compareTypes.put("refbill", NoCodeMulRefBillField.class.getSimpleName().toLowerCase());
            compareTypes.put("user", NoCodeCreatorField.class.getSimpleName().toLowerCase());
            compareTypes.put("pk", NoCodeMulRefBillField.class.getSimpleName().toLowerCase());
            compareTypes.put("org", OrgField.class.getSimpleName().toLowerCase());
            compareTypes.put("combo", ComboField.class.getSimpleName().toLowerCase());
            compareTypes.put("image", NoCodeImageUploadField.class.getSimpleName().toLowerCase());
            compareTypes.put("attachment", NoCodeAttachmentUploadField.class.getSimpleName().toLowerCase());
            compareTypes.put("textarea", NoCodeTextAreaField.class.getSimpleName().toLowerCase());
        }

        private RestApiServiceData<RestApiQueryResult> getHeadFieldFilterInfo(ListFilterRequestBO requestBO, RestApiQueryParam param) {
            Map<String, Object> filterColumn;
            MainEntityType dt;
            IDataEntityProperty property;
            long startTime = System.currentTimeMillis();
            String headField = requestBO.getHeadField();
            String formId = requestBO.getFormId();
            if (!NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId)) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
                resultMap.put("fieldFilterConfig", new HashMap(0));
                resultMap.put("configuredFilter", new HashMap(0));
                resultMap.put("groupInfo", new ArrayList(0));
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
            }
            Map httpQueryString = param.getRequest().getHttpQueryString();
            String schemaId = (String)httpQueryString.get("schemaId");
            if (StringUtils.isNotEmpty((CharSequence)schemaId)) {
                List<Map<String, Object>> filterRows = LIST_SCHEMA_SERVICE.getFilterRows(Long.parseLong(schemaId));
                ((Map)param.getRequest().getData()).put("defaultFilterRows", filterRows);
            }
            if ((property = NcEntityTypeUtil.findProperty((DynamicObjectType)(dt = NcEntityTypeUtil.getDataEntityType((String)formId)), (String)headField)) instanceof NoCodeAttachmentProp) {
                filterColumn = ListFilterConfigUtils.getFilterColumn((IDataEntityType)dt, headField + SysFilterConfigServiceImpl.FBASEDATAID_NAME);
            } else if ("bos_adminorg".equalsIgnoreCase(NcEntityTypeUtil.getRealBillEntityNumber((String)formId)) && Objects.equals("parent", headField)) {
                filterColumn = ListFilterConfigUtils.getFilterColumn((IDataEntityType)dt, "structure.viewparent.name");
                headField = "structure.viewparent.name";
            } else {
                filterColumn = ListFilterConfigUtils.getFilterColumn((IDataEntityType)dt, headField);
            }
            if (Objects.isNull(filterColumn)) {
                return this.returnEmptyFilterInfo(startTime);
            }
            List compareTypeDtoList = (List)filterColumn.get("compareTypes");
            compareTypeDtoList = compareTypeDtoList.stream().filter(compareTypeDto -> !Objects.equals(CompareTypeEnum.ENUM_EQ.getId(), compareTypeDto.getId())).collect(Collectors.toList());
            filterColumn.put("compareTypes", compareTypeDtoList);
            Map dataMap = (Map)param.getRequest().getData();
            ArrayList configuredFilterItems = dataMap.getOrDefault("filterRows", new ArrayList(0));
            List defaultFilterRows = dataMap.getOrDefault("defaultFilterRows", new ArrayList(0));
            String tempHeadField = headField;
            List headFieldConfiguredFilterItems = property instanceof NoCodeAttachmentProp ? configuredFilterItems.stream().filter(item -> Objects.equals(item.get("fieldName"), tempHeadField + SysFilterConfigServiceImpl.FBASEDATAID_NAME)).collect(Collectors.toList()) : configuredFilterItems.stream().filter(item -> Objects.equals(item.get("fieldName"), tempHeadField)).collect(Collectors.toList());
            HashMap<String, List<Object>> configuredFilterMap = new HashMap<String, List<Object>>(2);
            configuredFilterMap.put("items", headFieldConfiguredFilterItems);
            if (Boolean.parseBoolean((String)httpQueryString.get("ignoreConfiguredFilters"))) {
                configuredFilterMap.put("items", new ArrayList(0));
                configuredFilterItems = new ArrayList(0);
            }
            List<Map<String, Object>> groupInfo = this.getGroupInfo(headField, requestBO, configuredFilterItems, defaultFilterRows);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("fieldFilterConfig", filterColumn);
            resultMap.put("configuredFilter", configuredFilterMap);
            resultMap.put("groupInfo", groupInfo);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }

        @NotNull
        private RestApiServiceData<RestApiQueryResult> returnEmptyFilterInfo(long startTime) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
            resultMap.put("fieldFilterConfig", new HashMap(0));
            resultMap.put("configuredFilter", new HashMap(0));
            resultMap.put("groupInfo", new ArrayList(0));
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }

        private List<Map<String, Object>> getFilterItemsWithoutEnumOp(List<Map<String, Object>> configuredFilterItems, String headField, String formId) {
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
            DynamicProperty property = dt.getProperty(headField);
            if (property instanceof NoCodeAttachmentProp) {
                headField = headField + SysFilterConfigServiceImpl.FBASEDATAID_NAME;
            }
            ArrayList<Map<String, Object>> filterItemsWithoutEnumOp = new ArrayList<Map<String, Object>>(configuredFilterItems.size());
            for (Map<String, Object> row : configuredFilterItems) {
                String fieldName = (String)row.get("fieldName");
                String compareType = (String)row.get("compareType");
                if (Objects.equals(fieldName, headField) && Objects.equals(compareType, CompareTypeEnum.ENUM_EQ.getId())) continue;
                filterItemsWithoutEnumOp.add(row);
            }
            return filterItemsWithoutEnumOp;
        }

        private List<Map<String, Object>> getGroupInfo(String fieldName, ListFilterRequestBO requestBO, List<Map<String, Object>> configuredFilterItems, List<Map<String, Object>> defaultFilterItems) {
            BillEntityType dt;
            DynamicProperty property;
            if (CollectionUtils.isEmpty(defaultFilterItems)) {
                defaultFilterItems = new ArrayList<Map<String, Object>>(0);
            }
            String formId = requestBO.getFormId();
            String parentFieldName = fieldName;
            String originName = null;
            if (fieldName.contains(".") && (property = (DynamicProperty)NcEntityTypeUtil.findProperty((DynamicObjectType)(dt = NcEntityTypeUtil.getMainEntityType((String)formId)), (String)fieldName)) != null && property.getParent() instanceof NoCodeBillEntityType) {
                parentFieldName = fieldName.split("\\.")[0];
                originName = fieldName.split("\\.")[1];
            }
            List<Map<String, Object>> filterItemsWithoutEnumOp = this.getFilterItemsWithoutEnumOp(configuredFilterItems, parentFieldName, formId);
            filterItemsWithoutEnumOp.addAll(defaultFilterItems);
            String filterStr = ListFilterConfigUtils.buildFilter(filterItemsWithoutEnumOp, formId);
            QFilter[] filters = FilterUtil.getQFilters(formId, filterStr, requestBO.getSearchText());
            filters = NoCodePermHelper.combinePermFilter((String)requestBO.getAppId(), (String)formId, (QFilter[])filters);
            Map<String, Object> groupStatInfo = StringUtils.isNotBlank((CharSequence)originName) ? new GroupStatHandler().handle(formId, parentFieldName + "." + originName, filters, null) : new GroupStatHandler().handle(formId, parentFieldName, filters, null);
            List groupInfos = (List)groupStatInfo.get(ReportTypeEnum.GROUP.getCode());
            groupInfos.forEach(this::addTypeProperty);
            int total = groupInfos.stream().map(e -> (Map)e.get("value")).mapToInt(e -> (Integer)e.get("count")).sum();
            Map<String, Object> allSelectMap = StatMapUtils.getGroupMap(ResManager.loadKDString((String)"\u5168\u9009", (String)"SysFilterConfigServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]), "", "100", total);
            allSelectMap.put("type", "all");
            groupInfos.add(0, allSelectMap);
            return groupInfos;
        }

        private void addTypeProperty(Map<String, Object> info) {
            if (StringUtils.isEmpty((CharSequence)((String)info.get("fieldValue")))) {
                info.put("type", "empty");
            } else {
                info.put("type", "normal");
            }
        }

        private List<Map<String, Object>> getConfigInfoByEnv(ListFilterRequestBO requestBO, NoCodeEnvironmentEnum envEnum) {
            QFilter[] qFilters = ListConfigUtils.getQFilterByEnv((ListFilterRequestBO)requestBO, (String)envEnum.getCode());
            DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_filterconfig", (String)"appid,formid,userid,filterrows,creator,createdate,modifier,modifydate", (QFilter[])qFilters);
            if (Objects.isNull(dynObj)) {
                return new ArrayList<Map<String, Object>>(0);
            }
            String filterRowsStr = dynObj.getString("filterrows");
            return SerializationUtils.fromJsonStringToList((String)filterRowsStr, Map.class);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(Map<String, Object> resultMap) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows((List)Lists.newArrayList((Object[])new Map[]{resultMap}));
            return response;
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            result.setRows(rows);
            result.setTotalCount(rows.size());
            return response;
        }

        public RestApiServiceData<RestApiQueryResult> getEnumData(RestApiSaveParam param) {
            List filterRows;
            long startTime = System.currentTimeMillis();
            Map httpQueryString = param.getRequest().getHttpQueryString();
            String enumField = (String)httpQueryString.get("enumField");
            ListFilterRequestBO requestBO = new ListFilterRequestBO();
            Map dataMap = (Map)param.getDataList().get(0);
            String appId = (String)dataMap.get("appid");
            String formId = (String)dataMap.get("formid");
            requestBO.setAppId(appId);
            requestBO.setFormId(formId);
            if (!NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId)) {
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(new ArrayList<Map<String, Object>>(0)), (long)startTime, (long)endTime);
            }
            String schemaId = (String)httpQueryString.get("schemaId");
            if (StringUtils.isNotEmpty((CharSequence)schemaId)) {
                filterRows = LIST_SCHEMA_SERVICE.getFilterRows(Long.parseLong(schemaId));
                dataMap.put("defaultFilterRows", filterRows);
            }
            filterRows = dataMap.getOrDefault("filterrows", new ArrayList(0));
            List defaultFilterRows = dataMap.getOrDefault("defaultFilterRows", new ArrayList(0));
            List<Map<String, Object>> groupInfo = this.getGroupInfo(enumField, requestBO, filterRows, defaultFilterRows);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(groupInfo), (long)startTime, (long)endTime);
        }

        public RestApiServiceData<RestApiQueryResult> getFilter(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            Map dataMap = (Map)param.getDataList().get(0);
            String formId = (String)dataMap.get("formid");
            List filterRows = dataMap.getOrDefault("filterrows", new ArrayList(0));
            String filter = ListFilterConfigUtils.buildFilter(filterRows, formId);
            HashMap<String, String> filterMap = new HashMap<String, String>(1);
            filterMap.put("filter", filter);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(Lists.newArrayList((Object[])new Map[]{filterMap})), (long)startTime, (long)endTime);
        }
    }
}

