/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.constant.TemplateTypeEnum;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.mservice.NoCodeRuleService;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.core.util.DynamicObjectUtil;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.sys.SysMenuServiceImpl;
import kd.bos.nocode.restapi.service.sys.helper.MenuServiceHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.NoCodeBizButtonUtils;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcRetryUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.MapUtils;

public class SysFormMetaServiceImpl {
    public static final String MENU_INFO = "menuInfo";
    public static final String CUSTOM = "custom";
    public static final String BIZ_BUTTONS = "bizbuttons";
    private static final Log log = LogFactory.getLog(SysFormMetaServiceImpl.class);
    protected static final String MODEL_TYPE = "modelType";
    protected static final String NAME = "name";
    protected static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String ID2 = "Id";
    private static final String ENTITY_ID = "EntityId";
    private static final String NO_CODE_DESIGNER_DATA_SERVICE = "nocode_DesignerDataService";
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final String BOD_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DUPLICATEENTRY = "Duplicate entry";
    private static final String BIZ_APPID = "bizappid";
    private static final String TEMPLATEID = "templateId";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String FORM = "form";
    private static final String FORM_META = "formmeta";
    private static final String DESIGN_SETTING = "Setting";
    private static final String DESIGN_SETTING_L = "setting";
    private static final String BACK_IMAGE = "BackImage";
    private static final String BACK_IMAGE_L = "backImage";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String TABLE_NAME = "TableName";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            NoCodeTemplateUtil.templateCheck(param);
            FormMetaServiceSaveImpl formMetaServiceSave = new FormMetaServiceSaveImpl();
            return formMetaServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            if (param.getRequest().getUrl().contains(BIZ_BUTTONS)) {
                FormBizButtonsMetaQueryImpl formBizButtonsQuery = new FormBizButtonsMetaQueryImpl();
                return formBizButtonsQuery.execute((RestApiQueryParam)param);
            }
            FormMetaServiceQueryImpl formMetaServiceQuery = new FormMetaServiceQueryImpl();
            return formMetaServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            NoCodeTemplateUtil.templateCheck(param);
            FormMetaServiceDeleteImpl formMetaServiceDelete = new FormMetaServiceDeleteImpl();
            return formMetaServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException("\u8bf7\u6c42\u4e0d\u652f\u6301");
    }

    private static String getDefaultName() {
        return "\u672a\u547d\u540d\u8868\u5355";
    }

    public static class FormBizButtonsMetaQueryImpl
    implements QueryRestApiService {
        public static final String ID = "id";

        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            String[] split = param.getRequest().getUrl().split("/");
            String appId = split[split.length - 5];
            if (StringUtils.isBlank((CharSequence)appId)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            String formId = split[split.length - 3];
            if (StringUtils.isBlank((CharSequence)formId)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            String pkId = split[split.length - 1];
            if (StringUtils.isBlank((CharSequence)pkId)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            RestApiQueryResult result = new RestApiQueryResult();
            long startTime = System.currentTimeMillis();
            List<Map<String, Object>> rows = this.getRows(formId, pkId);
            long endTime = System.currentTimeMillis();
            result.setRows(rows);
            result.setTotalCount(rows.size());
            result.setLastPage(Boolean.valueOf(true));
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private List<Map<String, Object>> getRows(String formId, String pkId) {
            boolean check = NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId);
            if (!check) {
                return Collections.emptyList();
            }
            check = NoCodePermHelper.checkDataPermInNoCode((String)formId, (Object)Long.parseLong(pkId));
            if (!check) {
                return Collections.emptyList();
            }
            List<Map<String, Object>> bizButtonsMeta = this.getBizButtonsRuntimeMeta(formId, pkId);
            Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
            bizButtonsMeta.removeIf(s -> hides.contains(s.getOrDefault("id", "").toString()));
            if (!bizButtonsMeta.isEmpty()) {
                return bizButtonsMeta;
            }
            return Collections.emptyList();
        }

        private List<Map<String, Object>> getBizButtonsRuntimeMeta(String formId, String pkId) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            if (NcEntityTypeUtil.isFormExist((String)formId)) {
                FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                List bizButtons = formMetadata.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).sorted(Comparator.comparingInt(ControlAp::getIndex)).collect(Collectors.toList());
                for (ControlAp bizButton : bizButtons) {
                    NoCodeBizButtonAp noCodeBizButtonAp = (NoCodeBizButtonAp)bizButton;
                    if (!NoCodeBizButtonUtils.isVisibleByEnableFilterSetting(noCodeBizButtonAp, formId, pkId)) continue;
                    Map control = noCodeBizButtonAp.createControl();
                    result.add(control);
                }
            }
            return result;
        }
    }

    public static class FormMetaServiceDeleteImpl
    implements DeleteRestApiService {
        private static final String KEY_SUCCESS = "success";

        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException("\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee");
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"DeleteApiServiceImpl_1"), new Object[]{Integer.MAX_VALUE});
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            try {
                for (Object pkId : pkIds) {
                    data = new RestBaseFilterItemData();
                    String formId = (String)pkId;
                    NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.delete, (String)formId);
                    data.setId(formId);
                    String deleteMsg = FormMetaServiceDeleteImpl.deletePage(formId, param.getAppNumber());
                    if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
                        data.getErrors().add(deleteMsg);
                        data.setBillStatus(false);
                        ThreadPools.executeOnce((String)"nocode_asyncUpdateTableMeta", () -> this.deleteRefTableRelations(formId));
                        continue;
                    }
                    data.setBillStatus(true);
                }
            }
            catch (Exception e) {
                data.setBillStatus(false);
                data.getErrors().add(e.getMessage());
            }
            resultsData.add(data);
            long end = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }

        private void deleteRefTableRelations(String formId) {
            QFilter f1 = new QFilter("formid", "=", (Object)formId);
            QFilter f2 = new QFilter("refformid", "=", (Object)formId);
            QFilter f3 = f1.or(f2);
            DeleteServiceHelper.delete((String)"bos_nc_reftable", (QFilter[])new QFilter[]{f3});
        }

        public static String deletePage(String formId, String appNumber) {
            return FormMetadataUtils.deleteForm((String)formId, (String)appNumber);
        }

        public static String deletePages(Set<String> formIds, String appId) {
            if (formIds == null || formIds.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String formId : formIds) {
                String sError = FormMetaServiceDeleteImpl.deletePage(formId, appId);
                if (!StringUtils.isNotBlank((CharSequence)sError)) continue;
                sb.append(sError).append("\n");
            }
            return sb.toString();
        }
    }

    public static class FormMetaServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteApiServiceImpl_0"));
            }
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException("\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee");
            }
            QFilter[] idsFilter = new QFilter[]{new QFilter(SysFormMetaServiceImpl.ID, "in", (Object)pkIds)};
            String selectFields = "id,number,name,istemplate,enabled,bizappid";
            if (param.getSelect() != null && !param.getSelect().isEmpty()) {
                selectFields = String.join((CharSequence)",", param.getSelect());
            }
            String[] splitFields = selectFields.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            RestApiQueryResult result = new RestApiQueryResult();
            long startTime = System.currentTimeMillis();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)selectFields, (QFilter[])idsFilter);
            long endTime = System.currentTimeMillis();
            List<Map<String, Object>> rows = param.isDyObjResult() ? DynamicObjectUtil.serializeToMap((DynamicObject[])dynamicObjects, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bos_devportal_bizapp", selectSet)) : PropertyHandleUtil.toMapListRoot((String)"bos_devportal_bizapp", (String)"$", (DynamicObject[])dynamicObjects, selectSet);
            if (rows == null) {
                rows = Collections.emptyList();
            }
            this.fiexup(rows, param);
            result.setRows(rows);
            try {
                int totalCount;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_formmeta", (String)SysFormMetaServiceImpl.ID, (QFilter[])filters, null);){
                    totalCount = dataSet.count(SysFormMetaServiceImpl.ID, true);
                }
                result.setTotalCount(totalCount);
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
            }
            catch (Exception e) {
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
                log.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e));
            }
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private void fiexup(List<Map<String, Object>> rows, RestApiQueryParam param) {
            boolean isDyObjResult = param.isDyObjResult();
            for (Map<String, Object> row : rows) {
                String formId = (String)row.get(SysFormMetaServiceImpl.ID);
                Object bizappid = row.get(SysFormMetaServiceImpl.BIZ_APPID);
                String selectFields = "id,number,name";
                String[] splitFields = selectFields.split(",");
                HashSet selectSet = new HashSet(splitFields.length);
                Collections.addAll(selectSet, splitFields);
                Map appMap = null;
                DynamicObject appObject = BusinessDataServiceHelper.loadSingle((Object)bizappid, (String)"bos_devportal_bizapp");
                appMap = isDyObjResult ? DynamicObjectUtil.serializeToMap((DynamicObject)appObject, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bos_devportal_bizapp", selectSet)) : PropertyHandleUtil.toMap((Object)bizappid, (String)"bos_devportal_bizapp", (String)"$", (DynamicObject)appObject, selectSet, (boolean)false);
                row.remove(SysFormMetaServiceImpl.BIZ_APPID);
                row.put("app", appMap);
                row.put("image", "");
                MenuServiceHelper.getMenuImage((String)bizappid, formId).ifPresent(e -> row.put("image", e));
                Map content = MetadataDao.loadDesignerMetadata((String)formId, (String)RequestContext.get().getLang().toString());
                Map formMeta = (Map)content.get(SysFormMetaServiceImpl.FORM_META);
                List formMetaItems = (List)formMeta.get(SysFormMetaServiceImpl.ITEMS);
                Map formAp = (Map)formMetaItems.get(0);
                String settingStr = (String)formAp.get(SysFormMetaServiceImpl.DESIGN_SETTING);
                if (StringUtils.isNotBlank((CharSequence)settingStr)) {
                    Map setting = (Map)SerializationUtils.fromJsonString((String)settingStr, Map.class);
                    row.put(SysFormMetaServiceImpl.DESIGN_SETTING_L, setting);
                }
                String backImage = (String)formAp.get(SysFormMetaServiceImpl.BACK_IMAGE);
                if (StringUtils.isBlank((CharSequence)settingStr)) {
                    backImage = "/ncp/images/background_1.png";
                }
                row.put(SysFormMetaServiceImpl.BACK_IMAGE_L, backImage);
                if (!"true".equals(param.getRequest().getHttpQueryString().get("metadata"))) continue;
                row.put("metadata", content);
                List tableMetas = FormMetadataUtils.getTableMetas((Map)content);
                row.put("tableMetas", tableMetas);
            }
        }
    }

    public static class FormMetaServiceSaveImpl
    implements SaveRestApiService {
        private static final String BIZAPPID = "bizappid";
        private static final String KEY_BIZUNITID = "bizunitid";
        private static final String PARENTID = "parentId";

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam restApiSaveParam) {
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)restApiSaveParam.getAppNumber());
            NoCodePermHelper.verifyManage((String)appId);
            long startTime = System.currentTimeMillis();
            RestApiResponse response = new RestApiResponse();
            String sError = FormMetaUtil.checkMenuCount();
            if (StringUtils.isNotBlank((CharSequence)sError)) {
                return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)sError, (RestApiResponse)response, (long)(System.currentTimeMillis() - startTime));
            }
            List saveItemDatas = (List)NcRetryUtil.withRetry(() -> this.getSaveItemDatas(restApiSaveParam, appId));
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of((List)saveItemDatas);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private List<RestApiSaveItemData> getSaveItemDatas(RestApiSaveParam restApiSaveParam, String appId) {
            ArrayList<RestApiSaveItemData> saveItemDatas = new ArrayList<RestApiSaveItemData>(10);
            if (restApiSaveParam.isEmptyOfDataList()) {
                RestApiSaveItemData saveItemData = new RestApiSaveItemData();
                HashMap<String, Object> parameters = new HashMap<String, Object>(10);
                String id = FormMetaUtil.genIdUrlFriendly();
                parameters.put(SysFormMetaServiceImpl.NAME, SysFormMetaServiceImpl.getDefaultName());
                parameters.put(SysFormMetaServiceImpl.ID, id);
                parameters.put("bizappid", appId);
                this.createModel(parameters, saveItemData);
                saveItemDatas.add(saveItemData);
                return saveItemDatas;
            }
            for (Map dataMap : restApiSaveParam.getDataList()) {
                String sourceFormId = (String)dataMap.get("sourceFormId");
                RestApiSaveItemData saveItemData = new RestApiSaveItemData();
                String name = (String)dataMap.get(SysFormMetaServiceImpl.NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = SysFormMetaServiceImpl.getDefaultName();
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceFormId)) {
                    this.doCopy(sourceFormId, saveItemData, name, dataMap);
                } else {
                    HashMap<String, Object> parameters = new HashMap<String, Object>(10);
                    String number = null;
                    number = dataMap.containsKey("innerFormNumber") ? (String)dataMap.get("innerFormNumber") : FormMetaUtil.genIdUrlFriendly();
                    name = StringUtil.cleanXSSParam((String)name);
                    parameters.put(SysFormMetaServiceImpl.NAME, name.length() > 50 ? name.substring(0, 47) + "..." : name);
                    parameters.put(SysFormMetaServiceImpl.ID, number);
                    parameters.put("bizappid", appId);
                    if (dataMap.containsKey(SysFormMetaServiceImpl.TEMPLATEID)) {
                        parameters.put(SysFormMetaServiceImpl.TEMPLATEID, dataMap.get(SysFormMetaServiceImpl.TEMPLATEID));
                    }
                    if (dataMap.containsKey("enabled")) {
                        parameters.put("enabled", dataMap.get("enabled"));
                    }
                    parameters.put(SysFormMetaServiceImpl.MENU_INFO, dataMap.get(SysFormMetaServiceImpl.MENU_INFO));
                    parameters.put(SysFormMetaServiceImpl.CUSTOM, dataMap.getOrDefault("type", "").equals(SysFormMetaServiceImpl.CUSTOM));
                    this.createModel(parameters, saveItemData);
                }
                saveItemDatas.add(saveItemData);
            }
            return saveItemDatas;
        }

        private boolean resetInnerTable(Map<String, Object> content) {
            String _Type_;
            boolean containInnerForm = false;
            Map entitymeta = (Map)content.get(SysFormMetaServiceImpl.ENTITY_META);
            List items = (List)entitymeta.get(SysFormMetaServiceImpl.ITEMS);
            ArrayList<String> innerTableKeys = new ArrayList<String>(10);
            for (Map item : items) {
                String sourceForm;
                _Type_ = (String)item.get("_Type_");
                if (!"NoCodeRefBillTable".equals(_Type_) || !"1".equals(sourceForm = item.get("SourceForm") == null ? "2" : (String)item.get("SourceForm"))) continue;
                containInnerForm = true;
                innerTableKeys.add(item.get("Key").toString());
                item.put("BillEntityIdEx", "");
            }
            for (Map item : items) {
                String refTableKey;
                _Type_ = (String)item.get("_Type_");
                if (!"NoCodeMulRefBillField".equals(_Type_) || !innerTableKeys.contains(refTableKey = item.get("RefTableKey") == null ? null : item.get("RefTableKey").toString())) continue;
                item.put("BillEntityIdEx", "");
                item.put("BillEntityId", "");
            }
            return containInnerForm;
        }

        private void doCopy(String sourceFormId, RestApiSaveItemData saveItemData, String name, Map<String, Object> dataMap) {
            String menuId;
            String targetFormId;
            Map result;
            Throwable throwable;
            TXHandle tx;
            block41: {
                block42: {
                    block43: {
                        String bizAppId = FormMetaUtil.getAppIdByFormId((String)sourceFormId);
                        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
                        Map<String, Object> copyFormParameterMap = this.getCopyFormParameterMap(sourceFormId, name, appMetadata);
                        boolean custom = "DynamicFormModel".equalsIgnoreCase((String)copyFormParameterMap.get(SysFormMetaServiceImpl.MODEL_TYPE));
                        if (custom) {
                            copyFormParameterMap.put(SysFormMetaServiceImpl.CUSTOM, true);
                        }
                        NoCodeDesignerData noCodeDesignerData = new NoCodeDesignerData();
                        Map content = noCodeDesignerData.createBlankModel(copyFormParameterMap);
                        String number = (String)copyFormParameterMap.get(SysFormMetaServiceImpl.ID);
                        content.put(SysFormMetaServiceImpl.ID, number);
                        Map formMeta = (Map)content.get(SysFormMetaServiceImpl.FORM_META);
                        formMeta.put(SysFormMetaServiceImpl.ID2, number);
                        formMeta.put(SysFormMetaServiceImpl.ENTITY_ID, number);
                        Map entityMeta = (Map)content.get(SysFormMetaServiceImpl.ENTITY_META);
                        entityMeta.put(SysFormMetaServiceImpl.ID2, number);
                        if (!custom) {
                            boolean containInnerForm = this.resetInnerTable(content);
                            if (containInnerForm) {
                                noCodeDesignerData.setSaveTableMetas(true);
                            }
                            noCodeDesignerData.setSyncTableMetas(false);
                        }
                        tx = TX.required((String)SysFormMetaServiceImpl.NO_CODE_DESIGNER_DATA_SERVICE);
                        throwable = null;
                        if (!custom) {
                            this.replaceRelationInfo(content);
                        }
                        List entityItems = (List)entityMeta.get(SysFormMetaServiceImpl.ITEMS);
                        Map noCodeBillEntity = (Map)entityItems.get(0);
                        noCodeBillEntity.put(SysFormMetaServiceImpl.TABLE_NAME, String.format("%s%s", "t_nc_", number));
                        content.put("fromTemplate", true);
                        if (custom) {
                            DesignerData d = new DesignerData();
                            result = d.save(content);
                        } else {
                            result = noCodeDesignerData.save(content);
                        }
                        boolean isSuccess = (Boolean)result.get(SysFormMetaServiceImpl.SUCCESS);
                        targetFormId = (String)content.get(SysFormMetaServiceImpl.ID);
                        menuId = "";
                        if (isSuccess) {
                            try (TXHandle h = TX.required();){
                                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                                dObject.set(SysFormMetaServiceImpl.BIZAPP, copyFormParameterMap.get("bizappid"));
                                dObject.set(SysFormMetaServiceImpl.BIZUNIT, copyFormParameterMap.get(KEY_BIZUNITID));
                                dObject.set(SysFormMetaServiceImpl.FORM, (Object)targetFormId);
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                            }
                            Map menuInfo = (Map)dataMap.get(SysFormMetaServiceImpl.MENU_INFO);
                            if (MapUtils.isNotEmpty((Map)menuInfo)) {
                                if (custom) {
                                    menuInfo.put(SysFormMetaServiceImpl.CUSTOM, true);
                                }
                                menuId = this.saveMenuInfo(name, targetFormId, appMetadata, menuInfo);
                            }
                            if (!custom) {
                                NoCodeRuleService ruleService = (NoCodeRuleService)ServiceFactory.getService((String)"NoCodeRuleService");
                                ruleService.copyRules(sourceFormId, targetFormId);
                            } else {
                                this.cloneCardSetting(sourceFormId, targetFormId);
                            }
                            break block41;
                        }
                        saveItemData.setBillStatus(false);
                        RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                        HashSet<String> msgs = new HashSet<String>(1);
                        msgs.add(((ErrorInfo)((ArrayList)result.get(SysFormMetaServiceImpl.ERRORS)).get(0)).getError());
                        restApiSaveRowErrorData.setRowMsg(msgs);
                        saveItemData.getErrors().add(restApiSaveRowErrorData);
                        if (tx == null) break block42;
                        if (throwable == null) break block43;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block42;
                    }
                    tx.close();
                }
                return;
            }
            try {
                try {
                    result.put(SysFormMetaServiceImpl.ID, targetFormId);
                    saveItemData.setId(targetFormId);
                    saveItemData.setNumber(targetFormId);
                    saveItemData.setBillStatus(true);
                    saveItemData.getExtra().put("menuId", menuId);
                }
                catch (Exception exception) {
                    log.warn((Throwable)exception);
                    tx.markRollback();
                    saveItemData.setBillStatus(false);
                    String msg = ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe", (String)"PageBuilder_8", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                    HashSet<String> msgs = new HashSet<String>(1);
                    msgs.add(msg);
                    restApiSaveRowErrorData.setRowMsg(msgs);
                    saveItemData.getErrors().add(restApiSaveRowErrorData);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }

        private void cloneCardSetting(String srcFormId, String targetFormId) {
            QFilter filter = new QFilter("pageid", "=", (Object)Long.parseLong(srcFormId));
            DynamicObject[] containers = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)"id,cardid,pageid", (QFilter[])new QFilter[]{filter});
            Set cardIds = Arrays.stream(containers).map(dy -> dy.getString("cardid")).collect(Collectors.toSet());
            if (!cardIds.isEmpty()) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        HashMap<String, String> cardMap = new HashMap<String, String>();
                        ArrayList<DynamicObject> cards = new ArrayList<DynamicObject>(8);
                        for (String cardId : cardIds) {
                            boolean exists = QueryServiceHelper.exists((String)"bos_nocode_card", (Object)Long.parseLong(cardId));
                            if (!exists) continue;
                            DynamicObject dy2 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(cardId), (String)"bos_nocode_card");
                            DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dy2, (boolean)false, (boolean)true);
                            long id = kd.bos.id.ID.genLongId();
                            cardMap.put(cardId, String.valueOf(id));
                            clone.set(SysFormMetaServiceImpl.ID, (Object)id);
                            cards.add(clone);
                        }
                        SaveServiceHelper.save((DynamicObject[])cards.toArray(new DynamicObject[0]));
                        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
                        for (DynamicObject dy3 : containers) {
                            Object pk = dy3.getPkValue();
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bos_nocode_cardcontainer");
                            DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dynamicObject, (boolean)false, (boolean)true);
                            String pageid = dynamicObject.getString("pageid");
                            clone.set("pageid", (Object)targetFormId);
                            String cardid = clone.getString("cardid");
                            clone.set("cardid", cardMap.get(cardid));
                            list.add(clone);
                        }
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    }
                    catch (Exception ex) {
                        h.markRollback();
                        log.error((Throwable)ex);
                    }
                }
            }
        }

        private void replaceRelationInfo(Map<String, Object> content) {
            Map formmeta = (Map)content.get(SysFormMetaServiceImpl.FORM_META);
            List items = (List)formmeta.get(SysFormMetaServiceImpl.ITEMS);
            items.forEach(item -> {
                String type = (String)item.get("_Type_");
                if (NoCodeBizButtonAp.class.getSimpleName().equals(type)) {
                    item.put("TriggerProcess", "");
                    String operationType = (String)item.get("OperationType");
                    String inputForm = (String)item.get("InputForm");
                    if (Objects.equals(operationType, "2") && inputForm.startsWith("$")) {
                        int firstDotIndex = inputForm.indexOf(".");
                        if (firstDotIndex == -1) {
                            item.put("InputForm", "$" + content.get(SysFormMetaServiceImpl.ID));
                        } else {
                            String formId = inputForm.substring(0, firstDotIndex);
                            inputForm = inputForm.replace(formId, "$" + (String)content.get(SysFormMetaServiceImpl.ID));
                            item.put("InputForm", inputForm);
                        }
                    }
                }
            });
        }

        private Map<String, Object> getCopyFormParameterMap(String sourceFormId, String name, AppMetadata appMetadata) {
            String bizAppId = FormMetaUtil.getAppIdByFormId((String)sourceFormId);
            AbstractMetadata meta = MetadataDao.readMeta((String)sourceFormId, (MetaCategory)MetaCategory.Form);
            AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appMetadata.getAppFunctionPackets().get(0);
            String bizUnitId = appFunctionPacketElement.getId();
            String targetFormId = FormMetaUtil.genIdUrlFriendly();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bizappid", bizAppId);
            map.put(KEY_BIZUNITID, bizUnitId);
            map.put(SysFormMetaServiceImpl.MODEL_TYPE, meta.getModelType());
            map.put(SysFormMetaServiceImpl.ID, targetFormId);
            map.put(SysFormMetaServiceImpl.NAME, name);
            map.put("srcFormId", sourceFormId);
            map.put("islayout", Boolean.FALSE);
            map.put("entityId", sourceFormId);
            map.put("isCopy", Boolean.TRUE);
            map.put(PARENTID, meta.getParentId());
            return map;
        }

        public void createModel(Map<String, Object> parameters, RestApiSaveItemData saveItemData) {
            Map<String, Object> content;
            Throwable throwable;
            TXHandle tx;
            boolean custom;
            String number;
            String bizAppId;
            block32: {
                block33: {
                    block34: {
                        bizAppId = (String)parameters.get("bizappid");
                        number = (String)parameters.get(SysFormMetaServiceImpl.ID);
                        custom = (Boolean)parameters.getOrDefault(SysFormMetaServiceImpl.CUSTOM, false);
                        if (custom) {
                            parameters.put(SysFormMetaServiceImpl.MODEL_TYPE, "DynamicFormModel");
                        } else {
                            parameters.put(SysFormMetaServiceImpl.MODEL_TYPE, "NoCodeModel");
                        }
                        tx = TX.required((String)SysFormMetaServiceImpl.NO_CODE_DESIGNER_DATA_SERVICE);
                        throwable = null;
                        content = null;
                        Map saveResult = null;
                        NoCodeDesignerData designerData = new NoCodeDesignerData();
                        boolean fromTemplate = false;
                        if (parameters.get(SysFormMetaServiceImpl.TEMPLATEID) != null) {
                            content = this.createFromTemplate(parameters, content, designerData, bizAppId);
                            fromTemplate = true;
                        }
                        if (content == null) {
                            content = designerData.createBlankModel(parameters);
                        }
                        content.put(SysFormMetaServiceImpl.ID, number);
                        Map formMeta = (Map)content.get(SysFormMetaServiceImpl.FORM_META);
                        formMeta.put(SysFormMetaServiceImpl.ID2, number);
                        formMeta.put(SysFormMetaServiceImpl.ENTITY_ID, number);
                        Map entityMeta = (Map)content.get(SysFormMetaServiceImpl.ENTITY_META);
                        entityMeta.put(SysFormMetaServiceImpl.ID2, number);
                        if (!custom) {
                            List entityItems = (List)entityMeta.get(SysFormMetaServiceImpl.ITEMS);
                            Map noCodeBillEntity = (Map)entityItems.get(0);
                            noCodeBillEntity.put(SysFormMetaServiceImpl.TABLE_NAME, String.format("%s%s", "t_nc_", number));
                        }
                        if (fromTemplate) {
                            content.put("fromTemplate", true);
                            saveResult = designerData.save(content, true, false);
                        } else if (custom) {
                            DesignerData d = new DesignerData();
                            d.save(content);
                        } else {
                            saveResult = designerData.save(content, false, false);
                        }
                        if (saveResult == null || saveResult.get(SysFormMetaServiceImpl.SUCCESS) == null || !Boolean.FALSE.equals(saveResult.get(SysFormMetaServiceImpl.SUCCESS)) || saveResult.get(SysFormMetaServiceImpl.ERRORS) == null) break block32;
                        saveItemData.setBillStatus(false);
                        RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                        HashSet<String> msgs = new HashSet<String>(1);
                        msgs.add(((ErrorInfo)((ArrayList)saveResult.get(SysFormMetaServiceImpl.ERRORS)).get(0)).getError());
                        restApiSaveRowErrorData.setRowMsg(msgs);
                        saveItemData.getErrors().add(restApiSaveRowErrorData);
                        if (tx == null) break block33;
                        if (throwable == null) break block34;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block33;
                    }
                    tx.close();
                }
                return;
            }
            try {
                RestApiSaveRowErrorData restApiSaveRowErrorData;
                String msg;
                try {
                    String formId = (String)content.get(SysFormMetaServiceImpl.ID);
                    AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
                    AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appMetadata.getAppFunctionPackets().get(0);
                    String bizUnitId = appFunctionPacketElement.getId();
                    DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                    dObject.set(SysFormMetaServiceImpl.BIZAPP, (Object)bizAppId);
                    dObject.set(SysFormMetaServiceImpl.BIZUNIT, (Object)bizUnitId);
                    dObject.set(SysFormMetaServiceImpl.FORM, (Object)formId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                    Map menuInfo = (Map)parameters.get(SysFormMetaServiceImpl.MENU_INFO);
                    if (parameters.containsKey("enabled") && menuInfo != null) {
                        menuInfo.put("enabled", parameters.get("enabled"));
                    }
                    String name = (String)parameters.get(SysFormMetaServiceImpl.NAME);
                    if (MapUtils.isNotEmpty((Map)menuInfo)) {
                        menuInfo.put(SysFormMetaServiceImpl.CUSTOM, custom);
                        this.saveMenuInfo(name, formId, appMetadata, menuInfo);
                    }
                    saveItemData.setId(formId);
                    saveItemData.setNumber(number);
                    saveItemData.setBillStatus(true);
                }
                catch (NullPointerException exception) {
                    log.warn((Throwable)exception);
                    tx.markRollback();
                    saveItemData.setBillStatus(false);
                    msg = ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe", (String)"PageBuilder_8", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    if (msg.contains(SysFormMetaServiceImpl.DUPLICATEENTRY)) {
                        msg = ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010", (String)"PageBuilder_4", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + number + ResManager.loadKDString((String)"\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a", (String)"PageBuilder_5", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + msg;
                    }
                    restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                    HashSet<String> msgs = new HashSet<String>(1);
                    msgs.add(msg);
                    restApiSaveRowErrorData.setRowMsg(msgs);
                    saveItemData.getErrors().add(restApiSaveRowErrorData);
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                    tx.markRollback();
                    saveItemData.setBillStatus(false);
                    msg = e.getMessage();
                    if (e.getMessage().contains(SysFormMetaServiceImpl.DUPLICATEENTRY)) {
                        msg = ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010", (String)"PageBuilder_4", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + number + ResManager.loadKDString((String)"\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a", (String)"PageBuilder_5", (String)SysFormMetaServiceImpl.BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + msg;
                    }
                    restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                    HashSet<String> msgs = new HashSet<String>(1);
                    msgs.add(msg);
                    restApiSaveRowErrorData.setRowMsg(msgs);
                    saveItemData.getErrors().add(restApiSaveRowErrorData);
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            if (parameters.get(SysFormMetaServiceImpl.TEMPLATEID) != null) {
                Object templateid = parameters.get(SysFormMetaServiceImpl.TEMPLATEID);
                DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bos_nocode_templateconfig");
                String src = dy.getString("formid");
                NoCodeRuleService ruleService = (NoCodeRuleService)ServiceFactory.getService((String)"NoCodeRuleService");
                String type = dy.getString("type");
                TemplateTypeEnum.getByCode((String)type).ifPresent(templateType -> ruleService.copyRules(src, number, templateType));
            }
        }

        public String saveMenuInfo(String formName, String formId, AppMetadata appMetadata, Map<String, Object> menuInfo) {
            if (MapUtils.isEmpty(menuInfo)) {
                throw new RestApiException("\u83dc\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            menuInfo.put("formId", formId);
            menuInfo.put(SysFormMetaServiceImpl.NAME, formName);
            ArrayList<Map<String, Object>> sourceList = new ArrayList<Map<String, Object>>(1);
            sourceList.add(menuInfo);
            RestApiSaveItemData saveMenuItemData = new SysMenuServiceImpl.MenuServiceSaveImpl().executeSave(sourceList, true, appMetadata).get(0);
            if (Objects.isNull(saveMenuItemData)) {
                throw new RestApiException("\u4fdd\u5b58\u83dc\u5355\u5f02\u5e38");
            }
            if (!saveMenuItemData.isBillStatus()) {
                String errMsg = saveMenuItemData.getErrors().stream().flatMap(e -> e.getRowMsg().stream()).collect(Collectors.joining(","));
                throw new RestApiException("\u4fdd\u5b58\u83dc\u5355\u5f02\u5e38: " + errMsg);
            }
            Map saveMenuResult = AppMetaServiceHelper.save((AppMetadata)appMetadata);
            if (saveMenuResult.size() > 0 && !Boolean.parseBoolean(saveMenuResult.get(SysFormMetaServiceImpl.SUCCESS).toString())) {
                throw new RestApiException(saveMenuResult.get(SysFormMetaServiceImpl.MESSAGE).toString());
            }
            return saveMenuItemData.getId();
        }

        private Map<String, Object> createFromTemplate(Map<String, Object> parameters, Map<String, Object> content, NoCodeDesignerData designerData, String bizAppId) {
            Object templateid = parameters.get(SysFormMetaServiceImpl.TEMPLATEID);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bos_nocode_templateconfig");
            if (dy != null) {
                String formid = dy.getString("formid");
                Map metadata = MetadataDao.loadDesignerMetadata((String)formid, (String)RequestContext.get().getLang().toString());
                String number = (String)parameters.get(SysFormMetaServiceImpl.ID);
                FormMetadata formMeta = designerData.generateTemplateMeta(metadata, number);
                formMeta.getEntityMetadata().getRootEntity().setTemplate(false);
                String key = (String)parameters.get(SysFormMetaServiceImpl.ID);
                Object objName = parameters.get(SysFormMetaServiceImpl.NAME);
                LocaleString name = null;
                if (objName instanceof LocaleString) {
                    name = (LocaleString)objName;
                } else if (objName instanceof OrmLocaleValue) {
                    HashMap<String, String> localNameMap = new HashMap<String, String>(16);
                    for (String loId : ((OrmLocaleValue)objName).keySet()) {
                        localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
                    }
                    name = LocaleString.fromMap(localNameMap);
                } else {
                    name = new LocaleString("zh_CN", (String)objName);
                }
                formMeta.setKey(key);
                formMeta.setName(name);
                FormMetaServiceSaveImpl.setUpAppId(bizAppId, formMeta);
                content = formMeta.buildDesignMeta("zh_CN");
                Map em = (Map)content.get(SysFormMetaServiceImpl.ENTITY_META);
                List entityItems = (List)em.get(SysFormMetaServiceImpl.ITEMS);
                Map noCodeBillEntity = (Map)entityItems.get(0);
                noCodeBillEntity.remove(SysFormMetaServiceImpl.TABLE_NAME);
                Map fm = (Map)content.get(SysFormMetaServiceImpl.FORM_META);
                List fromItems = (List)fm.get(SysFormMetaServiceImpl.ITEMS);
                Map noCodeBillForm = (Map)fromItems.get(0);
                noCodeBillForm.remove(SysFormMetaServiceImpl.TABLE_NAME);
                try (TXHandle handle = TX.requiresNew();){
                    NoCodeTemplateUtil.addUseTimes((String)((String)templateid));
                }
            } else {
                log.debug("template:" + templateid + "not found");
            }
            return content;
        }

        private static void setUpAppId(String bizAppId, FormMetadata formMeta) {
            if (!bizAppId.equals(formMeta.getBizappId())) {
                formMeta.setBizappId(bizAppId);
                EntityMetadata entityMeta = formMeta.getEntityMetadata();
                entityMeta.setBizappId(bizAppId);
            }
        }
    }
}

